/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.prov.prereqs.OracleInventory;

public class PortHandlerUtil {
    private static final String EMD_PROPS = "sysman" + File.separator + "config" + File.separator + "emd.properties";
    private static final String EMD_URL = "EMD_URL";

    public static Hashtable getBusyPorts() {
        Hashtable<String, String> used = new Hashtable<String, String>();
        Vector oracleHomes = null;
        try {
            oracleHomes = OracleInventory.getAllHomes();
        }
        catch (Exception e) {
            e.printStackTrace();
            oracleHomes = new Vector();
        }
        if (oracleHomes == null) {
            oracleHomes = new Vector();
        }
        try {
            for (int i = 0; i < oracleHomes.size(); ++i) {
                String[] ohdirfiles;
                String oracleHome = (String)oracleHomes.get(i);
                File oh = new File(oracleHome);
                if (!oh.exists() || (ohdirfiles = oh.list()) == null || ohdirfiles.length == 0) continue;
                String port = "";
                for (int j = 0; j < ohdirfiles.length; ++j) {
                    String configpath = oh.getAbsolutePath() + File.separator + ohdirfiles[j] + File.separator + EMD_PROPS;
                    port = PortHandlerUtil.getAgentEmdPort(configpath);
                    if (port == null || port.length() <= 0 || used.keySet().contains(port)) continue;
                    used.put(port, configpath);
                }
                String emconfigdir = oracleHome + File.separator + EMD_PROPS;
                port = PortHandlerUtil.getAgentEmdPort(emconfigdir);
                if (port == null || used.keySet().contains(port)) continue;
                used.put(port, emconfigdir);
            }
        }
        catch (Exception ignore) {
            return new Hashtable();
        }
        return used;
    }

    private static String getAgentEmdPort(String path) {
        int index;
        String[] results;
        String emd_url;
        String port = null;
        Properties emdprops = PortHandlerUtil.getProperties(path);
        if (emdprops != null && (emd_url = emdprops.getProperty(EMD_URL)) != null && emd_url.length() != 0 && (results = emd_url.split(":")).length >= 3 && (index = results[2].indexOf(47)) != -1) {
            port = results[2].substring(0, index);
        }
        if (port == null || !PortHandlerUtil.isANumber(port)) {
            return null;
        }
        return port;
    }

    static Properties getProperties(String path) {
        Properties props = new Properties();
        if (path == null || path.trim().length() <= 0) {
            return props;
        }
        try {
            props.load(new FileInputStream(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    static boolean isANumber(String port) {
        if (port == null || port.trim().length() <= 0) {
            return false;
        }
        try {
            Integer.parseInt(port);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

