/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchGroup;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchRefHost;
import oracle.sysman.oip.oipc.oipch.OipchUnixGroup;
import oracle.sysman.oip.oipc.oipch.OipchUnixUser;
import oracle.sysman.oip.oipc.oipch.OipchUser;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class UserAndGroupChecks {
    private UserAndGroupChecks() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OipcrIResult doUsersExist(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        try {
            OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
            OipchRefHost oRefHost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
            OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
            Iterator oUsersList = oRefHost.getSystem().getUsers();
            if (oUsersList == null) return oResult;
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            while (oUsersList.hasNext()) {
                OipcrIResult oRes = null;
                OipchUser oUsr = (OipchUser)oUsersList.next();
                String sUsrName = oUsr.getUserName(oContext);
                if (sUsrName != null) {
                    oRes = UserAndGroupChecks.doesUserExist(sUsrName, oHost) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                    oResDetails.add(new OipcrResultDetails(null, (Object)sUsrName, oRes));
                }
                if (oResDetails.size() <= 0) continue;
                oResult = new OipcrResult(oResDetails);
            }
            return oResult;
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OipcrIResult doGroupsExist(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        try {
            OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
            OipchRefHost oRefHost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
            OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
            Iterator oGrpsList = oRefHost.getSystem().getGroups();
            if (oGrpsList == null) return oResult;
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            while (oGrpsList.hasNext()) {
                OipcrIResult oRes = null;
                OipchGroup oGrp = (OipchGroup)oGrpsList.next();
                String sGrpName = oGrp.getName(oContext);
                if (sGrpName != null) {
                    oRes = UserAndGroupChecks.doesGroupExist(sGrpName, oHost) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                    oResDetails.add(new OipcrResultDetails(null, (Object)sGrpName, oRes));
                }
                if (oResDetails.size() <= 0) continue;
                oResult = new OipcrResult(oResDetails);
            }
            return oResult;
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OipcrIResult doUsersHaveCorrectActiveGroups(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        try {
            OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
            OipchRefHost oRefHost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
            OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
            Iterator oUsersList = oRefHost.getSystem().getUsers();
            if (oUsersList == null) return oResult;
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            while (oUsersList.hasNext()) {
                String sUsrName;
                OipchUnixGroup oUnixGroup;
                OipcrIResult oRes = null;
                OipchUser oUsr = (OipchUser)oUsersList.next();
                OipchUnixUser oUnixUser = null;
                String sActiveGrpName = null;
                if (oUsr instanceof OipchUnixUser && (oUnixGroup = (oUnixUser = (OipchUnixUser)oUsr).getActiveGroup()) != null) {
                    sActiveGrpName = oUnixGroup.getName(oContext);
                }
                if ((sUsrName = oUsr.getUserName(oContext)) != null && sActiveGrpName != null) {
                    oRes = UserAndGroupChecks.isActiveGroupForUser(sUsrName, sActiveGrpName, oHost) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                    Object[] args = new String[]{sUsrName, sActiveGrpName};
                    String sExpectedValue = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_USR_GRP_FORMAT", (Object[])args);
                    oResDetails.add(new OipcrResultDetails(null, (Object)sExpectedValue, oRes));
                }
                if (oResDetails.size() <= 0) continue;
                oResult = new OipcrResult(oResDetails);
            }
            return oResult;
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OipcrIResult doUsersExistInGroups(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        try {
            OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
            OipchRefHost oRefHost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
            OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
            Iterator oUsersList = oRefHost.getSystem().getUsers();
            if (oUsersList == null) return oResult;
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            while (oUsersList.hasNext()) {
                List oGrps;
                OipcrIResult oRes = null;
                OipchUser oUsr = (OipchUser)oUsersList.next();
                String sUsrName = oUsr.getUserName(oContext);
                if (sUsrName != null && (oGrps = oUsr.getGroups()) != null) {
                    int nGrps = oGrps.size();
                    for (int i = 0; i < nGrps; ++i) {
                        OipchGroup oGrp = (OipchGroup)oGrps.get(i);
                        String sGrpName = oGrp.getName(oContext);
                        if (sGrpName == null) continue;
                        oRes = UserAndGroupChecks.doesUserExistInGroup(sUsrName, sGrpName, oHost) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                        Object[] args = new String[]{sUsrName, sGrpName};
                        String sExpectedValue = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_USR_GRP_FORMAT", (Object[])args);
                        oResDetails.add(new OipcrResultDetails(null, (Object)sExpectedValue, oRes));
                    }
                }
                if (oResDetails.size() <= 0) continue;
                oResult = new OipcrResult(oResDetails);
            }
            return oResult;
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
    }

    private static boolean doesUserExist(String sUser, OipchHost oHost) {
        OipchUser oUser = oHost.getSystem().getUser(sUser);
        boolean bFound = false;
        if (oUser != null && oUser.getUserName(null).equals(sUser)) {
            bFound = true;
        }
        return bFound;
    }

    private static boolean doesUserExistInGroup(String sUser, String sGrp, OipchHost oHost) {
        Iterator oUsers = oHost.getSystem().getUsers();
        boolean bFound = false;
        while (oUsers.hasNext()) {
            List oGrps;
            OipchUser oCurUsr = (OipchUser)oUsers.next();
            if (!sUser.equals(oCurUsr.getUserName(null)) || (oGrps = oCurUsr.getGroups()) == null) continue;
            int nGrps = oGrps.size();
            for (int i = 0; i < nGrps; ++i) {
                String sCurGrpName;
                OipchGroup oCurGrp = (OipchGroup)oGrps.get(i);
                if (oCurGrp == null || (sCurGrpName = oCurGrp.getName(null)) == null || !sCurGrpName.equals(sGrp)) continue;
                bFound = true;
            }
        }
        return bFound;
    }

    private static boolean doesGroupExist(String sGrp, OipchHost oHost) {
        Iterator oGrps = oHost.getSystem().getGroups();
        boolean bFound = false;
        while (oGrps.hasNext()) {
            OipchGroup oCurGrp = (OipchGroup)oGrps.next();
            if (!sGrp.equals(oCurGrp.getName(null))) continue;
            bFound = true;
        }
        return bFound;
    }

    private static boolean isActiveGroupForUser(String sUsrName, String sActiveGrpName, OipchHost oHost) {
        Iterator oUsers = oHost.getSystem().getUsers();
        boolean bFound = false;
        while (oUsers.hasNext()) {
            String sCurActiveGrpName;
            OipchUnixUser oCurUnixUser;
            OipchUnixGroup oGrp;
            OipchUser oCurUsr = (OipchUser)oUsers.next();
            if (!sUsrName.equals(oCurUsr.getUserName(null))) continue;
            if (!(oCurUsr instanceof OipchUnixUser) || (oGrp = (oCurUnixUser = (OipchUnixUser)oCurUsr).getActiveGroup()) == null || (sCurActiveGrpName = oGrp.getName(null)) == null || !sActiveGrpName.equals(sCurActiveGrpName)) break;
            bFound = true;
            break;
        }
        return bFound;
    }
}

