/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class OiClusterConfigFileInput
extends OiifpWizPanel
implements ActionListener,
MouseListener {
    private static final int INVALID_FILE_NAME = 20000;
    private static final int FILE_DOES_NOT_EXIST = 20001;
    private static final int DIRECTORY_MENTIONED = 20002;
    private static final int SECURITY_EXCEPTION = 20003;
    private static final int FILE_NOT_FOUND_EXCEPTION = 20004;
    private static final int IO_EXCEPTION = 20005;
    private static final int FILE_NOT_READABLE_EXCEPTION = 20006;
    private static final int THROWABLE_ERROR = 20007;
    private static final int NO_INFORMATION_RETRIEVED = 20008;
    private static final int PUBNODE_NOTFOUND_EXCEPTION = 20009;
    private static final int PRIVNODE_MISMATCH_EXCEPTION = 20010;
    private static final int INVALID_NODE_NAMES_EXCEPTION = 20011;
    private static final int INVALID_NODE_NAMES_GENERAL_ERROR = 20012;
    private static final int NO_9IRAC_FOUND = 20013;
    private static final int CLUSTER_NAME_NOT_SPECIFIED = 20014;
    private static final int INSETS = 5;
    private static final String DEFAULT_TITLE = OiStdDialogRes.getString("OiClusterConfigFileInput_CCF");
    private static final String DEFAULT_LABEL_0 = OiStdDialogRes.getString("OiClusterConfigFileInput_Location");
    private static final String DEF_BUTTON_LABEL_0 = OiStdDialogRes.getString("OiClusterConfigFileInput_OK");
    private static final String DEF_BUTTON_LABEL_1 = OiStdDialogRes.getString("OiClusterConfigFileInput_Cancel");
    private static final String DEF_BUTTON_LABEL_2 = OiStdDialogRes.getString("OiClusterConfigFileInput_Browse");
    private static final String CHOOSE_DIR = OiStdDialogRes.getString("OiClusterConfigFileInput_FileDlgTitle");
    private static final String[][] ERROR_MESSAGE = new String[][]{{"20000", OiStdDialogRes.getString("OiClusterConfigFileInput_INVALID_FILE_NAME")}, {"20001", OiStdDialogRes.getString("OiClusterConfigFileInput_FILE_DOES_NOT_EXIST")}, {"20002", OiStdDialogRes.getString("OiClusterConfigFileInput_DIRECTORY_MENTIONED")}, {"20003", OiStdDialogRes.getString("OiClusterConfigFileInput_SECURITY_EXCEPTION")}, {"20004", OiStdDialogRes.getString("OiClusterConfigFileInput_FILE_NOT_FOUND_EXCEPTION")}, {"20005", OiStdDialogRes.getString("OiClusterConfigFileInput_IO_EXCEPTION")}, {"20006", OiStdDialogRes.getString("OiClusterConfigFileInput_FILE_NOT_READABLE_EXCEPTION")}, {"20007", OiStdDialogRes.getString("OiClusterConfigFileInput_THROWABLE_ERROR")}, {"20008", OiStdDialogRes.getString("OiClusterConfigFileInput_NO_INFORMATION_RETRIEVED")}, {"20009", OiStdDialogRes.getString("OiClusterConfigFileInput_PUBNODE_NOTFOUND_EXCEPTION")}, {"20010", OiStdDialogRes.getString("OiClusterConfigFileInput_PRIVNODE_MISMATCH_EXCEPTION")}, {"20011", OiStdDialogRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_EXCEPTION")}, {"20012", OiStdDialogRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_GENERAL_ERROR")}, {"20013", OiStdDialogRes.getString("OiClusterConfigFileInput_NO_9IRAC_FOUND")}, {"20014", OiStdDialogRes.getString("OiClusterConfigFileInput_CLUSTER_NAME_NOT_SPECIFIED")}};
    private static final String ERROR_TITLE = OiStdDialogRes.getString("OiClusterConfigFileInput_ALERT_ERROR_TITLE");
    private static final String WARNING_TITLE = OiStdDialogRes.getString("OiClusterConfigFileInput_ALERT_WARNING_TITLE");
    private LWLabel label0 = new LWLabel(DEFAULT_LABEL_0);
    private LWTextField text0 = new LWTextField();
    private LWButton button0 = new LWButton(DEF_BUTTON_LABEL_0);
    private LWButton button1 = new LWButton(DEF_BUTTON_LABEL_1);
    private LWButton button2 = new LWButton(DEF_BUTTON_LABEL_2);
    private Color m_promptColor;
    private Color m_textLabelColor;
    private Color m_textFieldColor;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private int WIDTH = 500;
    private int HEIGHT = 150;
    private int TOP_VAL = 0;
    private int LEFT_VAL = 0;
    private BufferedDialog dispDialog = null;
    private String[] fillSpreadTable = null;
    private String clusterName = null;
    private boolean isVendorCluster = false;
    private String[] currentSpreadTable = null;
    private String[] nodeListFromAPI = null;
    private boolean isValidNodeSet = true;
    private String[] invalidNodes = null;
    private String exitMode = "CANCEL";
    private Cursor dCursor = null;
    FileDialog awtFileDlg = null;

    public OiClusterConfigFileInput() {
    }

    public OiClusterConfigFileInput(boolean isVendor, String[] curSpreadTable, String[] apiNodeList) {
        this.isVendorCluster = isVendor;
        this.currentSpreadTable = curSpreadTable == null ? this.copyArray(apiNodeList) : curSpreadTable;
        this.nodeListFromAPI = apiNodeList;
    }

    public OiClusterConfigFileInput(int top, int left, boolean isVendor, String[] curSpreadTable, String[] apiNodeList, Vector removedList) {
        super(DEFAULT_TITLE);
        this.TOP_VAL = top;
        this.LEFT_VAL = left;
        this.isVendorCluster = isVendor;
        if (curSpreadTable == null && removedList.size() != 0) {
            this.currentSpreadTable = this.copyArray(apiNodeList);
        } else if (curSpreadTable != null && removedList.size() != 0) {
            this.currentSpreadTable = this.copyArray(apiNodeList);
        } else if (curSpreadTable != null && removedList.size() == 0) {
            this.currentSpreadTable = curSpreadTable;
        }
        this.nodeListFromAPI = apiNodeList;
        this.gridbag = new GridBagLayout();
        this.mainPanel.setLayout((LayoutManager)this.gridbag);
        this.c = new GridBagConstraints();
        this.addComponent((Component)this.label0, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 0, 0, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.text0, (Container)this.mainPanel, this.gridbag, this.c, 2, 17, 1, 0, 3, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.button2, (Container)this.mainPanel, this.gridbag, this.c, 0, 13, 4, 0, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.button0, (Container)this.mainPanel, this.gridbag, this.c, 0, 13, 3, 1, 1, 1, 80.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.button1, (Container)this.mainPanel, this.gridbag, this.c, 0, 13, 4, 1, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.button0.addActionListener((ActionListener)this);
        this.button1.addActionListener((ActionListener)this);
        this.button2.addActionListener((ActionListener)this);
        OiifmMnemonicOps.processMnemonic((PushButton)this.button0);
        OiifmMnemonicOps.processMnemonic((PushButton)this.button1);
        OiifmMnemonicOps.processMnemonic((PushButton)this.button2);
        OiifmMnemonicOps.processMnemonic((LWLabel)this.label0);
        this.label0.setLabelFor((Component)this.text0);
    }

    public void showDialog(Frame parent) {
        this.dispDialog = new BufferedDialog(parent, DEFAULT_TITLE, true);
        WindowUtils.registerWindow((Window)this.dispDialog);
        this.dispDialog.add((Component)((Object)this));
        this.dispDialog.setSize(this.WIDTH, this.HEIGHT);
        WindowUtils.centerWindow((Window)this.dispDialog);
        this.dispDialog.setVisible(true);
        this.dispDialog.toFront();
        this.dispDialog.setFocusable(true);
    }

    private void addComponent(Component src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(src, gbc);
        dest.add(src);
    }

    public String[][] populateNodes(String configFile) {
        String[][] resultStr = new String[1][1];
        resultStr[0][0] = "ERROR0:20008";
        String curLine = null;
        Vector<String> vectorObj = new Vector<String>();
        String[] tempString = null;
        int rowCounter = 0;
        try {
            if (configFile == null || configFile.trim().length() == 0) {
                resultStr[0][0] = "ERROR0:20000";
                return resultStr;
            }
            File fileObj = new File(configFile);
            if (!fileObj.exists()) {
                resultStr[0][0] = "ERROR0:20001";
                return resultStr;
            }
            if (fileObj.isDirectory()) {
                resultStr[0][0] = "ERROR0:20002";
                return resultStr;
            }
            if (!fileObj.isFile()) {
                resultStr[0][0] = "ERROR0:20000";
                return resultStr;
            }
            if (!fileObj.canRead()) {
                resultStr[0][0] = "ERROR0:20006";
                return resultStr;
            }
            FileInputStream fileInputStreamObj = new FileInputStream(configFile);
            BufferedReader bufReaderObj = new BufferedReader(new InputStreamReader(fileInputStreamObj));
            int indexCounter = 0;
            boolean clusterNameParsed = false;
            while ((curLine = bufReaderObj.readLine()) != null) {
                if ((curLine = curLine.trim()).startsWith("#") || curLine.length() == 0 || (tempString = curLine.split("\\s+")) == null) continue;
                if (!clusterNameParsed) {
                    vectorObj.add(indexCounter++, curLine);
                    clusterNameParsed = true;
                } else if (tempString.length < 3) {
                    if (tempString.length == 1) {
                        vectorObj.add(indexCounter++, tempString[0]);
                        vectorObj.add(indexCounter++, "");
                        vectorObj.add(indexCounter++, "");
                    } else {
                        vectorObj.add(indexCounter++, tempString[0]);
                        vectorObj.add(indexCounter++, tempString[1]);
                        vectorObj.add(indexCounter++, "");
                    }
                } else if (tempString.length >= 3) {
                    for (int i = 0; i < 3; ++i) {
                        if (tempString[i] == null || tempString[i].trim().length() == 0) continue;
                        vectorObj.add(indexCounter++, tempString[i]);
                    }
                }
                vectorObj.add(indexCounter++, "END_OF_LINE");
                ++rowCounter;
            }
            if (rowCounter != 0) {
                resultStr = new String[rowCounter][];
                String tempVal = null;
                Vector<String> tempVector = null;
                int vectorIndex = 0;
                for (int i = 0; i < rowCounter; ++i) {
                    int k = 0;
                    tempVector = new Vector<String>();
                    while (!(tempVal = (String)vectorObj.elementAt(vectorIndex)).equals("END_OF_LINE")) {
                        tempVector.add(k++, tempVal);
                        ++vectorIndex;
                    }
                    ++vectorIndex;
                    resultStr[i] = new String[tempVector.size()];
                    for (int j = 0; j < tempVector.size(); ++j) {
                        resultStr[i][j] = (String)tempVector.elementAt(j);
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            resultStr = new String[1][1];
            resultStr[0][0] = "ERROR0:20004:" + fnfe.getMessage();
            return resultStr;
        }
        catch (SecurityException se) {
            resultStr = new String[1][1];
            resultStr[0][0] = "ERROR0:20003:" + se.getMessage();
            return resultStr;
        }
        catch (IOException ie) {
            resultStr = new String[1][1];
            resultStr[0][0] = "ERROR0:20005:" + ie.getMessage();
            return resultStr;
        }
        catch (Throwable t) {
            resultStr = new String[1][1];
            resultStr[0][0] = "ERROR0:20007:" + t.getMessage();
            return resultStr;
        }
        return resultStr;
    }

    public String[] validateNodeNames(String[] listReadFromFile) {
        Vector<String> inValidNodeVector = new Vector<String>();
        Vector<String> inValidPubNodesFromSpreadTable = new Vector<String>();
        Vector<String> inValidPubNodesFromFile = new Vector<String>();
        int idx = 0;
        int count9iRACNodesFromAPI = 0;
        boolean areFileNodesSubset = true;
        boolean areAllNodes9i = false;
        boolean comboCase = false;
        Vector<String> pickUp9iNodesFromSpreadTable = new Vector<String>();
        if (this.currentSpreadTable != null) {
            int i;
            for (i = 0; i < listReadFromFile.length; ++i) {
                if (listReadFromFile[i] == null) continue;
                inValidPubNodesFromFile.add(i, listReadFromFile[i].split(":")[0]);
            }
            for (i = 0; i < this.currentSpreadTable.length; ++i) {
                if (this.currentSpreadTable[i] == null) continue;
                inValidPubNodesFromSpreadTable.add(i, this.currentSpreadTable[i].split(":")[0]);
                if (!this.currentSpreadTable[i].split(":")[3].equalsIgnoreCase("Y")) continue;
                pickUp9iNodesFromSpreadTable.add(count9iRACNodesFromAPI, this.currentSpreadTable[i].split(":")[0]);
                ++count9iRACNodesFromAPI;
            }
            if (count9iRACNodesFromAPI == this.currentSpreadTable.length) {
                areAllNodes9i = true;
            }
            if (count9iRACNodesFromAPI > 0 && !areAllNodes9i) {
                comboCase = true;
            }
            if (count9iRACNodesFromAPI == 0) {
                // empty if block
            }
            if (listReadFromFile != null) {
                int i2;
                int counter;
                if (listReadFromFile.length > this.currentSpreadTable.length) {
                    areFileNodesSubset = false;
                    listReadFromFile = new String[]{"ERROR1:" + OiStdDialogRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_EXCEPTION")};
                    return listReadFromFile;
                }
                String curSpreadTablePubNode = null;
                String curSpreadTablePrivNode = null;
                String curPubNode = null;
                String curPrivNode = null;
                String[] tempArray1 = new String[5];
                String[] tempArray2 = new String[5];
                boolean isNodeSetValid = false;
                boolean isPubNodeFound = false;
                int matchingNodeIndex = -1;
                String matchingNode = "";
                for (int i3 = 0; i3 < listReadFromFile.length; ++i3) {
                    isNodeSetValid = false;
                    isPubNodeFound = false;
                    if (listReadFromFile[i3] == null) {
                        listReadFromFile = new String[]{"ERROR1:" + OiStdDialogRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_EXCEPTION")};
                        return listReadFromFile;
                    }
                    tempArray1 = listReadFromFile[i3].split(":");
                    curPubNode = tempArray1[0];
                    curPrivNode = tempArray1[1];
                    for (int j = 0; j < this.currentSpreadTable.length; ++j) {
                        if (this.currentSpreadTable[j] == null) continue;
                        tempArray2 = this.currentSpreadTable[j].split(":");
                        curSpreadTablePubNode = tempArray2[0];
                        String string = curSpreadTablePrivNode = tempArray2[1] == null ? "" : tempArray2[1];
                        if (!curPubNode.equalsIgnoreCase(curSpreadTablePubNode)) continue;
                        isPubNodeFound = true;
                        matchingNode = curSpreadTablePubNode;
                        if (tempArray2[4].equalsIgnoreCase("Y")) {
                            this.currentSpreadTable[j] = tempArray1[0] + ":" + tempArray1[1] + ":" + tempArray1[2] + ":" + this.currentSpreadTable[j].split(":")[3] + ":" + this.currentSpreadTable[j].split(":")[4];
                            isNodeSetValid = true;
                            break;
                        }
                        if (!curPrivNode.equalsIgnoreCase(curSpreadTablePrivNode)) break;
                        isNodeSetValid = true;
                        break;
                    }
                    if (isPubNodeFound && isNodeSetValid) {
                        inValidPubNodesFromSpreadTable.removeElement(matchingNode);
                        inValidPubNodesFromFile.removeElement(matchingNode);
                    }
                    if (!isPubNodeFound || isNodeSetValid) continue;
                    inValidPubNodesFromFile.removeElement(matchingNode);
                    inValidPubNodesFromSpreadTable.removeElement(matchingNode);
                    inValidNodeVector.add(idx++, "20010:" + tempArray2[0]);
                }
                if (!comboCase && inValidPubNodesFromFile.size() > 0) {
                    counter = inValidNodeVector.size();
                    for (i2 = 0; i2 < inValidPubNodesFromSpreadTable.size(); ++i2) {
                        inValidNodeVector.add(counter++, "20009:" + inValidPubNodesFromSpreadTable.elementAt(i2));
                    }
                }
                if (!comboCase && areAllNodes9i && inValidPubNodesFromFile.size() == 0 && inValidPubNodesFromSpreadTable.size() > 0) {
                    counter = inValidNodeVector.size();
                    for (i2 = 0; i2 < inValidPubNodesFromSpreadTable.size(); ++i2) {
                        inValidNodeVector.add(counter++, "20009:" + inValidPubNodesFromSpreadTable.elementAt(i2));
                    }
                }
                if (comboCase) {
                    if (inValidPubNodesFromFile.size() > 0) {
                        counter = inValidNodeVector.size();
                        for (i2 = 0; i2 < inValidPubNodesFromSpreadTable.size(); ++i2) {
                            inValidNodeVector.add(counter++, "20009:" + inValidPubNodesFromSpreadTable.elementAt(i2));
                        }
                    } else if (inValidPubNodesFromSpreadTable.size() > 0) {
                        counter = inValidNodeVector.size();
                        for (i2 = 0; i2 < inValidPubNodesFromSpreadTable.size(); ++i2) {
                            String a = (String)inValidPubNodesFromSpreadTable.elementAt(i2);
                            for (int j = 0; j < pickUp9iNodesFromSpreadTable.size(); ++j) {
                                String b = (String)pickUp9iNodesFromSpreadTable.elementAt(j);
                                if (!a.equalsIgnoreCase(b)) continue;
                                inValidNodeVector.add(counter++, "20009:" + inValidPubNodesFromSpreadTable.elementAt(i2));
                            }
                        }
                    }
                }
            }
        } else {
            if (listReadFromFile != null) {
                return listReadFromFile;
            }
            listReadFromFile = new String[]{"ERROR1:" + OiStdDialogRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_EXCEPTION")};
            return listReadFromFile;
        }
        if (inValidNodeVector.size() == 0) {
            return this.currentSpreadTable;
        }
        String[] errorArray = new String[inValidNodeVector.size()];
        for (int i = 0; i < inValidNodeVector.size(); ++i) {
            errorArray[i] = "ERROR2:" + inValidNodeVector.elementAt(i);
        }
        return errorArray;
    }

    public String[] copyArray(String[] curArray) {
        if (curArray != null) {
            this.currentSpreadTable = new String[curArray.length];
            for (int i = 0; i < curArray.length; ++i) {
                this.currentSpreadTable[i] = curArray[i];
            }
        }
        return this.currentSpreadTable;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (this.dispDialog.isVisible()) {
            this.dispDialog.toFront();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String configFileName;
        String[][] nodeList;
        Object source = event.getSource();
        if (source == this.button2) {
            this.button2.setEnabled(false);
            this.onBrowse();
            this.button2.setEnabled(true);
        } else if (source == this.button1) {
            this.setText0("");
            this.setExitMode("CANCEL");
            this.setVisible(false);
            this.dispDialog.setVisible(false);
            this.cleanUp();
        } else if (source == this.button0 && this.evaluateNodes(nodeList = this.populateNodes(configFileName = this.getText0()))) {
            this.setExitMode("OK");
            this.setVisible(false);
            this.dispDialog.setVisible(false);
            this.cleanUp();
        }
    }

    public String[] getSpreadTableValues() {
        return this.fillSpreadTable;
    }

    public void setClusterName(String cluster) {
        this.clusterName = cluster;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void cleanUp() {
        this.dispDialog.dispose();
    }

    public boolean evaluateNodes(String[][] nodeList) {
        boolean areNodesValid = false;
        int lenOutput = nodeList.length;
        if (nodeList[0][0].startsWith("ERROR0")) {
            int errorCode = Integer.parseInt(nodeList[0][0].split(":", 2)[1]);
            return this.handleFileError(errorCode);
        }
        this.setClusterName(nodeList[0][0]);
        this.fillSpreadTable = new String[nodeList.length - 1];
        for (int i = 1; i < nodeList.length; ++i) {
            this.fillSpreadTable[i - 1] = !this.isVendorCluster ? nodeList[i][0] + ":" + nodeList[i][1] + ":" + nodeList[i][2] + ":" + "N:Y" : nodeList[i][0] + ":" + nodeList[i][1] + ":" + nodeList[i][2] + ":" + "N:Y";
        }
        if (this.isVendorCluster) {
            this.fillSpreadTable = this.validateNodeNames(this.fillSpreadTable);
            if (this.fillSpreadTable[0].startsWith("ERROR1")) {
                return this.handleFileError(this.fillSpreadTable[0].split(":", 2)[1]);
            }
            if (this.fillSpreadTable[0].startsWith("ERROR2")) {
                String errorMessage = null;
                String unavailablePublicNodes = "";
                String invalidPubPrivNodes = "";
                for (int i = 0; i < this.fillSpreadTable.length; ++i) {
                    if (this.fillSpreadTable[i].split(":", 3)[1].equals("20009")) {
                        unavailablePublicNodes = unavailablePublicNodes + this.fillSpreadTable[i].split(":", 3)[2] + " ";
                        continue;
                    }
                    invalidPubPrivNodes = invalidPubPrivNodes + this.fillSpreadTable[i].split(":", 3)[2] + " ";
                }
                errorMessage = OiStdDialogRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_GENERAL_ERROR");
                errorMessage = errorMessage + "\n\n";
                if (unavailablePublicNodes.trim().length() != 0) {
                    errorMessage = errorMessage + OiStdDialogRes.getString("OiClusterConfigFileInput_PUBNODE_NOTFOUND_EXCEPTION");
                    errorMessage = errorMessage + "\n";
                    errorMessage = errorMessage + "\t" + unavailablePublicNodes;
                    errorMessage = errorMessage + "\n";
                }
                if (invalidPubPrivNodes.trim().length() != 0) {
                    errorMessage = errorMessage + OiStdDialogRes.getString("OiClusterConfigFileInput_PRIVNODE_MISMATCH_EXCEPTION");
                    errorMessage = errorMessage + "\n";
                    errorMessage = errorMessage + "\t" + invalidPubPrivNodes;
                    errorMessage = errorMessage + "\n";
                }
                errorMessage = errorMessage + OiStdDialogRes.getString("OiClusterConfigFileInput_CORRECTIVE_ACTION");
                return this.handleFileError(errorMessage);
            }
            if (this.fillSpreadTable[0].startsWith("ERROR3")) {
                return this.handleFileError(this.fillSpreadTable[0].split(":", 2)[1]);
            }
            areNodesValid = true;
        } else {
            String localNode = this.nodeListFromAPI[0].split(":")[0];
            for (int i = 0; i < this.fillSpreadTable.length; ++i) {
                String currentPubNodeFromFile = this.fillSpreadTable[i].split(":")[0];
                try {
                    InetAddress inetObjLocalNodeFromAPI = InetAddress.getByName(localNode);
                    InetAddress inetObjLocalNodeFromFile = InetAddress.getByName(currentPubNodeFromFile);
                    String localNodeFromAPI_IP = inetObjLocalNodeFromAPI.getHostAddress();
                    String localNodeFromFile_IP = inetObjLocalNodeFromFile.getHostAddress();
                    if (!localNodeFromAPI_IP.equalsIgnoreCase(localNodeFromFile_IP)) continue;
                    areNodesValid = true;
                    break;
                }
                catch (UnknownHostException unkhe) {
                    String errorText = "Exception Occurred while comparing the localNode from install flow:" + localNode + " and " + "the localNode retrieved from the CCF file:" + currentPubNodeFromFile;
                    OiiolTextLogger.appendText((String)errorText);
                    OiiolTextLogger.appendText((String)unkhe.getMessage());
                }
            }
            if (!areNodesValid) {
                String message = OiStdDialogRes.getString("OiClusterConfigFileInput_LOCAL_NODE_MISSING_EXCEPTION");
                return this.handleFileError(message);
            }
        }
        return areNodesValid;
    }

    private boolean handleFileError(int errorCode) {
        String currentErrorMessage = "";
        for (int i = 0; i < ERROR_MESSAGE.length; ++i) {
            if (errorCode != Integer.parseInt(ERROR_MESSAGE[i][0])) continue;
            currentErrorMessage = ERROR_MESSAGE[i][1];
            break;
        }
        OiifmAlert.displayAlert((String)ERROR_TITLE, (String)currentErrorMessage, (int)50, (int)1, (int)1, (int)20);
        return false;
    }

    private boolean handleFileError(String errorMessage) {
        OiifmAlert.displayAlert((String)ERROR_TITLE, (String)errorMessage, (int)50, (int)1, (int)1, (int)20);
        return false;
    }

    private boolean handleFileError(int errorCode, String errorMessage) {
        String currentErrorMessage = "";
        for (int i = 0; i < ERROR_MESSAGE.length; ++i) {
            if (errorCode != Integer.parseInt(ERROR_MESSAGE[i][0])) continue;
            currentErrorMessage = ERROR_MESSAGE[i][1];
            break;
        }
        OiifmAlert.displayAlert((String)ERROR_TITLE, (String)(currentErrorMessage + "\n" + errorMessage), (int)50, (int)1, (int)1, (int)20);
        return false;
    }

    private boolean handleFileError(int errorCode, int severity) {
        String currentErrorMessage = "";
        for (int i = 0; i < ERROR_MESSAGE.length; ++i) {
            if (errorCode != Integer.parseInt(ERROR_MESSAGE[i][0])) continue;
            currentErrorMessage = ERROR_MESSAGE[i][1];
            break;
        }
        if (severity == 2) {
            OiifmAlert.displayAlert((String)WARNING_TITLE, (String)currentErrorMessage, (int)30, (int)1, (int)1, (int)20);
        } else {
            OiifmAlert.displayAlert((String)ERROR_TITLE, (String)currentErrorMessage, (int)50, (int)1, (int)1, (int)20);
        }
        return false;
    }

    private void onBrowse() {
        this.awtFileDlg = new FileDialog(WindowUtils.parentFrame((Component)((Object)this)), CHOOSE_DIR, 0);
        this.awtFileDlg.setModal(true);
        WindowUtils.centerWindow((Window)this.awtFileDlg, (Component)this.dispDialog);
        this.awtFileDlg.toFront();
        this.awtFileDlg.setVisible(true);
        String dirLocation = this.awtFileDlg.getDirectory();
        String fileName = this.awtFileDlg.getFile();
        String absolutePath = "";
        if (dirLocation != null && dirLocation.trim().length() != 0 && fileName != null && fileName.trim().length() != 0) {
            absolutePath = dirLocation + fileName;
        }
        this.setText0(absolutePath);
    }

    public String getLabel0() {
        return this.label0.getText();
    }

    public void setExitMode(String mode) {
        this.exitMode = mode;
    }

    public String getExitMode() {
        return this.exitMode;
    }

    public void setLabel0(String label) {
        this.invalidate();
        this.label0.setText(label);
        this.validate();
    }

    public void setText0(String text) {
        if (text != null) {
            this.text0.setText(text.trim());
        }
    }

    public String getText0() {
        return this.text0.getText();
    }

    public void markLabel0() {
        this.label0.setBackground(this._markColor);
    }

    public void unmarkLabel0() {
        this.label0.setBackground(this.m_textLabelColor);
    }

    public static void main(String[] args) {
        BufferedFrame p = new BufferedFrame();
        OiClusterConfigFileInput panel1 = new OiClusterConfigFileInput();
        p.add((Component)((Object)panel1));
        int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int x = maxWidth / 2 - 250;
        int y = maxHeight / 2 - 75;
        p.setSize(430, 200);
        p.show();
        String output = panel1.getText0();
    }
}

