/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import oracle.ewt.UIManager;
import oracle.ewt.button.PushButton;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.layout.GroupBoxContainer;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiClusterStorage
extends OiifpWizPanel
implements ActionListener,
GridEditListener,
GridRowSelectListener {
    private static final String DEFAULT_TITLE = "Configure Cluster Storage";
    private static final String DEFAULT_PROMPT_0 = "Below is a list of available shared disks on the cluster. Designate which disks should be used for storing the Oracle Cluster Registry(OCR) and Cluster Synchronization Services (CSS) Voting disk. Unless your disks are already redundant, you should specify two partitions for the OCR and three partitions for the CSS Voting Disk. \n\n In addition you may specify which disks you wish to format with the Oracle Cluster File System (CFS), the format type and a drive letter to mount the formatted disk.";
    private static final String DEFAULT_SUBTITLE_0 = "Available Disks";
    private static final String DEFAULT_LABEL_0 = OiStdDialogRes.getString("OiCS_DEFAULT_DRIVE");
    private static final String DEFAULT_LABEL_1 = OiStdDialogRes.getString("OiCS_DEFAULT_FORMAT_TYPE");
    private static final String DEFAULT_LABEL_2 = OiStdDialogRes.getString("OiCS_DEFAULT_USAGE");
    private static final String DEFAULT_BUTTON_LABEL_0 = OiStdDialogRes.getString("OiCS_EDIT");
    private MultiLineLabel prompt0 = new MultiLineLabel(WordWrapper.getTextWrapper(), "Below is a list of available shared disks on the cluster. Designate which disks should be used for storing the Oracle Cluster Registry(OCR) and Cluster Synchronization Services (CSS) Voting disk. Unless your disks are already redundant, you should specify two partitions for the OCR and three partitions for the CSS Voting Disk. \n\n In addition you may specify which disks you wish to format with the Oracle Cluster File System (CFS), the format type and a drive letter to mount the formatted disk.");
    private LWLabel subTitle0 = new LWLabel("Available Disks");
    private LWButton button0 = new LWButton(DEFAULT_BUTTON_LABEL_0);
    private LWContainer panel0 = null;
    private SingleRowSelection gridSel;
    private Vector vecSelectable = new Vector();
    private String[] gridData = null;
    private String[] initialGridData = null;
    private static String[] DEF_COL_HEADERS = new String[]{OiStdDialogRes.getString("OiCS_DSKNUM_COL_LABEL"), OiStdDialogRes.getString("OiCS_PARTNUM_COL_LABEL"), OiStdDialogRes.getString("OiCS_PARTSIZE_COL_LABEL"), OiStdDialogRes.getString("OiCS_FMTTYPE_COL_LABEL"), OiStdDialogRes.getString("OiCS_DRVLTR_COL_LABEL"), OiStdDialogRes.getString("OiCS_USAGE_COL_LABEL")};
    private static int S_EMPTY_COLWIDTH = 20;
    private static int S_DISKNUM_COLWIDTH = 60;
    private static int S_PARTNUM_COLWIDTH = 90;
    private static int S_PARTSIZE_COLWIDTH = 70;
    private static int S_FORMAT_TYPE_COLWIDTH = 120;
    private static int S_DRIVE_LETTER_COLWIDTH = 100;
    private static int S_USAGE_COLWIDTH = 160;
    private static int totRows = 0;
    private SpreadTable sTable;
    private ArrayTwoDDataSource data;
    private ArrayOneDDataSource header;
    private ScrollBox tableScroll;
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c;
    private String[] Availdrives = null;
    private String strSelectionIndex0 = "";
    private int Row;
    private Grid grid;

    public OiClusterStorage() {
        super(DEFAULT_TITLE);
        this.mainPanel.setLayout((LayoutManager)this.gridbag);
        this.c = new GridBagConstraints();
        this.addComponent((Component)this.prompt0, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 0, 0, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.createPanel0();
        this.addComponent((Component)this.panel0, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 0, 1, 2, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
    }

    private void createPanel0() {
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        this.panel0 = new LWContainer();
        this.panel0.setLayout((LayoutManager)gridBag1);
        this.panel0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 1, 12));
        this.panel0.setBorderPainter(UIManager.createGroupBoxPainter((String)this.getSubTitle0()));
        int colLength = DEF_COL_HEADERS.length;
        this.header = new ArrayOneDDataSource((Object[])DEF_COL_HEADERS);
        this.data = new ArrayTwoDDataSource(colLength, 5);
        this.sTable = new SpreadTable((TwoDDataSource)this.data, (OneDDataSource)this.header, null);
        this.sTable.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 10));
        this.button0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 12));
        this.sTable.setColumnWidth(0, S_DISKNUM_COLWIDTH);
        this.sTable.setColumnWidth(1, S_PARTNUM_COLWIDTH);
        this.sTable.setColumnWidth(2, S_PARTSIZE_COLWIDTH);
        this.sTable.setColumnWidth(3, S_FORMAT_TYPE_COLWIDTH);
        this.sTable.setColumnWidth(4, S_DRIVE_LETTER_COLWIDTH);
        this.sTable.setColumnWidth(5, S_USAGE_COLWIDTH);
        this.sTable.setHorizontalSeparatorsVisible(true);
        this.sTable.setVerticalSeparatorsVisible(true);
        this.grid = this.sTable.getGrid();
        this.gridSel = new SingleRowSelection();
        this.grid.setGridSelection((GridSelection)this.gridSel);
        this.grid.addRowSelectListener((GridRowSelectListener)this);
        this.grid.addEditListener((GridEditListener)this);
        this.tableScroll = new ScrollBox((Component)this.sTable, 0, 0);
        this.addComponent((Component)this.tableScroll, (Container)this.panel0, gridBag1, c1, 1, 17, 0, 0, 0, 1, 1.0, 1.5, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.button0, (Container)this.panel0, gridBag1, c1, 0, 13, 0, 2, 1, 1, 1.0, 0.0, new Insets(1, 1, 5, 1));
        this.button0.addActionListener((ActionListener)this);
    }

    public void setPrompt0(String text) {
        if (text != null) {
            this.prompt0.setText(text);
        }
    }

    public String getPrompt0() {
        return this.prompt0.getText();
    }

    public void setSubTitle0(String text) {
        if (text != null) {
            this.subTitle0.setText(text);
            this.panel0.setBorderPainter(UIManager.createGroupBoxPainter((String)text));
        }
    }

    public String getSubTitle0() {
        return this.subTitle0.getText();
    }

    public void setButtonLabel(String text) {
        if (text != null) {
            this.button0.setLabel(text);
        }
    }

    public String getButtonLabel() {
        return this.button0.getLabel();
    }

    public void setDriveLetters(String[] drives) {
        this.Availdrives = drives;
    }

    public String[] getDriveLetters() {
        return this.Availdrives;
    }

    public String[] getAvailableDriveLetters(int selectedRow) {
        String defaultDrive;
        String[] currentGridTable = this.getTable();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.Availdrives.length; ++i) {
            v.add(i, this.Availdrives[i]);
        }
        String[] Availabledrives = null;
        this.grid = this.sTable.getGrid();
        int colCount = this.data.getColumnCount();
        int rowCount = currentGridTable.length / colCount;
        int selectedRowDriveIndex = (selectedRow + 1) * colCount - 2;
        block1: for (int idx = 4; idx < currentGridTable.length; idx += 6) {
            for (int j = 0; j < v.size(); ++j) {
                String curDrive = (String)v.elementAt(j);
                if (currentGridTable[idx] == null || !currentGridTable[idx].equalsIgnoreCase(curDrive)) continue;
                v.remove(curDrive);
                continue block1;
            }
        }
        if (currentGridTable[selectedRowDriveIndex] != null && !currentGridTable[selectedRowDriveIndex].equalsIgnoreCase(defaultDrive = OiStdDialogRes.getString("OiCS_DEFAULT_DRIVE"))) {
            v.add(currentGridTable[selectedRowDriveIndex]);
        }
        Availabledrives = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            Availabledrives[i] = (String)v.elementAt(i);
        }
        return Availabledrives;
    }

    public String[] getInitialTable() {
        return this.initialGridData;
    }

    public void setInitialTable(String[] list) {
        this.initialGridData = this.copyArrayToArray(list, this.initialGridData);
    }

    public String[] getTable() {
        if (this.gridData != null && this.gridData.length > 0) {
            return this.gridData;
        }
        return new String[]{""};
    }

    public void setTable(String[] list) {
        int selRow = 0;
        if (list != null && (list[0].equalsIgnoreCase("NO_VAL") || list[0].equalsIgnoreCase(""))) {
            this.gridData = this.initialGridData;
            list = this.gridData;
        } else {
            this.gridData = list;
        }
        this.invalidate();
        this.vecSelectable.removeAllElements();
        this.data.removeRows(0, this.data.getRowCount());
        int rows = list.length / 6;
        this.data.addRows(0, rows);
        int rowIdx = -1;
        int listIdx = 0;
        while (listIdx < list.length) {
            ++rowIdx;
            for (int colIdx = 0; colIdx < this.data.getColumnCount(); ++colIdx) {
                switch (colIdx) {
                    case 3: {
                        if (list[listIdx] == null || list[listIdx].length() == 0) {
                            list[listIdx] = "0";
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_DEFAULT_FORMAT_TYPE"));
                            break;
                        }
                        if (Integer.parseInt(list[listIdx]) == 0) {
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_DEFAULT_FORMAT_TYPE"));
                            break;
                        }
                        if (Integer.parseInt(list[listIdx]) == 1) {
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_DATA_FORMAT_TYPE"));
                            break;
                        }
                        this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_SOFTWARE_FORMAT_TYPE"));
                        break;
                    }
                    case 4: {
                        if (list[listIdx] == null || list[listIdx].length() == 0) {
                            list[listIdx] = OiStdDialogRes.getString("OiCS_DEFAULT_DRIVE");
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_DEFAULT_DRIVE"));
                            break;
                        }
                        this.data.setData(colIdx, rowIdx, (Object)list[listIdx]);
                        break;
                    }
                    case 5: {
                        if (list[listIdx] == null || list[listIdx].length() == 0) {
                            list[listIdx] = "0";
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_DEFAULT_USAGE"));
                            break;
                        }
                        if (Integer.parseInt(list[listIdx]) == 0) {
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_DEFAULT_USAGE"));
                            break;
                        }
                        if (Integer.parseInt(list[listIdx]) == 1) {
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_OCR_USAGE"));
                            break;
                        }
                        if (Integer.parseInt(list[listIdx]) == 2) {
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_VD_USAGE"));
                            break;
                        }
                        if (Integer.parseInt(list[listIdx]) == 3) {
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_VD_OCR_USAGE"));
                            break;
                        }
                        if (Integer.parseInt(list[listIdx]) == 4) {
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_OCR_MIRROR_USAGE"));
                            break;
                        }
                        if (Integer.parseInt(list[listIdx]) == 5) {
                            this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_VD_OCR_MIRROR_USAGE"));
                            break;
                        }
                        this.data.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiCS_DEFAULT_USAGE"));
                        break;
                    }
                    default: {
                        this.data.setData(colIdx, rowIdx, (Object)list[listIdx]);
                    }
                }
                ++listIdx;
            }
        }
        this.sTable.setDataSources((TwoDDataSource)this.data, (OneDDataSource)this.header, null);
        this.gridSel.setRowSelected(selRow, true);
        this.validate();
    }

    public void setSelection(String[] answer) {
        int anslen = answer.length;
        int match = 0;
        if (anslen != 0 && anslen == this.data.getColumnCount() - 1) {
            for (int rowIdx = 0; rowIdx < this.data.getRowCount(); ++rowIdx) {
                for (int colIdx = 0; colIdx < this.data.getColumnCount(); ++colIdx) {
                    if (answer[match].equalsIgnoreCase((String)this.data.getData(colIdx, rowIdx))) {
                        ++match;
                        continue;
                    }
                    match = 0;
                }
                if (match != this.data.getColumnCount() - 1) continue;
                this.gridSel.setRowSelected(rowIdx, true);
                this.data.setData(0, rowIdx, (Object)new Boolean(true));
                break;
            }
        }
        if (match == 0) {
            this.gridSel.setRowSelected(match, true);
            this.data.setData(match, match, (Object)new Boolean(true));
        }
    }

    public String[] getSelection() {
        String[] selections = new String[this.data.getColumnCount()];
        int[] rowSel = this.gridSel.getSelectedRows();
        int selStartIndex = (rowSel[0] + 1) * 6 - 6;
        for (int cellIdx = 0; cellIdx < 6; ++cellIdx) {
            selections[cellIdx] = this.gridData[selStartIndex++];
        }
        return selections;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Point pt = this.mainPanel.getLocation();
        int top = (int)pt.getY();
        int left = (int)pt.getX();
        int UsageCol = this.data.getColumnCount() - 1;
        int DrvLtrCol = UsageCol - 1;
        int FmtTypCol = DrvLtrCol - 1;
        Boolean fmtCfs = new Boolean(false);
        String StoreType = null;
        String DriveLetter = "";
        String[] partSel = this.getSelection();
        int[] selRow = this.gridSel.getSelectedRows();
        int selStartIndex = (selRow[0] + 1) * 6 - 6;
        String[] AvailDrvLtrs = this.getAvailableDriveLetters(selRow[0]);
        OiDiskConf DiskConf = new OiDiskConf(top + 30, left + 100, partSel, AvailDrvLtrs, this.gridData);
        DiskConf.display();
        Boolean OcrUsage = DiskConf.getSelection0();
        Boolean OcrMirrorUsage = DiskConf.getSelection0_1();
        Boolean VdskUsage = DiskConf.getSelection1();
        fmtCfs = DiskConf.getSelection2();
        if (fmtCfs.booleanValue()) {
            StoreType = DiskConf.getSelection3();
            DriveLetter = DiskConf.getSelection4();
        }
        DiskConf.Dlgdispose();
        if (OcrUsage.booleanValue() && !OcrMirrorUsage.booleanValue() && !VdskUsage.booleanValue()) {
            this.data.setData(UsageCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_OCR_USAGE"));
            this.gridData[selStartIndex + 5] = "1";
        } else if (OcrMirrorUsage.booleanValue() && !OcrUsage.booleanValue() && !VdskUsage.booleanValue()) {
            this.data.setData(UsageCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_OCR_MIRROR_USAGE"));
            this.gridData[selStartIndex + 5] = "4";
        } else if (VdskUsage.booleanValue() && !OcrMirrorUsage.booleanValue() && !OcrUsage.booleanValue()) {
            this.data.setData(UsageCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_VD_USAGE"));
            this.gridData[selStartIndex + 5] = "2";
        } else if (OcrUsage.booleanValue() && VdskUsage.booleanValue() && !OcrMirrorUsage.booleanValue()) {
            this.data.setData(UsageCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_VD_OCR_USAGE"));
            this.gridData[selStartIndex + 5] = "3";
        } else if (OcrMirrorUsage.booleanValue() && VdskUsage.booleanValue() && !OcrUsage.booleanValue()) {
            this.data.setData(UsageCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_VD_OCR_MIRROR_USAGE"));
            this.gridData[selStartIndex + 5] = "5";
        } else {
            this.data.setData(UsageCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_DEFAULT_USAGE"));
            this.gridData[selStartIndex + 5] = "0";
        }
        if (fmtCfs.booleanValue() && StoreType.equals("cb0")) {
            this.data.setData(FmtTypCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_DATA_FORMAT_TYPE"));
            this.gridData[selStartIndex + 3] = "1";
            this.data.setData(DrvLtrCol, this.Row, (Object)DriveLetter);
            this.gridData[selStartIndex + 4] = DriveLetter;
        }
        if (fmtCfs.booleanValue() && StoreType.equals("cb1")) {
            this.data.setData(FmtTypCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_SOFTWARE_FORMAT_TYPE"));
            this.gridData[selStartIndex + 3] = "2";
            this.data.setData(DrvLtrCol, this.Row, (Object)DriveLetter);
            this.gridData[selStartIndex + 4] = DriveLetter;
        }
        if (!fmtCfs.booleanValue()) {
            this.data.setData(FmtTypCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_DEFAULT_FORMAT_TYPE"));
            this.gridData[selStartIndex + 3] = "0";
            this.data.setData(DrvLtrCol, this.Row, (Object)OiStdDialogRes.getString("OiCS_DEFAULT_DRIVE"));
            this.gridData[selStartIndex + 4] = OiStdDialogRes.getString("OiCS_DEFAULT_DRIVE");
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void cellEditing(GridEvent e) {
    }

    public void cellEdited(GridEvent e) {
    }

    public void rowSelecting(GridEvent e) {
    }

    public void rowDeselecting(GridEvent e) {
    }

    public void rowDeselected(GridEvent e) {
    }

    public void rowSelected(GridEvent e) {
        int selectedRow;
        this.Row = selectedRow = e.getRow();
    }

    private String[] copyArrayToArray(String[] fromArr, String[] toArr) {
        toArr = new String[fromArr.length - 1];
        for (int i = 1; i < fromArr.length; ++i) {
            toArr[i - 1] = fromArr[i];
        }
        return toArr;
    }

    private void addComponent(Component src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(src, gbc);
        dest.add(src);
    }

    public static void main(String[] args) {
        BufferedFrame p = new BufferedFrame();
        OiClusterStorage obj = new OiClusterStorage();
        String[] setTableArgs = new String[]{"NO_VAL"};
        String[] setInitialTableArgs = new String[]{"NO_VAL", "1", "2", "3", "", "", "", "4", "5", "6", "", "", "", "7", "8", "9", "", "", "", "10", "11", "12", "", "", ""};
        String[] setSelArgs = new String[]{"7", "8", "9", "Raw", "N/A", "None"};
        String[] Drvs = new String[]{"b:", "c:", "d:", "f:", "g:", "h:"};
        obj.setInitialTable(setInitialTableArgs);
        obj.setTable(setTableArgs);
        obj.setDriveLetters(Drvs);
        p.add((Component)((Object)obj));
        p.setSize(630, 400);
        p.show();
    }

    private class OiDiskConf
    extends OiifpWizPanel
    implements ActionListener,
    ItemListener {
        private GridBagLayout gridbag;
        private GridBagConstraints c;
        private String title = OiStdDialogRes.getString("OiDiskConf_TITLE");
        private String subTitle0 = OiStdDialogRes.getString("OiDiskConfring_USAGE_TITLE_LABEL");
        private String myPrompt0 = OiStdDialogRes.getString("OiDiskConf_PROMPT0");
        private String myPrompt1 = OiStdDialogRes.getString("OiDiskConf_PROMPT1");
        private MultiLineLabel prompt0 = new MultiLineLabel(WordWrapper.getTextWrapper(), this.myPrompt0);
        private MultiLineLabel prompt1 = new MultiLineLabel(WordWrapper.getTextWrapper(), this.myPrompt1);
        private LWLabel ChoiceLabel = new LWLabel();
        private String label0Str = OiStdDialogRes.getString("OiDiskConf_DISK_LABEL");
        private String label1Str = OiStdDialogRes.getString("OiDiskConf_PARTITION_LABEL");
        private String label2Str = OiStdDialogRes.getString("OiDiskConf_SIZE_LABEL");
        private String[] DEF_CHOICES = new String[]{"c:", "d:"};
        private LWButton button1 = new LWButton(OiStdDialogRes.getString("OiDiskConf_BUTTON_LABEL_1"));
        private LWButton button2 = new LWButton(OiStdDialogRes.getString("OiDiskConf_BUTTON_LABEL_2"));
        private LWContainer topPanel = null;
        private LWContainer panel0 = null;
        private LWContainer panel1 = null;
        private LWContainer panel2 = null;
        private LWCheckboxGroup checkGroup;
        private LWCheckbox Checkbox0;
        private LWCheckbox Checkbox0_1;
        private LWCheckbox Checkbox1;
        private LWCheckbox cb0;
        private LWCheckbox cb1;
        private LWCheckbox Checkbox2;
        private LWChoice Choice1;
        private BufferedDialog dlg;
        private int top = 0;
        private int left = 0;
        private int WIDTH = 485;
        private int HEIGHT = 370;
        private boolean oldOcrUsage_val;
        private boolean oldOcrMirrorUsage_val;
        private boolean oldVdskUsage_val;
        private boolean oldfmtCfs_val;
        private String oldDriveLetter_val;
        private String oldStoreType_val;
        private int startIndexOCRPrimary = -1;
        private int startIndexOCRMirror = -1;
        private String[] selectedDiskData = null;
        private String[] currentAvailableDrives = null;
        private String[] currentGridData = null;
        private String[] alsoToBeChangedRow = null;
        boolean doesOCRPrimaryExist = false;
        boolean doesOCRMirrorExist = false;
        private boolean trapCboxStatusOCRPrimary = false;
        private boolean trapCboxStatusOCRMirror = false;

        private OiDiskConf() {
            this(0, 0, null, null, null);
        }

        private OiDiskConf(int top, int left, String[] DiskSel, String[] DrvLtrs, String[] curGridData) {
            this.top = top;
            this.left = left;
            this.gridbag = new GridBagLayout();
            this.mainPanel.setLayout((LayoutManager)this.gridbag);
            this.c = new GridBagConstraints();
            this.currentGridData = curGridData;
            this.button1.setDefault(true);
            this.selectedDiskData = DiskSel;
            this.currentAvailableDrives = DrvLtrs;
            this.Choice1 = new LWChoice();
            this.setChoice(this.currentAvailableDrives);
            this.createTopPanel();
            this.createPanel0();
            this.createPanel1();
            OiClusterStorage.this.addComponent((Component)this.topPanel, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 0, 0, 6, 1, 10.0, 5.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)this.panel0, (Container)this.mainPanel, this.gridbag, this.c, 0, 17, 0, 5, 3, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)this.panel1, (Container)this.mainPanel, this.gridbag, this.c, 0, 17, 3, 5, 3, 1, 20.0, 0.0, new Insets(3, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)this.button1, (Container)this.mainPanel, this.gridbag, this.c, 0, 13, 4, 6, 1, 1, 2.0, 0.0, new Insets(10, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)this.button2, (Container)this.mainPanel, this.gridbag, this.c, 0, 13, 5, 6, 1, 1, 0.0, 0.0, new Insets(10, 0, 0, 0));
            this.button1.addActionListener((ActionListener)this);
            this.button2.addActionListener((ActionListener)this);
            OiifmMnemonicOps.processMnemonic((PushButton)this.button1);
        }

        private void createTopPanel() {
            GridBagLayout gridBag1 = new GridBagLayout();
            GridBagConstraints c1 = new GridBagConstraints();
            this.topPanel = new LWContainer();
            this.topPanel.setLayout((LayoutManager)gridBag1);
            LWLabel label0 = new LWLabel(this.label0Str);
            LWLabel label0Value = new LWLabel(this.selectedDiskData[0]);
            LWLabel label1 = new LWLabel(this.label1Str);
            LWLabel label1Value = new LWLabel(this.selectedDiskData[1]);
            LWLabel label2 = new LWLabel(this.label2Str);
            LWLabel label2Value = new LWLabel(this.selectedDiskData[2]);
            this.topPanel.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 12));
            OiClusterStorage.this.addComponent((Component)this.prompt0, (Container)this.topPanel, gridBag1, c1, 2, 17, 0, 0, 6, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)this.prompt1, (Container)this.topPanel, gridBag1, c1, 1, 17, 0, 1, 6, 1, 1.0, 2.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)label0, (Container)this.topPanel, gridBag1, c1, 0, 17, 0, 2, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)label0Value, (Container)this.topPanel, gridBag1, c1, 0, 17, 1, 2, 1, 1, 4.0, 0.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)label1, (Container)this.topPanel, gridBag1, c1, 0, 17, 0, 3, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)label1Value, (Container)this.topPanel, gridBag1, c1, 0, 17, 1, 3, 1, 1, 4.0, 0.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)label2, (Container)this.topPanel, gridBag1, c1, 0, 17, 0, 4, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)label2Value, (Container)this.topPanel, gridBag1, c1, 0, 17, 1, 4, 1, 1, 4.0, 0.0, new Insets(0, 0, 0, 0));
        }

        private void createPanel0() {
            GridBagLayout gridBag1 = new GridBagLayout();
            GridBagConstraints c1 = new GridBagConstraints();
            this.panel0 = new LWContainer();
            this.panel0.setLayout((LayoutManager)gridBag1);
            String OcrPart = OiStdDialogRes.getString("OiDiskConfring_USAGE_OCR_LABEL");
            String OcrMirrorPart = OiStdDialogRes.getString("OiDiskConfring_USAGE_OCR_MIRROR_LABEL");
            String VdskPart = OiStdDialogRes.getString("OiDiskConfring_USAGE_VD_LABEL");
            this.determineOCRStateInGrid();
            if (Integer.parseInt(this.selectedDiskData[5]) == 0) {
                this.Checkbox0 = new LWCheckbox(OcrPart, false);
                this.Checkbox0_1 = new LWCheckbox(OcrMirrorPart, false);
                this.Checkbox1 = new LWCheckbox(VdskPart, false);
                this.oldOcrUsage_val = false;
                this.oldVdskUsage_val = false;
                this.oldOcrMirrorUsage_val = false;
                if (this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0_1.setEnabled(false);
                    this.Checkbox0.setEnabled(false);
                } else if (this.doesOCRPrimaryExist && !this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(false);
                } else if (!this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0_1.setEnabled(false);
                } else {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                }
            } else if (Integer.parseInt(this.selectedDiskData[5]) == 1) {
                this.Checkbox0 = new LWCheckbox(OcrPart, true);
                this.Checkbox0_1 = new LWCheckbox(OcrMirrorPart, false);
                this.Checkbox1 = new LWCheckbox(VdskPart, false);
                this.oldOcrUsage_val = true;
                this.oldOcrMirrorUsage_val = false;
                this.oldVdskUsage_val = false;
                if (this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(false);
                } else if (this.doesOCRPrimaryExist && !this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                } else {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                }
            } else if (Integer.parseInt(this.selectedDiskData[5]) == 2) {
                this.Checkbox0 = new LWCheckbox(OcrPart, false);
                this.Checkbox0_1 = new LWCheckbox(OcrMirrorPart, false);
                this.Checkbox1 = new LWCheckbox(VdskPart, true);
                this.oldOcrUsage_val = false;
                this.oldOcrMirrorUsage_val = false;
                this.oldVdskUsage_val = true;
                if (this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(false);
                    this.Checkbox0_1.setEnabled(false);
                } else if (this.doesOCRPrimaryExist && !this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(false);
                } else if (!this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0_1.setEnabled(false);
                } else {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                }
            } else if (Integer.parseInt(this.selectedDiskData[5]) == 3) {
                this.Checkbox0 = new LWCheckbox(OcrPart, true);
                this.Checkbox1 = new LWCheckbox(VdskPart, true);
                this.Checkbox0_1 = new LWCheckbox(OcrMirrorPart, false);
                this.oldOcrUsage_val = true;
                this.oldVdskUsage_val = true;
                this.oldOcrMirrorUsage_val = false;
                if (this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(false);
                } else if (this.doesOCRPrimaryExist && !this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                } else {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                }
            } else if (Integer.parseInt(this.selectedDiskData[5]) == 4) {
                this.Checkbox0 = new LWCheckbox(OcrPart, false);
                this.Checkbox0_1 = new LWCheckbox(OcrMirrorPart, true);
                this.Checkbox0_1.setEnabled(true);
                this.Checkbox1 = new LWCheckbox(VdskPart, false);
                this.oldOcrUsage_val = false;
                this.oldOcrMirrorUsage_val = true;
                this.oldVdskUsage_val = false;
                if (this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(false);
                    this.Checkbox0_1.setEnabled(true);
                } else if (!this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                } else {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                }
            } else if (Integer.parseInt(this.selectedDiskData[5]) == 5) {
                this.Checkbox0 = new LWCheckbox(OcrPart, false);
                this.Checkbox0_1 = new LWCheckbox(OcrMirrorPart, true);
                this.Checkbox0_1.setEnabled(true);
                this.Checkbox1 = new LWCheckbox(VdskPart, true);
                this.oldOcrUsage_val = false;
                this.oldOcrMirrorUsage_val = true;
                this.oldVdskUsage_val = true;
                if (this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(false);
                    this.Checkbox0_1.setEnabled(true);
                } else if (!this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                } else {
                    this.Checkbox0.setEnabled(true);
                    this.Checkbox0_1.setEnabled(true);
                }
            }
            this.trapCboxStatusOCRPrimary = this.Checkbox0.isEnabled();
            this.trapCboxStatusOCRMirror = this.Checkbox0_1.isEnabled();
            this.Checkbox0.addItemListener((ItemListener)this);
            this.Checkbox0_1.addItemListener((ItemListener)this);
            this.Checkbox1.addItemListener((ItemListener)this);
            OiifmMnemonicOps.processMnemonic((LWCheckbox)this.Checkbox0);
            OiifmMnemonicOps.processMnemonic((LWCheckbox)this.Checkbox0_1);
            OiifmMnemonicOps.processMnemonic((LWCheckbox)this.Checkbox1);
            this.panel0.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 12));
            this.panel0.setBorderPainter(UIManager.createGroupBoxPainter((String)this.getSubTitle0()));
            OiClusterStorage.this.addComponent((Component)this.Checkbox0, (Container)this.panel0, gridBag1, c1, 2, 17, 0, 0, 0, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)this.Checkbox0_1, (Container)this.panel0, gridBag1, c1, 2, 17, 0, 2, 0, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
            OiClusterStorage.this.addComponent((Component)this.Checkbox1, (Container)this.panel0, gridBag1, c1, 2, 17, 0, 4, 0, 1, 1.0, 2.0, new Insets(10, 0, 0, 0));
        }

        private void createPanel1() {
            String FmtCfs = OiStdDialogRes.getString("OiDiskConfring_CFS_TITLE_LABEL");
            String DEFAULT_CHECKBOX_LABEL_0 = OiStdDialogRes.getString("OiDiskConfring_CFS_DATA_LABEL");
            String DEFAULT_CHECKBOX_LABEL_1 = OiStdDialogRes.getString("OiDiskConfring_CFS_SOFTWARE_LABEL");
            if (Integer.parseInt(this.selectedDiskData[3]) == 0) {
                this.Checkbox2 = new LWCheckbox(FmtCfs, false);
                this.oldfmtCfs_val = false;
            } else {
                this.Checkbox2 = new LWCheckbox(FmtCfs, true);
                this.oldfmtCfs_val = true;
            }
            this.Checkbox2.addItemListener((ItemListener)this);
            OiifmMnemonicOps.processMnemonic((LWCheckbox)this.Checkbox2);
            GridBagLayout gridBag1 = new GridBagLayout();
            GridBagConstraints c1 = new GridBagConstraints();
            this.panel1 = new LWContainer();
            this.panel1.setLayout((LayoutManager)gridBag1);
            this.panel1.setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 12));
            GridBagLayout gridBag2 = new GridBagLayout();
            GridBagConstraints c2 = new GridBagConstraints();
            LWComponent subpanel0 = new LWComponent();
            subpanel0.setLayout((LayoutManager)gridBag2);
            GroupBoxContainer gbPanel = new GroupBoxContainer((Component)this.Checkbox2, (Component)subpanel0);
            OiClusterStorage.this.addComponent((Component)gbPanel, (Container)this.panel1, gridBag1, c1, 1, 17, 0, 0, 1, 1, 0.0, 0.0, new Insets(0, 1, 0, 1));
            this.checkGroup = new LWCheckboxGroup();
            if (this.Checkbox2.getState()) {
                if (Integer.parseInt(this.selectedDiskData[3]) == 1) {
                    this.cb0 = new LWCheckbox(DEFAULT_CHECKBOX_LABEL_0, this.checkGroup, true);
                    this.cb1 = new LWCheckbox(DEFAULT_CHECKBOX_LABEL_1, this.checkGroup, false);
                    this.oldStoreType_val = "cb0";
                } else if (Integer.parseInt(this.selectedDiskData[3]) == 2) {
                    this.cb0 = new LWCheckbox(DEFAULT_CHECKBOX_LABEL_0, this.checkGroup, false);
                    this.cb1 = new LWCheckbox(DEFAULT_CHECKBOX_LABEL_1, this.checkGroup, true);
                    this.oldStoreType_val = "cb1";
                    this.makeSelection(22, true);
                } else {
                    this.cb0 = new LWCheckbox(DEFAULT_CHECKBOX_LABEL_0, this.checkGroup, true);
                    this.cb1 = new LWCheckbox(DEFAULT_CHECKBOX_LABEL_1, this.checkGroup, false);
                    this.oldStoreType_val = "cb0";
                }
                this.setChoiceSelection(this.selectedDiskData[4]);
                this.oldDriveLetter_val = this.selectedDiskData[4];
            } else {
                this.oldStoreType_val = "cb0";
                this.oldDriveLetter_val = OiStdDialogRes.getString("OiCS_DEFAULT_DRIVE");
                this.cb0 = new LWCheckbox(DEFAULT_CHECKBOX_LABEL_0, this.checkGroup, true);
                this.cb1 = new LWCheckbox(DEFAULT_CHECKBOX_LABEL_1, this.checkGroup, false);
                this.cb0.setEnabled(false);
                this.cb1.setEnabled(false);
                this.ChoiceLabel.setEnabled(false);
                this.Choice1.setEnabled(false);
            }
            this.cb0.addItemListener((ItemListener)this);
            this.cb1.addItemListener((ItemListener)this);
            this.Choice1.addItemListener((ItemListener)this);
            OiClusterStorage.this.addComponent((Component)this.cb0, (Container)subpanel0, gridBag2, c2, 0, 17, 0, 0, -1, 1, 1.0, 1.0, new Insets(1, 1, 1, 1));
            OiClusterStorage.this.addComponent((Component)this.cb1, (Container)subpanel0, gridBag2, c2, 0, 17, 0, 1, -1, 1, 1.0, 1.0, new Insets(1, 1, 1, 1));
            OiifmMnemonicOps.processMnemonic((LWCheckbox)this.cb0);
            OiifmMnemonicOps.processMnemonic((LWCheckbox)this.cb1);
            this.setLabel(OiStdDialogRes.getString("OiDiskConfring_DRIVE_LABEL"));
            OiClusterStorage.this.addComponent((Component)this.ChoiceLabel, (Container)subpanel0, gridBag2, c2, 0, 17, 0, 2, -1, 1, 1.0, 1.0, new Insets(1, 1, 1, 1));
            OiifmMnemonicOps.processMnemonic((LWLabel)this.ChoiceLabel);
            OiClusterStorage.this.addComponent((Component)this.Choice1, (Container)subpanel0, gridBag2, c2, 0, 13, 0, 2, 0, 1, 1.0, 1.0, new Insets(1, 1, 1, 1));
            this.ChoiceLabel.setLabelFor((Component)this.Choice1);
        }

        private void setLabel(String text) {
            if (text != null) {
                this.ChoiceLabel.setText(text);
            }
        }

        private void setChoice(String[] list) {
            this.invalidate();
            this.Choice1.removeAll();
            for (int i = 0; i < list.length; ++i) {
                this.Choice1.insert(list[i], i);
                this.Choice1.select(0);
            }
            this.validate();
        }

        private void setChoiceSelection(String selDrive) {
            this.invalidate();
            for (int i = 0; i < this.Choice1.getItemCount(); ++i) {
                if (this.Choice1.getItem(i) == null || !this.Choice1.getItem(i).equalsIgnoreCase(selDrive)) continue;
                this.Choice1.select(i);
                break;
            }
            this.validate();
        }

        private Boolean getSelection0() {
            this.oldOcrUsage_val = this.Checkbox0.getState();
            if (this.Checkbox0.getState() && this.Checkbox0.isEnabled()) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        private void setSelection0(boolean state) {
            this.Checkbox0.setState(state);
        }

        private Boolean getSelection0_1() {
            this.oldOcrMirrorUsage_val = this.Checkbox0_1.getState();
            if (this.Checkbox0_1.getState() && this.Checkbox0_1.isEnabled()) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        private void setSelection0_1(boolean state) {
            this.Checkbox0_1.setState(state);
        }

        private Boolean getSelection1() {
            this.oldVdskUsage_val = this.Checkbox1.getState();
            if (this.Checkbox1.getState() && this.Checkbox1.isEnabled()) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        private void setSelection1(boolean state) {
            this.Checkbox1.setState(state);
        }

        private Boolean getSelection2() {
            this.oldfmtCfs_val = this.Checkbox2.getState();
            if (this.Checkbox2.getState()) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        private void setSelection2(boolean state) {
            this.Checkbox2.setState(state);
        }

        private String getSelection3() {
            if (this.cb0.getState()) {
                return "cb0";
            }
            return "cb1";
        }

        private void setSelection3(boolean state) {
            if (state) {
                this.cb0.setState(true);
                this.cb1.setState(false);
            } else {
                this.cb1.setState(true);
                this.cb0.setState(false);
            }
        }

        private String getSelection4() {
            this.oldDriveLetter_val = this.Choice1.getSelectedItem();
            return this.Choice1.getSelectedItem();
        }

        private void setSelection4(String text) {
            if (text != null) {
                this.Choice1.select(text);
            }
        }

        public String getSubTitle0() {
            return this.subTitle0;
        }

        public String[] getChangedRow() {
            return null;
        }

        public int getToBeModifiedRowIndex() {
            if (this.startIndexOCRPrimary == -1 && this.startIndexOCRMirror != -1) {
                return this.startIndexOCRMirror;
            }
            if (this.startIndexOCRPrimary != -1 && this.startIndexOCRMirror == -1) {
                return this.startIndexOCRPrimary;
            }
            return -1;
        }

        private void display() {
            BufferedFrame f = new BufferedFrame();
            this.dlg = new BufferedDialog((Frame)f, this.title, true);
            this.dlg.add((Component)((Object)this));
            this.dlg.setLocation(this.top, this.left);
            int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
            int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
            int x = maxWidth / 2 - 250;
            int y = maxHeight / 2 - 75;
            this.dlg.setBounds(x, y, this.WIDTH, this.HEIGHT);
            this.dlg.show();
        }

        private void Dlgdispose() {
            this.dlg.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.button2) {
                this.dlg.hide();
                this.setSelection0(this.oldOcrUsage_val);
                this.setSelection0_1(this.oldOcrMirrorUsage_val);
                this.setSelection1(this.oldVdskUsage_val);
                this.setSelection2(this.oldfmtCfs_val);
                if (this.oldfmtCfs_val) {
                    this.setSelection3(this.oldStoreType_val.equals("cb0"));
                    this.setSelection4(this.oldDriveLetter_val);
                }
            } else if (e.getSource() == this.button1) {
                if (!this.Checkbox2.getState() && (this.Checkbox1.getState() && this.Checkbox0.getState() || this.Checkbox1.getState() && this.Checkbox0_1.getState())) {
                    OiifmAlert.displayAlert((String)OiStdDialogRes.getString("OiDiskConf_ERROR_TITLE"), (String)OiStdDialogRes.getString("OiDiskConf_ERROR_MESSAGE0"), (int)50, (int)1, (int)1, (int)20);
                    return;
                }
                if (!this.Checkbox2.getState() || !this.cb0.getState() || this.Checkbox1.getState() || this.Checkbox0.getState() || !this.Checkbox0_1.getState()) {
                    // empty if block
                }
                this.dlg.hide();
            }
        }

        public void determineOCRStateInGrid() {
            for (int i = 5; i < this.currentGridData.length; i += 6) {
                if (!this.doesOCRPrimaryExist && (this.currentGridData[i].trim().equals("1") || this.currentGridData[i].trim().equals("3"))) {
                    this.doesOCRPrimaryExist = true;
                    this.startIndexOCRPrimary = i - 5;
                }
                if (!this.doesOCRMirrorExist && (this.currentGridData[i].trim().equals("4") || this.currentGridData[i].trim().equals("5"))) {
                    this.doesOCRMirrorExist = true;
                    this.startIndexOCRMirror = i - 5;
                }
                if (this.doesOCRPrimaryExist && this.doesOCRMirrorExist) break;
            }
        }

        public int getToBeModifiedRowStatus() {
            if (this.selectedDiskData[5].equalsIgnoreCase("1") || this.selectedDiskData[5].equalsIgnoreCase("3")) {
                return 100;
            }
            if (this.selectedDiskData[5].equalsIgnoreCase("4") || this.selectedDiskData[5].equalsIgnoreCase("5")) {
                return 200;
            }
            return 300;
        }

        public boolean OCRChecks() {
            this.determineOCRStateInGrid();
            if (!this.doesOCRPrimaryExist && !this.doesOCRMirrorExist) {
                return true;
            }
            if (this.doesOCRPrimaryExist && !this.doesOCRMirrorExist) {
                if (this.Checkbox0.getState()) {
                    boolean doesToBeModifiedRowContainPrimaryOCR = false;
                    if (this.selectedDiskData[0].equalsIgnoreCase(this.currentGridData[this.startIndexOCRPrimary]) && this.selectedDiskData[1].equalsIgnoreCase(this.currentGridData[this.startIndexOCRPrimary + 1])) {
                        doesToBeModifiedRowContainPrimaryOCR = true;
                    }
                    if (doesToBeModifiedRowContainPrimaryOCR) {
                        return true;
                    }
                    int usersResponse = OiifmAlert.displayAlert((String)OiStdDialogRes.getString("OiDiskConf_ERROR_TITLE"), (String)OiStdDialogRes.getString("OiDiskConf_ERROR_MESSAGE2"), (int)30, (int)3, (int)2, (int)10);
                    if (usersResponse == 2) {
                        return false;
                    }
                    this.alsoToBeChangedRow = new String[6];
                    this.alsoToBeChangedRow[0] = this.currentGridData[this.startIndexOCRPrimary];
                    this.alsoToBeChangedRow[1] = this.currentGridData[this.startIndexOCRPrimary + 1];
                    this.alsoToBeChangedRow[2] = this.currentGridData[this.startIndexOCRPrimary + 2];
                    this.alsoToBeChangedRow[3] = this.currentGridData[this.startIndexOCRPrimary + 3];
                    this.alsoToBeChangedRow[4] = this.currentGridData[this.startIndexOCRPrimary + 4];
                    if (this.currentGridData[this.startIndexOCRPrimary + 5].equals("1")) {
                        this.alsoToBeChangedRow[5] = "4";
                    } else if (this.currentGridData[this.startIndexOCRPrimary + 5].equals("3")) {
                        this.alsoToBeChangedRow[5] = "5";
                    }
                    return true;
                }
                return true;
            }
            if (!this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                if (this.Checkbox0_1.getState()) {
                    boolean doesToBeModifiedRowContainMirrorOCR = false;
                    if (this.selectedDiskData[0].equalsIgnoreCase(this.currentGridData[this.startIndexOCRMirror]) && this.selectedDiskData[1].equalsIgnoreCase(this.currentGridData[this.startIndexOCRMirror + 1])) {
                        doesToBeModifiedRowContainMirrorOCR = true;
                    }
                    if (doesToBeModifiedRowContainMirrorOCR) {
                        return true;
                    }
                    int usersResponse = OiifmAlert.displayAlert((String)OiStdDialogRes.getString("OiDiskConf_ERROR_TITLE"), (String)OiStdDialogRes.getString("OiDiskConf_ERROR_MESSAGE3"), (int)30, (int)3, (int)2, (int)10);
                    if (usersResponse == 2) {
                        return false;
                    }
                    this.alsoToBeChangedRow = new String[6];
                    this.alsoToBeChangedRow[0] = this.currentGridData[this.startIndexOCRMirror];
                    this.alsoToBeChangedRow[1] = this.currentGridData[this.startIndexOCRMirror + 1];
                    this.alsoToBeChangedRow[2] = this.currentGridData[this.startIndexOCRMirror + 2];
                    this.alsoToBeChangedRow[3] = this.currentGridData[this.startIndexOCRMirror + 3];
                    this.alsoToBeChangedRow[4] = this.currentGridData[this.startIndexOCRMirror + 4];
                    if (this.currentGridData[this.startIndexOCRMirror + 5].equals("4")) {
                        this.alsoToBeChangedRow[5] = "1";
                    } else if (this.currentGridData[this.startIndexOCRMirror + 5].equals("5")) {
                        this.alsoToBeChangedRow[5] = "3";
                    }
                    return true;
                }
                return true;
            }
            if (this.doesOCRPrimaryExist && this.doesOCRMirrorExist) {
                boolean doesToBeModifiedRowContainPrimaryOCR = false;
                boolean doesToBeModifiedRowContainMirrorOCR = false;
                if (this.selectedDiskData[0].equalsIgnoreCase(this.currentGridData[this.startIndexOCRPrimary]) && this.selectedDiskData[1].equalsIgnoreCase(this.currentGridData[this.startIndexOCRPrimary + 1])) {
                    doesToBeModifiedRowContainPrimaryOCR = true;
                }
                if (this.selectedDiskData[0].equalsIgnoreCase(this.currentGridData[this.startIndexOCRMirror]) && this.selectedDiskData[1].equalsIgnoreCase(this.currentGridData[this.startIndexOCRMirror + 1])) {
                    doesToBeModifiedRowContainMirrorOCR = true;
                }
                if (this.Checkbox0_1.getState()) {
                    if (!doesToBeModifiedRowContainPrimaryOCR && !doesToBeModifiedRowContainMirrorOCR) {
                        int usersResponse = OiifmAlert.displayAlert((String)OiStdDialogRes.getString("OiDiskConf_ERROR_TITLE"), (String)OiStdDialogRes.getString("OiDiskConf_ERROR_MESSAGE4"), (int)30, (int)3, (int)2, (int)10);
                        if (usersResponse == 2) {
                            return false;
                        }
                        this.alsoToBeChangedRow = new String[6];
                        this.alsoToBeChangedRow[0] = this.currentGridData[this.startIndexOCRMirror];
                        this.alsoToBeChangedRow[1] = this.currentGridData[this.startIndexOCRMirror + 1];
                        this.alsoToBeChangedRow[2] = this.currentGridData[this.startIndexOCRMirror + 2];
                        if (this.currentGridData[this.startIndexOCRMirror + 5].equals("4")) {
                            this.alsoToBeChangedRow[3] = "0";
                            this.alsoToBeChangedRow[4] = OiStdDialogRes.getString("OiCS_DEFAULT_DRIVE");
                            this.alsoToBeChangedRow[5] = "0";
                        } else if (this.currentGridData[this.startIndexOCRMirror + 5].equals("5")) {
                            this.alsoToBeChangedRow[3] = this.currentGridData[this.startIndexOCRMirror + 3];
                            this.alsoToBeChangedRow[4] = this.currentGridData[this.startIndexOCRMirror + 4];
                            this.alsoToBeChangedRow[5] = "2";
                        }
                        this.startIndexOCRPrimary = -1;
                        return true;
                    }
                    if (doesToBeModifiedRowContainPrimaryOCR) {
                        int usersResponse = OiifmAlert.displayAlert((String)OiStdDialogRes.getString("OiDiskConf_ERROR_TITLE"), (String)OiStdDialogRes.getString("OiDiskConf_ERROR_MESSAGE6"), (int)30, (int)3, (int)2, (int)10);
                        if (usersResponse == 2) {
                            return false;
                        }
                        this.alsoToBeChangedRow = new String[6];
                        this.alsoToBeChangedRow[0] = this.currentGridData[this.startIndexOCRMirror];
                        this.alsoToBeChangedRow[1] = this.currentGridData[this.startIndexOCRMirror + 1];
                        this.alsoToBeChangedRow[2] = this.currentGridData[this.startIndexOCRMirror + 2];
                        this.alsoToBeChangedRow[3] = this.currentGridData[this.startIndexOCRMirror + 3];
                        this.alsoToBeChangedRow[4] = this.currentGridData[this.startIndexOCRMirror + 4];
                        if (this.currentGridData[this.startIndexOCRMirror + 5].equals("4")) {
                            this.alsoToBeChangedRow[5] = "1";
                        } else if (this.currentGridData[this.startIndexOCRMirror + 5].equals("5")) {
                            this.alsoToBeChangedRow[5] = "3";
                        }
                        this.startIndexOCRPrimary = -1;
                        return true;
                    }
                    return true;
                }
                if (this.Checkbox0.getState()) {
                    if (!doesToBeModifiedRowContainPrimaryOCR && !doesToBeModifiedRowContainMirrorOCR) {
                        int usersResponse = OiifmAlert.displayAlert((String)OiStdDialogRes.getString("OiDiskConf_ERROR_TITLE"), (String)OiStdDialogRes.getString("OiDiskConf_ERROR_MESSAGE5"), (int)30, (int)3, (int)2, (int)10);
                        if (usersResponse == 2) {
                            return false;
                        }
                        this.alsoToBeChangedRow = new String[6];
                        this.alsoToBeChangedRow[0] = this.currentGridData[this.startIndexOCRPrimary];
                        this.alsoToBeChangedRow[1] = this.currentGridData[this.startIndexOCRPrimary + 1];
                        this.alsoToBeChangedRow[2] = this.currentGridData[this.startIndexOCRPrimary + 2];
                        if (this.currentGridData[this.startIndexOCRPrimary + 5].equals("1")) {
                            this.alsoToBeChangedRow[3] = "0";
                            this.alsoToBeChangedRow[4] = OiStdDialogRes.getString("OiCS_DEFAULT_DRIVE");
                            this.alsoToBeChangedRow[5] = "0";
                        } else if (this.currentGridData[this.startIndexOCRPrimary + 5].equals("3")) {
                            this.alsoToBeChangedRow[3] = this.currentGridData[this.startIndexOCRPrimary + 3];
                            this.alsoToBeChangedRow[4] = this.currentGridData[this.startIndexOCRPrimary + 4];
                            this.alsoToBeChangedRow[5] = "2";
                        }
                        this.startIndexOCRMirror = -1;
                        return true;
                    }
                    if (doesToBeModifiedRowContainMirrorOCR) {
                        int usersResponse = OiifmAlert.displayAlert((String)OiStdDialogRes.getString("OiDiskConf_ERROR_TITLE"), (String)OiStdDialogRes.getString("OiDiskConf_ERROR_MESSAGE7"), (int)30, (int)3, (int)2, (int)10);
                        if (usersResponse == 2) {
                            return false;
                        }
                        this.alsoToBeChangedRow = new String[6];
                        this.alsoToBeChangedRow[0] = this.currentGridData[this.startIndexOCRPrimary];
                        this.alsoToBeChangedRow[1] = this.currentGridData[this.startIndexOCRPrimary + 1];
                        this.alsoToBeChangedRow[2] = this.currentGridData[this.startIndexOCRPrimary + 2];
                        this.alsoToBeChangedRow[3] = this.currentGridData[this.startIndexOCRPrimary + 3];
                        this.alsoToBeChangedRow[4] = this.currentGridData[this.startIndexOCRPrimary + 4];
                        if (this.currentGridData[this.startIndexOCRPrimary + 5].equals("1")) {
                            this.alsoToBeChangedRow[5] = "4";
                        } else if (this.currentGridData[this.startIndexOCRPrimary + 5].equals("3")) {
                            this.alsoToBeChangedRow[5] = "5";
                        }
                        this.startIndexOCRMirror = -1;
                        return true;
                    }
                    return true;
                }
            }
            return true;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.Checkbox2) {
                if (this.Checkbox2.getState()) {
                    this.makeSelection(2, true);
                } else {
                    this.makeSelection(2, false);
                }
            } else if (e.getSource() == this.cb0) {
                this.makeSelection(21, true);
            } else if (e.getSource() == this.cb1) {
                this.makeSelection(22, true);
            } else if (e.getSource() == this.Checkbox0) {
                if (this.Checkbox0.isEnabled() && this.Checkbox0_1.isEnabled()) {
                    this.makeSelection(100, this.Checkbox0.getState());
                }
            } else if (e.getSource() == this.Checkbox0_1 && this.Checkbox0.isEnabled() && this.Checkbox0_1.isEnabled()) {
                this.makeSelection(101, true);
            }
        }

        private void makeSelection(int mode, boolean state) {
            if (mode == 2) {
                this.cb0.setEnabled(state);
                this.cb1.setEnabled(state);
                this.ChoiceLabel.setEnabled(state);
                this.Choice1.setEnabled(state);
                if (state) {
                    if (this.cb0.getState()) {
                        this.makeOCRSelection(state);
                    } else if (this.cb1.getState()) {
                        if (this.Checkbox0.getState()) {
                            this.Checkbox0.setState(!state);
                        }
                        if (this.Checkbox0_1.getState()) {
                            this.Checkbox0_1.setState(!state);
                        }
                        if (this.Checkbox1.getState()) {
                            this.Checkbox1.setState(!state);
                        }
                        this.Checkbox0.setEnabled(!state);
                        this.Checkbox0_1.setEnabled(!state);
                        this.Checkbox1.setEnabled(!state);
                    }
                } else {
                    this.Checkbox0.setEnabled(this.trapCboxStatusOCRPrimary);
                    this.Checkbox0_1.setEnabled(this.trapCboxStatusOCRMirror);
                    this.Checkbox1.setEnabled(true);
                }
            } else if (mode == 22) {
                this.Checkbox0.setEnabled(!state);
                this.Checkbox0_1.setEnabled(!state);
                this.Checkbox1.setEnabled(!state);
            } else if (mode == 21) {
                this.makeOCRSelection(state);
            } else if (mode == 100) {
                if (state) {
                    this.Checkbox0_1.setState(!state);
                }
            } else if (mode == 101 && state) {
                this.Checkbox0.setState(!state);
            }
        }

        public void makeOCRSelection(boolean state) {
            if (this.trapCboxStatusOCRPrimary && this.trapCboxStatusOCRMirror) {
                this.Checkbox0.setEnabled(state);
                this.Checkbox0_1.setEnabled(state);
                this.Checkbox1.setEnabled(state);
            } else if (this.trapCboxStatusOCRPrimary && !this.trapCboxStatusOCRMirror) {
                this.Checkbox0.setEnabled(state);
                this.Checkbox0_1.setEnabled(!state);
                this.Checkbox1.setEnabled(state);
            } else if (!this.trapCboxStatusOCRPrimary && this.trapCboxStatusOCRMirror) {
                this.Checkbox0.setEnabled(!state);
                this.Checkbox0_1.setEnabled(state);
                this.Checkbox1.setEnabled(state);
            } else if (!this.trapCboxStatusOCRPrimary && !this.trapCboxStatusOCRMirror) {
                this.Checkbox0.setEnabled(!state);
                this.Checkbox0_1.setEnabled(!state);
                this.Checkbox1.setEnabled(state);
            }
        }
    }
}

