/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.CheckPainter;
import oracle.ewt.grid.ChoiceInputHandler;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridToolTipClient;
import oracle.ewt.grid.NullGridSelection;
import oracle.ewt.grid.ProxyInputHandler;
import oracle.ewt.grid.TextFieldInputHandler;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.Painter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;

public class OiDynamicXYSpreadTable
extends OiifpWizPanel {
    ArrayOneDDataSource myHeader;
    ArrayTwoDDataSource myData;
    ExSpreadTable MyTable;
    GridBagConstraints mc = new GridBagConstraints();
    GridBagLayout mgridbag = new GridBagLayout();
    int newColumns = 0;
    OiGrid grid;
    boolean theresACheckbox = false;
    private MultiLineLabel myPrompt;
    private MultiLineLabel myTableTitle;
    private ScrollBox tableScroll;
    private static final String DEFAULT_PROMPT = "This is the defaultPrompt";
    private static final String DEFAULT_TITLE = "This is the main Title";
    private static final String DEFAULT_TABLE_TITLE = "This is the table title.";
    private static final String[] setColHeadersArray = new String[]{"default1", "default2", "default3", "default4"};
    private static final String[] setDefaultData = new String[]{"defaultA", "defaultB", "defaultC", "defaultD"};
    private static final String[] setReadWriteable = new String[]{"checkbox", "readonly", "secure", "writeable"};
    String[] headerList;
    String promptString;
    String tableTitleString;
    String[] readWriteable;
    String[] tableContents;
    private int choiceIndex;
    String[] choicesArray;
    private ExSpreadTable myTable;
    LWPasswordField pw = new LWPasswordField();
    LWContainer mainPanel = new LWContainer();

    public OiDynamicXYSpreadTable() {
        this("DEFAULT_PROMPT");
        this.setTitleLabel(DEFAULT_TITLE);
        System.out.println("\nOiDynamicXYSpreadTable version 1.0.3.0.0 - May 12, 2003\n");
    }

    public OiDynamicXYSpreadTable(String promptString) {
        super(DEFAULT_TITLE);
        this.myPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), promptString);
        this.myTableTitle = new MultiLineLabel(WordWrapper.getTextWrapper(), this.tableTitleString);
        this.setTableTitle(DEFAULT_TABLE_TITLE);
        this.setPrompt(DEFAULT_PROMPT);
        this.setColHeaders(setColHeadersArray);
        this.setReadWrite(setReadWriteable);
        this.setTable(setDefaultData);
    }

    public void setColHeaders(String[] list) {
        this.headerList = list;
    }

    public void setReadWrite(String[] readWrite) {
        this.readWriteable = readWrite;
    }

    public void setTable(String[] myTableContents) {
        this.tableContents = myTableContents;
        this.setTable(this.tableContents, this.readWriteable, this.headerList);
    }

    private void setTable(String[] tableContents, String[] readWriteable, String[] list) {
        this.mainPanel.removeAll();
        this.mainPanel.setLayout((LayoutManager)this.mgridbag);
        GridBagConstraints mc = new GridBagConstraints();
        mc.fill = 1;
        this.mainPanel.setLayout((LayoutManager)this.mgridbag);
        mc.gridx = 0;
        mc.gridy = 0;
        mc.weightx = 1.0;
        mc.weighty = 4.0;
        mc.anchor = 18;
        mc.gridwidth = -1;
        this.mgridbag.setConstraints((Component)this.myPrompt, mc);
        this.mainPanel.add((Component)this.myPrompt);
        mc.gridx = 0;
        mc.gridy = 1;
        mc.weightx = 1.0;
        mc.weighty = 1.0;
        mc.anchor = 17;
        mc.gridwidth = -1;
        mc.fill = 2;
        this.mgridbag.setConstraints((Component)this.myTableTitle, mc);
        this.mainPanel.add((Component)this.myTableTitle);
        Boolean checked = new Boolean(true);
        Boolean notchecked = new Boolean(false);
        this.newColumns = list.length;
        this.myHeader = new ArrayOneDDataSource((Object[])list);
        int Idx = 0;
        this.myData = new ArrayTwoDDataSource(this.newColumns, tableContents.length / this.newColumns);
        System.err.println("\nData as it is fed into the table starts here: ");
        for (int rowIdx = 0; rowIdx < tableContents.length / this.newColumns; ++rowIdx) {
            for (int colIdx = 0; colIdx < this.newColumns; ++colIdx) {
                this.myData.setData(colIdx, rowIdx, (Object)tableContents[Idx++]);
                System.err.println(tableContents[Idx - 1]);
                String doh = this.myData.getData(colIdx, rowIdx).toString();
                if (doh.equalsIgnoreCase("checked")) {
                    this.myData.setData(colIdx, rowIdx, (Object)new Boolean(true));
                }
                if (!doh.equalsIgnoreCase("notchecked")) continue;
                this.myData.setData(colIdx, rowIdx, (Object)new Boolean(false));
            }
        }
        System.err.println("End of data filling table for this go-round.\n");
        this.myTable = new ExSpreadTable((TwoDDataSource)this.myData, (OneDDataSource)this.myHeader, null);
        this.grid = (OiGrid)this.myTable.getGrid();
        ComplexAppearanceManager am = new ComplexAppearanceManager();
        this.grid.setAppearanceManager((AppearanceManager)am);
        this.grid.setToolTipValue(GridToolTipClient.getToolTipClient());
        int newRows = tableContents.length / this.newColumns - 1;
        for (int column = 0; column < readWriteable.length; ++column) {
            if (readWriteable[column].equalsIgnoreCase("writeable")) {
                this.grid.setColumnCellInputHandler(column, TextFieldInputHandler.getCellInputHandler());
                this.findMyColumnWidth(column);
            } else if (readWriteable[column].equalsIgnoreCase("secure")) {
                this.grid.setColumnCellInputHandler(column, PasswordFieldInputHandler.getCellInputHandler());
                this.grid.setColumnPainter(column, (Painter)new PasswordPainter());
                this.findMyColumnWidth(column);
            } else if (readWriteable[column].equalsIgnoreCase("checkbox")) {
                this.theresACheckbox = true;
                this.myTable.setColumnWidth(column, 25);
                this.grid.setGridSelection(NullGridSelection.getGridSelection());
                this.grid.setColumnPainter(column, CheckPainter.getPainter());
                this.grid.setColumnCellInputHandler(column, ReadOnlyBooleanInputHandler.getCellInputHandler());
            } else if (readWriteable[column].equalsIgnoreCase("choices")) {
                CustomInputHandler2 handler = new CustomInputHandler2();
                this.grid.setColumnCellInputHandler(column, (CellInputHandler)handler);
                for (int row = 0; row <= newRows; ++row) {
                    ArrayList<Object> stringToArray = new ArrayList<Object>();
                    String beforeTokenizedString = this.myData.getData(column, row).toString();
                    System.out.println("beforeTokenizedString is " + beforeTokenizedString);
                    StringTokenizer sT = new StringTokenizer(beforeTokenizedString, ":");
                    while (sT.hasMoreTokens()) {
                        stringToArray.add(sT.nextElement());
                    }
                    String[] comboBoxListArray = stringToArray.toArray(new String[0]);
                    this.myData.setData(column, row, (Object)comboBoxListArray[0]);
                    ChoiceInputHandler cHandler = (ChoiceInputHandler)handler.getCellInputHandler(this.grid, column, row);
                    cHandler.setItems(comboBoxListArray);
                }
                this.myTable.setColumnWidth(column, 160);
            } else {
                this.findMyColumnWidth(column);
                Appearance appearance = am.getColumnAppearance(column);
                appearance.setBackground(Color.lightGray);
                am.setColumnAppearance(column, appearance);
            }
            this.tableScroll = new ScrollBox((Component)((Object)this.myTable), 0, 0);
            this.myTable.setHorizontalSeparatorsVisible(true);
            this.myTable.setVerticalSeparatorsVisible(true);
            this.mgridbag.setConstraints((Component)this.tableScroll, mc);
        }
        for (int rowIdx = 0; rowIdx < this.myData.getRowCount() * this.myData.getColumnCount() / this.myData.getColumnCount(); ++rowIdx) {
            for (int colIdx = 0; colIdx < this.myData.getColumnCount(); ++colIdx) {
                String doh = this.myData.getData(colIdx, rowIdx).toString();
                if (doh.equalsIgnoreCase("checked") || doh.equalsIgnoreCase("true")) {
                    this.myData.setData(colIdx, rowIdx, (Object)new Boolean(true));
                }
                if (!doh.equalsIgnoreCase("notchecked") && !doh.equalsIgnoreCase("false")) continue;
                this.myData.setData(colIdx, rowIdx, (Object)new Boolean(false));
            }
        }
        mc.gridwidth = 0;
        mc.fill = 1;
        mc.gridy = -1;
        mc.gridy = 2;
        mc.weightx = 1.0;
        mc.weighty = 6.0;
        this.mgridbag.setConstraints((Component)this.tableScroll, mc);
        this.mainPanel.add((Component)this.tableScroll);
        this.add((Component)this.mainPanel);
        this.validate();
    }

    private void findMyColumnWidth(int column) {
        int checkBoxSize = this.theresACheckbox ? 25 : 0;
        if (this.newColumns <= 4 && this.tableContents.length / this.newColumns <= 7) {
            this.myTable.setColumnWidth(column, 595 / this.newColumns);
        } else if (this.newColumns <= 4 && this.tableContents.length / this.newColumns > 7) {
            this.myTable.setColumnWidth(column, (580 - checkBoxSize) / this.newColumns);
        } else {
            this.myTable.setColumnWidth(column, (580 - checkBoxSize) / 4);
        }
    }

    public void setPrompt(String text) {
        if (text != null) {
            this.myPrompt.setText(text);
        }
    }

    public void setTableTitle(String text) {
        if (text != null) {
            this.myTableTitle.setText(text);
        }
    }

    public String[] getTable() {
        int selIdx = 0;
        int RowCount = this.myData.getRowCount();
        int Colcount = this.grid.getColumnCount();
        String[] selections = new String[RowCount * Colcount];
        for (int rowIdx = 0; rowIdx < RowCount; ++rowIdx) {
            for (int colIdx = 0; colIdx < Colcount; ++colIdx) {
                selections[selIdx++] = this.myData.getData(colIdx, rowIdx).toString();
            }
        }
        return selections;
    }

    public String[] getColumnHeaders() {
        String[] fromColumnHeaders = new String[]{"1", "2", "3", "4"};
        return fromColumnHeaders;
    }

    public static void main(String[] args) {
        BufferedFrame p = new BufferedFrame();
        int columns = 8;
        OiDynamicXYSpreadTable OiDynamicXYSpreadTable1 = new OiDynamicXYSpreadTable();
        String[] headerArray = new String[columns];
        for (int i = 0; i < columns; ++i) {
            headerArray[i] = "Test header that's too long to fit" + i;
        }
        OiDynamicXYSpreadTable1.setColHeaders(headerArray);
        String[] readWrite = new String[columns];
        readWrite[0] = "checkbox";
        readWrite[1] = "readonly";
        readWrite[2] = "secure";
        readWrite[3] = "writeable";
        readWrite[4] = "writeable";
        readWrite[5] = "readonly";
        readWrite[6] = "choices";
        readWrite[7] = "writeable";
        String[] dataArray = new String[columns * 4];
        dataArray[0] = "checked";
        dataArray[1] = "This is readonly";
        dataArray[2] = "password";
        dataArray[3] = "test";
        dataArray[4] = "This is writeable and too long";
        dataArray[5] = "This is a too long read only field";
        dataArray[6] = "Choice1:Choice2:Choice3:Choice4";
        dataArray[7] = "This is writeable and too long also";
        dataArray[8] = "notchecked";
        dataArray[9] = "This is 2 readonly";
        dataArray[10] = "password";
        dataArray[11] = "testtext";
        dataArray[12] = "This is writeable and too long";
        dataArray[13] = "This is a too long read only field";
        dataArray[14] = "Choice5:Choice6:Choice7:Choice8";
        dataArray[15] = "This is writeable and too long also";
        dataArray[16] = "checked";
        dataArray[17] = "This is 3 readonly";
        dataArray[18] = "password";
        dataArray[19] = "test";
        dataArray[20] = "This is writeable and too long";
        dataArray[21] = "This is a too long read only field";
        dataArray[22] = "Choice9:Choice10:Choice11:Choice12";
        dataArray[23] = "This is writeable and too long also";
        dataArray[24] = "checked";
        dataArray[25] = "This is 4 readonly";
        dataArray[26] = "password";
        dataArray[27] = "test";
        dataArray[28] = "This is writeable and too long";
        dataArray[29] = "This is a too long read only field";
        dataArray[30] = "Choice13:Choice14:Choice15:Choice16";
        dataArray[31] = "This is writeable and too long also";
        OiDynamicXYSpreadTable1.setReadWrite(readWrite);
        OiDynamicXYSpreadTable1.setTable(dataArray);
        OiDynamicXYSpreadTable1.setPrompt("This is the standard prompt from Main");
        OiDynamicXYSpreadTable1.setTableTitle("This is the table title from the Main");
        p.add((Component)((Object)OiDynamicXYSpreadTable1));
        p.setSize(600, 400);
        p.show();
        String[] returnVal = OiDynamicXYSpreadTable1.getTable();
        for (int i = 0; i < returnVal.length; ++i) {
        }
    }

    private class CustomInputHandler2
    extends ProxyInputHandler {
        private ChoiceInputHandler _choice0 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice1 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice2 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice3 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice4 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice5 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice6 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice7 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice8 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice9 = new ChoiceInputHandler();
        private ChoiceInputHandler _choice10 = new ChoiceInputHandler();

        private CustomInputHandler2() {
        }

        public CellInputHandler getCellInputHandler(Grid grid, int column, int row) {
            switch (row) {
                case 0: {
                    return this._choice0;
                }
                case 1: {
                    return this._choice1;
                }
                case 2: {
                    return this._choice2;
                }
                case 3: {
                    return this._choice3;
                }
                case 4: {
                    return this._choice4;
                }
                case 5: {
                    return this._choice5;
                }
                case 6: {
                    return this._choice6;
                }
                case 7: {
                    return this._choice7;
                }
                case 8: {
                    return this._choice8;
                }
                case 9: {
                    return this._choice9;
                }
                case 10: {
                    return this._choice10;
                }
            }
            return this._choice10;
        }
    }

    private class CustomInputHandler
    extends TextFieldInputHandler {
        private LWPasswordField _passwdField = null;

        protected CustomInputHandler() {
        }

        public synchronized Component getEditControl(Grid grid, int column, int row) {
            if (this._passwdField == null) {
                this._passwdField = new LWPasswordField();
            }
            return this._passwdField;
        }
    }
}

