/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMXPathQuery {
    private String URIfile = "";
    private String attributeName = "";
    private String elementPath = "";
    private Vector matchedValues;
    private Vector parsedElements;
    private StringTokenizer ep;
    private int elementIndex = 0;
    private int elementCount = 0;
    private boolean lastElementReached;
    private boolean optionalParameterSet;

    private String getURIFromFile(String s) {
        return new String("file:" + s);
    }

    public Vector getQueryResults() {
        return (Vector)this.matchedValues.clone();
    }

    public DOMXPathQuery(String uri, String elem, String attrib, boolean op) {
        this.optionalParameterSet = op;
        this.lastElementReached = false;
        this.URIfile = this.getURIFromFile(uri);
        this.attributeName = attrib;
        this.elementPath = elem;
        this.matchedValues = new Vector();
        this.parsedElements = new Vector();
        this.ep = new StringTokenizer(this.elementPath, "/");
        this.elementCount = this.ep.countTokens();
        while (this.ep.hasMoreTokens()) {
            this.parsedElements.addElement(this.ep.nextToken());
        }
    }

    public void queryNode(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                if (!doc.getDocumentElement().getNodeName().equals(this.parsedElements.elementAt(this.elementIndex))) break;
                this.queryNode(doc.getDocumentElement());
                break;
            }
            case 1: {
                NodeList children;
                String name = node.getNodeName();
                if (this.parsedElements.lastElement().equals(name) && this.elementIndex == this.elementCount - 1) {
                    this.lastElementReached = true;
                    if (this.optionalParameterSet) {
                        NamedNodeMap attributes = node.getAttributes();
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            Node current = attributes.item(i);
                            if (!current.getNodeName().equals(this.attributeName)) continue;
                            this.matchedValues.addElement(current.getNodeValue().trim());
                        }
                    } else {
                        NodeList children2 = node.getChildNodes();
                        if (children2 != null) {
                            for (int i = 0; i < children2.getLength(); ++i) {
                                Node temp = children2.item(i);
                                if (!temp.getNodeName().equalsIgnoreCase("#cdata-section") && !temp.getNodeName().equalsIgnoreCase("#text")) continue;
                                this.queryNode(children2.item(i));
                            }
                        }
                    }
                } else if (name.equals(this.parsedElements.elementAt(this.elementIndex)) && !this.lastElementReached && (children = node.getChildNodes()) != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        if (!children.item(i).getNodeName().equals(this.parsedElements.elementAt(this.elementIndex + 1))) continue;
                        ++this.elementIndex;
                        this.queryNode(children.item(i));
                    }
                }
                if (this.elementIndex <= 0) break;
                --this.elementIndex;
                this.lastElementReached = false;
                break;
            }
            case 3: 
            case 4: {
                if (!this.lastElementReached) break;
                this.matchedValues.addElement(node.getNodeValue().trim());
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public void performXPathQuery() {
        DOMParser parser = new DOMParser();
        try {
            parser.parse(this.URIfile);
            XMLDocument doc = parser.getDocument();
            this.queryNode((Node)doc);
        }
        catch (Exception e) {
            System.out.println("Error in parsing: " + e.getMessage());
        }
    }
}

