/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.InputEventUtils;

public class PasswordFieldInputHandler
extends CellInputHandler {
    private static PasswordFieldInputHandler _sInputHandler;
    private LWPasswordField _passwordField;
    private boolean _dirty;

    public LWPasswordField getLWPasswordField() {
        return (LWPasswordField)this.getEditControl(null, -1, -1);
    }

    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        Cell cell = grid.getFocusCell();
        if (cell.column == n && cell.row == n2 && InputEventUtils.isLeftMouseButton((MouseEvent)mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
        super.mousePressed(mouseEvent, grid, n, n2);
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\u001b' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            return;
        }
        grid.startCellEdit(n, n2);
        LWPasswordField lWPasswordField = this.getLWPasswordField();
        if (lWPasswordField.isEditable()) {
            if (keyEvent.getKeyChar() == '\b') {
                lWPasswordField.setText("");
                this._dirty = true;
            } else {
                String string = String.valueOf(keyEvent.getKeyChar());
                lWPasswordField.setText(string);
                lWPasswordField.select(1, 1);
                this._dirty = true;
            }
        }
        keyEvent.consume();
    }

    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (this._passwordField == null) {
            this._passwordField = new LWPasswordField();
            this._passwordField.addTextListener((TextListener)new Dirty());
            this._passwordField.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 2, 0, 0));
        }
        return this._passwordField;
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return this._dirty;
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        LWPasswordField lWPasswordField = this.getLWPasswordField();
        lWPasswordField.setText((String)object);
        if (object != null) {
            lWPasswordField.selectAll();
        }
        this._dirty = false;
    }

    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        LWPasswordField lWPasswordField = this.getLWPasswordField();
        String string = lWPasswordField.getText();
        return string;
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = PasswordFieldInputHandler.createPasswordFieldInputHandler();
        }
        return _sInputHandler;
    }

    public static PasswordFieldInputHandler createPasswordFieldInputHandler() {
        return new PasswordFieldInputHandler();
    }

    private class Dirty
    implements TextListener {
        private Dirty() {
        }

        public void textValueChanged(TextEvent textEvent) {
            PasswordFieldInputHandler.this._dirty = true;
        }
    }
}

