/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.activehelp;

import java.util.MissingResourceException;
import java.util.logging.Logger;
import oracle.install.commons.activehelp.ActiveHelpRegistry;
import oracle.install.commons.activehelp.HelpInfo;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.HelpManager;
import oracle.install.commons.util.Resource;

public class DefaultActiveHelpRegistry
implements ActiveHelpRegistry {
    private static Logger logger = Logger.getLogger(DefaultActiveHelpRegistry.class.getName());
    private Resource resource;

    public DefaultActiveHelpRegistry() {
        Application application = Application.getInstance();
        this.resource = application.getDefaultResource();
    }

    public DefaultActiveHelpRegistry(String resourceName) {
        Application application = Application.getInstance();
        this.resource = application.getResource(resourceName);
    }

    public DefaultActiveHelpRegistry(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public HelpInfo getHelpInfo(String helpId) {
        HelpInfo helpInfo = null;
        if (this.resource != null) {
            try {
                String conciseHelpText = this.resource.getProperty(helpId + ".conciseHelpText", new Object[0]);
                String extendedHelpText = this.resource.getProperty(helpId + ".extendedHelpText", new Object[0]);
                helpInfo = new HelpInfo(helpId, conciseHelpText, extendedHelpText);
                Application application = Application.getInstance();
                HelpManager helpManager = application.getHelpManager();
                String value = Application.getInstance().getString("oracle.install.activehelp.disableMoreLink", null, new Object[0]);
                if (value != null && value.equalsIgnoreCase("true")) {
                    helpInfo.setMoreHelpAvailable(false);
                } else {
                    helpInfo.setMoreHelpAvailable(helpManager.getHelpTopic(helpId) != null);
                }
            }
            catch (MissingResourceException e) {
                logger.warning("Active Help Content for " + helpId + " do not exist. Error :" + e.getMessage());
            }
        }
        return helpInfo;
    }
}

