/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.util;

import java.util.Properties;
import oracle.install.commons.base.driver.common.Installer;
import oracle.install.commons.base.driver.common.NodeScaler;
import oracle.install.commons.base.interview.common.action.AbstractPrereqAction;
import oracle.install.commons.base.interview.common.validator.PrereqValidator;
import oracle.install.commons.base.prereq.ui.PrereqCheckerFrame;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutor;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.FlowWorker;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ExceptionManager;

public class PrereqExecutor
implements FlowExecutor {
    private AbstractPrereqAction prereqAction;

    public PrereqExecutor(AbstractPrereqAction prereqAction) {
        this.prereqAction = prereqAction;
    }

    @Override
    public void execute(FlowContext flowContext, FlowExecutionMode flowExecutionMode) {
        Application application = Application.getInstance();
        UIType uiType = application.getUIType();
        flowContext.setFlowExecutionType(uiType == UIType.GRAPHICAL ? FlowExecutorType.INTERACTIVE : FlowExecutorType.SILENT);
        if (this.prereqAction != null) {
            NodeScaler nodeScaler;
            String[] nodes;
            String clusterNodes;
            Installer installer;
            Properties properties;
            this.prereqAction.setStandalone(true);
            if (application instanceof Installer && (properties = (installer = (Installer)application).getFlowDataDefaults()) != null && (clusterNodes = properties.getProperty("CLUSTER_NODES")) != null) {
                nodes = clusterNodes.split(",");
                this.prereqAction.setTargetNodes(nodes);
            }
            if (application instanceof NodeScaler && (properties = (nodeScaler = (NodeScaler)application).getFlowDataDefaults()) != null && (clusterNodes = properties.getProperty("CLUSTER_NEW_NODES")) != null) {
                nodes = clusterNodes.split(",");
                this.prereqAction.setTargetNodes(nodes);
            }
            switch (uiType) {
                case GRAPHICAL: {
                    PrereqCheckerFrame frame = new PrereqCheckerFrame();
                    frame.setVisible(true);
                }
            }
            this.prereqAction.execute(flowContext);
            switch (uiType) {
                case NONE: {
                    FlowWorker flowWorker = FlowWorker.getInstance(flowContext);
                    try {
                        flowWorker.waitForCompletion();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    PrereqValidator validator = new PrereqValidator();
                    try {
                        validator.validate(flowContext);
                    }
                    catch (Throwable t) {
                        ExceptionManager.report(t);
                    }
                    Application.getInstance().shutdown();
                }
            }
        }
    }
}

