/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.validator;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.Installer;
import oracle.install.commons.base.prereq.CompositePrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.base.prereq.PrereqCheckerJob;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Status;

public class PrereqValidator
implements Validator {
    private static Logger logger = Logger.getLogger(PrereqValidator.class.getName());

    @Override
    public void validate(FlowContext flowContext) throws ValidationException {
        PrereqChecker checker = PrereqChecker.getInstance();
        CompositePrereqCheckerJob job = checker.getVerificationJob();
        if (job != null) {
            Status status = job.getStatus();
            if (status == Status.FAILED || status == Status.SUCCEEDED_PARTIALLY) {
                LogManager logManager = LogManager.getInstance();
                File defaultLogFile = logManager.getDefaultLogFile();
                Severity failureSeverity = job.getFailureSeverity();
                logger.log(Level.INFO, "------------------List of failed Tasks------------------");
                this.logFailedJobResult(job);
                logger.log(Level.INFO, "-----------------End of failed Tasks List----------------");
                if (failureSeverity == Severity.FATAL) {
                    Application.addExitStatus(Installer.CommonExitStatus.PREREQUISITES_NOT_MET);
                    Application.removeApplicationWarning(Installer.InstallerWarning.PREREQS_FAILED_WITH_WARNING);
                    throw new ValidationException((ErrorCode)PrereqCheckerErrorCode.MANDATORY_PREREQUISITES_NOT_MET, defaultLogFile);
                }
                Application.addApplicationWarning(Installer.InstallerWarning.PREREQS_FAILED_WITH_WARNING);
                Application.removeExitStatus(Installer.CommonExitStatus.PREREQUISITES_NOT_MET);
                throw new ValidationException((ErrorCode)PrereqCheckerErrorCode.OPTIONAL_PREREQUISITES_NOT_MET, defaultLogFile);
            }
            Application.removeExitStatus(Installer.CommonExitStatus.PREREQUISITES_NOT_MET);
        }
        Application.getInstance();
        if (!Application.isCommandLineSwitchEnabled("-silent") && Application.isApplicationWarningPresent(Installer.InstallerWarning.PREREQS_FAILED_WITH_WARNING)) {
            throw new ValidationException((ErrorCode)PrereqCheckerErrorCode.USER_IGNORED_PREREQ_WARNING, new Object[0]);
        }
    }

    protected void logFailedJobResult(Job job) {
        if (job != null) {
            if (job instanceof CompositePrereqCheckerJob) {
                List<Job> jobs = ((CompositePrereqCheckerJob)job).getJobs();
                if (jobs != null && jobs.size() > 0) {
                    for (Job j : jobs) {
                        this.logFailedJobResult(j);
                    }
                }
            } else if (job instanceof PrereqCheckerJob && (job.getStatus() == Status.FAILED || job.getStatus() == Status.WARNING)) {
                PrereqCheckerJob prereqJob = (PrereqCheckerJob)job;
                prereqJob.logTaskOverallResult();
            }
        }
    }
}

