/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.base.summary.SummaryEditEvent;
import oracle.install.commons.base.summary.SummaryEditListener;
import oracle.install.commons.base.summary.SummaryPane;
import oracle.install.commons.base.summary.Variable;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.FlowDataRecorder;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.UIPropertyDef;
import oracle.install.commons.flow.annotation.ViewDef;

@ViewDef(id="SummaryUI")
@UIPropertyDef(showValidationStatusPanel=false)
public class SummaryGUI
implements View {
    private SummaryPane summaryPane = new SummaryPane();

    @Override
    public Component getView() {
        return this.summaryPane;
    }

    @Override
    public void processInput(FlowContext flowContext) {
    }

    @Override
    public void onEvent(final FlowContext flowContext, EventType eventType) {
        switch (eventType) {
            case INIT: {
                Summary summary = Summary.getInstance();
                this.summaryPane.setSummary(summary);
                this.summaryPane.addSaveActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File respFile = SummaryGUI.this.summaryPane.getResponseFile();
                        if (respFile != null) {
                            FlowDataRecorder recorder = FlowDataRecorder.getInstance();
                            recorder.setRecordFile(respFile);
                            recorder.record(flowContext);
                        }
                    }
                });
                this.summaryPane.addSummaryEditListener(new SummaryEditListener(){

                    @Override
                    public void update(SummaryEditEvent e) {
                        FlowControl flowControl;
                        String stateId;
                        Variable variable = (Variable)e.getSource();
                        if (variable != null && (stateId = variable.getAssociatedStateId()) != null && stateId.length() > 0 && (flowControl = flowContext.getFlowControl()) != null) {
                            flowControl.moveTo(stateId);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void localize(FlowContext flowContext) {
    }
}

