/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.prereq.PrereqCheckerJob;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Status;

public class CompositePrereqCheckerJob
extends CompositeJob {
    private static final Logger logger = Logger.getLogger(CompositePrereqCheckerJob.class.getName());
    private VerificationTask verificationTask;
    private VerificationResultSet verificationResultSet;
    private boolean fixable;
    private static final PropertyChangeListener fixableChangeListener = new FixableChangeListener();

    public CompositePrereqCheckerJob() {
    }

    public CompositePrereqCheckerJob(VerificationTask verificationTask) {
        super(verificationTask.getElementName(), verificationTask.getElementName(), 1.0f);
        this.verificationTask = verificationTask;
        logger.log(Level.INFO, "Creating CompositePrereqChecker Job for container task " + verificationTask.getElementName());
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public VerificationResultSet getVerificationResultSet() {
        return this.verificationResultSet;
    }

    public void setVerificationResultSet(VerificationResultSet verificationResultSet) {
        this.verificationResultSet = verificationResultSet;
    }

    public VerificationTask getVerificationTask() {
        return this.verificationTask;
    }

    @Override
    public void add(Job job) {
        if (job != null) {
            job.addPropertyChangeListener("PrereqCheckerJob.fixable", fixableChangeListener);
            super.add(job);
        }
    }

    public Status getStatus(String node) {
        Status status = null;
        List<Job> jobs = this.getJobs();
        if (jobs != null) {
            status = Status.SUCCEEDED;
            for (Job job : jobs) {
                Status childJobStatus = null;
                if (job instanceof CompositePrereqCheckerJob) {
                    childJobStatus = ((CompositePrereqCheckerJob)job).getStatus(node);
                } else if (job instanceof PrereqCheckerJob) {
                    childJobStatus = ((PrereqCheckerJob)job).getStatus(node);
                }
                if (childJobStatus == Status.ABORTED || childJobStatus == Status.CANCELLED || childJobStatus == Status.FAILED) {
                    status = childJobStatus;
                    break;
                }
                if (childJobStatus != Status.WARNING) continue;
                status = childJobStatus;
            }
        } else {
            status = super.getStatus();
        }
        return status;
    }

    public boolean isFixable(String node) {
        boolean fixable = false;
        List<Job> jobs = this.getJobs();
        if (jobs != null) {
            for (Job job : jobs) {
                if (job instanceof CompositePrereqCheckerJob) {
                    fixable = ((CompositePrereqCheckerJob)job).isFixable(node);
                } else if (job instanceof PrereqCheckerJob) {
                    fixable = ((PrereqCheckerJob)job).isFixable(node);
                }
                if (!fixable) continue;
                break;
            }
        } else {
            fixable = this.isFixable();
        }
        return fixable;
    }

    public boolean isFixable() {
        boolean fixable = false;
        List<Job> jobs = this.getJobs();
        if (jobs != null) {
            for (Job job : jobs) {
                if (job instanceof CompositePrereqCheckerJob) {
                    fixable = ((CompositePrereqCheckerJob)job).isFixable();
                } else if (job instanceof PrereqCheckerJob) {
                    fixable = ((PrereqCheckerJob)job).isFixable();
                }
                if (!fixable) continue;
                break;
            }
        } else {
            fixable = this.isFixable();
        }
        return fixable;
    }

    public void setFixable(boolean fixable) {
        if (this.fixable != fixable) {
            boolean oldValue = this.fixable;
            this.fixable = fixable;
            this.propertyChangeSupport.firePropertyChange("PrereqCheckerJob.fixable", oldValue, fixable);
        }
    }

    static class FixableChangeListener
    implements PropertyChangeListener {
        FixableChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Job task;
            Object source = evt.getSource();
            CompositeJob parent = null;
            if (source instanceof PrereqCheckerJob) {
                task = (PrereqCheckerJob)source;
                parent = (CompositePrereqCheckerJob)task.getParent();
            } else if (source instanceof CompositePrereqCheckerJob) {
                task = (CompositePrereqCheckerJob)source;
                parent = (CompositePrereqCheckerJob)task.getParent();
            }
            int completedJobCount = parent.getCompletedJobs();
            if (completedJobCount == parent.getJobs().size()) {
                List<Job> jobs = parent.getJobs();
                boolean fixable = false;
                for (Job j : jobs) {
                    PrereqCheckerJob job = (PrereqCheckerJob)j;
                    Status childJobStatus = job.getStatus();
                    if (childJobStatus != Status.SUCCEEDED_PARTIALLY && childJobStatus != Status.FAILED && childJobStatus != Status.WARNING || !job.isFixable()) continue;
                    fixable = true;
                    break;
                }
                ((CompositePrereqCheckerJob)parent).setFixable(fixable);
            }
        }
    }
}

