/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.summary;

import java.util.ArrayList;
import java.util.List;
import oracle.install.commons.base.summary.Variable;

public class Category {
    private String name;
    private String description;
    private List<Variable> variables;

    public Category() {
        this(null, null);
    }

    public Category(String name, String description) {
        this.description = description;
        this.name = name;
        this.variables = new ArrayList<Variable>();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addVariable(Variable variable) {
        this.variables.add(variable);
    }

    public Variable getVariable(String name) {
        Variable variable = null;
        if (name != null && this.variables != null) {
            for (Variable v : this.variables) {
                if (!v.getName().equals(name)) continue;
                variable = v;
                break;
            }
        }
        return variable;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Category) {
            Category c2 = (Category)obj;
            result = this.name != null && c2.name != null ? this.name.equals(c2.name) : super.equals(obj);
        }
        return result;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : super.hashCode();
    }
}

