/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.bean.ArrayDefinition;
import oracle.install.commons.bean.BeanStoreErrorCode;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.ListDefinition;
import oracle.install.commons.bean.MapDefinition;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;

public class BeanDefinition
extends PropertyDefinition
implements Cloneable {
    private static final Logger logger = Logger.getLogger(BeanDefinition.class.getName());
    private List<PropertyDefinition> memberDefinitions;
    private BeanDef beanDef;
    private static final Map<Class, BeanDefinition> beanDefRegistry = new HashMap<Class, BeanDefinition>();

    public BeanDefinition() {
    }

    public BeanDefinition(String name, Class baseType, Method setter, Method getter, List<PropertyDefinition> memberDefinition) {
        super(name, baseType, setter, getter);
        this.memberDefinitions = memberDefinition;
    }

    public List<PropertyDefinition> getMemberDefinitions() {
        return this.memberDefinitions;
    }

    public void setMemberDefinitions(List<PropertyDefinition> memberDefinition) {
        this.memberDefinitions = memberDefinition;
    }

    public BeanDef getBeanDef() {
        return this.beanDef;
    }

    public void setBeanDef(BeanDef beanDef) {
        this.beanDef = beanDef;
    }

    public Object newInstance() {
        Object instance = null;
        try {
            instance = this.getBaseType().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static Type[] getGenericTypes(Type baseType) {
        Type[] types = null;
        if (baseType instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)baseType;
            types = ptype.getActualTypeArguments();
        }
        return types;
    }

    public static final BeanDefinition getBeanDefinition(Class beanType) throws BeanStoreException {
        return BeanDefinition.getBeanDefinition(beanType, null);
    }

    public static final BeanDefinition getBeanDefinition(Class beanType, String alias) throws BeanStoreException {
        BeanDefinition beanDefinition = null;
        BeanDef beanDef = beanType.getAnnotation(BeanDef.class);
        if (beanDef != null) {
            logger.fine("Creating bean defination for Bean Type:" + beanType);
            String beanId = alias == null ? beanDef.value() : alias;
            beanDefinition = beanDefRegistry.get(beanType);
            if (beanDefinition != null) {
                String name = beanDefinition.getName();
                if (name != null && !name.equals(alias)) {
                    try {
                        beanDefinition = (BeanDefinition)beanDefinition.clone();
                        beanDefinition.setName(beanId);
                    }
                    catch (CloneNotSupportedException e) {
                        logger.log(Level.WARNING, "Unable to clone bean definition for " + name, e);
                    }
                }
                return beanDefinition;
            }
            beanDefinition = new BeanDefinition();
            beanDefRegistry.put(beanType, beanDefinition);
            beanDefinition.setName(beanId);
            beanDefinition.setBaseType(beanType);
            beanDefinition.setBeanDef(beanDef);
            beanDefinition.setDescription(beanDef.description());
            PropertyDefinition typeDefinition = null;
            ArrayList<PropertyDefinition> memberDefinitions = new ArrayList<PropertyDefinition>();
            beanDefinition.setMemberDefinitions(memberDefinitions);
            Method[] methods = beanType.getMethods();
            HashMap<String, Method> availableMethods = new HashMap<String, Method>();
            for (Method method : methods) {
                availableMethods.put(method.getName(), method);
            }
            StringBuffer methodName = new StringBuffer();
            for (Method method : methods) {
                PropertyDef propertyDef;
                methodName.setLength(0);
                methodName.append(method.getName());
                if (methodName.indexOf("get") != 0 && methodName.indexOf("is") != 0 || (propertyDef = method.getAnnotation(PropertyDef.class)) == null) continue;
                if (methodName.charAt(0) == 'i') {
                    methodName.delete(0, 2);
                    methodName.insert(0, "set");
                } else {
                    methodName.setCharAt(0, 's');
                }
                Method setter = (Method)availableMethods.get(methodName.toString());
                Method getter = method;
                if (getter != null) {
                    Type[] genericTypes;
                    methodName.setCharAt(3, Character.toLowerCase(methodName.charAt(3)));
                    String propertyName = propertyDef.value();
                    Class<?> propertyType = method.getReturnType();
                    if (Map.class.isAssignableFrom(propertyType)) {
                        genericTypes = BeanDefinition.getGenericTypes(method.getGenericReturnType());
                        if (genericTypes != null && genericTypes.length == 2) {
                            Class keyType = (Class)genericTypes[0];
                            Class valueType = (Class)genericTypes[1];
                            PropertyDefinition keyDefinition = BeanDefinition.getEntryDefinition(keyType, "key");
                            PropertyDefinition valueDefinition = BeanDefinition.getEntryDefinition(valueType, "value");
                            typeDefinition = new MapDefinition(propertyName, propertyType, setter, getter, keyDefinition, valueDefinition);
                            logger.fine("Created MapDefinition for property:" + propertyName);
                        }
                    } else if (List.class.isAssignableFrom(propertyType)) {
                        genericTypes = BeanDefinition.getGenericTypes(method.getGenericReturnType());
                        if (genericTypes != null && genericTypes.length == 1) {
                            Class entryType = (Class)genericTypes[0];
                            PropertyDefinition entryDefinition = BeanDefinition.getBeanDefinition(entryType, null);
                            if (entryDefinition == null) {
                                entryDefinition = new PropertyDefinition("value", entryType, null, null);
                            }
                            typeDefinition = new ListDefinition(propertyName, propertyType, setter, getter, entryDefinition);
                            logger.fine("Created ListDefinition for property:" + propertyName);
                        }
                    } else if (propertyType.isArray()) {
                        Class<?> entryType = propertyType.getComponentType();
                        PropertyDefinition entryDefinition = BeanDefinition.getBeanDefinition(entryType, null);
                        if (entryDefinition == null) {
                            entryDefinition = new PropertyDefinition("value", entryType, null, null);
                        }
                        typeDefinition = new ArrayDefinition(propertyName, propertyType, setter, getter, entryDefinition);
                        logger.fine("Created ArrayDefinition for property:" + propertyName);
                    } else {
                        typeDefinition = BeanDefinition.getBeanDefinition(propertyType, propertyName);
                        if (typeDefinition == null) {
                            typeDefinition = new PropertyDefinition(propertyName, propertyType, setter, getter);
                            logger.fine("Created PropertyDefinition for property:" + propertyName);
                        } else {
                            typeDefinition.setSetter(setter);
                            typeDefinition.setGetter(getter);
                        }
                    }
                    if (typeDefinition != null) {
                        memberDefinitions.add(typeDefinition);
                    } else {
                        throw new BeanStoreException(BeanStoreErrorCode.INVALID_TYPE_DEFINITION, propertyName, beanType.getName());
                    }
                }
                if (typeDefinition == null) continue;
                typeDefinition.setPropertyDef(propertyDef);
                typeDefinition.setDescription(propertyDef.description());
            }
            availableMethods.clear();
        }
        return beanDefinition;
    }

    public static PropertyDefinition getEntryDefinition(Class propertyType, String alias) throws BeanStoreException {
        PropertyDefinition propertyDefinition = null;
        propertyDefinition = Number.class.isAssignableFrom(propertyType) || propertyType == String.class ? new PropertyDefinition(alias, propertyType, null, null) : BeanDefinition.getBeanDefinition(propertyType, null);
        return propertyDefinition;
    }

    public static PropertyDefinition getAliasedEntryDefinition(Class propertyType, String alias) throws BeanStoreException {
        PropertyDefinition propertyDefinition = null;
        propertyDefinition = Number.class.isAssignableFrom(propertyType) || propertyType == String.class ? new PropertyDefinition(alias, propertyType, null, null) : BeanDefinition.getBeanDefinition(propertyType, alias);
        return propertyDefinition;
    }
}

