/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TypeTranslator {
    private static final Logger logger = Logger.getLogger(TypeTranslator.class.getName());

    public static <A> A translate(String value, Class<A> type) {
        Object returnValue = null;
        if (value != null) {
            if (type.isPrimitive()) {
                value = value.trim();
                if (type == Long.TYPE) {
                    returnValue = Long.valueOf(value);
                } else if (type == Integer.TYPE) {
                    returnValue = Integer.valueOf(value);
                } else if (type == Boolean.TYPE) {
                    returnValue = Boolean.valueOf(value);
                } else if (type == Short.TYPE) {
                    returnValue = Short.valueOf(value);
                } else if (type == Float.TYPE) {
                    returnValue = Float.valueOf(value);
                } else if (type == Double.TYPE) {
                    returnValue = Double.valueOf(value);
                }
            } else if (type.equals(String.class)) {
                returnValue = value;
            } else if (type.equals(Integer.class)) {
                returnValue = Integer.valueOf(value);
            } else if (type.equals(Double.class)) {
                returnValue = Double.valueOf(value);
            } else if (type.equals(Long.class)) {
                returnValue = Long.valueOf(value);
            } else if (type.equals(Float.class)) {
                returnValue = Float.valueOf(value);
            } else if (type.equals(Short.class)) {
                returnValue = Short.valueOf(value);
            } else if (Enum.class.isAssignableFrom(type)) {
                try {
                    Field field = type.getField(value);
                    returnValue = field.get(null);
                }
                catch (NoSuchFieldException e) {
                    logger.log(Level.WARNING, "Enum constant " + value + " not found in " + type.getName());
                    throw new IllegalArgumentException(value);
                }
                catch (IllegalAccessException e) {
                    logger.log(Level.WARNING, "Enum constant " + value + " not accessible in " + type.getName());
                    throw new IllegalArgumentException(value);
                }
            }
        }
        return (A)returnValue;
    }
}

