/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.util.XmlSupport;
import oracle.install.commons.util.XmlTag;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PropertyFileFormat
extends XmlBeanStoreFormat {
    private static Logger logger = Logger.getLogger(PropertyFileFormat.class.getName());
    private static final String GENERIC_PROPERTY_NAME = "Generic";
    private static final EntityResolver RESOLVER = new Resolver();
    private static final String PROPS_DTD_URI = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROPS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED \"1.0\"><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry  key CDATA #REQUIRED>";

    public PropertyFileFormat() {
    }

    public PropertyFileFormat(String namespaceURI, URL raw2extTransformer, URL ext2rawTransformer, URL schema) {
        this(null, namespaceURI, raw2extTransformer, ext2rawTransformer, schema);
    }

    public PropertyFileFormat(String beanStoreName, String namespaceURI, URL raw2extTransformer, URL ext2rawTransformer, URL schema) {
        super(beanStoreName, null, namespaceURI, raw2extTransformer, ext2rawTransformer, schema);
    }

    @Override
    public Document ext2raw(InputSource source) throws Exception {
        Document rawDoc = null;
        if (source != null) {
            InputStream in = null;
            if (source.getSystemId() != null) {
                URL url = new URL(source.getSystemId());
                in = url.openStream();
            } else {
                in = source.getByteStream();
            }
            if (in != null) {
                Document document = this.toDocument(in);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                XmlSupport.transform(new DOMSource(document), new StreamResult(buffer));
                rawDoc = super.ext2raw(new InputSource(new ByteArrayInputStream(buffer.toByteArray())));
            } else {
                rawDoc = super.ext2raw(source);
            }
        }
        return rawDoc;
    }

    public Document toDocument(InputStream in) throws Exception {
        Properties properties = new Properties();
        properties = this.loadProperties(in);
        in.close();
        logger.log(Level.FINE, "Creating xml document - in PropertyFileFormat.toDocument()");
        XmlTag propertiesTag = XmlTag.createInstance("properties");
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            try {
                XmlTag tag = propertiesTag.setText(key.trim(), value);
                if (tag != null) continue;
                logger.log(Level.WARNING, "Unable to create xml tag for the key:" + key);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception occurred while creating xml tag to the key:" + key, t);
            }
        }
        return propertiesTag.getDocument();
    }

    @Override
    public void validate(Source beanStore) throws Exception {
        String systemId = beanStore.getSystemId();
        StreamSource propxml = new StreamSource();
        if (systemId != null) {
            URL url = new URL(systemId);
            InputStream in = url.openStream();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            Document document = this.buildDocument(in);
            XmlSupport.transform(new DOMSource(document), new StreamResult(buffer));
            propxml = new StreamSource(new ByteArrayInputStream(buffer.toByteArray()));
        }
        super.validate(propxml);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return RESOLVER;
    }

    public Properties loadProperties(InputStream in) throws IOException {
        Properties prop = new Properties();
        BufferedReader input = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = input.readLine()) != null) {
            prop.putAll(this.parseLine(line));
        }
        return prop;
    }

    public Document buildDocument(InputStream in) throws Exception {
        Map<Object, Object> propertiesMap = new HashMap();
        propertiesMap = this.loadPropertiesMap(in);
        in.close();
        logger.log(Level.FINE, "Creating xml document - in ExtendedPropertyFileFormat.buildDocument()");
        XmlTag propertiesTag = XmlTag.createInstance("properties");
        for (Map.Entry<Object, Object> entry : propertiesMap.entrySet()) {
            String sectionKey = (String)entry.getKey();
            Properties sectionProperties = (Properties)entry.getValue();
            XmlTag sectionTag = sectionKey.equalsIgnoreCase(GENERIC_PROPERTY_NAME) ? propertiesTag : propertiesTag.createXmlTag(sectionKey);
            for (Map.Entry<Object, Object> e : sectionProperties.entrySet()) {
                String key = e.getKey().toString();
                String value = e.getValue().toString();
                try {
                    XmlTag tag = sectionTag.setText(key.trim(), value);
                    if (tag != null) continue;
                    logger.log(Level.WARNING, "Unable to create xml tag for the key:" + key);
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Exception occurred while creating xml tag to the key:" + key, t);
                }
            }
        }
        return propertiesTag.getDocument();
    }

    public Map<String, Properties> loadPropertiesMap(InputStream in) throws IOException {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        BufferedReader input = new BufferedReader(new InputStreamReader(in));
        String line = null;
        String key = GENERIC_PROPERTY_NAME;
        Properties prop = new Properties();
        logger.log(Level.INFO, "Createing properties map - in ExtendedPropertyFileFormat.loadPropertiesMap()");
        while ((line = input.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            if (line.startsWith("[")) {
                int endIndex = line.indexOf(93);
                if (endIndex == -1) {
                    logger.log(Level.WARNING, "End of section name indicator not found for the line");
                    continue;
                }
                propertiesMap.put(key, prop);
                String newKey = line.substring(1, endIndex).trim();
                key = key.equalsIgnoreCase(newKey) ? GENERIC_PROPERTY_NAME : newKey;
                prop = propertiesMap.get(key) != null ? (Properties)propertiesMap.get(key) : new Properties();
                continue;
            }
            prop.putAll(this.parseLine(line));
        }
        propertiesMap.put(key, prop);
        return propertiesMap;
    }

    protected Map<String, String> parseLine(String line) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        int lineLength = line.length();
        int valueStart = 0;
        boolean hasSep = false;
        boolean precedingBackslash = false;
        StringBuffer key = new StringBuffer();
        if ((line = line.trim()).length() > 0 && !line.startsWith("#") && !line.startsWith("[")) {
            lineLength = line.length();
            for (int keyLen = 0; keyLen < lineLength; ++keyLen) {
                char c = line.charAt(keyLen);
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
                key.append(c);
            }
            String value = new String();
            if (hasSep) {
                if (valueStart > 0) {
                    value = line.substring(valueStart);
                }
            } else {
                logger.log(Level.WARNING, "Separator for key and value not found for the property:" + key.toString());
            }
            if (key.length() > 0) {
                propertyMap.put(key.toString(), value);
            }
        }
        return propertyMap;
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (sid.equals(PropertyFileFormat.PROPS_DTD_URI)) {
                InputSource is = new InputSource(new StringReader(PropertyFileFormat.PROPS_DTD));
                is.setSystemId(PropertyFileFormat.PROPS_DTD_URI);
                return is;
            }
            throw new SAXException("Invalid system identifier: " + sid);
        }
    }
}

