/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.xml;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.install.commons.bean.ArrayDefinition;
import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStoreErrorCode;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreReader;
import oracle.install.commons.bean.ListDefinition;
import oracle.install.commons.bean.MapDefinition;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.TypeTranslator;
import oracle.install.commons.bean.xml.XmlBeanStore;
import oracle.install.commons.util.exception.Severity;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlBeanStoreReader
extends BeanStoreReader<XmlBeanStore> {
    private static final Logger logger = Logger.getLogger(XmlBeanStoreReader.class.getName());
    private XmlBeanStore beanStore;
    private Node beanStoreNode;
    private XPath xpath;

    @Override
    public XmlBeanStore getBeanStore() {
        return this.beanStore;
    }

    @Override
    public void open(XmlBeanStore beanStore) throws BeanStoreException {
        this.beanStore = beanStore;
        try {
            Document document = this.beanStore.getDocument();
            this.xpath = XPathFactory.newInstance().newXPath();
            this.beanStoreNode = (Node)this.xpath.evaluate(this.beanStore.getBeanStoreName(), document, XPathConstants.NODE);
        }
        catch (Exception e) {
            throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_OPEN_BEANSTOREREADER, new Object[0]);
        }
    }

    @Override
    public void close() throws BeanStoreException {
        this.beanStoreNode = null;
        this.xpath = null;
        this.beanStore = null;
    }

    @Override
    protected Object readBean(BeanDefinition beanDefinition, Object bean) throws BeanStoreException {
        logger.info("Loading beans from Xml Bean Store. [BeanStoreName:" + this.beanStore.getBeanStoreName() + "]");
        boolean isParentNode = this.beanStoreNode != null && !beanDefinition.getName().equals(this.beanStoreNode.getNodeName());
        return this.readBean(beanDefinition, bean, this.beanStoreNode, isParentNode);
    }

    private Object readBean(PropertyDefinition propertyDefinition, Object bean, Node node, boolean isParentNode) throws BeanStoreException {
        Object returnValue;
        block36: {
            returnValue = null;
            if (node == null) {
                return returnValue;
            }
            String propertyName = propertyDefinition.getName();
            Node propertyNode = null;
            try {
                propertyNode = isParentNode ? (Node)this.xpath.evaluate(propertyName, node, XPathConstants.NODE) : node;
            }
            catch (XPathExpressionException e) {
                throw new BeanStoreException(BeanStoreErrorCode.UNSPECIFIED_PROPERTY, propertyName);
            }
            if (propertyNode != null) {
                if (propertyDefinition instanceof BeanDefinition) {
                    BeanDefinition beanDefinition = (BeanDefinition)propertyDefinition;
                    List<PropertyDefinition> memberDefinitions = beanDefinition.getMemberDefinitions();
                    returnValue = bean == null ? beanDefinition.newInstance() : bean;
                    for (PropertyDefinition memberDefinition : memberDefinitions) {
                        Object propBean = memberDefinition.getValue(bean);
                        try {
                            Object memberValue = this.readBean(memberDefinition, propBean, propertyNode, true);
                            if (memberValue == null) continue;
                            memberDefinition.setValue(returnValue, memberValue);
                            logger.info("Setting value for the property:" + memberDefinition.getName() + " in the bean:" + propertyName);
                        }
                        catch (BeanStoreException e) {
                            if (e.getSeverity() == Severity.FATAL) {
                                throw e;
                            }
                            logger.fine(e.getMessage());
                        }
                    }
                } else if (propertyDefinition instanceof ListDefinition) {
                    ListDefinition listDefinition = (ListDefinition)propertyDefinition;
                    PropertyDefinition entryDefinition = listDefinition.getEntryDefinition();
                    try {
                        int n;
                        NodeList entryNodes = (NodeList)this.xpath.evaluate(entryDefinition.getName(), propertyNode, XPathConstants.NODESET);
                        if (entryNodes != null && (n = entryNodes.getLength()) > 0) {
                            List list = listDefinition.newInstance();
                            returnValue = list;
                            for (int i = 0; i < n; ++i) {
                                Node entryNode = entryNodes.item(i);
                                PropertyDefinition nodeEntryDefinition = this.getEntryDefinationForNode(entryNode, entryDefinition);
                                Object entryBean = nodeEntryDefinition.getValue(bean);
                                Object value = this.readBean(nodeEntryDefinition, entryBean, entryNode, false);
                                list.add(value);
                            }
                            logger.fine("Created List object of size:" + n + " for the property:" + propertyName);
                        }
                    }
                    catch (XPathExpressionException e) {
                        logger.warning("Unable to read list entries of '" + propertyName + "'. Error: " + e.getMessage());
                    }
                } else if (propertyDefinition instanceof MapDefinition) {
                    MapDefinition mapDefinition = (MapDefinition)propertyDefinition;
                    PropertyDefinition keyDefinition = mapDefinition.getKeyDefinition();
                    PropertyDefinition valueDefinition = mapDefinition.getValueDefinition();
                    try {
                        int n;
                        NodeList entryNodes = (NodeList)this.xpath.evaluate("entry", propertyNode, XPathConstants.NODESET);
                        if (entryNodes != null && (n = entryNodes.getLength()) > 0) {
                            Map map = mapDefinition.newInstance();
                            returnValue = map;
                            for (int i = 0; i < n; ++i) {
                                Object keyBean;
                                PropertyDefinition nodeKeyDefinition;
                                Object entryKey;
                                Node entryNode = entryNodes.item(i);
                                Node keyNode = (Node)this.xpath.evaluate(keyDefinition.getName(), entryNode, XPathConstants.NODE);
                                if (keyNode == null || (entryKey = this.readBean(nodeKeyDefinition = this.getEntryDefinationForNode(keyNode, keyDefinition), keyBean = nodeKeyDefinition.getValue(bean), keyNode, false)) == null) continue;
                                Object entryValue = null;
                                Node valueNode = (Node)this.xpath.evaluate(valueDefinition.getName(), entryNode, XPathConstants.NODE);
                                if (keyDefinition.getName().equals(valueDefinition.getName())) {
                                    NodeList nodes = (NodeList)this.xpath.evaluate(valueDefinition.getName(), entryNode, XPathConstants.NODESET);
                                    Node node2 = valueNode = nodes.getLength() > 1 ? nodes.item(nodes.getLength() - 1) : valueNode;
                                }
                                if (valueNode != null) {
                                    PropertyDefinition nodeValueDefinition = this.getEntryDefinationForNode(valueNode, valueDefinition);
                                    Object valueBean = nodeValueDefinition.getValue(bean);
                                    entryValue = this.readBean(nodeValueDefinition, valueBean, valueNode, false);
                                }
                                map.put(entryKey, entryValue);
                            }
                            logger.fine("Created Map object of size:" + n + " for the property:" + propertyName);
                        }
                    }
                    catch (XPathExpressionException e) {
                        logger.warning("Unable to read map entries of '" + propertyName + "'. Error: " + e.getMessage());
                    }
                } else if (propertyDefinition instanceof ArrayDefinition) {
                    ArrayDefinition arrayDefinition = (ArrayDefinition)propertyDefinition;
                    returnValue = null;
                    PropertyDefinition entryDefinition = arrayDefinition.getEntryDefinition();
                    try {
                        NodeList entryNodes = (NodeList)this.xpath.evaluate(entryDefinition.getName(), propertyNode, XPathConstants.NODESET);
                        if (entryNodes != null) {
                            int n = entryNodes.getLength();
                            if (n > 0) {
                                returnValue = Array.newInstance(entryDefinition.getBaseType(), n);
                                for (int i = 0; i < n; ++i) {
                                    Node entryNode = entryNodes.item(i);
                                    PropertyDefinition nodeEntryDefinition = this.getEntryDefinationForNode(entryNode, entryDefinition);
                                    Object entryBean = nodeEntryDefinition.getValue(bean);
                                    Object value = this.readBean(nodeEntryDefinition, entryBean, entryNode, false);
                                    Array.set(returnValue, i, value);
                                }
                            }
                            logger.fine("Created Array object of size:" + n + " for the property:" + propertyName);
                        }
                    }
                    catch (XPathExpressionException e) {
                        logger.warning("Unable to read array entries of '" + propertyName + "'. Error: " + e.getMessage());
                    }
                } else {
                    try {
                        Node valueNode = (Node)this.xpath.evaluate("text()", propertyNode, XPathConstants.NODE);
                        if (valueNode == null) break block36;
                        try {
                            returnValue = TypeTranslator.translate(valueNode.getNodeValue(), propertyDefinition.getBaseType());
                        }
                        catch (IllegalArgumentException e) {
                            throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.INVALID_ARGUMENT, e.getMessage());
                        }
                    }
                    catch (XPathExpressionException e) {
                        logger.warning("Unable to read value of '" + propertyName + "'. Error: " + e.getMessage());
                    }
                }
            } else {
                throw new BeanStoreException(BeanStoreErrorCode.UNSPECIFIED_PROPERTY, propertyName);
            }
        }
        return returnValue;
    }

    private PropertyDefinition getEntryDefinationForNode(Node node, PropertyDefinition defaultEntryDefinition) throws BeanStoreException {
        Node srcAttr;
        PropertyDefinition nodeEntryDefinition = defaultEntryDefinition;
        NamedNodeMap attributes = node.getAttributes();
        Node node2 = srcAttr = attributes != null ? attributes.getNamedItem("type") : null;
        if (srcAttr != null) {
            String typeValue = srcAttr.getNodeValue();
            try {
                Class<?> type = Class.forName(typeValue);
                nodeEntryDefinition = BeanDefinition.getEntryDefinition(type, defaultEntryDefinition.getName());
                nodeEntryDefinition = nodeEntryDefinition != null && defaultEntryDefinition.getBaseType().isAssignableFrom(nodeEntryDefinition.getBaseType()) ? nodeEntryDefinition : defaultEntryDefinition;
            }
            catch (ClassNotFoundException e) {
                logger.warning("Unable to find class:'" + typeValue + "'. Error: " + e.getMessage());
            }
        }
        return nodeEntryDefinition;
    }
}

