/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDataRecorder;
import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.FlowDisplay;
import oracle.install.commons.flow.FlowErrorCode;
import oracle.install.commons.flow.FlowException;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutor;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.FlowHelper;
import oracle.install.commons.flow.FlowWorker;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.TraceRoutePolicy;
import oracle.install.commons.flow.Transition;
import oracle.install.commons.flow.TransitionAbortedException;
import oracle.install.commons.flow.TransitionEvent;
import oracle.install.commons.flow.TransitionListener;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.ViewManagerException;
import oracle.install.commons.flow.checkpoint.Checkpoint;
import oracle.install.commons.flow.checkpoint.CheckpointHandler;
import oracle.install.commons.flow.validation.PessimisticValidationPolicy;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationHelper;
import oracle.install.commons.flow.validation.ValidationPolicy;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationProgressEvent;
import oracle.install.commons.util.ExitStatusSet;
import oracle.install.commons.util.Graph;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ExceptionHandler;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.Status;

public abstract class AbstractFlowExecutor
implements FlowExecutor {
    private static final Logger logger = Logger.getLogger(AbstractFlowExecutor.class.getName());
    protected FlowContext flowContext;
    protected FlowExecutionMode flowExecutionMode;
    protected FlowExecutorType flowExecutorType;
    protected TraceRoutePolicy traceRoutePolicy = TraceRoutePolicy.NONE;
    private boolean startStateLoaded;
    private FlowDataRecorder flowDataRecorder;
    private FlowDisplay flowDisplay;
    protected RoutePlan routePlan;
    private ValidationPolicy validationPolicy = new PessimisticValidationPolicy();
    private Transition transition;

    public AbstractFlowExecutor() {
        ExceptionManager exceptionManager = ExceptionManager.getInstance();
        exceptionManager.addExceptionHandler(TransitionAbortedException.class, new ExceptionHandler<TransitionAbortedException>(){

            @Override
            public void handleException(TransitionAbortedException exception) {
                logger.info("Transition aborted");
                AbstractFlowExecutor.this.rollback();
            }
        });
        exceptionManager.addExceptionHandler(ValidationException.class, new ExceptionHandler<ValidationException>(){

            @Override
            public void handleException(ValidationException exception) {
                AbstractFlowExecutor.this.handleValidationFailure(exception);
            }
        });
    }

    public void setFlowDisplay(FlowDisplay flowDisplay) {
        this.flowDisplay = flowDisplay;
    }

    public FlowDisplay getFlowDisplay() {
        return this.flowDisplay;
    }

    public ValidationPolicy getValidationPolicy() {
        return this.validationPolicy;
    }

    public void setValidationPolicy(ValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }

    public abstract FlowExecutorType getFlowExecutorType();

    public RoutePlan getRoutePlan() {
        return this.routePlan;
    }

    public TraceRoutePolicy getTraceRoutePolicy() {
        return this.traceRoutePolicy;
    }

    public Graph<Route, State> getCurrentVertex() {
        return this.flowContext.getCurrentVertex();
    }

    public FlowContext getFlowContext() {
        return this.flowContext;
    }

    public FlowExecutionMode getFlowExecutionMode() {
        return this.flowExecutionMode;
    }

    @Override
    public final void execute(FlowContext flowContext, FlowExecutionMode flowExecutionMode) {
        CheckpointHandler checkpointHandler;
        this.transition = new Transition();
        flowContext.setTransition(this.transition);
        this.transition.addTransitionListener(new TransitionStatusMonitor());
        this.routePlan = new RoutePlan();
        this.routePlan.setFlowContext(flowContext);
        this.routePlan.addRoutePlanChangeListener(flowContext);
        this.routePlan.setTraceRoutePolicy(this.getTraceRoutePolicy());
        this.flowContext = flowContext;
        this.flowExecutionMode = flowExecutionMode;
        this.flowExecutorType = this.getFlowExecutorType();
        this.flowDisplay = this.getFlowDisplay();
        this.flowContext.setFlowExecutionType(this.flowExecutorType);
        if (this.flowExecutionMode != FlowExecutionMode.RECONCILE && (checkpointHandler = CheckpointHandler.getInstance()).isCheckpointDataExist(flowContext)) {
            logger.info("Found checkpoint data. Using FlowExecutionMode: " + (Object)((Object)FlowExecutionMode.CONTINUE));
            flowExecutionMode = this.confirmSessionContinuation();
        }
        this.flowDataRecorder = FlowDataRecorder.getInstance();
        if (this.flowExecutionMode == null) {
            this.flowExecutionMode = FlowExecutionMode.NEW;
        }
        logger.log(Level.INFO, "Started executing the flow in {0} mode", (Object)this.flowExecutorType);
        if (flowExecutionMode == FlowExecutionMode.RECONCILE) {
            this.reconcileSession();
        } else if (flowExecutionMode == FlowExecutionMode.CONTINUE) {
            this.restoreSession();
            this.execute();
        } else {
            this.execute();
        }
    }

    public State nextViewState() throws FlowException, ValidationException {
        State state = null;
        while ((state = this.nextState()) != null && !state.isViewState()) {
        }
        return state;
    }

    public State previousViewState() throws FlowException, ValidationException {
        State state;
        Graph<Route, State> vertex = this.transition(Transition.Type.SEQUENTIAL, FlowDirection.BACKWARD, null);
        State state2 = state = vertex != null ? vertex.getValue() : null;
        if (state != null) {
            logger.log(Level.INFO, "Moved back to state: {0}", state.getId());
        }
        return state;
    }

    public State nextState() throws FlowException, ValidationException {
        State state;
        Graph<Route, State> vertex = this.transition(Transition.Type.SEQUENTIAL, FlowDirection.FORWARD, null);
        State state2 = state = vertex != null ? vertex.getValue() : null;
        if (state != null) {
            logger.log(Level.INFO, "Moved to state <{0}>", state.getId());
        }
        return state;
    }

    public Graph<Route, State> moveTo(Graph<Route, State> vertex) throws FlowException, ValidationException {
        State state;
        State state2 = state = (vertex = this.transition(Transition.Type.RANDOM, null, vertex)) != null ? vertex.getValue() : null;
        if (state != null) {
            logger.log(Level.INFO, "Jumped to state <{0}>", state.getId());
        }
        return vertex;
    }

    public State previousState() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Graph<Route, State> transition(Transition.Type transitionType, FlowDirection direction, Graph<Route, State> destVertex) throws FlowException, ValidationException {
        Graph<Route, State> sourceVertex = this.flowContext.getCurrentVertex();
        Graph<Route, State> newVertex = null;
        if (sourceVertex != null && destVertex != null) {
            direction = this.routePlan.getDirection(sourceVertex, destVertex);
        }
        if (direction == null || direction == FlowDirection.NONE) {
            return sourceVertex;
        }
        try {
            this.transition.begin(transitionType, direction, sourceVertex);
            newVertex = this.leaveVertex(sourceVertex, direction, destVertex);
            if (newVertex != null) {
                this.transition.setDestinationVertex(newVertex);
                this.enterVertex(newVertex, direction, transitionType);
            }
        }
        finally {
            this.transition.end();
        }
        return newVertex;
    }

    protected void setTraceRoutePolicy(TraceRoutePolicy traceRoutePolicy) {
        this.traceRoutePolicy = traceRoutePolicy;
    }

    protected void startAction(Graph<Route, State> vertex) throws FlowException {
        if (vertex != null) {
            State state = vertex.getValue();
            Action action = state.getAction();
            this.transition.beginStep(Transition.Step.EXECUTE);
            logger.log(Level.INFO, "Executing action at state {0}", state.getId());
            try {
                action.execute(this.flowContext);
            }
            catch (Throwable t) {
                throw new FlowException(t, FlowErrorCode.ACTION_EXECUTION_FAILED, state.getId());
            }
            logger.log(Level.INFO, "Completed executing action at state <{0}>", state.getId());
            this.transition.endStep();
        }
    }

    protected Advice validate(Graph<Route, State> vertex) throws FlowException {
        Advice advice = Advice.CONTINUE;
        if (this.validationPolicy.requireValidation(this.flowContext, vertex)) {
            ExitStatusSet exitSet;
            Application application;
            StatusMessages<ValidationStatusMessage> messages;
            State state = vertex.getValue();
            if (this.flowDisplay != null && this.flowExecutorType == FlowExecutorType.INTERACTIVE) {
                this.transition.beginStep(Transition.Step.VALIDATE_VIEW);
                logger.log(Level.INFO, "Validating view at state <{0}>", state.getId());
                try {
                    messages = ValidationHelper.validateView(this.flowContext, state);
                    if (messages != null && messages.size() > 0) {
                        advice = this.handleValidationFailure(messages);
                    } else {
                        application = Application.getInstance();
                        if (application != null && (exitSet = application.getExitStatusSet()).contains(Application.CommonExitStatus.INVALID_USER_INPUT)) {
                            Application.removeExitStatus(Application.CommonExitStatus.INVALID_USER_INPUT);
                        }
                    }
                }
                catch (ValidationException e) {
                    advice = this.handleValidationFailure(e);
                }
                catch (Throwable t) {
                    throw new FlowException(t, FlowErrorCode.VALIDATION_FAILED, state.getId());
                }
                logger.log(Level.INFO, "Completed validating view at state <{0}>", state.getId());
                this.transition.endStep();
                if (advice != Advice.CONTINUE) {
                    return advice;
                }
            }
            this.transition.beginStep(Transition.Step.VALIDATE);
            logger.log(Level.INFO, "Validating state <{0}>", state.getId());
            try {
                messages = ValidationHelper.validateState(this.flowContext, state);
                if (messages != null && messages.size() > 0) {
                    advice = this.handleValidationFailure(messages);
                } else {
                    application = Application.getInstance();
                    if (application != null && (exitSet = application.getExitStatusSet()).contains(Application.CommonExitStatus.INVALID_USER_INPUT)) {
                        Application.removeExitStatus(Application.CommonExitStatus.INVALID_USER_INPUT);
                    }
                }
            }
            catch (ValidationException e) {
                advice = this.handleValidationFailure(e);
            }
            catch (Throwable t) {
                throw new FlowException(t, FlowErrorCode.VALIDATION_FAILED, state.getId());
            }
            logger.log(Level.INFO, "Completed validating state <{0}>", state.getId());
            this.transition.endStep();
        }
        return advice;
    }

    protected void saveState(Graph<Route, State> vertex) {
        CheckpointHandler checkpointHandler;
        State state;
        if (vertex != null && (state = vertex.getValue()) != null && state.isCheckpointEnabled() && (checkpointHandler = CheckpointHandler.getInstance()).isEnabled()) {
            logger.log(Level.INFO, "Saving checkpoint information at state <{0}>", state.getId());
            checkpointHandler.storeCheckpoint(this.flowContext);
            logger.log(Level.INFO, "Completed saving checkpoint information at state <{0}>", state.getId());
        }
    }

    protected Route stopAction(Graph<Route, State> vertex) throws FlowException {
        State state;
        Route route = null;
        if (vertex != null && (state = vertex.getValue()) != null) {
            Action action = state.getAction();
            this.transition.beginStep(Transition.Step.TRANSITION);
            try {
                route = action.transition(this.flowContext);
            }
            catch (Throwable t) {
                throw new FlowException(t, FlowErrorCode.TRANSITION_FAILED, state.getId());
            }
            this.transition.endStep();
            if (route != null && route != Route.FINISH) {
                logger.info("Verifying route " + route.getId());
                vertex = vertex.getGraph(route);
                if (vertex == null) {
                    throw new FlowException(FlowErrorCode.UNKNOWN_ROUTE, state.getId(), route.getId());
                }
            } else if (!state.isFinishState()) {
                throw new FlowException(FlowErrorCode.NULL_ROUTE, state.getId());
            }
        }
        return route;
    }

    protected void processInput(Graph<Route, State> vertex) throws FlowException, ValidationException {
        State state;
        View view;
        if (vertex != null && this.isInteractive() && (view = (state = vertex.getValue()).getView()) != null) {
            state.setDirty(true);
            this.transition.beginStep(Transition.Step.PROCESS_INPUT_FROM_VIEW);
            try {
                view.processInput(this.flowContext);
            }
            catch (UncheckedValidationException e) {
                Advice advice = this.handleValidationFailure(e);
                if (advice != Advice.CONTINUE) {
                    this.transition.abort();
                }
            }
            catch (Throwable t) {
                throw new FlowException(t, FlowErrorCode.VIEW_PROCESSING_FAILED, state.getId(), state.getViewId());
            }
            this.transition.endStep();
        }
    }

    protected void unloadView(Graph<Route, State> vertex) throws FlowException {
        State state;
        View view;
        if (vertex != null && this.isInteractive() && (view = (state = vertex.getValue()).getView()) != null) {
            this.transition.beginStep(Transition.Step.UNLOAD_VIEW);
            view.onEvent(this.flowContext, EventType.UNLOAD);
            this.transition.endStep();
        }
    }

    protected void loadView(Graph<Route, State> vertex) throws FlowException, ViewManagerException {
        State state;
        View view;
        if (vertex != null && this.isInteractive() && (view = (state = vertex.getValue()).getView()) != null) {
            Object[] messageArgs = new Object[]{state.getViewId(), state.getId()};
            boolean justInitialized = false;
            if (!state.isViewInitialized()) {
                this.transition.beginStep(Transition.Step.INITIALIZE_VIEW);
                logger.log(Level.INFO, "Initializing view <{0}> at state <{1}>", messageArgs);
                try {
                    view.onEvent(this.flowContext, EventType.INIT);
                }
                catch (Throwable t) {
                    throw new FlowException(t, FlowErrorCode.VIEW_LOADING_FAILED, state.getId(), state.getViewId());
                }
                justInitialized = true;
                state.setViewInitialized(true);
                logger.log(Level.INFO, "Completed initializing view <{0}> at state <{1}>", messageArgs);
                this.transition.endStep();
            }
            this.transition.beginStep(Transition.Step.DISPLAY_VIEW);
            logger.log(Level.INFO, "Displaying view <{0}> at state <{1}>", messageArgs);
            this.flowDisplay.display(this.flowContext, vertex);
            logger.log(Level.INFO, "Completed displaying view <{0}> at state <{1}>", messageArgs);
            this.transition.endStep();
            this.transition.beginStep(Transition.Step.LOAD_VIEW);
            logger.log(Level.INFO, "Loading view <{0}> at state <{1}>", messageArgs);
            try {
                view.onEvent(this.flowContext, EventType.LOAD);
            }
            catch (Throwable t) {
                throw new FlowException(t, FlowErrorCode.VIEW_LOADING_FAILED, state.getId(), state.getViewId());
            }
            logger.log(Level.INFO, "Completed loading view <{0}> at state <{1}>", messageArgs);
            this.transition.endStep();
            if (justInitialized) {
                this.transition.beginStep(Transition.Step.LOCALIZE_VIEW);
                logger.log(Level.INFO, "Localizing view <{0}> at state <{1}>", messageArgs);
                try {
                    view.localize(this.flowContext);
                }
                catch (Throwable t) {
                    throw new FlowException(t, FlowErrorCode.VIEW_LOCALIZATION_FAILED, state.getId(), state.getViewId());
                }
                logger.log(Level.INFO, "Completed localizing view <{0}> at state <{1}>", messageArgs);
                this.transition.endStep();
            }
        }
    }

    protected void enterVertex(Graph<Route, State> vertex, FlowDirection flowDirection, Transition.Type transitionType) throws FlowException {
        this.flowContext.setFlowDirection(flowDirection);
        this.routePlan.layoutAt(vertex, transitionType);
        this.loadView(vertex);
        this.completeBackgroundOperations(true);
        this.startAction(vertex);
    }

    protected Graph<Route, State> leaveVertex(Graph<Route, State> sourceVertex, FlowDirection flowDirection, Graph<Route, State> expectedDestVertex) throws FlowException, ValidationException {
        Graph<Route, State> destVertex = null;
        State sourceState = sourceVertex.getValue();
        if (!this.startStateLoaded && sourceState.isStartState()) {
            this.startStateLoaded = true;
            return sourceVertex;
        }
        destVertex = expectedDestVertex;
        this.flowContext.setFlowDirection(flowDirection);
        this.completeBackgroundOperations(flowDirection == FlowDirection.FORWARD);
        this.processInput(sourceVertex);
        Transition.Type type = this.transition.getType();
        switch (flowDirection) {
            case FORWARD: {
                block4 : switch (type) {
                    case RANDOM: {
                        List<Graph<Route, State>> vertices = this.validationPolicy.requireValidation(this.flowContext, sourceVertex, destVertex);
                        if (vertices == null) break;
                        Advice advice = Advice.CONTINUE;
                        for (Graph<Route, State> vertex : vertices) {
                            advice = this.validate(vertex);
                            if (advice == Advice.CONTINUE) continue;
                            destVertex = vertex;
                            break block4;
                        }
                        break;
                    }
                    case SEQUENTIAL: {
                        Advice advice = this.validate(sourceVertex);
                        if (advice == Advice.CONTINUE) break;
                        this.transition.abort();
                    }
                }
                Route route = this.stopAction(sourceVertex);
                State state = sourceVertex.getValue();
                if (route == Route.FINISH || state.isFinishState()) {
                    destVertex = null;
                } else if (destVertex == null) {
                    destVertex = FlowHelper.findNextVertex(this.flowContext, sourceVertex, route);
                }
                this.transition.setRoute(route);
                break;
            }
            case BACKWARD: {
                if (type != Transition.Type.SEQUENTIAL) break;
                destVertex = this.routePlan.getPreviousVertex((short)3);
            }
        }
        this.saveState(sourceVertex);
        this.unloadView(sourceVertex);
        return destVertex;
    }

    protected FlowExecutionMode confirmSessionContinuation() {
        FlowExecutionMode flowExecutionMode = FlowExecutionMode.NEW;
        return flowExecutionMode;
    }

    protected void reconcileSession() {
        ExceptionManager em = ExceptionManager.getInstance();
        State state = null;
        boolean continueReconcilation = true;
        do {
            try {
                state = this.nextState();
            }
            catch (FlowException e) {
                em.handleException(e);
            }
            catch (ViewManagerException e) {
                em.handleException(e);
            }
            catch (ValidationException e) {
                em.handleException(e);
                this.reconcileState(state);
            }
        } while (continueReconcilation && state != null);
    }

    protected void reconcileState(State state) {
    }

    protected boolean confirmReconcileSessionContinuation() {
        return true;
    }

    protected void restoreSession() {
        logger.info("Running in CONTINUE mode");
        CheckpointHandler checkpointHandler = CheckpointHandler.getInstance();
        checkpointHandler.restoreCheckpoint(this.flowContext);
        Checkpoint checkpoint = checkpointHandler.getCheckpoint(this.flowContext);
        String lastStateId = null;
        ExceptionManager em = ExceptionManager.getInstance();
        if (checkpoint != null) {
            lastStateId = checkpoint.getLastStateId();
            logger.warning("Last checkpoint state: " + lastStateId);
            State state = null;
            do {
                try {
                    state = this.nextState();
                }
                catch (FlowException e) {
                    em.handleException(e);
                }
                catch (ValidationException e) {
                    em.handleException(e);
                    break;
                }
                catch (ViewManagerException e) {
                    em.handleException(e);
                }
            } while (state != null && !state.getId().equals(lastStateId));
        } else {
            em.reportException(null, Severity.WARNING, FlowErrorCode.INVALID_CHECKPOINT_FILE, "Flow Execution Error");
            logger.warning("Checkpoint not found");
        }
    }

    protected Resource getResource() {
        Application application = Application.getInstance();
        return application.getResource("oracle.install.commons.flow.resource.FlowResourceBundle");
    }

    protected abstract void execute();

    protected Advice advise(StatusMessages<ValidationStatusMessage> messages) {
        FlowDisplay flowDisplay = this.getFlowDisplay();
        return ExceptionManager.advise((Object)flowDisplay, messages);
    }

    private boolean isInteractive() {
        return this.flowDisplay != null && this.flowExecutorType == FlowExecutorType.INTERACTIVE;
    }

    private Advice handleValidationFailure(Throwable e) {
        ValidationStatusMessage message = new ValidationStatusMessage(e);
        StatusMessages<ValidationStatusMessage> messages = new StatusMessages<ValidationStatusMessage>();
        messages.add(message);
        return this.handleValidationFailure(messages);
    }

    private Advice handleValidationFailure(StatusMessages<ValidationStatusMessage> messages) {
        Advice advice = Advice.CONTINUE;
        if (messages != null && !messages.isEmpty() && (advice = this.advise(messages)) == Advice.ABORT) {
            Application.addExitStatus(Application.CommonExitStatus.INVALID_USER_INPUT);
        }
        return advice;
    }

    private void completeBackgroundOperations(boolean wait) {
        FlowWorker flowWorker = FlowWorker.getInstance(this.flowContext);
        if (wait) {
            try {
                logger.info("Waiting for completion of background operations");
                flowWorker.waitForCompletion();
                logger.info("Completed background operations");
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
            }
        } else {
            logger.info("Terminating all background operations");
            flowWorker.terminate();
            logger.info("Terminated all background operations");
        }
    }

    private void rollback() {
        Graph<Route, State> currentVertex;
        Graph<Route, State> lastTracedVertex;
        if (this.transition.isAborted() && (lastTracedVertex = this.routePlan.getLastTracedVertex(currentVertex = this.routePlan.getCurrentVertex())) != null) {
            this.routePlan.layoutAt(lastTracedVertex, null);
            logger.log(Level.INFO, "Rolled back to state <{0}>", lastTracedVertex.getValue().getId());
        }
    }

    class TransitionStatusMonitor
    implements TransitionListener {
        TransitionStatusMonitor() {
        }

        @Override
        public void update(TransitionEvent e) {
            Transition transition = (Transition)e.getSource();
            switch ((TransitionEvent.Type)e.getType()) {
                case STATUS_CHANGED: {
                    StatusControl statusControl = Application.getInstance().getStatusControl();
                    if (transition.isStarted()) {
                        statusControl.open();
                        break;
                    }
                    if (!transition.isEnded()) break;
                    AbstractFlowExecutor.this.completeBackgroundOperations(transition.getStatus() == Status.SUCCEEDED);
                    statusControl.close();
                    Graph<Route, State> sourceVertex = transition.getSourceVertex();
                    if (sourceVertex == null || !sourceVertex.isTerminal()) break;
                    CheckpointHandler ch = CheckpointHandler.getInstance();
                    ch.reset(AbstractFlowExecutor.this.flowContext);
                    logger.log(Level.INFO, "Successfully executed the flow in {0} mode", (Object)AbstractFlowExecutor.this.flowExecutorType);
                    break;
                }
                case STEP_BEGUN: {
                    Application.setApplicationProgress(transition.getStep().toString(), "Starting step:" + transition.getStep().toString() + " of state:" + AbstractFlowExecutor.this.routePlan.getCurrentVertex().getValue().getId(), ApplicationProgressEvent.Type.START);
                    break;
                }
                case STEP_ENDED: {
                    Application.setApplicationProgress(transition.getStep().toString(), "Finished step:" + transition.getStep().toString() + " of state:" + AbstractFlowExecutor.this.routePlan.getCurrentVertex().getValue().getId(), ApplicationProgressEvent.Type.END);
                }
            }
        }
    }
}

