/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.net.URL;
import java.util.Properties;
import oracle.install.commons.flow.FlowBuilder;
import oracle.install.commons.flow.FlowConfigException;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDataSource;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutor;
import oracle.install.commons.flow.FlowExecutorFactory;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.LocaleChangeListener;
import oracle.install.commons.flow.resource.StringResourceBundle;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ApplicationException;

public class FlowApplication
extends Application {
    private FlowExecutorType executorType = FlowExecutorType.INTERACTIVE;
    private FlowExecutionMode executionMode;
    private URL flowConfig;
    private FlowDataSource flowDataSource;
    private Properties flowDataDefaults;
    private Resource resource = super.getResource(StringResourceBundle.class.getName());

    public FlowApplication() {
        this(null);
    }

    public FlowApplication(String name) {
        super.setName(name);
    }

    public FlowExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(FlowExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public FlowExecutorType getExecutorType() {
        return this.executorType;
    }

    public void setExecutorType(FlowExecutorType executorType) {
        this.executorType = executorType;
    }

    public URL getFlowConfig() {
        return this.flowConfig;
    }

    public void setFlowConfig(URL flowConfig) {
        this.flowConfig = flowConfig;
    }

    public FlowDataSource getFlowDataSource() {
        return this.flowDataSource;
    }

    public void setFlowDataSource(FlowDataSource flowDataSource) {
        this.flowDataSource = flowDataSource;
    }

    public Properties getFlowDataDefaults() {
        return this.flowDataDefaults;
    }

    public void setFlowDataDefaults(Properties flowDataDefaults) {
        this.flowDataDefaults = flowDataDefaults;
    }

    protected FlowExecutor getFlowExecutor() {
        FlowExecutor flowExecutor = FlowExecutorFactory.createFlowExecutor(this.executorType);
        return flowExecutor;
    }

    protected FlowContext loadFlow() throws FlowConfigException {
        FlowApplication.showStatus(this.resource.getString("FlowApplication.status.buildFlow", "Building Flow", new Object[0]));
        FlowBuilder flowBuilder = FlowBuilder.getInstance();
        FlowContext flowContext = flowBuilder.buildFlow(this.flowConfig, this.flowDataSource, this.flowDataDefaults);
        super.addApplicationListener(new LocaleChangeListener(flowContext));
        return flowContext;
    }

    protected void executeFlow(FlowContext flowContext) {
        FlowApplication.showStatus(this.resource.getString("FlowApplication.status.launchApp", "Launching {0}", super.getName()));
        FlowExecutor flowExecutor = this.getFlowExecutor();
        if (flowExecutor != null) {
            flowExecutor.execute(flowContext, this.executionMode);
        }
    }

    @Override
    protected void run() {
        try {
            FlowContext flowContext = this.loadFlow();
            this.executeFlow(flowContext);
            super.run();
        }
        catch (FlowConfigException e) {
            throw new ApplicationException(e, e.getErrorInfo());
        }
    }

    public void startup(URL appConfig, URL flowConfig, FlowDataSource flowData, Properties flowDataDefaults, String ... args) throws ApplicationException {
        this.flowConfig = flowConfig;
        this.flowDataSource = flowData;
        this.flowDataDefaults = flowDataDefaults;
        super.startup(appConfig, args);
    }

    public void startup(String appConfig, String flowConfig, String flowData, Properties flowDataDefaults, String ... args) throws ApplicationException {
        URL appConfigURL = appConfig != null ? FlowApplication.class.getResource(appConfig) : null;
        URL flowConfigURL = flowConfig != null ? FlowApplication.class.getResource(flowConfig) : null;
        URL flowDataURL = flowData != null ? FlowApplication.class.getResource(flowData) : null;
        FlowDataSource flowDataSource = new FlowDataSource(flowDataURL);
        this.startup(appConfigURL, flowConfigURL, flowDataSource, flowDataDefaults, args);
    }
}

