/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreFactory;
import oracle.install.commons.bean.BeanStoreReader;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.bean.properties.PropertiesBeanStore;
import oracle.install.commons.bean.xml.PropertyFileFormat;
import oracle.install.commons.bean.xml.XmlBeanStore;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.Condition;
import oracle.install.commons.flow.ConditionRoutine;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.Flow;
import oracle.install.commons.flow.FlowBeanRegistry;
import oracle.install.commons.flow.FlowConfigErrorCode;
import oracle.install.commons.flow.FlowConfigException;
import oracle.install.commons.flow.FlowConfigTag;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDataSource;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.StateType;
import oracle.install.commons.flow.ViewManager;
import oracle.install.commons.flow.ViewManagerException;
import oracle.install.commons.util.Graph;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ExceptionManager;
import org.xml.sax.SAXException;

public final class FlowBuilder {
    private static final Logger logger = Logger.getLogger(FlowBuilder.class.getName());
    private static FlowBuilder instance;
    private static final String ATTR_CONDITION_TRANSITION_MAP = "conditionTransitionMap";
    private static final String ATTR_DEFAULT_TARGET_ID = "defaultTargetId";
    private Map<Class<?>, Object> flowDataMap = new HashMap();

    public static FlowBuilder getInstance() {
        if (instance == null) {
            instance = new FlowBuilder();
        }
        return instance;
    }

    private FlowBuilder() {
    }

    public void registerFlowData(Object flowData) {
        if (flowData != null) {
            this.flowDataMap.put(flowData.getClass(), flowData);
        }
    }

    public void reset() {
        this.flowDataMap.clear();
    }

    public FlowContext buildFlow(URL flowConfig) throws FlowConfigException {
        return this.buildFlow(flowConfig, null, null);
    }

    public FlowContext buildFlow(URL flowConfig, FlowDataSource flowData) throws FlowConfigException {
        return this.buildFlow(flowConfig, flowData, null);
    }

    public FlowContext buildFlow(URL flowConfig, FlowDataSource flowDataSource, Properties flowDataDefaults) throws FlowConfigException {
        FlowContext flowContext = new FlowContext();
        InputStream configStream = null;
        try {
            configStream = flowConfig.openStream();
            FlowConfigTag flowConfigTag = FlowConfigTag.getInstance(configStream);
            if (flowConfigTag == null) {
                throw new FlowConfigException(FlowConfigErrorCode.INVALID_FLOW_CONFIG, new Object[0]);
            }
            List<FlowConfigTag.FlowTag> flowTags = flowConfigTag.getFlowTags();
            if (flowTags.isEmpty()) {
                throw new FlowConfigException(FlowConfigErrorCode.INVALID_FLOW_CONFIG, new Object[0]);
            }
            Map<String, Condition> globalConditionsMap = this.loadConditions(flowConfigTag);
            TreeMap<String, Flow> flowMap = new TreeMap<String, Flow>();
            for (FlowConfigTag.FlowTag flowTag : flowTags) {
                Flow flow = this.buildFlow(flowTag, globalConditionsMap);
                flowMap.put(flow.getId(), flow);
            }
            String flowId = flowConfigTag.getStartFlow();
            Flow startFlow = (Flow)flowMap.get(flowId);
            Graph<Route, State> rootVertex = startFlow.getRootVertex();
            State state = rootVertex.getValue();
            state.setStartState(true);
            flowContext.setFlow(rootVertex);
            logger.info("Linking states ");
            for (Map.Entry flowEntry : flowMap.entrySet()) {
                Flow flow = (Flow)flowEntry.getValue();
                for (Map.Entry<String, Graph<Route, State>> stateEntry : flow.getStateMap().entrySet()) {
                    Graph<Route, State> vertex;
                    String id = stateEntry.getKey();
                    Graph<Route, State> graph = stateEntry.getValue();
                    TreeMap<String, String> transitionMap = flow.getStateTransitionMap().get(id);
                    for (Map.Entry<String, String> transitionEntry : transitionMap.entrySet()) {
                        String event = transitionEntry.getKey();
                        String to = transitionEntry.getValue();
                        vertex = this.getVertex(to, flow, flowMap);
                        if (vertex == null) {
                            throw new FlowConfigException(FlowConfigErrorCode.INVALID_ROUTE_IDENTIFIER, to, id);
                        }
                        logger.info("State[" + id + "]: route=" + event + "; to=" + vertex.getValue().getId());
                        graph.setGraph(new Route(event), vertex);
                    }
                    state = graph.getValue();
                    Condition condition = state.getCondition();
                    if (condition == null) continue;
                    Map transitionMappings = (Map)state.getAttribute(ATTR_CONDITION_TRANSITION_MAP);
                    HashMap<Route, Graph<Route, State>> conditionTransitionMap = new HashMap<Route, Graph<Route, State>>();
                    if (transitionMappings != null) {
                        for (Map.Entry transitionEntry : transitionMappings.entrySet()) {
                            String event = (String)transitionEntry.getKey();
                            String to = (String)transitionEntry.getValue();
                            Graph<Route, State> vertex2 = this.getVertex(to, flow, flowMap);
                            if (vertex2 == null) {
                                throw new FlowConfigException(FlowConfigErrorCode.INVALID_ROUTE_IDENTIFIER, to, id);
                            }
                            logger.info("Condition of state[" + id + "]: route=" + event + "; to=" + vertex2.getValue().getId());
                            conditionTransitionMap.put(new Route(event), vertex2);
                        }
                    }
                    condition.setTransitionMap(conditionTransitionMap);
                    String defaultTargetId = (String)state.getAttribute(ATTR_DEFAULT_TARGET_ID);
                    if (defaultTargetId == null) continue;
                    vertex = this.getVertex(defaultTargetId, flow, flowMap);
                    if (vertex == null) {
                        throw new FlowConfigException(FlowConfigErrorCode.INVALID_ROUTE_IDENTIFIER, defaultTargetId, id);
                    }
                    condition.setDefaultTarget(vertex);
                }
            }
            logger.info("Successfully built the flow");
            BeanStore[] beanStores = this.openBeanStores(flowDataSource, flowDataDefaults);
            this.loadBeans(flowConfigTag, flowContext, beanStores);
            this.closeBeanStores(beanStores);
            this.loadViews(flowConfigTag);
        }
        catch (IOException e) {
            logger.severe("Failed to read flow config");
            ExceptionManager.handle(e);
        }
        catch (ParserConfigurationException e) {
            throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_FLOW_CONFIG, new Object[0]);
        }
        catch (SAXException e) {
            throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_FLOW_CONFIG, new Object[0]);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    ExceptionManager.handle(e);
                }
            }
        }
        return flowContext;
    }

    public void loadBeanStores(FlowContext flowContext, FlowConfigTag flowConfigTag, BeanStore ... beanStores) throws FlowConfigException {
        if (flowContext != null && flowConfigTag != null && beanStores != null) {
            this.loadBeans(flowConfigTag, flowContext, beanStores);
            this.closeBeanStores(beanStores);
        } else {
            logger.log(Level.SEVERE, "Either flowContext or flowConfig  tag is null");
        }
    }

    private Graph<Route, State> getVertex(String to, Flow flow, TreeMap<String, Flow> flowMap) {
        Graph<Route, State> vertex = null;
        if (to.startsWith("flow:")) {
            if (!to.contains("state:")) {
                String flowId = to.substring(5);
                Flow externalFlow = flowMap.get(flowId);
                vertex = externalFlow.getRootVertex();
            } else {
                String[] arguments = to.split("state:");
                if (arguments != null && arguments.length > 0 && arguments[0] != null && arguments[1] != null) {
                    String flowId = arguments[0].substring(5).trim();
                    Flow externalFlow = flowMap.get(flowId);
                    vertex = externalFlow.getStateMap().get(arguments[1].trim());
                }
            }
        } else {
            vertex = flow.getStateMap().get(to);
        }
        return vertex;
    }

    private Flow buildFlow(FlowConfigTag.FlowTag flowTag, Map<String, Condition> globalConditionsMap) throws FlowConfigException {
        Flow flow = new Flow();
        List<FlowConfigTag.StateTag> stateTags = flowTag.getStateTags();
        if (stateTags == null || stateTags.isEmpty()) {
            throw new FlowConfigException(FlowConfigErrorCode.INVALID_FLOW_CONFIG, new Object[0]);
        }
        logger.info("Building the flow graph");
        for (FlowConfigTag.StateTag stateTag : stateTags) {
            State state = this.buildState(stateTag, flow, globalConditionsMap);
            Graph graph = new Graph(state);
            flow.getStateMap().put(state.getId(), graph);
            logger.info("Loaded state " + state.getId());
        }
        String id = flowTag.getId();
        flow.setId(id);
        String startStateId = flowTag.getStartStateId();
        Graph<Route, State> rootVertex = flow.getStateMap().get(startStateId);
        flow.setRootVertex(rootVertex);
        return flow;
    }

    private State buildState(FlowConfigTag.StateTag stateTag, Flow flow, Map<String, Condition> globalConditionsMap) throws FlowConfigException {
        State state = new State();
        String id = stateTag.getId();
        StateType stateType = stateTag.getStateType();
        String actionClass = stateTag.getAction();
        String viewId = stateTag.getView();
        String defaultRouteId = stateTag.getDefaultRoute();
        boolean checkpointEnabled = stateTag.isCheckpointEnabled();
        String validatorId = stateTag.getValidator();
        Boolean conditional = stateTag.isConditional();
        state.setId(id);
        if (!StringUtils.isEmpty(viewId)) {
            state.setViewId(viewId);
        }
        state.setCheckpointEnabled(checkpointEnabled);
        if (!StringUtils.isEmpty(validatorId)) {
            state.setValidatorId(validatorId);
        }
        state.setStateType(stateType);
        if (!StringUtils.isEmpty(defaultRouteId)) {
            state.setDefaultRoute(new Route(defaultRouteId));
        }
        int transitionsCount = 0;
        List<FlowConfigTag.TransitionTag> transitionTags = stateTag.getTransitionTags();
        TreeMap<String, String> transitionMap = new TreeMap<String, String>();
        if (transitionTags != null) {
            transitionsCount = transitionTags.size();
            for (FlowConfigTag.TransitionTag transitionTag : transitionTags) {
                String on = transitionTag.getRouteId();
                String to = transitionTag.getTargetStateId();
                transitionMap.put(on, to);
            }
        }
        flow.getStateTransitionMap().put(id, transitionMap);
        state.setFinishState(transitionsCount == 0);
        Action action = null;
        if (!StringUtils.isEmpty(actionClass)) {
            try {
                Class<?> clazz = Class.forName(actionClass);
                action = (Action)clazz.newInstance();
            }
            catch (Exception e) {
                throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_ACTION_DEFINITION, new Object[0]);
            }
        } else {
            action = transitionsCount > 0 ? new DefaultAction() : new DefaultAction(Route.FINISH);
        }
        state.setAction(action);
        this.loadStateCondition(stateTag, state, globalConditionsMap);
        if (conditional != null) {
            state.setConditional(conditional);
        }
        return state;
    }

    private void loadStateCondition(FlowConfigTag.StateTag stateTag, State state, Map<String, Condition> globalConditionsMap) throws FlowConfigException {
        FlowConfigTag.ConditionTag conditionTag = stateTag.getConditionTag();
        if (conditionTag == null) {
            return;
        }
        String conditionClass = conditionTag.getConditionClass();
        String refId = conditionTag.getRefId();
        Action action = state.getAction();
        Condition condition = null;
        ConditionRoutine conditionRoutine = null;
        if (!StringUtils.isEmpty(conditionClass)) {
            if (action != null && action.getClass().getName().equals(conditionClass)) {
                logger.log(Level.INFO, "The action and the condition are of same type for state {0}. Using the action as the condition.", state.getId());
                conditionRoutine = (ConditionRoutine)((Object)action);
            } else {
                try {
                    Class<?> clazz = Class.forName(conditionClass);
                    conditionRoutine = (ConditionRoutine)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_CONDITION_DEFINITION, new Object[0]);
                }
            }
            condition = new Condition();
            condition.setConditionRoutine(conditionRoutine);
        } else if (refId != null) {
            Condition globalCondition = globalConditionsMap.get(refId);
            condition = new Condition(globalCondition);
        } else if (action != null && action instanceof ConditionRoutine) {
            conditionRoutine = (ConditionRoutine)((Object)action);
            condition = new Condition();
            condition.setConditionRoutine(conditionRoutine);
        }
        if (condition != null) {
            String defaultTarget = conditionTag.getDefaultTarget();
            List<FlowConfigTag.TransitionTag> transitionTags = conditionTag.getTransitionTags();
            if (transitionTags != null && !transitionTags.isEmpty()) {
                TreeMap<String, String> conditionTransitionMap = new TreeMap<String, String>();
                for (FlowConfigTag.TransitionTag transitionTag : transitionTags) {
                    conditionTransitionMap.put(transitionTag.getRouteId(), transitionTag.getTargetStateId());
                }
                state.setAttribute(ATTR_CONDITION_TRANSITION_MAP, conditionTransitionMap);
            } else if (defaultTarget != null) {
                state.setAttribute(ATTR_DEFAULT_TARGET_ID, defaultTarget);
            } else {
                throw new FlowConfigException(FlowConfigErrorCode.NO_TRANSITION_SPECIFIED_FOR_CONDITION, state.getId());
            }
            Map<String, String> params = conditionTag.getParameters();
            Map<String, String> conditionParams = condition.getParameters();
            if (conditionParams != null) {
                conditionParams.putAll(params);
            } else {
                condition.setParameters(params);
            }
            state.setCondition(condition);
            state.setConditional(true);
        }
    }

    private void loadBeans(FlowConfigTag flowConfigTag, FlowContext flowContext, BeanStore ... beanStores) throws FlowConfigException {
        List<FlowConfigTag.BeanTag> beanTags = flowConfigTag.getBeanTags();
        if (beanTags == null || beanTags.isEmpty()) {
            logger.info("No flow bean definitions found");
            return;
        }
        logger.info("Loading flow data beans");
        BeanStoreReader[] readers = this.openBeanStoreReaders(beanStores);
        for (FlowConfigTag.BeanTag beanTag : beanTags) {
            this.loadBean(beanTag, flowContext, readers);
        }
        this.closeBeanStoreReaders(readers);
    }

    private void loadBean(FlowConfigTag.BeanTag beanTag, FlowContext flowContext, BeanStoreReader ... beanStoreReaders) throws FlowConfigException {
        Object bean = null;
        String className = beanTag.getBeanClass();
        try {
            Class<? extends Object> beanType = FlowBeanRegistry.addBeanType(className);
            if (beanType != null) {
                flowContext.addRequiredBeanType(beanType);
                bean = this.flowDataMap.get(beanType);
                for (BeanStoreReader reader : beanStoreReaders) {
                    if (reader == null) continue;
                    if (bean != null) {
                        reader.read(bean);
                        continue;
                    }
                    bean = reader.read(beanType);
                }
                if (bean != null) {
                    String beanId = FlowBeanRegistry.getBeanId(beanType);
                    flowContext.setBean(beanId, bean);
                    logger.log(Level.INFO, "Set value for bean {0}", beanId);
                } else {
                    logger.log(Level.INFO, "Value not found for {0}", beanType);
                }
            }
        }
        catch (Exception e) {
            logger.fine("Failed to load bean " + className + ". Reason: " + e.getMessage());
        }
    }

    private BeanStore[] openBeanStores(FlowDataSource flowDataSource, Properties flowDataDefaults) {
        XmlBeanStoreFormat format;
        logger.log(Level.INFO, "Opening bean stores from which the beans can be loaded");
        ArrayList<BeanStore> beanStores = new ArrayList<BeanStore>();
        boolean flowDataDefaultsExist = flowDataDefaults != null && !flowDataDefaults.isEmpty();
        Properties properties = new Properties();
        properties.putAll(System.getenv());
        beanStores.add(new PropertiesBeanStore(properties, true));
        if (flowDataDefaultsExist) {
            FlowBuilder.safeCopy(flowDataDefaults, properties);
        }
        if (flowDataSource != null && flowDataSource.getSourceURL() != null) {
            XmlBeanStoreFormat format2;
            if (!properties.isEmpty() && (format2 = flowDataSource.getFormat()) instanceof PropertyFileFormat) {
                logger.log(Level.INFO, "Changing the format to extended property file format to merge the flowDataDefaults with the flowDataSource");
                flowDataSource.setFormat(new ExtendedPropertyFileFormat((PropertyFileFormat)format2, flowDataDefaults));
            }
            BeanStoreFactory beanStoreFactory = BeanStoreFactory.getInstance();
            try {
                Object beanStore = beanStoreFactory.newBeanStore(flowDataSource);
                ((BeanStore)beanStore).setBeanStoreName(flowDataSource.getBeanStoreName());
                beanStores.add((BeanStore)beanStore);
            }
            catch (BeanStoreException e) {
                ExceptionManager.handle(e);
            }
            catch (Exception e) {
                ExceptionManager.handle(e);
            }
            logger.log(Level.INFO, "Loaded BeanStore using the flow data source");
        } else if (!properties.isEmpty() && (format = XmlBeanStoreFormatRegistry.getInstance().getDefaultFormat()) instanceof PropertyFileFormat) {
            try {
                XmlBeanStore beanStore = BeanStoreUtils.createXmlBeanStore((PropertyFileFormat)format, properties);
                beanStore.setBeanStoreName(format.getBeanStoreName());
                beanStores.add(beanStore);
            }
            catch (BeanStoreException e) {
                ExceptionManager.handle(e);
            }
        }
        if (flowDataDefaultsExist) {
            beanStores.add(new PropertiesBeanStore(flowDataDefaults, false));
            logger.log(Level.INFO, "Loaded BeanStore using the flow data defaults");
        }
        return beanStores.toArray(new BeanStore[0]);
    }

    private void closeBeanStores(BeanStore ... beanStores) {
        logger.log(Level.INFO, "Closing bean stores from which the beans can be loaded");
        if (beanStores != null) {
            for (BeanStore beanStore : beanStores) {
                try {
                    beanStore.close();
                }
                catch (BeanStoreException e) {
                    logger.log(Level.WARNING, "Failed to close bean store", e);
                }
            }
        }
    }

    private BeanStoreReader[] openBeanStoreReaders(BeanStore ... beanStores) {
        ArrayList readers = new ArrayList();
        for (BeanStore beanStore : beanStores) {
            try {
                readers.add(beanStore.newBeanStoreReader());
            }
            catch (BeanStoreException e) {
                logger.log(Level.WARNING, "Failed to create bean store reader", e);
            }
        }
        return readers.toArray(new BeanStoreReader[0]);
    }

    private void closeBeanStoreReaders(BeanStoreReader ... readers) {
        if (readers != null) {
            for (BeanStoreReader reader : readers) {
                try {
                    reader.close();
                }
                catch (BeanStoreException e) {
                    logger.log(Level.WARNING, "Failed to close bean store reader", e);
                }
            }
        }
    }

    private void loadViews(FlowConfigTag flowConfigTag) throws FlowConfigException {
        List<FlowConfigTag.ViewTag> viewTags = flowConfigTag.getViewTags();
        if (viewTags == null || viewTags.isEmpty()) {
            logger.log(Level.INFO, "No view definitions found.");
            return;
        }
        logger.info("Registering the flow views");
        for (FlowConfigTag.ViewTag viewTag : viewTags) {
            String className = viewTag.getViewClass();
            UIType uiType = viewTag.getUIType();
            String viewId = viewTag.getViewName();
            if (className == null) continue;
            try {
                ViewManager.addViewType(className, viewId, uiType);
            }
            catch (ViewManagerException e) {
                throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_VIEW_DEFINITION, new Object[0]);
            }
        }
    }

    private Map<String, Condition> loadConditions(FlowConfigTag flowConfigTag) throws FlowConfigException {
        TreeMap<String, Condition> conditionMap = null;
        List<FlowConfigTag.ConditionTag> conditionTags = flowConfigTag.getConditionTags();
        if (conditionTags == null || conditionTags.isEmpty()) {
            logger.log(Level.INFO, "No global condition definition found.");
            return null;
        }
        conditionMap = new TreeMap<String, Condition>();
        for (FlowConfigTag.ConditionTag conditionTag : conditionTags) {
            String id = conditionTag.getId();
            String conditionClass = conditionTag.getConditionClass();
            if (StringUtils.isEmpty(conditionClass) || StringUtils.isEmpty(id)) continue;
            logger.log(Level.INFO, "Loading condition class {0}", conditionClass);
            try {
                Class<?> clazz = Class.forName(conditionClass);
                ConditionRoutine conditionRoutine = (ConditionRoutine)clazz.newInstance();
                Condition condition = new Condition();
                condition.setConditionRoutine(conditionRoutine);
                condition.setId(id);
                condition.setParameters(conditionTag.getParameters());
                conditionMap.put(id, condition);
            }
            catch (Exception e) {
                throw new FlowConfigException((Throwable)e, FlowConfigErrorCode.INVALID_CONDITION_DEFINITION, new Object[0]);
            }
        }
        return conditionMap;
    }

    private static Properties safeCopy(Properties source, Properties target) {
        for (Map.Entry<Object, Object> e : source.entrySet()) {
            Object value = e.getValue();
            if (!(value instanceof String)) continue;
            String string = (String)value;
            if ((string = string.trim()).length() <= 0) continue;
            target.put(e.getKey(), value);
        }
        return target;
    }

    class ExtendedPropertyFileFormat
    extends PropertyFileFormat {
        private Properties defaults;

        public ExtendedPropertyFileFormat(PropertyFileFormat sourceFormat, Properties defaults) {
            super(sourceFormat.getBeanStoreName(), sourceFormat.getNamespaceURI(), sourceFormat.getRaw2extTransformer(), sourceFormat.getExt2rawTransformer(), sourceFormat.getSchema());
            this.defaults = defaults;
        }

        @Override
        public Properties loadProperties(InputStream in) throws IOException {
            Properties properties = new Properties();
            properties = super.loadProperties(in);
            if (this.defaults != null) {
                this.updateProperties(this.defaults, properties);
            }
            return properties;
        }

        private Properties updateProperties(Properties source, Properties target) {
            for (Map.Entry<Object, Object> e : source.entrySet()) {
                Object value = e.getValue();
                Set<Object> targetKeySet = target.keySet();
                if (!(value instanceof String) || !targetKeySet.contains(e.getKey())) continue;
                String string = (String)value;
                if ((string = string.trim()).length() <= 0) continue;
                target.put(e.getKey(), value);
            }
            return target;
        }
    }
}

