/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.jewt;

import java.awt.Component;
import java.util.Set;
import javax.swing.JPanel;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.StateType;
import oracle.install.commons.flow.View;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Graph;

public class FlowWizardPage
extends WizardPage {
    private static final Component BLANK = new JPanel();
    private static final String FLOW_WIZARD_PAGE_KEY = "oracle.install.commons.flow.jewt.FlowWizardPage.key";
    public static final int TYPE_PROGRESS = 1;
    public static final int TYPE_END_OF_PROCESS = 2;
    private Graph<Route, State> vertex;
    private int type;

    public static FlowWizardPage getInstance(Graph<Route, State> vertex) {
        State state = vertex.getValue();
        FlowWizardPage wizardPage = (FlowWizardPage)((Object)state.getAttribute(FLOW_WIZARD_PAGE_KEY));
        return wizardPage;
    }

    public static FlowWizardPage newBlankInstance(Graph<Route, State> vertex) {
        return FlowWizardPage.newInstance(vertex, BLANK);
    }

    public static FlowWizardPage newInstance(Graph<Route, State> vertex) {
        View view;
        Component content = BLANK;
        State state = vertex.getValue();
        if (state.isViewState() && (view = state.getView()) != null) {
            content = view.getView();
        }
        return FlowWizardPage.newInstance(vertex, content);
    }

    public static FlowWizardPage newInstance(Graph<Route, State> vertex, Component content) {
        FlowWizardPage wizardPage = new FlowWizardPage(content, vertex);
        State state = vertex.getValue();
        state.setAttribute(FLOW_WIZARD_PAGE_KEY, (Object)wizardPage);
        return wizardPage;
    }

    private FlowWizardPage(Component content, Graph<Route, State> vertex) {
        super(content);
        this.setVertex(vertex);
        this.associateInlineValidators(content);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    private void associateInlineValidators(Component content) {
        super.removeAllValidationComponents();
        Set<ValidationComponent> validators = InlineValidationHelper.getRegisteredInlineValidators(content);
        if (validators != null) {
            for (ValidationComponent validator : validators) {
                super.addValidationComponent(validator);
            }
        }
    }

    public final void setContent(Component content) {
        if (this.getContent() != content) {
            this.associateInlineValidators(content);
            super.setContent(content);
        }
    }

    public final void setVertex(Graph<Route, State> vertex) {
        if (vertex != null && this.vertex != vertex) {
            String accessibleDescription;
            this.vertex = vertex;
            State state = vertex.getValue();
            if (Application.getInstance().getBoolean("wizard.roadmap.branchVisible", true)) {
                super.setBranching(state.getStateType() == StateType.decision);
            }
            Application application = Application.getInstance();
            String stateId = state.getId();
            String tag = application.getString(stateId + ".tag", stateId, new Object[0]);
            String name = application.getString(stateId + ".name", stateId, new Object[0]);
            if (name != null) {
                super.setLabel(name);
                super.setPageTitle(name);
            }
            if ((accessibleDescription = application.getString(stateId + ".accessibleDescription", name, new Object[0])) != null && !accessibleDescription.trim().startsWith(name)) {
                accessibleDescription = name + ". " + accessibleDescription;
            }
            super.setAccessibleDescription(accessibleDescription);
            if (tag != null && !tag.equals(stateId)) {
                super.setLabel(tag);
            }
            if (state.getStateType() == StateType.progress) {
                this.type = 1;
            } else if (state.getStateType() == StateType.end) {
                this.type = 2;
            }
        }
    }

    public Graph<Route, State> getVertex() {
        return this.vertex;
    }

    public void dispose() {
        State state = this.vertex.getValue();
        state.removeAttribute(FLOW_WIZARD_PAGE_KEY);
        this.vertex = null;
    }
}

