/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.net.NetworkUtilityErrorCode;
import oracle.install.commons.net.NetworkUtilityException;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;

public class NetworkUtility {
    private static final Logger logger = Logger.getLogger(NetworkUtility.class.getName());
    private static NetworkUtility instance = null;

    public static NetworkUtility getInstance() {
        if (instance == null) {
            ProxyFactory proxyFactory = ProxyFactory.getInstance();
            instance = proxyFactory.createProxy(NetworkUtility.class, new NetworkUtility());
        }
        return instance;
    }

    protected NetworkUtility() {
    }

    public String getLocalHostName() throws NetworkUtilityException {
        String localhostName = null;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            localhostName = localhost.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new NetworkUtilityException((Throwable)e, (ErrorCode)NetworkUtilityErrorCode.UNKNOWN_LOCALHOST, new Object[0]);
        }
        return localhostName;
    }

    public boolean isLocalHost(String hostName) {
        boolean localHost = false;
        try {
            InetAddress[] addresses = InetAddress.getAllByName(hostName);
            for (int i = 0; i < addresses.length; ++i) {
                NetworkInterface networkInterface = NetworkInterface.getByInetAddress(addresses[i]);
                if (networkInterface == null) continue;
                localHost = true;
                break;
            }
        }
        catch (UnknownHostException e) {
            logger.log(Level.FINE, "Unknown Host: {0}. Error: {1}", new Object[]{hostName, e.getMessage()});
        }
        catch (SocketException e) {
            logger.log(Level.FINE, "Invalid Host: {0}. Error: {1}", new Object[]{hostName, e.getMessage()});
        }
        return localHost;
    }
}

