/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Font;
import java.io.StringReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class HtmlPane
extends JTextPane {
    private static Logger logger = Logger.getLogger(HtmlPane.class.getName());
    private HTMLDocument htmlDocument;
    private String resourcePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HtmlPane() {
        this.setEditable(false);
        this.setContentType("text/html");
        this.htmlDocument = (HTMLDocument)this.getDocument();
        StyleSheet stylesheet = this.htmlDocument.getStyleSheet();
        StringBuffer cssBuffer = new StringBuffer();
        Font font = this.getFont();
        cssBuffer.append("body {font-size: " + font.getSize() + ";font-family: " + font.getFamily() + "}");
        StringReader reader = new StringReader(cssBuffer.toString());
        try {
            stylesheet.loadRules(reader, null);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to set the CSS.", e);
        }
        finally {
            reader.close();
        }
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                String href;
                HyperlinkEvent.EventType et = e.getEventType();
                if (et == HyperlinkEvent.EventType.ACTIVATED && (href = e.getDescription()) != null && href.startsWith("#")) {
                    HtmlPane.this.scrollToReference(href.substring(1));
                }
            }
        });
    }

    public HTMLDocument getHtmlDocument() {
        return this.htmlDocument;
    }

    public void setResourcePath(String resourcePath) {
        URL baseUrl = this.getClass().getResource(resourcePath);
        if (baseUrl == null) {
            throw new IllegalArgumentException(resourcePath);
        }
        this.htmlDocument.setBase(baseUrl);
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }
}

