/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.install.commons.swing.StatusMessagePane;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;

public class StatusMessageDialog
extends JDialog {
    public static final int OK_OPTION = 0;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    protected StatusMessagePane statusMessagePane;
    protected JOptionPane optionPane;
    protected JLabel lblActionRequired;

    public StatusMessageDialog(Frame owner) {
        super(owner);
        this.buildUI();
    }

    public StatusMessageDialog(Dialog owner) {
        super(owner);
        this.buildUI();
    }

    protected void buildUI() {
        super.setModal(true);
        this.statusMessagePane = new StatusMessagePane();
        this.optionPane = new JOptionPane();
        this.lblActionRequired = new JLabel();
        BorderLayout layout = new BorderLayout();
        layout.setVgap(5);
        JPanel pnlMain = new JPanel(layout);
        pnlMain.add(this.statusMessagePane);
        pnlMain.add((Component)this.lblActionRequired, "South");
        this.optionPane.setMessage(pnlMain);
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (StatusMessageDialog.this.isVisible() && event.getSource() == StatusMessageDialog.this.optionPane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    StatusMessageDialog.this.setVisible(false);
                }
            }
        });
        this.getContentPane().add(this.optionPane);
        this.pack();
        this.setResizable(false);
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                StatusMessageDialog.this.optionPane.setValue(null);
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    StatusMessageDialog.this.optionPane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        this.addWindowListener(adapter);
        this.addWindowFocusListener(adapter);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                StatusMessageDialog.this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
    }

    protected void prepare(Level level) {
        int messageType = 1;
        int optionType = 2;
        String message = null;
        if (level == Level.SEVERE) {
            messageType = 0;
            optionType = -1;
        } else if (level == Level.WARNING) {
            messageType = 2;
            optionType = 0;
            Application application = Application.getInstance();
            message = application.getString(ResourceURL.resURL("oracle.install.commons.util.resource.StringResourceBundle", "prompt.warning.confirmation"), "Are you sure you want to continue ?", new Object[0]);
        } else {
            messageType = 1;
        }
        if (message != null) {
            this.lblActionRequired.setText(message);
            this.lblActionRequired.setVisible(true);
        } else {
            this.lblActionRequired.setVisible(false);
        }
        this.optionPane.setMessageType(messageType);
        this.optionPane.setOptionType(optionType);
        this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
        this.statusMessagePane.reset();
    }

    public int show(StatusMessage statusMessage) {
        StatusMessages<StatusMessage> statusMessages = new StatusMessages<StatusMessage>();
        statusMessages.add(statusMessage);
        int returnCode = this.show(statusMessages);
        statusMessages.clear();
        return returnCode;
    }

    public int show(StatusMessages<? extends StatusMessage> statusMessages) {
        int returnCode = 0;
        if (statusMessages != null && !statusMessages.isEmpty()) {
            Level level = statusMessages.getAggregateLevel();
            this.prepare(level);
            this.statusMessagePane.setMaxLimit(statusMessages.size() > 1 ? -1 : 1);
            statusMessages.sortByLevel();
            for (StatusMessage statusMessage : statusMessages) {
                this.statusMessagePane.appendStatusMessage(statusMessage);
            }
            this.setLocationRelativeTo(this.getOwner());
            super.setVisible(true);
            Object selectedValue = this.optionPane.getValue();
            if (selectedValue instanceof Integer) {
                returnCode = (Integer)selectedValue;
            }
        }
        return returnCode;
    }
}

