/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing.tree;

import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.install.commons.swing.tree.HashedLinkedList;
import oracle.install.commons.swing.tree.TreeGeneratorException;
import oracle.install.commons.swing.tree.TreeNodeFactory;

public class TreeUtils {
    public static int ASCENDING_ORDER = 1;
    public static int DESCENDING_ORDER = 2;

    public static DefaultMutableTreeNode createTree(TreeNodeFactory factory, Collection recordSet) throws TreeGeneratorException {
        return TreeUtils.createTree(factory, recordSet, -1);
    }

    public static DefaultMutableTreeNode createTree(TreeNodeFactory factory, Collection recordSet, int orderingMode) throws TreeGeneratorException {
        boolean ordered = orderingMode == ASCENDING_ORDER || orderingMode == DESCENDING_ORDER;
        Comparator nodeComparator = factory.getNodeComparator();
        DefaultMutableTreeNode root = factory.getRootNode();
        HashMap<Object, DefaultMutableTreeNode> treeNodeStore = new HashMap<Object, DefaultMutableTreeNode>();
        for (int pass = 1; pass <= 2; ++pass) {
            int size = recordSet.size();
            Iterator recordIterator = recordSet.iterator();
            int index = 0;
            while (recordIterator.hasNext()) {
                Object record = recordIterator.next();
                ++index;
                Object id = factory.getId(record);
                if (id == null) {
                    throw new TreeGeneratorException("id not found", record, index);
                }
                Object parentId = factory.getParentId(record);
                switch (pass) {
                    case 1: {
                        DefaultMutableTreeNode newNode;
                        DefaultMutableTreeNode defaultMutableTreeNode = newNode = parentId == null || factory.isRootsId(parentId) ? factory.createRootNode(record) : factory.createNode(record);
                        if (newNode == null) {
                            throw new TreeGeneratorException("Node cannot be Null", record, index);
                        }
                        treeNodeStore.put(id, newNode);
                        break;
                    }
                    case 2: {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)treeNodeStore.get(id);
                        DefaultMutableTreeNode parentNode = factory.isRootsId(parentId) ? root : (DefaultMutableTreeNode)treeNodeStore.get(parentId);
                        DefaultMutableTreeNode defaultMutableTreeNode = parentNode = parentNode != null ? parentNode : root;
                        if (ordered) {
                            TreeUtils.addNodeInOrder(parentNode, childNode, orderingMode, nodeComparator);
                            break;
                        }
                        parentNode.add(childNode);
                    }
                }
            }
        }
        treeNodeStore.clear();
        treeNodeStore = null;
        return root;
    }

    public static void addNodeInOrder(DefaultMutableTreeNode parent, DefaultMutableTreeNode node, int orderingMode, Comparator nodeComparator) {
        if (parent.isLeaf()) {
            parent.add(node);
        } else {
            Enumeration<TreeNode> e = parent.children();
            int index = 0;
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
                int equality = nodeComparator != null ? nodeComparator.compare(node, child) : node.toString().compareTo(child.toString());
                if (orderingMode == ASCENDING_ORDER && equality < 0 || orderingMode == DESCENDING_ORDER && equality > 0) {
                    parent.insert(node, index);
                    break;
                }
                ++index;
            }
            if (index == parent.getChildCount()) {
                parent.add(node);
            }
        }
    }

    public static DefaultMutableTreeNode addToTree(Collection data, DefaultMutableTreeNode tree, TreeNodeFactory factory) throws TreeGeneratorException {
        HashedLinkedList nodeMap = new HashedLinkedList();
        for (Object item : data) {
            if (factory.getId(item) != null) {
                Object parentId = factory.getParentId(item);
                DefaultMutableTreeNode node = factory.createNode(item);
                nodeMap.put(parentId, node);
                continue;
            }
            throw new TreeGeneratorException("id not found", item, -1);
        }
        Enumeration<TreeNode> nodes = tree.preorderEnumeration();
        while (nodes.hasMoreElements() && !nodeMap.isEmpty()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            Object id = factory.getId(node);
            if (!nodeMap.containsKey(id)) continue;
            LinkedList children = (LinkedList)nodeMap.get(id);
            for (DefaultMutableTreeNode child : children) {
                node.add(child);
            }
            nodeMap.remove(id);
        }
        return tree;
    }

    public static boolean setNodeExpanded(JTree tree, DefaultMutableTreeNode node, boolean expand) {
        boolean success = false;
        TreePath path = new TreePath(node.getPath());
        if (expand) {
            success = !tree.isExpanded(path);
            if (success) {
                tree.expandPath(path);
            }
        } else {
            success = !tree.isCollapsed(path);
            if (success) {
                tree.collapsePath(path);
            }
        }
        return success;
    }

    public static boolean setSubTreeExpanded(JTree tree, DefaultMutableTreeNode node, boolean expand) {
        Enumeration<TreeNode> e;
        boolean success = false;
        Enumeration<TreeNode> enumeration = e = expand ? node.preorderEnumeration() : node.postorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
            if (childNode.isRoot()) continue;
            success = TreeUtils.setNodeExpanded(tree, childNode, expand) || success;
        }
        return success;
    }
}

