/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.system.filemgmt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.io.StreamComparator;
import oracle.install.commons.system.filemgmt.FileSystemErrorCode;
import oracle.install.commons.system.filemgmt.FileSystemException;
import oracle.install.commons.util.exception.ErrorCode;

public class FileSystem {
    private static File tmpDir = new File(System.getProperty("java.io.tmpdir"));
    private static File homeDir = new File(System.getProperty("user.home"));
    private static final String INSTALL_BADCHARS_RESPONSE_FILE_WIN = "!@%^&*()+=|/`[{]};'\",<>?";
    private static final String INSTALL_BADCHARS_RESPONSE_FILE_UNIX = "!@%^&*()+=|`~[{]};:'\",<>?\\";

    public static File getTempDirectory() {
        return tmpDir;
    }

    public static File getHomeDirectory() {
        return homeDir;
    }

    public static boolean match(File file1, File file2) throws Exception {
        StreamComparator comparator = StreamComparator.getInstance();
        return comparator.match(file1, file2);
    }

    public static boolean differ(File file1, File file2) {
        boolean result = true;
        try {
            result = !FileSystem.match(file1, file2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static boolean isValidDirectory(String path) {
        File[] roots;
        path = path.toLowerCase();
        boolean valid = false;
        for (File root : roots = File.listRoots()) {
            if (!path.startsWith(root.getPath().toLowerCase())) continue;
            valid = true;
            break;
        }
        return valid;
    }

    public static String getFileExtension(String file) {
        return FileSystem.getFileExtension(new File(file));
    }

    public static String getFileExtension(File file) {
        String ext = null;
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            ext = name.substring(dotIndex + 1);
        }
        return ext;
    }

    public static void delete(File path) {
        FileSystem.delete(path, null);
    }

    public static void delete(File path, FileFilter filter) {
        if (path.exists()) {
            if (path.isDirectory()) {
                File[] children;
                for (File file : children = path.listFiles(filter)) {
                    FileSystem.delete(file, filter);
                }
            }
            path.delete();
        }
    }

    public static void copy(File srcDir, File destDir, FileFilter filter) {
        if (srcDir.exists()) {
            FileSystem.__copy(srcDir, destDir, filter);
        }
    }

    public static void copy(File srcFile, File destFile, boolean overwrite) {
        if (!srcFile.exists()) {
            throw new FileSystemException((ErrorCode)FileSystemErrorCode.SOURCE_FILE_NOT_FOUND, srcFile);
        }
        if (!srcFile.isFile()) {
            throw new FileSystemException((ErrorCode)FileSystemErrorCode.NOT_A_FILE, srcFile);
        }
        if (destFile.isDirectory()) {
            destFile = new File(destFile, srcFile.getName());
        }
        if (srcFile.equals(destFile)) {
            throw new FileSystemException((ErrorCode)FileSystemErrorCode.CANNOT_COPY_FILE_ONTO_ITSELF, srcFile);
        }
        if (!overwrite && destFile.exists()) {
            throw new FileSystemException((ErrorCode)FileSystemErrorCode.TARGET_FILE_ALREADY_EXISTS, srcFile, destFile);
        }
        File destDir = destFile.getParentFile();
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new FileSystemException((ErrorCode)FileSystemErrorCode.PARENT_DIRECTORY_CREATION_FAILED, srcFile, destFile);
        }
        try {
            FileSystem.__copy(new FileInputStream(srcFile), new FileOutputStream(destFile), true);
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e, (ErrorCode)FileSystemErrorCode.FILE_COPY_FAILED, srcFile, destFile);
        }
    }

    public static void copy(File srcFile, File destFile) {
        FileSystem.copy(srcFile, destFile, false);
    }

    public static void move(File srcFile, File destFile) {
        FileSystem.copy(srcFile, destFile);
        srcFile.delete();
    }

    public static void move(File srcDir, File destDir, FileFilter filter) {
        FileSystem.copy(srcDir, destDir, filter);
        FileSystem.delete(srcDir);
    }

    public static void archive(File path, File archiveFile) {
        try {
            Zip zip = new Zip();
            zip.archive(path, archiveFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void extract(File archiveFile, File destDir) {
        if (!archiveFile.isFile() || !archiveFile.exists()) {
            throw new FileSystemException((ErrorCode)FileSystemErrorCode.INVALID_ARCHIVE, archiveFile);
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new FileSystemException((ErrorCode)FileSystemErrorCode.NOT_A_DIRECTORY, destDir);
        }
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try {
            Zip zip = new Zip();
            zip.extract(archiveFile, destDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void __copy(File src, File dest, FileFilter filter) {
        if (src.isDirectory()) {
            File[] files;
            for (File file : files = src.listFiles(filter)) {
                FileSystem.__copy(file, new File(dest, file.getName()), filter);
            }
        } else {
            FileSystem.copy(src, dest);
        }
    }

    private static void __copy(InputStream in, OutputStream out, boolean close) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in);
        BufferedOutputStream bout = new BufferedOutputStream(out);
        byte[] buffer = new byte[512];
        int len = -1;
        while ((len = bin.read(buffer)) != -1) {
            bout.write(buffer, 0, len);
            bout.flush();
        }
        if (close) {
            out.close();
        }
        bin.close();
    }

    public static boolean isFileNameValid(String fileName, String unSupportedCharacters) {
        boolean valid = true;
        if (fileName != null && fileName.length() > 0) {
            unSupportedCharacters = unSupportedCharacters == null ? "" : unSupportedCharacters;
            for (char ch : fileName.toCharArray()) {
                if (unSupportedCharacters.indexOf(ch) < 0) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    public static String getBadCharsSet() {
        String badChars = null;
        badChars = PlatformInfo.getInstance().isWindows() ? INSTALL_BADCHARS_RESPONSE_FILE_WIN : INSTALL_BADCHARS_RESPONSE_FILE_UNIX;
        return badChars;
    }

    private static class Zip {
        private Zip() {
        }

        public void archive(File file, File archiveFile) throws IOException {
            FileOutputStream fout = new FileOutputStream(archiveFile);
            ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(fout));
            zout.setMethod(8);
            File baseDir = file.isDirectory() ? file : null;
            this.zip(baseDir, file, zout);
            zout.close();
        }

        public void extract(File archiveFile, File destDir) throws IOException {
            ZipFile zipFile = new ZipFile(archiveFile);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                InputStream zin = zipFile.getInputStream(entry);
                String entryName = entry.getName();
                File file = new File(destDir, entryName);
                File parentDir = file.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                if (entryName.endsWith("/")) continue;
                FileSystem.__copy(zin, new FileOutputStream(file), true);
            }
        }

        private void zip(File baseDir, File file, ZipOutputStream zout) throws IOException {
            if (file.isDirectory()) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    this.zip(baseDir, f, zout);
                }
            } else {
                String dir;
                int index;
                String name = file.getPath();
                if (baseDir != null && (index = name.indexOf(dir = baseDir.getName())) != -1) {
                    name = name.substring(index += dir.length() + 1);
                }
                name = name.replace('\\', '/');
                ZipEntry entry = new ZipEntry(name);
                zout.putNextEntry(entry);
                FileSystem.__copy(new FileInputStream(file), zout, false);
                zout.closeEntry();
            }
        }
    }
}

