/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.system.process;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.system.process.ProcessEvent;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessListener;

class ProcessMonitor
implements ProcessListener {
    private static final Logger logger = Logger.getLogger(ProcessMonitor.class.getName());
    private long timeout;
    private Timer timer;

    public ProcessMonitor(long timeout) {
        this.timeout = timeout;
        this.timer = new Timer("ProcessMonitor.Timer");
    }

    @Override
    public void update(ProcessEvent e) {
        ProcessLaunchInfo processLaunchInfo = e.getProcessLaunchInfo();
        String executable = processLaunchInfo.getExecutable();
        switch ((ProcessEvent.Type)e.getType()) {
            case PROCESS_STARTED: {
                logger.log(Level.INFO, "Scheduling the timeout for the process ''{0}'' to be after {1} ms", new Object[]{executable, this.timeout});
                this.timer.schedule((TimerTask)new ProcessKillerTask(processLaunchInfo, (Process)e.getSource()), this.timeout);
                break;
            }
            case PROCESS_COMPLETED: 
            case PROCESS_FAILED: {
                this.timer.cancel();
                break;
            }
            case PROCESS_TIMEDOUT: {
                logger.log(Level.INFO, "Timed the process ''{0}''", executable);
            }
        }
    }

    class ProcessKillerTask
    extends TimerTask {
        private Process process;
        private ProcessLaunchInfo processLaunchInfo;

        public ProcessKillerTask(ProcessLaunchInfo processLaunchInfo, Process process) {
            this.processLaunchInfo = processLaunchInfo;
            this.process = process;
        }

        @Override
        public boolean cancel() {
            logger.log(Level.INFO, "Cancelling the timeout timer for the process ''{0}''", this.processLaunchInfo.getExecutable());
            this.process = null;
            return super.cancel();
        }

        @Override
        public void run() {
            if (this.process != null) {
                logger.log(Level.INFO, "Timing out the process ''{0}''", this.processLaunchInfo.getExecutable());
                this.process.destroy();
                this.processLaunchInfo.fireProcessEvent(new ProcessEvent(this.process, ProcessEvent.Type.PROCESS_TIMEDOUT, this.processLaunchInfo));
                this.process = null;
            }
        }
    }
}

