/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.ApplicationProgressEvent;
import oracle.install.commons.util.ApplicationProgressListener;
import oracle.install.commons.util.ApplicationWarning;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.ExitStatusSet;
import oracle.install.commons.util.HelpManager;
import oracle.install.commons.util.HelpManagerException;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.Splash;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.XmlSupport;
import oracle.install.commons.util.exception.ApplicationException;
import oracle.install.commons.util.exception.CommonErrorCode;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.ExceptionManager;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Application {
    private static final Logger logger = Logger.getLogger(Application.class.getName());
    private static Application instance;
    private EventSupport<ApplicationEvent> eventSupport;
    private EventSupport<ApplicationProgressEvent> progressEventSupport;
    private HelpManager helpManager;
    private Locale locale;
    private UIType uiType;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Resource defaultResource;
    private String name = "Application";
    private Map<String, Resource> resourceMap;
    private List<String> arguments;
    private Level logLevel;
    private StatusControl statusControl;
    private ExitStatusSet exitStatusSet;
    private Set<ApplicationWarning> applicationWarningSet;
    public static final String DEFAULT_APPLICATION_RESOURCE_NAME = "ApplicationResources";
    public static final String DEFAULT_APPLICATION_NAME = "Application";
    private static URL applicationConfigXsd;

    public static Application getInstance() {
        if (instance == null) {
            instance = new Application();
        }
        return instance;
    }

    public static <A extends Application> A getInstance(Class<A> type) {
        if (instance == null || !instance.getClass().equals(type)) {
            try {
                instance = (Application)type.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (A)instance;
    }

    protected Application() {
        this.uiType = UIType.GRAPHICAL;
        this.locale = Locale.getDefault();
        this.eventSupport = new EventSupport();
        this.progressEventSupport = new EventSupport();
        this.resourceMap = new HashMap<String, Resource>();
        this.statusControl = new StatusControl();
        this.defaultResource = new Resource(null, null);
        this.exitStatusSet = new ExitStatusSet();
        this.applicationWarningSet = new HashSet<ApplicationWarning>();
    }

    public HelpManager getHelpManager() throws ApplicationException {
        if (this.helpManager == null) {
            throw new ApplicationException((ErrorCode)CommonErrorCode.HELP_NOT_AVAILABLE, new Object[0]);
        }
        return this.helpManager;
    }

    protected Resource findResource(String key) {
        Resource resource;
        block4: {
            resource = this.defaultResource;
            if (ResourceURL.isResourceURL(key)) {
                try {
                    ResourceURL url = new ResourceURL(key);
                    Resource cachedResource = this.getResource(url.getResourceBundleName());
                    if (cachedResource != null) {
                        resource = cachedResource;
                    }
                }
                catch (MalformedURLException e) {
                    if (logger == null) break block4;
                    logger.severe("'" + key + "' is not a valid Resource URL.");
                }
            }
        }
        return resource;
    }

    protected void reloadAllResources(Locale locale) {
        for (Resource resource : this.resourceMap.values()) {
            resource.reload(locale);
        }
    }

    public Resource loadResource(String resourceBundleName, boolean isDefault) throws MissingResourceException {
        Resource resource = null;
        if (resourceBundleName != null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName, this.locale);
            resource = new Resource(resourceBundleName, resourceBundle);
            this.resourceMap.put(resourceBundleName, resource);
            if (isDefault) {
                this.defaultResource = resource;
                this.name = this.defaultResource.getString("application.name", DEFAULT_APPLICATION_NAME, new Object[0]);
            }
        }
        return resource;
    }

    public Resource getResource(String resourceBundleName) {
        Resource resource;
        block4: {
            resource = this.resourceMap.get(resourceBundleName);
            if (resource == null) {
                try {
                    resource = this.loadResource(resourceBundleName, false);
                }
                catch (MissingResourceException e) {
                    if (logger != null) {
                        logger.severe("Failed to load application resources from " + resourceBundleName);
                    }
                    resource = new Resource(resourceBundleName, null);
                    if (logger == null) break block4;
                    logger.severe("Created empty resource object");
                }
            }
        }
        return resource;
    }

    public Resource loadDefaultResource(String resourceBundleName) {
        Resource resource;
        block3: {
            resource = null;
            try {
                resourceBundleName = resourceBundleName != null ? resourceBundleName : DEFAULT_APPLICATION_RESOURCE_NAME;
                this.loadResource(resourceBundleName, true);
            }
            catch (MissingResourceException e) {
                if (logger != null) {
                    logger.severe("Failed to load application resources from " + resourceBundleName);
                }
                resource = new Resource(resourceBundleName, null);
                if (logger == null) break block3;
                logger.severe("Created empty resource object");
            }
        }
        return resource;
    }

    public Resource getDefaultResource() {
        return this.defaultResource;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getString("application.name", DEFAULT_APPLICATION_NAME, new Object[0]);
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (!locale.equals(this.locale)) {
            this.locale = locale;
            this.reloadAllResources(this.locale);
            this.fireApplicationEvent(new ApplicationEvent(this, ApplicationEvent.Type.LOCALE_CHANGED, new Object[0]));
        }
    }

    public UIType getUIType() {
        return this.uiType;
    }

    public void setUIType(UIType uiType) {
        this.uiType = uiType;
    }

    public String getProperty(String key, Object ... args) {
        String property = null;
        Resource resource = this.findResource(key);
        if (resource != null) {
            property = resource.getProperty(ResourceURL.resKey(key), args);
        }
        return property;
    }

    public String getString(String key, String defaultValue, Object ... args) {
        String string = defaultValue;
        Resource resource = this.findResource(key);
        if (resource != null) {
            string = resource.getString(ResourceURL.resKey(key), defaultValue, args);
        }
        return string;
    }

    public ImageIcon getIcon(String key, Object ... args) {
        return this.getIcon(key, null, args);
    }

    public ImageIcon getIcon(String key, ImageIcon defaultIcon, Object ... args) {
        ImageIcon icon = defaultIcon;
        Resource resource = this.findResource(key);
        if (resource != null) {
            icon = resource.getIcon(ResourceURL.resKey(key), defaultIcon, args);
        }
        return icon;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(ResourceURL.resKey(key), false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean flag = defaultValue;
        Resource resource = this.findResource(key);
        if (resource != null) {
            flag = resource.getBoolean(ResourceURL.resKey(key), defaultValue);
        }
        return flag;
    }

    public ErrorInfo getErrorInfo(ErrorCode errorCode, Object ... args) {
        return ErrorInfo.getInstance(errorCode, args);
    }

    public String getString(Enum<?> e, Object ... args) {
        String message = e != null ? e.toString() : null;
        Resource resource = this.defaultResource;
        if (resource != null) {
            message = resource.getString(e, args);
        }
        return message;
    }

    public String getEnumString(Enum<?> e, String defaultValue, Object ... args) {
        String message = e != null ? e.toString() : null;
        Resource resource = this.defaultResource;
        if (resource != null) {
            message = resource.getEnumString(e, defaultValue, args);
        }
        return message;
    }

    protected void run() {
        Splash.getInstance().close();
    }

    protected void showUsage() {
    }

    protected void processArguments(List<String> args) throws IllegalArgumentException {
        if (args.contains("-help")) {
            this.showUsage();
            this.shutdown();
        }
        if (args.contains("-debug")) {
            this.logLevel = Level.FINEST;
        }
        int index = -1;
        index = args.indexOf("-logLevel");
        if (index != -1 && index + 1 < args.size()) {
            String name = args.get(index + 1);
            try {
                this.logLevel = Level.parse(name.toUpperCase());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void startup(String configPath, String ... args) throws Exception {
        URL appConfig = null;
        appConfig = configPath == null ? null : Application.class.getResource(configPath);
        this.startup(appConfig, args);
    }

    public void startup(URL appConfig, String ... args) throws ApplicationException {
        Logger.getLogger("").setLevel(Level.OFF);
        ArrayList<String> argList = new ArrayList<String>();
        Collections.addAll(argList, args);
        this.arguments = Arrays.asList(argList.toArray(new String[0]));
        try {
            this.processArguments(argList);
        }
        catch (IllegalArgumentException e) {
            Application.addExitStatus(CommonExitStatus.INVALID_USER_INPUT);
            System.out.println(e.getMessage());
            this.showUsage();
            this.shutdown();
        }
        if (appConfig != null) {
            try {
                XmlSupport.validate(appConfig, applicationConfigXsd);
            }
            catch (Exception e) {
                throw new ApplicationException((Throwable)e, (ErrorCode)CommonErrorCode.INVALID_APPLICATION_CONFIG, new Object[0]);
            }
            InputStream appConfigStream = null;
            try {
                appConfigStream = appConfig.openStream();
            }
            catch (IOException e) {
                throw new ApplicationException((Throwable)e, (ErrorCode)CommonErrorCode.APPLICATION_STARTUP_FAILED, new Object[0]);
            }
            try {
                Node appPropertyNode;
                NamedNodeMap attributes;
                NodeList nl;
                Node resourcesNode;
                NamedNodeMap attribs;
                Node refPathAttr;
                InputSource source = new InputSource(appConfigStream);
                XPath xpath = XPathFactory.newInstance().newXPath();
                Node appConfigNode = (Node)xpath.evaluate("application-config", source, XPathConstants.NODE);
                Node loggingNode = (Node)xpath.evaluate("logging", appConfigNode, XPathConstants.NODE);
                if (loggingNode != null && (refPathAttr = (attribs = loggingNode.getAttributes()).getNamedItem("src")) != null) {
                    String logRefPath = refPathAttr.getNodeValue();
                    LogManager.getInstance().loadConfiguration(logRefPath);
                    if (this.logLevel != null) {
                        LogManager.getInstance().setLevel(this.logLevel);
                    }
                }
                if ((resourcesNode = (Node)xpath.evaluate("resources", appConfigNode, XPathConstants.NODE)) != null) {
                    nl = (NodeList)xpath.evaluate("resource", resourcesNode, XPathConstants.NODESET);
                    int n = nl.getLength();
                    for (int i = 0; i < n; ++i) {
                        Node resourceNode = nl.item(i);
                        attributes = resourceNode.getAttributes();
                        Node attrName = attributes.getNamedItem("name");
                        Node attrDefault = attributes.getNamedItem("default");
                        String resourceBundleName = null;
                        String defaultFlag = null;
                        if (attrName != null) {
                            resourceBundleName = attrName.getNodeValue();
                        }
                        if (attrDefault != null) {
                            defaultFlag = attrDefault.getNodeValue();
                        }
                        if (resourceBundleName == null) continue;
                        try {
                            if (defaultFlag != null && Boolean.parseBoolean(defaultFlag)) {
                                this.loadDefaultResource(resourceBundleName);
                                continue;
                            }
                            this.loadResource(resourceBundleName, false);
                            continue;
                        }
                        catch (MissingResourceException e) {
                            ExceptionManager.handle(e);
                        }
                    }
                }
                if (this.uiType == UIType.GRAPHICAL) {
                    Node lnfNode = (Node)xpath.evaluate("lnf", appConfigNode, XPathConstants.NODE);
                    String lnfClassName = null;
                    if (lnfNode != null) {
                        lnfClassName = lnfNode.getTextContent();
                    }
                    if (lnfClassName == null) {
                        lnfClassName = UIManager.getSystemLookAndFeelClassName();
                    }
                    try {
                        UIManager.setLookAndFeel(lnfClassName);
                        logger.info("Using " + lnfClassName + " LookAndFeel");
                    }
                    catch (Exception e) {
                        ExceptionManager.handle(e);
                    }
                    try {
                        this.helpManager = new HelpManager();
                        Node helpNode = (Node)xpath.evaluate("help", appConfigNode, XPathConstants.NODE);
                        if (helpNode != null) {
                            NamedNodeMap attributes2 = helpNode.getAttributes();
                            Node attr = attributes2.getNamedItem("src");
                            if (attr != null) {
                                String helpPath = attr.getNodeValue();
                                URL helpURL = Application.class.getResource(helpPath);
                                if (helpURL != null) {
                                    this.helpManager.loadHelp(helpURL);
                                } else {
                                    logger.warning("Unknown help resource " + helpPath);
                                }
                            }
                            if ((attr = attributes2.getNamedItem("defaultTopicId")) != null) {
                                this.helpManager.setDefaultHelpTopic(attr.getNodeValue());
                            }
                            NodeList nl2 = (NodeList)xpath.evaluate("component", helpNode, XPathConstants.NODESET);
                            int n = nl2.getLength();
                            for (int i = 0; i < n; ++i) {
                                Node componentNode = nl2.item(i);
                                attributes2 = componentNode.getAttributes();
                                Node attrName = attributes2.getNamedItem("name");
                                Node attrTopicId = attributes2.getNamedItem("topicId");
                                this.helpManager.setHelpTopic(attrName.getNodeValue(), attrTopicId.getNodeValue());
                            }
                        }
                    }
                    catch (HelpManagerException e) {
                        ExceptionManager.handle(e);
                    }
                }
                if ((nl = (NodeList)xpath.evaluate("system-properties/property", appConfigNode, XPathConstants.NODESET)) != null) {
                    int n = nl.getLength();
                    for (int i = 0; i < n; ++i) {
                        Node propertyNode = nl.item(i);
                        NamedNodeMap attr = propertyNode.getAttributes();
                        Node attrName = attr.getNamedItem("name");
                        Node attrValue = attr.getNamedItem("value");
                        if (attrName == null || attrValue == null) continue;
                        System.setProperty(attrName.getNodeValue(), attrValue.getNodeValue());
                    }
                }
                if (this.defaultResource == null) {
                    this.defaultResource = new Resource();
                }
                if ((appPropertyNode = (Node)xpath.evaluate("application-properties", appConfigNode, XPathConstants.NODE)) != null) {
                    attributes = appPropertyNode.getAttributes();
                    Node srcAttr = attributes.getNamedItem("src");
                    if (srcAttr != null) {
                        String propertySource = srcAttr.getNodeValue();
                        URL propertiesURL = Application.class.getResource(propertySource);
                        Properties properties = new Properties();
                        properties.load(propertiesURL.openStream());
                        for (Map.Entry<Object, Object> e : properties.entrySet()) {
                            this.defaultResource.setProperty(e.getKey().toString(), e.getValue().toString());
                        }
                    }
                    if ((nl = (NodeList)xpath.evaluate("property", appPropertyNode, XPathConstants.NODESET)) != null) {
                        int n = nl.getLength();
                        for (int i = 0; i < n; ++i) {
                            Node propertyNode = nl.item(i);
                            NamedNodeMap attr = propertyNode.getAttributes();
                            Node attrName = attr.getNamedItem("name");
                            Node attrValue = attr.getNamedItem("value");
                            if (attrName == null || attrValue == null) continue;
                            this.defaultResource.setProperty(attrName.getNodeValue(), attrValue.getNodeValue());
                        }
                    }
                }
            }
            catch (XPathExpressionException e) {
                throw new ApplicationException((Throwable)e, (ErrorCode)CommonErrorCode.APPLICATION_STARTUP_FAILED, new Object[0]);
            }
            catch (IOException e) {
                throw new ApplicationException((Throwable)e, (ErrorCode)CommonErrorCode.APPLICATION_STARTUP_FAILED, new Object[0]);
            }
            finally {
                if (appConfigStream != null) {
                    try {
                        appConfigStream.close();
                    }
                    catch (IOException e) {
                        throw new ApplicationException(e);
                    }
                }
            }
        }
        Splash splash = Splash.getInstance();
        splash.open();
        this.setStatusControl(splash);
        this.run();
    }

    public void registerComponentForHelp(Component component, String helpId) {
        if (this.helpManager != null) {
            this.helpManager.registerComponentForHelp(component, helpId);
        }
    }

    public void showHelpForComponent(Component component) {
        if (this.helpManager != null) {
            try {
                this.helpManager.showHelpForComponent(component);
            }
            catch (HelpManagerException e) {
                ExceptionManager.handle(e);
            }
        }
    }

    public synchronized void restart(Object ... args) {
        this.fireApplicationEvent(new ApplicationEvent(this, ApplicationEvent.Type.RESTART, args));
        ExitStatus exitStatus = this.getExitStatusSet().getExitStatus();
        logger.log(Level.INFO, "Restarting {0}", this.name);
        this.exit(exitStatus.getIntValue());
    }

    public synchronized void shutdown(ExitStatus exitStatus) {
        this.exitStatusSet.add(exitStatus);
        this.shutdown();
    }

    public synchronized void shutdown() {
        this.fireApplicationEvent(new ApplicationEvent(this, ApplicationEvent.Type.SHUTDOWN, new Object[0]));
        Set<ApplicationWarning> applicatioinWarnings = this.getApplicaitonWarningSet();
        if (!applicatioinWarnings.isEmpty()) {
            Application.addExitStatus(CommonExitStatus.SUCCESS_WITH_WARNINGS);
        }
        ExitStatus exitStatus = this.getExitStatusSet().getExitStatus();
        logger.log(Level.INFO, "Exit Status is {0}", exitStatus.getIntValue());
        if (exitStatus == CommonExitStatus.SUCCESS_WITH_WARNINGS) {
            logger.log(Level.INFO, "List of warnings encountered in this Application:");
            for (ApplicationWarning warning : applicatioinWarnings) {
                logger.log(Level.INFO, warning.getMessage());
            }
        }
        logger.log(Level.INFO, "Shutdown {0}", this.name);
        this.exit(exitStatus.getIntValue());
    }

    protected void exit(int exitCode) {
        System.exit(exitCode);
    }

    public void pause(boolean pause) {
        if (pause) {
            this.fireApplicationEvent(new ApplicationEvent(this, ApplicationEvent.Type.PAUSE, new Object[0]));
            logger.info("Pause " + this.name);
        } else {
            this.fireApplicationEvent(new ApplicationEvent(this, ApplicationEvent.Type.RESUME, new Object[0]));
            logger.info("Resume " + this.name);
        }
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        LogManager.getInstance().setLevel(logLevel);
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    protected void fireApplicationEvent(ApplicationEvent e) {
        this.eventSupport.fireEvent(e);
    }

    public void addApplicationProgressListener(ApplicationProgressListener listener) {
        this.progressEventSupport.addEventListener(listener);
    }

    public void removeApplicationProgressListener(ApplicationProgressListener listener) {
        this.progressEventSupport.removeEventListener(listener);
    }

    protected void fireApplicationProgressEvent(ApplicationProgressEvent e) {
        this.progressEventSupport.fireEvent(e);
    }

    public static void setApplicationProgress(String id, String message, ApplicationProgressEvent.Type type) {
        if (message != null && message.length() > 0) {
            Application application = Application.getInstance();
            application.fireApplicationProgressEvent(new ApplicationProgressEvent(application, id, message, type));
        } else {
            logger.log(Level.WARNING, "Application progress message is empty for ID:" + id);
        }
    }

    public StatusControl getStatusControl() {
        return this.statusControl;
    }

    public void setStatusControl(StatusControl statusControl) {
        this.statusControl = statusControl;
    }

    public ExitStatusSet getExitStatusSet() {
        return this.exitStatusSet;
    }

    public Set<ApplicationWarning> getApplicaitonWarningSet() {
        return this.applicationWarningSet;
    }

    public static boolean addExitStatus(ExitStatus exitStatus) {
        Application application = Application.getInstance();
        ExitStatusSet exitStatusSet = application.getExitStatusSet();
        return exitStatusSet.add(exitStatus);
    }

    public static boolean removeExitStatus(ExitStatus exitStatus) {
        Application application = Application.getInstance();
        ExitStatusSet exitStatusSet = application.getExitStatusSet();
        return exitStatusSet.remove(exitStatus);
    }

    public static ExitStatus getExitStatus() {
        Application application = Application.getInstance();
        ExitStatusSet exitStatusSet = application.getExitStatusSet();
        return exitStatusSet.getExitStatus();
    }

    public static boolean addApplicationWarning(ApplicationWarning warning) {
        Application application = Application.getInstance();
        Set<ApplicationWarning> exitStatusSet = application.getApplicaitonWarningSet();
        return exitStatusSet.add(warning);
    }

    public static boolean removeApplicationWarning(ApplicationWarning warning) {
        Application application = Application.getInstance();
        Set<ApplicationWarning> exitStatusSet = application.getApplicaitonWarningSet();
        return exitStatusSet.remove(warning);
    }

    public static void status(String message) {
        Application.showStatus(message);
    }

    public static void showStatus(String message) {
        Application application = Application.getInstance();
        StatusControl statusControl = application.getStatusControl();
        if (message == null) {
            statusControl.clean();
        } else {
            statusControl.showMessage(message);
        }
    }

    public static void hideStatus() {
        Application application = Application.getInstance();
        StatusControl statusControl = application.getStatusControl();
        statusControl.clean();
        statusControl.close();
    }

    public static boolean isCommandLineSwitchEnabled(String switchName) {
        List<String> args = Application.getInstance().getArguments();
        boolean isSwitchEnabled = false;
        for (String arg : args) {
            if (!arg.equalsIgnoreCase(switchName)) continue;
            isSwitchEnabled = true;
        }
        return isSwitchEnabled;
    }

    public static boolean isApplicationWarningPresent(ApplicationWarning warning) {
        Application application = Application.getInstance();
        Set<ApplicationWarning> applicationWarningSet = application.getApplicaitonWarningSet();
        boolean isApplicationWarningPresent = false;
        if (applicationWarningSet.contains(warning)) {
            isApplicationWarningPresent = true;
        }
        return isApplicationWarningPresent;
    }

    static {
        applicationConfigXsd = Application.class.getResource("/oracle/install/commons/util/resource/application_config_schema_v11_2_0.xsd");
    }

    public static enum CommonExitStatus implements ExitStatus
    {
        SUCCESS(0, Level.INFO),
        FAILURE(-1, Level.SEVERE),
        INVALID_USER_INPUT(-2, Level.SEVERE),
        SUCCESS_WITH_WARNINGS(6, Level.WARNING),
        USER_CANCELLED_INSTALL(4, Level.SEVERE);

        private int intValue;
        private Level level;

        private CommonExitStatus(int intValue, Level level) {
            this.intValue = intValue;
            this.level = level;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public String getMessage() {
            Application application = Application.getInstance();
            return application.getString(this, new Object[0]);
        }
    }
}

