/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import oracle.install.commons.util.StatusMessage;

public class StatusMessages<T extends StatusMessage>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;
    private Level aggregateLevel = Level.FINEST;
    private static final Comparator<StatusMessage> statusMessageComparator = new Comparator<StatusMessage>(){

        @Override
        public int compare(StatusMessage o1, StatusMessage o2) {
            Integer o1Level = o1.getLevel().intValue();
            Integer o2Level = o2.getLevel().intValue();
            return o1Level.compareTo(o2Level);
        }
    };

    protected void computeAggregateLevel(Collection<? extends T> c) {
        for (StatusMessage statusMessage : c) {
            this.computeAggregateLevel(statusMessage);
        }
    }

    protected void computeAggregateLevel(T statusMessage) {
        Level level = statusMessage.getLevel();
        if (level.intValue() > this.aggregateLevel.intValue()) {
            this.aggregateLevel = level;
        }
    }

    public Level getAggregateLevel() {
        return this.aggregateLevel;
    }

    @Override
    public boolean add(T statusMessage) {
        boolean status = false;
        if (statusMessage != null) {
            if (this.contains(statusMessage)) {
                status = true;
            } else if (super.add(statusMessage)) {
                this.computeAggregateLevel(statusMessage);
                status = true;
            }
        }
        return status;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean status = false;
        if (c != null && (status = super.addAll(c))) {
            this.computeAggregateLevel((T)c);
        }
        return status;
    }

    @Override
    public boolean remove(Object o) {
        boolean status = false;
        if (o instanceof StatusMessage) {
            StatusMessage statusMessage = (StatusMessage)o;
            status = super.remove(statusMessage);
            if (statusMessage.getLevel() == this.aggregateLevel) {
                this.computeAggregateLevel((T)this);
            }
        }
        return status;
    }

    @Override
    public void clear() {
        super.clear();
        this.aggregateLevel = Level.FINEST;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean status = false;
        if (c != null && (status = super.removeAll(c))) {
            this.computeAggregateLevel((T)this);
        }
        return status;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean status = false;
        if (c != null && (status = super.retainAll(c))) {
            this.computeAggregateLevel((T)this);
        }
        return status;
    }

    public synchronized void sortByLevel() {
        Collections.sort(this, statusMessageComparator);
    }
}

