/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlSupport {
    public static void transform(Source input, Result output) throws Exception {
        XmlSupport.transform(input, output, null);
    }

    public static void transform(Source input, Result output, Source xslt) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = xslt != null ? transformerFactory.newTransformer(xslt) : transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(input, output);
    }

    public static String formatAsText(Source input, Source xslt) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = xslt != null ? transformerFactory.newTransformer(xslt) : transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter out = new StringWriter();
        transformer.transform(input, new StreamResult(out));
        return out.toString();
    }

    public static String formatAsText(Document document, String xslt) throws Exception {
        URL url = xslt != null ? XmlSupport.class.getResource(xslt) : null;
        StreamSource xsltSource = null;
        if (url != null) {
            xsltSource = new StreamSource(url.openStream());
        }
        return XmlSupport.formatAsText(new DOMSource(document), xsltSource);
    }

    public static String getNamespaceURI(InputSource xmlSource, String namespace) throws Exception {
        String namespaceURI = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document document = documentBuilder.parse(xmlSource);
        namespaceURI = document.lookupNamespaceURI(namespace);
        return namespaceURI;
    }

    public static void validate(Source xmlSource, URL schemaLocation) throws Exception {
        if (schemaLocation != null && xmlSource != null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaLocation);
            Validator validator = schema.newValidator();
            LocalErrorHandler errorHandler = new LocalErrorHandler();
            validator.setErrorHandler(errorHandler);
            validator.validate(xmlSource);
            if (errorHandler.isFailed()) {
                throw new Exception(errorHandler.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Either schema Location or the XML file location is not specified.");
        }
    }

    public static void validate(File xmlFile, URL schemaLocation) throws Exception {
        XmlSupport.validate(xmlFile.toURL(), schemaLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate(URL xmlLocation, URL schemaLocation) throws Exception {
        if (xmlLocation != null) {
            InputStream inputStream = null;
            try {
                inputStream = xmlLocation.openStream();
                XmlSupport.validate(new StreamSource(inputStream), schemaLocation);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    static class LocalErrorHandler
    implements ErrorHandler {
        private StringBuffer messageBuffer = new StringBuffer();
        private boolean failed;

        public void reset() {
            this.failed = false;
            this.messageBuffer.setLength(0);
        }

        public boolean isFailed() {
            return this.failed;
        }

        public String getMessage() {
            return this.messageBuffer.toString();
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.messageBuffer.append(exception.getMessage()).append('\n');
            this.failed = true;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.messageBuffer.append(exception.getMessage()).append('\n');
            this.failed = true;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.messageBuffer.append(exception.getMessage()).append('\n');
        }
    }
}

