/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ErrorAdvisor;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.html.HTMLToPlainTextConverter;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.resource.StringResourceBundle;

public class DefaultErrorAdvisor
implements ErrorAdvisor {
    private static final Logger logger = Logger.getLogger(DefaultErrorAdvisor.class.getName());
    private Resource stringResource;
    private Map<UIType, ErrorAdvisor> errorAdvisorMap = new HashMap<UIType, ErrorAdvisor>();

    public DefaultErrorAdvisor() {
        this.errorAdvisorMap.put(UIType.GRAPHICAL, new GraphicalErrorAdvisor());
        this.errorAdvisorMap.put(UIType.TEXTUAL, new TextualErrorAdvisor());
        this.errorAdvisorMap.put(UIType.NONE, new SilentErrorAdvisor());
    }

    public Map<UIType, ErrorAdvisor> getErrorAdvisorMap() {
        return this.errorAdvisorMap;
    }

    public void setErrorAdvisorMap(Map<UIType, ErrorAdvisor> errorAdvisorMap) {
        this.errorAdvisorMap = errorAdvisorMap;
    }

    @Override
    public Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages) {
        Application application = Application.getInstance();
        this.stringResource = application.getResource(StringResourceBundle.class.getName());
        UIType uiType = application.getUIType();
        ErrorAdvisor delegate = this.errorAdvisorMap.get((Object)uiType);
        return delegate.advise(observer, errorMessages);
    }

    abstract class AbstractErrorAdvisor
    implements ErrorAdvisor {
        AbstractErrorAdvisor() {
        }

        abstract Advice advise(Object var1, StatusMessages<? extends ErrorMessage> var2, String var3);

        @Override
        public final Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages) {
            String detailedMessage = this.getDetailedMessage(errorMessages);
            Advice advice = this.advise(observer, errorMessages, detailedMessage);
            logger.log(Level.INFO, "Advice is {0}", advice);
            return advice;
        }

        protected String getDetailedMessage(StatusMessages<? extends ErrorMessage> errorMessages) {
            StringWriter buffer = new StringWriter();
            PrintWriter out = new PrintWriter(buffer);
            StringBuffer entryBuffer = new StringBuffer();
            for (ErrorMessage errorMessage : errorMessages) {
                String message = errorMessage.getMessage();
                String details = this.getDetails(errorMessage);
                Level level = errorMessage.getLevel();
                Severity severity = ExceptionManager.getSeverity(level);
                entryBuffer.append(String.format("[%s] %s", new Object[]{severity, message}));
                if (details.length() > 0) {
                    entryBuffer.append('\n').append(details);
                    int lastCharIndex = entryBuffer.length() - 1;
                    if (entryBuffer.charAt(lastCharIndex) == '\n') {
                        entryBuffer.deleteCharAt(lastCharIndex);
                    }
                }
                String detailedMessage = entryBuffer.toString();
                entryBuffer.setLength(0);
                logger.log(level, detailedMessage, errorMessage.getCause());
                out.println(detailedMessage);
            }
            return buffer.toString();
        }

        private String getDetails(ErrorMessage errorMessage) {
            StringBuffer detailsBuffer = new StringBuffer();
            if (errorMessage != null) {
                ErrorInfo errorInfo = errorMessage.getErrorInfo();
                detailsBuffer.append(this.getDetails(errorInfo));
                Throwable cause = errorMessage.getCause();
                if (cause != null) {
                    detailsBuffer.append(this.getStacktraceDetails(cause));
                }
                detailsBuffer.append(this.getExtraDetails(errorInfo));
            }
            return detailsBuffer.toString();
        }

        private String getExtraDetails(ErrorInfo errorInfo) {
            String content;
            ContentType contentType;
            Content extraDetails;
            StringWriter detailsBuffer = new StringWriter();
            if (errorInfo != null && (extraDetails = errorInfo.getExtraDetails()) != null && ((contentType = extraDetails.getContentType()) == ContentType.PLAIN_TEXT || Application.getInstance().getBoolean("ErrorMessage.extraDetails.printHTMLDetails", true)) && (content = extraDetails.getContent()) != null && content.trim().length() > 0) {
                String title = extraDetails.getTitle();
                String string = title = title == null || title.trim().length() == 0 ? DefaultErrorAdvisor.this.stringResource.getString("ErrorMessage.details.titles.extraDetails", "More Details", new Object[0]) : title;
                if (contentType == ContentType.HTML) {
                    content = new HTMLToPlainTextConverter().convert(content);
                }
                PrintWriter out = new PrintWriter(detailsBuffer);
                out.printf("*%S*\n", title);
                out.printf("%s\n", content);
            }
            return detailsBuffer.toString();
        }

        private String getDetails(ErrorInfo errorInfo) {
            String details = "";
            if (errorInfo != null) {
                StringWriter detailsBuffer = new StringWriter();
                PrintWriter out = new PrintWriter(detailsBuffer);
                String cause = errorInfo.getCause();
                String action = errorInfo.getAction();
                if (cause != null && cause.trim().length() > 0) {
                    out.printf("   %S: %s\n", DefaultErrorAdvisor.this.stringResource.getString("ErrorMessage.details.titles.cause", "Cause", new Object[0]), cause);
                }
                if (action != null && action.trim().length() > 0) {
                    out.printf("   %S: %s\n", DefaultErrorAdvisor.this.stringResource.getString("ErrorMessage.details.titles.action", "Action", new Object[0]), action);
                }
                details = detailsBuffer.toString();
            }
            return details;
        }

        private String getStacktraceDetails(Throwable throwable) {
            String details = "";
            if (throwable != null) {
                StringWriter detailsBuffer = new StringWriter();
                PrintWriter out = new PrintWriter(detailsBuffer);
                ArrayList<String> causes = new ArrayList<String>();
                ExceptionManager.enumCauses(throwable, causes);
                if (!causes.isEmpty()) {
                    String title = DefaultErrorAdvisor.this.stringResource.getString("ErrorMessage.details.titles.stackSummary", "Summary", new Object[0]);
                    out.printf("   %S:\n", title);
                    for (String cause : causes) {
                        out.printf("       - %s\n", cause);
                    }
                }
                details = detailsBuffer.toString();
            }
            return details;
        }
    }

    class TextualErrorAdvisor
    extends AbstractErrorAdvisor {
        TextualErrorAdvisor() {
        }

        @Override
        public Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages, String detailedMessage) {
            Advice advice = Advice.CONTINUE;
            return advice;
        }
    }

    class SilentErrorAdvisor
    extends AbstractErrorAdvisor {
        SilentErrorAdvisor() {
        }

        @Override
        public Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages, String detailedMessage) {
            Advice advice = Advice.CONTINUE;
            System.out.print(detailedMessage);
            Level aggregateLevel = errorMessages.getAggregateLevel();
            if (ExceptionManager.getSeverity(aggregateLevel) == Severity.FATAL) {
                advice = Advice.ABORT;
            }
            return advice;
        }
    }

    class GraphicalErrorAdvisor
    extends AbstractErrorAdvisor {
        GraphicalErrorAdvisor() {
        }

        @Override
        public Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages, String detailedMessage) {
            Component owner = observer instanceof Component ? (Component)observer : null;
            return StandardDialog.showErrors(owner, errorMessages);
        }
    }
}

