/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.util.logging.Level;
import oracle.install.commons.util.exception.BaseException;
import oracle.install.commons.util.exception.CommonErrorCode;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;

public class DefaultErrorMessage
implements ErrorMessage {
    private Severity severity;
    private Level level;
    private String message;
    private ErrorInfo errorInfo;
    private Throwable cause;

    public DefaultErrorMessage(String message) {
        this(message, Severity.FATAL);
    }

    public DefaultErrorMessage(String message, Severity severity) {
        this.message = message;
        this.severity = severity == null ? Severity.FATAL : severity;
        this.level = ExceptionManager.getLevel(this.severity);
    }

    public DefaultErrorMessage(Throwable cause) {
        this(cause, null, new Object[0]);
    }

    public DefaultErrorMessage(ErrorCode errorCode, Object ... messageArgs) {
        this(errorCode, null, messageArgs);
    }

    public DefaultErrorMessage(ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        this(null, errorCode, severity, messageArgs);
    }

    public DefaultErrorMessage(Throwable cause, ErrorCode errorCode, Object ... messageArgs) {
        this(cause, errorCode, null, messageArgs);
    }

    public DefaultErrorMessage(Throwable cause, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        if (errorCode != null) {
            String message;
            this.errorInfo = ErrorInfo.getInstance(errorCode, messageArgs);
            this.message = this.errorInfo.getMessage();
            Severity severity2 = this.severity = severity == null ? this.errorInfo.getSeverity() : severity;
            if ((errorCode == CommonErrorCode.UNHANDLED_EXCEPTION || errorCode == CommonErrorCode.UNKNOWN_ERROR) && cause != null && (message = cause.getMessage()) != null) {
                this.message = message;
                this.errorInfo.setMessage(message);
            }
        } else if (cause instanceof BaseException) {
            BaseException e = (BaseException)((Object)cause);
            this.errorInfo = e.getErrorInfo();
            this.message = e.getMessage();
            this.severity = severity != null ? severity : e.getSeverity();
        } else {
            if (cause != null) {
                this.message = cause.getMessage();
                if (this.message == null) {
                    this.message = cause.getClass().getName();
                }
            }
            this.severity = severity != null ? severity : Severity.FATAL;
        }
        this.level = ExceptionManager.getLevel(this.severity);
        this.cause = cause;
    }

    public DefaultErrorMessage(Throwable throwable, Severity severity, ErrorCode errorCode, String hint, String message, Object ... messageArgs) {
        this(throwable, errorCode, severity, messageArgs);
        Content content;
        if (message != null) {
            this.setMessage(message);
        }
        ErrorInfo errorInfo = this.getErrorInfo();
        if (throwable instanceof BaseException && (content = ((BaseException)((Object)throwable)).getErrorInfo().getExtraDetails()) != null) {
            errorInfo.setExtraDetails(content);
        }
        if (errorInfo != null) {
            errorInfo.setHint(hint);
        }
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }
}

