/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.message.grid;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;

public class FixedGridContent
extends Content {
    public static final int DEFAULT_MAX_WIDTH = 80;
    private String[] header;
    private List<List<String>> data;
    private int[] columnWidth;
    private int maxWidth;
    private boolean[] wrap;

    public FixedGridContent(String ... header) {
        if (header.length == 0) {
            throw new IllegalArgumentException();
        }
        this.header = header;
        this.data = new ArrayList<List<String>>();
        this.columnWidth = new int[header.length];
        this.maxWidth = 80;
        this.wrap = new boolean[header.length];
        Arrays.fill(this.wrap, false);
    }

    public FixedGridContent(Map<?, ?> data, String ... header) {
        this(header);
        for (Map.Entry<?, ?> row : data.entrySet()) {
            Object key = row.getKey();
            Object value = row.getValue();
            this.addRow(key == null ? "null" : key.toString(), value == null ? "null" : value.toString());
        }
        this.setWrappable(1, true);
    }

    public void setWrappable(int column, boolean wrappable) {
        this.wrap[column] = wrappable;
    }

    public boolean isWrappable(int column) {
        return this.wrap[column];
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxColumnDataWidth) {
        this.maxWidth = maxColumnDataWidth;
    }

    private void adjustColumnWidth(String ... data) {
        for (int i = 0; i < this.columnWidth.length; ++i) {
            this.columnWidth[i] = Math.max(this.columnWidth[i], data[i].length());
        }
    }

    public void addRow(String ... rowData) {
        if (rowData.length != this.header.length) {
            throw new IllegalArgumentException();
        }
        this.data.add(Arrays.asList(rowData));
        this.adjustColumnWidth(rowData);
    }

    private String truncate(String string, int width) {
        if (string != null) {
            int len = string.length();
            int endIndex = Math.min(len, width);
            string = string.substring(0, endIndex);
            if (endIndex < len) {
                string = string.substring(0, endIndex - 3);
                string = string + "...";
            }
        }
        return string;
    }

    private List<String> slice(String string, int width) {
        ArrayList<String> slices = new ArrayList<String>();
        if (string != null) {
            int beginIndex = 0;
            int endIndex = 0;
            int len = 0;
            do {
                len = string.length();
                endIndex = Math.min(len, beginIndex + width);
                String slice = string.substring(beginIndex, endIndex);
                slices.add(slice);
            } while ((beginIndex = endIndex) < len);
        }
        return slices;
    }

    private String[][] normalize(String[] data, int[] columnWidth) {
        String[][] normalizedData = null;
        int maxSlices = 0;
        ArrayList<List<String>> columnSplitList = new ArrayList<List<String>>();
        for (int i = 0; i < data.length; ++i) {
            String col = data[i];
            int width = columnWidth[i];
            List<String> slices = null;
            slices = this.wrap[i] ? this.slice(col, width) : Arrays.asList(this.truncate(col, width));
            columnSplitList.add(slices);
            maxSlices = Math.max(maxSlices, slices.size());
        }
        int cols = data.length;
        for (Object[] objectArray : normalizedData = new String[maxSlices][cols]) {
            Arrays.fill(objectArray, "");
        }
        for (int i = 0; i < cols; ++i) {
            List slices = (List)columnSplitList.get(i);
            for (int j = 0; j < slices.size(); ++j) {
                normalizedData[j][i] = (String)slices.get(j);
            }
        }
        return normalizedData;
    }

    private int[] normalizeWidths(int[] columnWidths) {
        int totalTextWidth = 0;
        int totalFixedTextWidth = 0;
        for (int i = 0; i < columnWidths.length; ++i) {
            int textWidth = columnWidths[i];
            totalTextWidth += textWidth;
            if (this.wrap[i]) continue;
            totalFixedTextWidth += textWidth;
        }
        int totalPaddingWidth = columnWidths.length * 2 + 1;
        int totalWidth = totalTextWidth + totalPaddingWidth;
        int totalAllowedWidth = Math.min(this.getMaxWidth(), totalWidth) - totalPaddingWidth;
        int totalResizableWidth = totalAllowedWidth - totalFixedTextWidth;
        int totalResizableTextWidth = totalTextWidth - totalFixedTextWidth;
        float[] ratio = new float[columnWidths.length];
        Arrays.fill(ratio, 1.0f);
        if (totalResizableWidth < totalResizableTextWidth) {
            for (int i = 0; i < columnWidths.length; ++i) {
                if (!this.wrap[i]) continue;
                ratio[i] = (float)columnWidths[i] / (float)totalResizableWidth;
            }
        }
        int[] normalizedWidths = new int[columnWidths.length];
        int totalUnallocatedWidth = totalAllowedWidth;
        for (int i = 0; i < normalizedWidths.length; ++i) {
            int normalizedWidth;
            normalizedWidths[i] = normalizedWidth = Math.round(ratio[i] * (float)columnWidths[i]);
            totalUnallocatedWidth -= normalizedWidth;
        }
        int n = columnWidths.length - 1;
        normalizedWidths[n] = normalizedWidths[n] + totalUnallocatedWidth;
        return normalizedWidths;
    }

    public String toString() {
        int[] normalizedColumnWidths = this.normalizeWidths(this.columnWidth);
        int totalWidth = 1;
        StringBuffer dataRowFormat = new StringBuffer();
        for (int colWidth : normalizedColumnWidths) {
            totalWidth += colWidth + 2;
            dataRowFormat.append(" %-").append(colWidth).append("s ");
        }
        dataRowFormat.append("\n");
        char[] sep = new char[totalWidth];
        Arrays.fill(sep, '-');
        String separator = new String(sep);
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        String title = this.getTitle();
        if (title != null && title.trim().length() > 0) {
            out.printf("%s :\n", title);
        }
        out.println(separator);
        out.printf(dataRowFormat.toString(), this.header);
        out.println(separator);
        for (List<String> row : this.data) {
            String[][] normalizedData;
            for (String[] rowData : normalizedData = this.normalize(row.toArray(new String[0]), normalizedColumnWidths)) {
                out.printf(dataRowFormat.toString(), rowData);
            }
            out.flush();
        }
        out.println(separator);
        out.close();
        return buffer.toString();
    }

    @Override
    public String getContent() {
        return this.toString();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.PLAIN_TEXT;
    }

    @Override
    public boolean isContentPreFormated() {
        return true;
    }
}

