/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.UIType;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.driver.oui.SafeLogLocationInputPane;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixTeePrintStream;

public class LogSafetyChecker
implements ApplicationListener {
    private static final Logger logger = Logger.getLogger(LogSafetyChecker.class.getName());
    private static final String SCRATCH_PATH = System.getProperty("oracle.installer.scratchPath");
    private static final char sep = File.separatorChar;
    protected static final Resource resource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);

    @Override
    public void update(ApplicationEvent e) {
        if (e.getType() == ApplicationEvent.Type.SHUTDOWN) {
            File tmpLogFile = null;
            File logFile = null;
            if (OUILogHandler.isDirectLoggingEnabled()) {
                logFile = OUILogHandler.getLogFile();
                if (logFile != null && logFile.exists() && logFile.getPath().startsWith(SCRATCH_PATH)) {
                    tmpLogFile = logFile;
                }
            } else {
                String logFilename = OiiolTextLogger.getCurLogFileName();
                if (logFilename == null) {
                    logFilename = OUILogHandler.getLogFile().getPath();
                }
                if (logFilename != null && (logFile = new File(logFilename)) != null && logFile.exists() && logFile.getPath().startsWith(SCRATCH_PATH)) {
                    tmpLogFile = logFile;
                }
            }
            if (tmpLogFile != null) {
                String log = tmpLogFile.getPath();
                UIType uiType = Application.getInstance().getUIType();
                if (uiType == UIType.GRAPHICAL) {
                    SafeLogLocationInputPane ui = new SafeLogLocationInputPane();
                    String defaultLoc = System.getProperty("user.home", "") + System.getProperty("file.separator", "/") + ".oracle" + System.getProperty("file.separator", "/") + "logs";
                    ui.setSafeLogLocation(defaultLoc);
                    String logLocDesc = resource.getString("INSTALL_MOVE_LOGFILE_DLG_TEXT", "A log of this session is currently saved as: {0}. Oracle recommends that if you want to keep this log, you should move it from the temporary locationn. Specify a new log location.", log);
                    ui.setSafeLogLocDesc(logLocDesc);
                    String title = resource.getString("INSTALL_MOVE_LOGFILE_DLG_TITLE", "Move Log File", new Object[0]);
                    Option opt = StandardDialog.showCustomDialog(null, title, ui.getSafeLogLocationPane(), LogMovePromptOption.MOVE_AND_EXIT, LogMovePromptOption.MOVE_AND_EXIT, LogMovePromptOption.EXIT);
                    if (opt != null && opt == LogMovePromptOption.MOVE_AND_EXIT) {
                        String newLocation = ui.getSafeLogLocation();
                        try {
                            DriverHelper.addCleanupTask(new MoveLogFilesToPermanentLocation(newLocation, tmpLogFile));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            String error = resource.getString("INSTALL_MOVE_LOGFILE_DLG_ERROR", "The installer could not move the log file to the directory you specified.", new Object[0]);
                            logger.log(Level.SEVERE, error, ex);
                            StandardDialog.showError(null, error);
                        }
                    } else {
                        this.recurseDeleteScratchPath(true);
                        this.markScratchPathForDeletion();
                    }
                } else {
                    String message = resource.getString("INSTALL_MOVE_LOGFILE_WARNING", "A log of this session is currently saved as: {0}. Oracle recommends that if you want to keep this log, you should move it from the temporary location.\n", log);
                    logger.warning(message);
                    System.out.println(message);
                    this.recurseDeleteScratchPath(true);
                }
            } else {
                this.moveLogFilesToInventory();
                this.recurseDeleteScratchPath(false);
            }
        }
    }

    private void markScratchPathForDeletion() {
        try {
            DriverHelper.markForDelete(new File(SCRATCH_PATH));
        }
        catch (Exception e1) {
            logger.info("Occured " + e1.getClass() + " while deleting " + SCRATCH_PATH);
            e1.printStackTrace();
        }
    }

    private void moveLogFilesToInventory() {
        String stdErrFile = OiixTeePrintStream.getErrFileLoc();
        String stdOutFile = OiixTeePrintStream.getOutFileLoc();
        if (stdErrFile.startsWith(SCRATCH_PATH) || stdOutFile.startsWith(SCRATCH_PATH)) {
            DriverHelper.addCleanupTask(new MoveFilesToInventory());
        }
    }

    private void recurseDeleteScratchPath(boolean preserveLogs) {
        File scratch_dir = new File(SCRATCH_PATH);
        String[] files = scratch_dir.list();
        boolean doDelete = true;
        boolean deleteScratchPath = true;
        if (files != null) {
            for (String thisFile : files) {
                if (preserveLogs) {
                    boolean bl = doDelete = !thisFile.endsWith(".log") && !thisFile.endsWith(".err") && !thisFile.endsWith(".out");
                }
                if (doDelete) {
                    OiicExitOps.getExitOps().addDelDir(SCRATCH_PATH + sep + thisFile);
                    continue;
                }
                deleteScratchPath = false;
            }
            if (deleteScratchPath) {
                OiicExitOps.getExitOps().addDelDir(SCRATCH_PATH);
            }
        }
    }

    private class MoveLogFilesToPermanentLocation
    implements Callable<Void> {
        private String newLocation;
        private File tmpLogFile;

        MoveLogFilesToPermanentLocation(String newLocation, File tmpLogFile) {
            this.newLocation = newLocation;
            this.tmpLogFile = tmpLogFile;
        }

        @Override
        public Void call() throws Exception {
            File newLogFile = new File(this.newLocation + sep + this.tmpLogFile.getName());
            FileSystem.copy(this.tmpLogFile, newLogFile);
            File logDestDir = newLogFile.getParentFile();
            String stdErrFile = OiixTeePrintStream.getErrFileLoc();
            File stdErr = new File(stdErrFile);
            if (stdErrFile.startsWith(SCRATCH_PATH)) {
                FileSystem.copy(stdErr, new File(logDestDir, stdErr.getName()));
            }
            String stdOutFile = OiixTeePrintStream.getOutFileLoc();
            File stdOut = new File(stdOutFile);
            if (stdOutFile.startsWith(SCRATCH_PATH)) {
                FileSystem.copy(stdOut, new File(logDestDir, stdOut.getName()));
            }
            LogSafetyChecker.this.recurseDeleteScratchPath(false);
            return null;
        }
    }

    private class MoveFilesToInventory
    implements Callable<Void> {
        private MoveFilesToInventory() {
        }

        @Override
        public Void call() throws Exception {
            this.handleFile(OiixTeePrintStream.getErrFileLoc());
            this.handleFile(OiixTeePrintStream.getOutFileLoc());
            return null;
        }

        private void handleFile(String logFile) {
            if (!logFile.startsWith(SCRATCH_PATH)) {
                return;
            }
            String invLoc = InventoryInfo.getInstance().getDefaultInventoryLoc();
            File log = new File(logFile);
            File inventorylogFile = new File(invLoc + sep + "logs" + sep + log.getName());
            if (!inventorylogFile.exists()) {
                logger.info("copying log file " + log + " into " + inventorylogFile);
                FileSystem.copy(log, inventorylogFile);
            }
        }
    }

    public static enum LogMovePromptOption implements Option
    {
        MOVE_AND_EXIT,
        EXIT;


        @Override
        public String toString() {
            return resource.getString(this, new Object[0]);
        }

        @Override
        public int toInt() {
            return this.ordinal();
        }
    }
}

