/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.InstallEngineErrorCode;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.ScriptExecutor;
import oracle.install.commons.bean.OracleCloneBean;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.RootScriptJob;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.resource.OUIErrorCode;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiix.OiixGeneralQueries;
import oracle.sysman.oii.oiix.OiixNetOps;

public class OUICloneDriver
extends OUISetupDriver<OracleCloneBean> {
    public static final String PROPERTY_PROXY_MAPPINGS = "oracle.install.driver.oui.proxyMappings";
    public static final String ORAINST_ROOT_SCRIPT_FILE = "orainstRoot.sh";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    private static Logger logger = Logger.getLogger(OUICloneDriver.class.getName());
    private Resource stringResource;

    public OUICloneDriver() {
        this.setupBean = new OracleCloneBean();
        this.stringResource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
    }

    @Override
    public void load() throws SetupDriverException {
        super.load();
        OUILogHandler.setDirectLoggingEnabled(true);
        logger.log(Level.INFO, "Entering OUICloneDriver.load() method...");
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        int returnCodeInvCheck = -1;
        try {
            returnCodeInvCheck = apiInstaller.initInstallEnvironment(this.properties, true, 3);
        }
        catch (OiicIllegalStateException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        catch (OiicInstallAPIException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        catch (Throwable t) {
            throw new SetupDriverException(t, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        if (returnCodeInvCheck == 1001 && !OiiiInstallAreaControl.isCleanMachine()) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.INVENTORY_INIT_FAILED, new Object[0]);
        }
        if (!PlatformInfo.getInstance().isWindows() && !Boolean.getBoolean("oracle.install.skipInventoryGroupCheck") && InventoryInfo.getInstance().isInventoryExist() && (InventoryInfo.getInstance().getUnixGroupName() == null || InventoryInfo.getInstance().getUnixGroupName().isEmpty())) {
            throw new SetupDriverException((ErrorCode)OUIErrorCode.NO_INVENTORY_GROUP_PRESENT_ORAINST_LOC_FILE, new Object[0]);
        }
    }

    @Override
    protected HashMap constructAdditionalProperties(HashMap hashMap) throws SetupDriverException {
        super.constructAdditionalProperties(hashMap);
        String oracle_home = hashMap.get("ORACLE_HOME").toString();
        File readmeLoc = new File(oracle_home, "install/readme.txt");
        hashMap.put("readme.exist", readmeLoc.exists());
        int j = 0;
        List<String> args = Application.getInstance().getArguments();
        Iterator<String> it = args.iterator();
        Iterator<String> it1 = args.iterator();
        boolean isOracleHomeName = false;
        boolean isSecure = false;
        while (it.hasNext()) {
            String value = it.next();
            if (!value.contains("ORACLE_HOME_NAME")) continue;
            isOracleHomeName = true;
            break;
        }
        int k = 0;
        if (PlatformInfo.getInstance().isWindows()) {
            if (Application.isCommandLineSwitchEnabled("-secure")) {
                while (it1.hasNext()) {
                    String key = it1.next();
                    if (!key.contains("ORACLE_HOME_USER")) continue;
                    isSecure = true;
                    k = key.indexOf("=");
                    String value = key.substring(k + 1);
                    hashMap.put("oracle_install_IsBuiltInAccount", FALSE);
                    hashMap.put("oracle_install_OracleHomeUserName", value);
                    break;
                }
                if (!isSecure) {
                    System.out.println(this.stringResource.getString("clone.secure.flag.error.msessage.windows", "-secure flag should always be used in conjunction with ORACLE_SERVICE_USER", new Object[0]));
                    logger.log(Level.SEVERE, this.stringResource.getString("clone.secure.flag.error.msessage.windows", "-secure flag should always be used in conjunction with ORACLE_SERVICE_USER", new Object[0]));
                    Application.getInstance().shutdown(OUIExitStatus.VAR_VALIDATION_FAILURE);
                }
            } else {
                hashMap.put("oracle_install_IsBuiltInAccount", TRUE);
            }
        }
        if (!isOracleHomeName) {
            String oracleHomeName = InventoryInfo.getInstance().computeOracleHomeName(oracle_home);
            hashMap.put("ORACLE_HOME_NAME", oracleHomeName);
        }
        for (int i = 0; i < args.size(); ++i) {
            j = args.get(i).indexOf("=");
            if (j == -1) continue;
            String key = args.get(i).substring(0, j);
            String value = args.get(i).substring(j + 1);
            if (key.equalsIgnoreCase("CLUSTER_NODES")) {
                if (value == null || value.length() <= 0) continue;
                value = value.substring(1, value.length() - 1).replaceAll(" ", "");
                ArrayList<String> nodesList = new ArrayList<String>(Arrays.asList(value.split(",")));
                String localNodeName = OiixNetOps.getMachineName((String)PlatformInfo.getInstance().getFullHostName());
                for (String node : nodesList) {
                    if (!node.toLowerCase().contains(localNodeName.toLowerCase())) continue;
                    nodesList.remove(node);
                    nodesList.add(0, node);
                    break;
                }
                value = ((Object)nodesList).toString().substring(1, ((Object)nodesList).toString().length() - 1);
                hashMap.put("CLUSTER_NODES", value);
                OiixGeneralQueries.setClusterON();
                continue;
            }
            hashMap.put(key, value);
        }
        return hashMap;
    }

    @Override
    protected CompositeJob prepareJob() throws SetupDriverException {
        CompositeJob compositeJob = new CompositeJob();
        SetupJob cloneJob = new SetupJob((Object)"Clone", "Oracle Cloning", 0.95f, this.getCloneDetails(), SetupJob.OUISetupMode.CLONE);
        compositeJob.add(cloneJob);
        if (!PlatformInfo.getInstance().isWindows() && !Application.isCommandLineSwitchEnabled("-suppressRootMessage")) {
            logger.log(Level.INFO, "Adding root script.");
            compositeJob.add(new RootScriptJob(cloneJob));
        }
        return compositeJob;
    }

    protected SessionDetails getCloneDetails() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int j = 0;
        List<String> args = Application.getInstance().getArguments();
        for (int i = 0; i < args.size(); ++i) {
            j = args.get(i).indexOf("=");
            if (j == -1) continue;
            String key = args.get(i).substring(0, j);
            String value = args.get(i).substring(j + 1);
            hashMap.put(key, value);
            if (!key.equals("oracle_install_OSASM")) continue;
            hashMap.put("oracle_install_OSBKP", value);
            hashMap.put("oracle_install_OSDGD", value);
            hashMap.put("oracle_install_OSKMT", value);
        }
        SessionDetails sessionDetails = new SessionDetails("session", hashMap);
        return sessionDetails;
    }

    @Override
    protected ScriptExecutor<?> getRootScriptExecutor() {
        return null;
    }

    @Override
    public void processCommandLine(String ... args) {
        if (!Application.isCommandLineSwitchEnabled("-help")) {
            this.validateArguments(args);
        }
        super.processCommandLine(args);
    }

    public void validateArguments(String ... args) {
        HashMap<String, String> commandLineArgsMap = new HashMap<String, String>();
        List<String> argList = Arrays.asList(args);
        for (String argument : argList) {
            String[] parameter;
            if (argument.indexOf("=") <= 0 || (parameter = argument.split("=")) == null || parameter.length != 2) continue;
            commandLineArgsMap.put(parameter[0], parameter[1]);
        }
        String oracleHome = (String)commandLineArgsMap.get("ORACLE_HOME");
        String oracleBase = (String)commandLineArgsMap.get("ORACLE_BASE");
        if (oracleHome == null || oracleHome.length() == 0) {
            throw new IllegalArgumentException(new ValidationStatusMessage((ErrorCode)OUIErrorCode.CLONE_ORACLE_HOME_NOT_PASSED, new Object[0]).getMessage());
        }
        if (oracleBase == null || oracleBase.length() == 0) {
            throw new IllegalArgumentException(new ValidationStatusMessage((ErrorCode)OUIErrorCode.CLONE_ORACLE_BASE_NOT_PASSED, new Object[0]).getMessage());
        }
    }
}

