/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class OUILogFormatter
extends Formatter {
    public static boolean PRINT_TIME = Boolean.getBoolean("oracle.installer.printtime") || Boolean.getBoolean("oracle.installer.printtimeverbose");
    MessageFormat formater = new MessageFormat("{0,date} {0,time}");
    Date dat = new Date();

    @Override
    public String format(LogRecord logRecord) {
        Level level = logRecord.getLevel();
        String message = this.formatMessage(logRecord);
        StringBuffer buffer = new StringBuffer();
        this.dat.setTime(logRecord.getMillis());
        if (message != null) {
            buffer.append(message);
            if (level.getName().startsWith(Level.FINE.getName())) {
                buffer.insert(0, ':');
                buffer.insert(0, logRecord.getLoggerName());
            }
        }
        if (PRINT_TIME) {
            StringBuffer text = new StringBuffer();
            this.formater.format(new Object[]{this.dat}, text, (FieldPosition)null);
            buffer.insert(0, " [" + text + "] ");
        }
        return buffer.toString();
    }
}

