/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.InstallEngineErrorCode;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.oui.OUICommandHelper;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.resource.OUIErrorCode;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;

public abstract class OUINodeScalerDriver<T>
extends OUISetupDriver<T> {
    private static Logger logger = Logger.getLogger(OUINodeScalerDriver.class.getName());

    public OUINodeScalerDriver() {
        OUICommandHelper.setMode(SetupJob.OUISetupMode.ADDNODE);
    }

    @Override
    public void load() throws SetupDriverException {
        super.load();
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        int exitStatus = 0;
        try {
            exitStatus = apiInstaller.initInstallEnvironment(this.properties, false, 4);
        }
        catch (OiicIllegalStateException e) {
            logger.log(Level.INFO, "Excpetion while initializing add node mode", e);
        }
        catch (OiicInstallAPIException e) {
            logger.log(Level.INFO, "Exception while initializing add node mode", e);
        }
        OUILogHandler.setDirectLoggingEnabled(true);
        if (exitStatus == 1001 && !OiiiInstallAreaControl.isCleanMachine()) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.INVENTORY_INIT_FAILED, new Object[0]);
        }
        if (!PlatformInfo.getInstance().isWindows() && !Boolean.getBoolean("oracle.install.skipInventoryGroupCheck") && InventoryInfo.getInstance().isInventoryExist() && (InventoryInfo.getInstance().getUnixGroupName() == null || InventoryInfo.getInstance().getUnixGroupName().isEmpty())) {
            throw new SetupDriverException((ErrorCode)OUIErrorCode.NO_INVENTORY_GROUP_PRESENT_ORAINST_LOC_FILE, new Object[0]);
        }
    }
}

