/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.EmptyStackException;
import java.util.Stack;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.ApplicationProgressEvent;
import oracle.install.commons.util.ApplicationProgressListener;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixDebug;

public class OUITimeLogHandler
implements ApplicationProgressListener {
    private static File timeLog;
    private static PrintWriter logWriter;
    private Stack<EventDetails> eventStack = new Stack();
    public static String DELIM;
    private boolean directLogEnabled = true;
    private static OUITimeLogHandler instance;

    public static OUITimeLogHandler getInstanse() {
        if (instance == null) {
            instance = new OUITimeLogHandler();
        }
        return instance;
    }

    public void setDirectLogingEnabled(boolean enabled) {
        this.directLogEnabled = enabled;
        if (!enabled && logWriter != null) {
            logWriter.close();
            logWriter = null;
        }
    }

    protected OUITimeLogHandler() {
        Application.getInstance().addApplicationListener(new ApplicationListener(){

            @Override
            public void update(ApplicationEvent e) {
                if (e.getType() == ApplicationEvent.Type.SHUTDOWN) {
                    if (logWriter != null) {
                        logWriter.flush();
                        logWriter.close();
                    }
                    OUITimeLogHandler.this.eventStack.clear();
                    OUITimeLogHandler.this.eventStack = null;
                }
            }
        });
    }

    public void setLogLocation(String logDir) {
        if (logDir != null && logDir.length() > 0) {
            try {
                timeLog = new File(logDir, "time" + OiiolLoggerUtil.getTimeStamp() + ".log");
            }
            catch (Exception e) {}
        } else {
            String logFileLoc = OiiolTextLogger.getTimeLogFileName();
            if (logFileLoc != null) {
                timeLog = new File(logFileLoc);
            }
        }
        if (timeLog != null) {
            try {
                if (logWriter != null) {
                    logWriter.close();
                }
                logWriter = new PrintWriter(new BufferedWriter(new FileWriter(timeLog, true)));
                logWriter.println(DELIM + "Message" + DELIM + "ElapsedTime" + DELIM + "Current Time ( ms )");
                logWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void update(ApplicationProgressEvent e) {
        switch ((ApplicationProgressEvent.Type)e.getType()) {
            case START: {
                this.eventStack.push(new EventDetails(e.getId(), System.currentTimeMillis()));
                if (!this.directLogEnabled) {
                    OiixDebug.printTimeMsg((String)e.getMessage(), (long)0L);
                    break;
                }
                if (logWriter == null) break;
                logWriter.println(DELIM + e.getMessage() + DELIM + " 0 " + DELIM + System.currentTimeMillis());
                logWriter.flush();
                break;
            }
            case END: {
                try {
                    EventDetails eventDetails = this.eventStack.pop();
                    while (!eventDetails.getId().equals(e.getId())) {
                        eventDetails = this.eventStack.pop();
                    }
                    if (eventDetails == null) break;
                    if (!this.directLogEnabled) {
                        OiixDebug.printTimeMsg((String)e.getMessage(), (long)(System.currentTimeMillis() - eventDetails.getTimeInMili()));
                        break;
                    }
                    if (logWriter == null) break;
                    logWriter.println(DELIM + e.getMessage() + DELIM + (System.currentTimeMillis() - eventDetails.getTimeInMili()) + DELIM + System.currentTimeMillis());
                    logWriter.flush();
                    break;
                }
                catch (EmptyStackException emp) {
                    return;
                }
            }
        }
    }

    static {
        DELIM = " # ";
    }

    class EventDetails {
        private String id;
        private Long timeInMili;

        public EventDetails(String id, Long timeInMilis) {
            this.id = id;
            this.timeInMili = timeInMilis;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Long getTimeInMili() {
            return this.timeInMili;
        }

        public void setTimeInMili(Long timeInMili) {
            this.timeInMili = timeInMili;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof EventDetails) {
                return this.id.equals(((EventDetails)arg0).getId());
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

