/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.driver.oui.InventoryInfo;
import oracle.sysman.oii.oiii.OiiiClusterInstallInventory;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;

public class RemoteInventoryInfo {
    private List<String> remoteHomes;
    private String node;
    private String inventoryLocation;
    private static OiiiClusterInstallInventory oClusterInstInv = new OiiiClusterInstallInventory();
    private static OiipgClusterInvSetup oClusterInvSetup;
    private static Map<String, RemoteInventoryInfo> instances;

    public static RemoteInventoryInfo getInstance(String node) {
        return RemoteInventoryInfo.getInstance(node, false);
    }

    public static RemoteInventoryInfo getInstance(String node, boolean reload) {
        if (instances == null) {
            instances = new HashMap<String, RemoteInventoryInfo>();
        }
        if (!reload) {
            for (Map.Entry<String, RemoteInventoryInfo> instance : instances.entrySet()) {
                if (!instance.getKey().equalsIgnoreCase(node)) continue;
                return instance.getValue();
            }
        }
        RemoteInventoryInfo newinstance = new RemoteInventoryInfo(node);
        if (instances.containsKey(node.toLowerCase())) {
            instances.remove(node);
        }
        instances.put(node.toLowerCase(), newinstance);
        return newinstance;
    }

    private RemoteInventoryInfo(String node) {
        if (!PlatformInfo.getInstance().isWindows()) {
            System.setProperty("oracle.installer.invPtrLoc", OiipgPropertyLoader.getUnixPtrFileLoc());
        }
        this.node = node;
        this.remoteHomes = oClusterInstInv.getHomes(node);
        this.inventoryLocation = OiipgClusterInvSetup.getInventoryLocationOnNode((String)node);
    }

    public boolean isHomeWithLocationExist(String home) {
        if (this.remoteHomes != null) {
            for (int i = 0; i < this.remoteHomes.size(); ++i) {
                if (!(PlatformInfo.getInstance().isWindows() ? this.remoteHomes.get(i).equalsIgnoreCase(home) : this.remoteHomes.get(i).equals(home))) continue;
                return true;
            }
        }
        return false;
    }

    public OiiiRemoteHome getRemoteHomeInfoObj(String home) {
        if (this.isHomeWithLocationExist(home)) {
            return oClusterInstInv.getRemoteHome(this.node, home);
        }
        return null;
    }

    public boolean compareToLocalHome(String homeLoc, String node) {
        return InventoryInfo.getInstance().findAndCompareToLocalHome(RemoteInventoryInfo.getInstance(node).getRemoteHomeInfoObj(homeLoc));
    }

    public List<String> getNodesWithSameHome(String[] nodes, String oracleHome) {
        ArrayList<String> nodesWithSameHome = new ArrayList<String>();
        if (this.remoteHomes.contains(oracleHome)) {
            for (String node : nodes) {
                if (!RemoteInventoryInfo.getInstance(node).isHomeWithLocationExist(oracleHome)) continue;
                nodesWithSameHome.add(node);
            }
        }
        return nodesWithSameHome;
    }

    public boolean isInventoryExists() {
        return this.inventoryLocation != null && !this.inventoryLocation.isEmpty();
    }
}

