/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.util.logging.Level;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.DefaultProgressMonitor;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Status;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixProgressListener;

public class SessionInitProgressMonitor
extends DefaultProgressMonitor
implements OiixProgressListener {
    private long bytes;
    private long totalBytes;
    private boolean enable;

    public SessionInitProgressMonitor() {
    }

    public SessionInitProgressMonitor(CompositeJob compositeJob, ProgressUI progressUI) {
        super(compositeJob, progressUI);
    }

    public void addBytes(int bytes) {
        this.bytes += (long)bytes;
        if (this.enable) {
            super.setProgress((float)((double)this.bytes / (double)this.totalBytes));
        }
    }

    public void addPercentage(int percent) {
    }

    public void onDoneProgress() {
        Job task = super.getActiveJob();
        if (task != null) {
            task.setStatus(Status.SUCCEEDED);
            String currentLogFileName = OiiolTextLogger.getCurLogFileName();
            if (currentLogFileName != null) {
                LogManager.getInstance().setDefaultLogFile(new File(currentLogFileName));
            }
            super.getProgressUI().setLogLocation(OiiolTextLogger.getCurLogFileName());
        }
    }

    public void removeBytes(int bytes) {
    }

    public void setStatus(String status) {
        super.log(Level.INFO, status, new Object[0]);
    }

    public void setTitle(String title) {
    }

    public void setTotalBytes(long bytes) {
        this.totalBytes = bytes;
        Job task = super.nextJob();
        if (task != null) {
            this.enable = true;
            task.setStatus(Status.INPROGRESS);
        } else {
            this.enable = false;
        }
    }
}

