/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.InstallEngineErrorCode;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.resource.StringResourceBundle;
import oracle.sysman.oii.oiic.OiicUpdateNodeListEx;

public class UpdateNodelistJob
extends CompositeJob
implements Callable<Void>,
Retriable<Job> {
    private static final Logger logger = Logger.getLogger(UpdateNodelistJob.class.getName());
    Map<List<String>, List<String>> hostsNodelistMap;
    String oracleHome;
    String localHost;
    boolean isCRS;
    boolean isShared;
    boolean isLocal;
    boolean doNotUpdateNodeList;
    ErrorMessage message;

    public UpdateNodelistJob(String oracleHome, String localHost, boolean isCRS) {
        this(oracleHome, localHost, isCRS, false, false);
    }

    public UpdateNodelistJob(String oracleHome, String localHost, boolean isCRS, boolean isShared) {
        this(oracleHome, localHost, isCRS, isShared, false);
    }

    public UpdateNodelistJob(String oracleHome, String localHost, boolean isCRS, boolean isShared, boolean isLocal) {
        super("updatenodelist", null, 0.1f);
        this.setDescription(Application.getInstance().getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "updateNodelistJob.text"), "Inventory Update", new Object[0]));
        this.setRetryEnabled(true);
        this.setRequired(true);
        this.setRetriable(this);
        this.oracleHome = oracleHome;
        this.localHost = localHost;
        this.isCRS = isCRS;
        this.isShared = isShared;
        this.isLocal = isLocal;
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void call(boolean retry) throws Exception {
        this.setStatus(Status.INPROGRESS);
        boolean succeeded = true;
        List failedNodesList = null;
        HashMap failedNodesCommandMap = null;
        String propOUILoc = System.getProperty("oracle.installer.oui_loc");
        String propJRELoc = System.getProperty("oracle.installer.jre_loc");
        if (this.hostsNodelistMap != null && this.hostsNodelistMap.size() > 0) {
            try {
                System.setProperty("oracle.installer.doNotUpdateNodeList", Boolean.toString(this.getDoNotUpdateNodeList()));
                String sOracleHomeForAPI = this.getOracleHomeForAPI();
                File fOUILoc = new File(sOracleHomeForAPI, "oui");
                File fJDKLoc = new File(sOracleHomeForAPI, "jdk");
                File fJRELoc = new File(fJDKLoc.getAbsolutePath(), "jre");
                System.setProperty("oracle.installer.oui_loc", fOUILoc.getAbsolutePath());
                System.setProperty("oracle.installer.jre_loc", fJRELoc.getAbsolutePath());
                OiicUpdateNodeListEx o = OiicUpdateNodeListEx.getOiicUpdateNodeListExInstance();
                logger.log(Level.INFO, "UpdateNodelist data:");
                logger.log(Level.INFO, String.format("oracle.installer.oui_loc:%s", System.getProperty("oracle.installer.oui_loc")));
                logger.log(Level.INFO, String.format("oracle.installer.jre_loc:%s", System.getProperty("oracle.installer.jre_loc")));
                logger.log(Level.INFO, String.format("oracle.installer.doNotUpdateNodeList:%s", System.getProperty("oracle.installer.doNotUpdateNodeList")));
                logger.log(Level.INFO, String.format("OracleHomeToUpdate:%s;isCRS:%s;isCFS:%s;isLocal:%s", this.oracleHome, this.isCRS, this.isShared, this.isLocal));
                for (Map.Entry<List<String>, List<String>> e : this.hostsNodelistMap.entrySet()) {
                    logger.log(Level.INFO, String.format("From map: Hosts:%s => Nodelist:%s", e.getKey(), e.getValue()));
                    ArrayList<String> slHosts = new ArrayList<String>((Collection)e.getKey());
                    boolean bUpdateLocalNode = true;
                    if (slHosts != null) {
                        if (!StringUtils.containsIgnoreCase(slHosts, this.localHost)) {
                            bUpdateLocalNode = false;
                            slHosts.add(0, this.localHost);
                            logger.log(Level.INFO, "Adding local node to hostlist, but will not be updated");
                        } else if (!slHosts.get(0).equalsIgnoreCase(this.localHost)) {
                            Collections.swap(slHosts, 0, StringUtils.indexOfIgnoreCase(slHosts, this.localHost));
                        }
                    }
                    String[] nodesWhereUpdate = slHosts.toArray(new String[0]);
                    String[] hostsToUpdate = e.getValue() != null ? e.getValue().toArray(new String[0]) : new String[]{};
                    logger.log(Level.INFO, String.format("Before calling api: Hosts:%s => Nodelist:%s, update localnode? %b", slHosts, e.getValue(), bUpdateLocalNode));
                    failedNodesList = o.updateNodeListEx(hostsToUpdate, nodesWhereUpdate, this.oracleHome, this.isCRS, this.isShared, this.isLocal, bUpdateLocalNode);
                    if (failedNodesList == null || failedNodesList.isEmpty()) continue;
                    succeeded = false;
                    if (failedNodesCommandMap == null) {
                        failedNodesCommandMap = new HashMap();
                    }
                    failedNodesCommandMap.put(new ArrayList(failedNodesList), this.getUpdateNodelistCmd(hostsToUpdate, this.oracleHome, this.isCRS, this.isShared));
                    failedNodesList.clear();
                }
                System.setProperty("oracle.installer.oui_loc", propOUILoc == null ? "" : propOUILoc);
            }
            catch (Exception e) {
                try {
                    succeeded = false;
                    logger.log(Level.INFO, "Update nodelist failed", e);
                    System.setProperty("oracle.installer.oui_loc", propOUILoc == null ? "" : propOUILoc);
                }
                catch (Throwable throwable) {
                    System.setProperty("oracle.installer.oui_loc", propOUILoc == null ? "" : propOUILoc);
                    System.setProperty("oracle.installer.jre_loc", propJRELoc == null ? "" : propJRELoc);
                    throw throwable;
                }
                System.setProperty("oracle.installer.jre_loc", propJRELoc == null ? "" : propJRELoc);
            }
            System.setProperty("oracle.installer.jre_loc", propJRELoc == null ? "" : propJRELoc);
        }
        if (succeeded) {
            this.setStatus(Status.SUCCEEDED);
        } else {
            this.message = new DefaultErrorMessage((ErrorCode)InstallEngineErrorCode.UPDATENODELIST_FAILED, new Object[0]);
            PlainContent extraDetails = new PlainContent();
            if (failedNodesCommandMap != null && !failedNodesCommandMap.isEmpty()) {
                StringBuilder s = new StringBuilder();
                for (Map.Entry e : failedNodesCommandMap.entrySet()) {
                    Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
                    s.append(resource.getString("UpdateNodelistJob.ErrorContentMsg", "\nExecute the following command on node(s) {0}:\n{1}\n", e.getKey(), e.getValue()));
                }
                extraDetails.setContent(s.toString());
            }
            this.message.getErrorInfo().setExtraDetails(extraDetails);
            Advice advice = ExceptionManager.advise(this.message);
            if (advice == Advice.CONTINUE) {
                this.setStatus(Status.SUCCEEDED);
            } else {
                this.setStatus(Status.FAILED);
            }
        }
    }

    private String getUpdateNodelistCmd(String[] hostsToUpdate, String sOracleHome, boolean bIsCRS, boolean bIsShared) {
        String ouiExec = PlatformInfo.getInstance().isWindows() ? "%s\\oui\\bin\\setup.exe" : "%s/oui/bin/runInstaller";
        ouiExec = String.format(ouiExec, sOracleHome);
        String args = "-jreLoc %1$s%3$sjdk%3$sjre -paramFile %1$s%3$soui%3$sclusterparam.ini -silent -ignoreSysPrereqs -updateNodeList -bigCluster ORACLE_HOME=%1$s CLUSTER_NODES=<Local Node> \"NODES_TO_SET={%2$s}\" -invPtrLoc \"%1$s%3$soraInst.loc\" -local";
        StringBuilder shosts = new StringBuilder();
        for (String s : hostsToUpdate) {
            shosts.append(s);
            shosts.append(",");
        }
        if (shosts.length() > 0) {
            shosts.deleteCharAt(shosts.length() - 1);
        }
        args = String.format(args, sOracleHome, shosts.toString(), File.separator);
        String crsArg = bIsCRS ? "CRS=true" : "";
        String cfsArg = bIsShared ? "-cfs" : "";
        String doNotUpdateNodelistArg = Boolean.getBoolean("oracle.installer.doNotUpdateNodeList") ? "-doNotUpdateNodeList" : "";
        StringBuilder cmd = new StringBuilder();
        cmd.append(ouiExec);
        cmd.append(" ");
        cmd.append(args);
        cmd.append(" ");
        cmd.append(crsArg);
        cmd.append(" ");
        cmd.append(cfsArg);
        cmd.append(" ");
        cmd.append(doNotUpdateNodelistArg);
        return cmd.toString();
    }

    @Override
    public void retry() throws Exception {
        this.call(true);
    }

    @Override
    public Void call() throws Exception {
        this.call(false);
        return null;
    }

    public void setHostsNodelistMap(Map<List<String>, List<String>> hostsNodelistMap) {
        this.hostsNodelistMap = hostsNodelistMap;
    }

    public void setDoNotUpdateNodeList(boolean val) {
        this.doNotUpdateNodeList = val;
    }

    private boolean getDoNotUpdateNodeList() {
        return this.doNotUpdateNodeList;
    }

    protected String getOracleHomeForAPI() {
        return this.oracleHome;
    }

    @Override
    public List<Job> getRetriableJobs() {
        ArrayList<Job> retriableJobs = new ArrayList<Job>();
        List<Job> jobList = this.getJobs();
        if (jobList.size() > 0) {
            for (Job job : jobList) {
                Status status = job.getStatus();
                if (!job.isRetryEnabled() || status != Status.PENDING && status != Status.FAILED) continue;
                logger.log(Level.INFO, "Selecting job named ''{0}'' for retry", job.getDescription());
                retriableJobs.add(job);
            }
        } else {
            Status status = this.getStatus();
            if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
                retriableJobs.add(this);
            }
        }
        return retriableJobs;
    }

    public String getLocalHost() {
        return this.localHost;
    }
}

