/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.base.util.OracleServiceRegistry;
import oracle.install.commons.util.Version;
import oracle.sysman.oii.oiix.OiixServiceOps;

class WinOracleServiceRegistry
extends OracleServiceRegistry {
    private static final Logger logger = Logger.getLogger(WinOracleServiceRegistry.class.getName());

    WinOracleServiceRegistry() {
    }

    @Override
    public List<OracleService> getServices() {
        ArrayList<OracleService> servicesList = null;
        try {
            Object[] services = OiixServiceOps.getAllOracleServices();
            OracleService s = null;
            servicesList = new ArrayList<OracleService>();
            for (Object serv : services) {
                String oracleHome = this.getOracleHome(OiixServiceOps.getServiceExeName((String)serv.toString()));
                boolean autoStartEnabled = false;
                int autoStartType = OiixServiceOps.getServiceStartType((String)serv.toString());
                if (autoStartType == 2) {
                    autoStartEnabled = true;
                }
                s = new OracleService(serv.toString(), new File(oracleHome), Version.UNKNOWN, autoStartEnabled);
                servicesList.add(s);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Error while getting the services list", e.getMessage());
        }
        return servicesList;
    }

    private String getOracleHome(String serviceName) {
        String oraHome = null;
        if (serviceName != null) {
            if (serviceName.contains("bin")) {
                String[] arr = serviceName.split("bin");
                oraHome = arr[0].substring(0, arr[0].length() - 1);
            } else {
                oraHome = new File(serviceName).getParent();
            }
        }
        return oraHome;
    }
}

