/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.config;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.LogStream;
import oracle.install.driver.oui.config.ConfigAssistantParams;
import oracle.install.driver.oui.config.ConfigClientListener;
import oracle.sysman.emCfg.client.CfwClient;
import oracle.sysman.emCfg.client.CfwProgressMonitor;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.IAction;
import oracle.sysman.emCfg.common.IActionReference;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IPlugIn;
import oracle.sysman.emCfg.common.IPlugInInvocationState;
import oracle.sysman.emCfg.common.IPlugInReference;
import oracle.sysman.emCfg.common.IProgressMonitor;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.MicroStepStatus;

public class ConfigClient {
    private String m_sOracleHome;
    private String m_sInventoryLoc = File.separator + "inventory" + File.separator + "ContentsXML" + File.separator + "ConfigXML";
    private String m_sTopCompAggId;
    private CfwSession m_oCfwSession;
    private List m_lAggregateList;
    private CfwClient m_oCfwClient;
    private IAggregate[] m_oAggregate;
    private IAggregateReference[] m_oAggregateRef;
    private boolean m_bDebug = true;
    private Vector<IAction> m_vActionList = new Vector();
    private String logDirectory = "";
    private static ConfigClient configClientInstance = null;
    private Logger logger = Logger.getLogger(ConfigClient.class.getName());
    private Set<ConfigClientListener> listeners;
    private boolean isAnyConfigToolFailed = false;
    private Map<String, ConfigAssistantParams> configAssistantParams;

    private ConfigClient() {
        configClientInstance = this;
        this.listeners = new HashSet<ConfigClientListener>();
        this.configAssistantParams = new HashMap<String, ConfigAssistantParams>();
        this.logger.setLevel(Level.INFO);
    }

    public static ConfigClient getConfigClient() {
        if (configClientInstance == null) {
            new ConfigClient();
        }
        return configClientInstance;
    }

    public ConfigAssistantParams getConfigAssistantParams(String name) {
        return this.configAssistantParams.get(name);
    }

    public void addConfigAssistantParams(ConfigAssistantParams params) {
        this.configAssistantParams.put(params.getAssistantName(), params);
    }

    public void removeConfigAssistantParams(String name) {
        this.configAssistantParams.remove(name);
    }

    public void addConfigClientListener(ConfigClientListener listener) {
        this.listeners.add(listener);
    }

    public void removeConfigClientListener(ConfigClientListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireConfigSessionInitialized() {
        this.logger.info("Calling event ConfigSessionInitialized");
        for (ConfigClientListener listener : this.listeners) {
            listener.configSessionInitialized();
        }
    }

    protected void fireConfigToolsExecuted() {
        this.logger.info("Calling event ConfigToolsExecuted");
        for (ConfigClientListener listener : this.listeners) {
            listener.configToolsExecuted();
        }
    }

    private void fireConfigSessionEnding() {
        this.logger.info("Calling event ConfigSessionEnding");
        for (ConfigClientListener listener : this.listeners) {
            listener.configSessionEnding();
        }
    }

    public void init(String sOracleHomeLoc, boolean bDebug, String sTopAggId) throws CfwException {
        this.logger.log(Level.INFO, "Entering ConfigClient.init method");
        this.m_bDebug = bDebug;
        this.m_sOracleHome = sOracleHomeLoc;
        this.m_sTopCompAggId = sTopAggId;
        String[] TLAggrs = new String[]{this.m_sTopCompAggId};
        this.m_lAggregateList = Arrays.asList(TLAggrs);
        this.logger.log(Level.INFO, "ConfigClient.init sOracleHomeLoc=" + sOracleHomeLoc + ", sTopAggId=" + sTopAggId);
        this.initClientAndSession();
        this.logger.log(Level.INFO, "Exiting ConfigClient.init method");
        this.fireConfigSessionInitialized();
        this.registerOutErrStream(new PrintStream(new LogStream(this.logger, Level.INFO)), new PrintStream(new LogStream(this.logger, Level.WARNING)));
    }

    public void init(String sOracleHomeLoc, boolean bDebug, List sTopAggIdList) throws CfwException {
        this.logger.log(Level.INFO, "Entering ConfigClient.init method");
        this.m_bDebug = bDebug;
        this.m_sOracleHome = sOracleHomeLoc;
        this.m_lAggregateList = sTopAggIdList;
        this.logger.log(Level.INFO, "ConfigClient.init sOracleHomeLoc=" + sOracleHomeLoc + ", sTopAggIdList=" + sTopAggIdList);
        this.initClientAndSession();
        this.logger.log(Level.INFO, "Exiting ConfigClient.init method");
    }

    public CfwSession getCfwSession() {
        return this.m_oCfwSession;
    }

    private void initClientAndSession() throws CfwException {
        this.logger.log(Level.INFO, "Entering ConfigClient.initClientAndSession method");
        this.m_oCfwClient = CfwClient.connect((boolean)this.m_bDebug, (String)this.m_sOracleHome, (String)this.m_sInventoryLoc, (String)this.m_sInventoryLoc, (List)this.m_lAggregateList);
        this.logger.log(Level.INFO, "ConfigClient.initClientAndSession status : connected to the config framework");
        this.m_oCfwSession = this.m_oCfwClient.begin();
        this.logger.log(Level.INFO, "ConfigClient.initClientAndSession session begun " + this.m_oCfwSession);
        this.m_oAggregateRef = new IAggregateReference[this.m_lAggregateList.size()];
        ArrayList<IAggregate> oAggregate = new ArrayList<IAggregate>();
        for (int i = 0; i < this.m_lAggregateList.size(); ++i) {
            String thisID = (String)this.m_lAggregateList.get(i);
            if (thisID == null) continue;
            CfwIdentifier cfwIdentifier = new CfwIdentifier(thisID);
            IAggregateReference thisRef = null;
            try {
                thisRef = this.m_oCfwSession.getAggregateReference(cfwIdentifier);
            }
            catch (CfwException ce) {
                this.logger.info("occured while processing top level aggregate-xml file\n " + (Object)((Object)ce));
            }
            if (thisRef == null) continue;
            this.m_oAggregateRef[i] = thisRef;
            oAggregate.add(this.m_oCfwSession.getAggregate(this.m_oAggregateRef[i]));
        }
        this.m_oAggregate = new IAggregate[oAggregate.size()];
        oAggregate.toArray(this.m_oAggregate);
        this.logger.log(Level.INFO, "ConfigClient.initClientAndSession m_oAggregate=" + this.m_oAggregate);
        String logDir = this.m_sOracleHome + File.separator + "cfgtoollogs";
        this.setLogDirectory(logDir);
    }

    public void registerEventListener(CfwProgressMonitor eventMonitor) throws CfwException {
        if (null != this.m_oCfwSession && null != this.m_oAggregate && this.m_oAggregate.length > 0) {
            for (int i = 0; i < this.m_oAggregate.length; ++i) {
                this.m_oAggregate[i].addProgressListener((IProgressMonitor)eventMonitor);
            }
        }
        this.logger.log(Level.FINEST, "ConfigClient.registerEventListener method called");
    }

    public void unregisterEventListener(CfwProgressMonitor eventMonitor) throws CfwException {
        if (null != this.m_oCfwSession && null != this.m_oAggregate && this.m_oAggregate.length > 0) {
            for (int i = 0; i < this.m_oAggregate.length; ++i) {
                this.m_oAggregate[i].removeProgressListener((IProgressMonitor)eventMonitor);
            }
        }
        this.logger.log(Level.FINEST, "ConfigClient.unregisterEventListener method called");
    }

    public void registerOutErrStream(PrintStream outStream, PrintStream errStream) throws CfwException {
        if (null != this.m_oCfwSession) {
            this.m_oCfwSession.registerStreams(outStream, errStream);
        }
        this.logger.log(Level.INFO, "ConfigClient.registerOutErrStream method called");
    }

    public IAggregate[] getAggregateList() {
        return this.m_oAggregate;
    }

    public IAggregate getTopLevelAggregate() {
        IAggregate topLevelAggregate = null;
        if (this.m_oAggregate.length >= 1) {
            topLevelAggregate = this.m_oAggregate[0];
        }
        return topLevelAggregate;
    }

    public IMicroStepStateReference[] getToolsList(boolean bRecommendedonly, boolean bSilentOnly, boolean bRetry, boolean bSkipDetached, ActionType oActType, IAggregate oAggregate) throws CfwException {
        this.logger.log(Level.INFO, "Entering ConfigClient.getToolsList method");
        if (null != oAggregate) {
            return oAggregate.listTools(bRecommendedonly, bSilentOnly, bRetry, bSkipDetached, oActType);
        }
        this.logger.log(Level.INFO, "Exiting ConfigClient.getToolsList method");
        return null;
    }

    public IMicroStepStateReference[] getToolsList(boolean bRecommendedonly, boolean bSilentOnly, boolean bRetry, boolean bSkipDetached, ActionType oActType) throws CfwException {
        IMicroStepStateReference[] tools = null;
        IAggregate[] aggregateList = this.getAggregateList();
        if (aggregateList != null) {
            IAggregate aggregate = aggregateList[0];
            tools = this.getToolsList(bRecommendedonly, bSilentOnly, bRetry, bSkipDetached, oActType, aggregate);
        }
        return tools;
    }

    public void printToolInfo(IMicroStepStateReference oTool) throws CfwException {
        IMicroStepState microState = this.m_oCfwSession.getMicroStepState(oTool);
        IActionStepState actionState = microState.getActionStepState();
        MicroStepStatus microStatus = (MicroStepStatus)microState.getStatus();
        IPlugInInvocationState pState = microState.getPlugInInvocationState();
        IActionState actState = microState.getActionState();
        String oraHome = actState.getOriginator().getOracleHome();
        String compName = actState.getOriginator().getSelfID();
        String actionName = oTool.getActionID();
        String stepIdx = Integer.toString(oTool.getStepIndex());
        String mstepIdx = Integer.toString(oTool.getMicroStepIndex());
        this.logger.info("oracle home = " + oraHome + " comp name = " + compName + " actionName = " + actionName + " stepIdx = " + stepIdx + " mstepIdx = " + mstepIdx + " command = " + pState.getCommand() + " argument = " + pState.getArg());
        if (microStatus.equals((Object)MicroStepStatus.PERFORMED_SUCCESS)) {
            this.logger.info("Executed Successfully");
        } else if (microStatus.equals((Object)MicroStepStatus.PERFORMED_FAILED)) {
            this.logger.info("Required tool's Execution failed");
        } else if (microStatus.equals((Object)MicroStepStatus.FAILED_NOTREQUIRED)) {
            this.logger.info("Optional tool's Execution failed");
        } else if (microStatus.equals((Object)MicroStepStatus.WAS_ABORTED)) {
            this.logger.info("Execution Aborted");
        } else if (microStatus.equals((Object)MicroStepStatus.INACTIVE_PLUGIN)) {
            this.logger.info("Tool is made as inactive , hence not executed");
        } else if (microStatus.equals((Object)MicroStepStatus.NOT_PERFORMED)) {
            this.logger.info("Tool wasn't executed");
        } else if (microStatus.equals((Object)MicroStepStatus.ACTION_NOT_FOUND)) {
            this.logger.info("Action wasn't found");
        } else if (microStatus.equals((Object)MicroStepStatus.AGGREGATE_NOT_AVAILABLE)) {
            this.logger.info("Aggregate XML not found");
        } else if (microStatus.equals((Object)MicroStepStatus.AGGREGATE_INACTIVE)) {
            this.logger.info("Component having the tool is inactive");
        } else if (microStatus.equals((Object)MicroStepStatus.ACTION_ALREADY_REFERENCED)) {
            this.logger.info("Tool was already referred in another place");
        } else if (microStatus.equals((Object)MicroStepStatus.INACTIVE_PLUGININVOCATION)) {
            this.logger.info("Tool Plugin invocation is inactive");
        } else if (microStatus.equals((Object)MicroStepStatus.INVALID_TARGET)) {
            this.logger.info("Tool's target/command is invalid");
        } else if (microStatus.equals((Object)MicroStepStatus.USE_OF_UNINITIALIZED_PARAMETER)) {
            this.logger.info("Tool's Parameter wasnt initialized");
        } else if (microStatus.equals((Object)MicroStepStatus.UNSPECIFIED_ERROR)) {
            this.logger.info("Unknown Error");
        }
    }

    public String getToolName(IMicroStepStateReference oTool) throws CfwException {
        IMicroStepState microState = this.m_oCfwSession.getMicroStepState(oTool);
        return microState.getPlugInID();
    }

    public boolean isRequiredTool(IMicroStepStateReference oTool) throws CfwException {
        IMicroStepState microState = this.m_oCfwSession.getMicroStepState(oTool);
        IActionStepState actionState = microState.getActionStepState();
        return actionState.isRequired();
    }

    public void executeToolsInAggregate(boolean bBlocking, boolean bSilentOnly, boolean bRetry, boolean bSkipDetached, ActionType oActType, IAggregate oAggregate) throws CfwException {
        this.logger.log(Level.INFO, "Entering ConfigClient.executeToolsInAggregate method");
        if (null != oAggregate) {
            this.logger.log(Level.INFO, "ConfigClient.executeToolsInAggregate oAggregate=" + oAggregate);
            this.assignAction(oAggregate, oActType);
            this.logger.log(Level.INFO, "ConfigClient.executeToolsInAggregate action assigned");
            oAggregate.performAction(bBlocking, bSilentOnly, bRetry, bSkipDetached, oActType);
            this.logger.log(Level.INFO, "ConfigClient.executeToolsInAggregate action performed");
        }
        this.logger.log(Level.INFO, "Exiting ConfigClient.executeToolsInAggregate method");
        this.fireConfigToolsExecuted();
    }

    public void executeSelectedToolsInAggregate(boolean bBlocking, boolean bSilentOnly, boolean bRetry, boolean bSkipDetached, ActionType oActType, IAggregate oAggregate, IMicroStepStateReference[] toolsList) throws CfwException {
        this.logger.log(Level.INFO, "Entering ConfigClient.executeSelectedToolsInAggregate method");
        if (null != oAggregate && toolsList.length > 0) {
            this.logger.log(Level.INFO, "ConfigClient.executeSelectedToolsInAggregate oAggregate=" + oAggregate);
            this.assignAction(oAggregate, oActType);
            this.logger.log(Level.INFO, "ConfigClient.executeSelectedToolsInAggregate action assigned");
            oAggregate.performAction(bBlocking, bSilentOnly, bRetry, bSkipDetached, toolsList, oActType);
            this.logger.log(Level.INFO, "ConfigClient.executeSelectedToolsInAggregate action performed");
        }
        this.logger.log(Level.INFO, "Exiting ConfigClient.executeSelectedToolsInAggregate method");
    }

    private void assignAction(IAggregate oAggregate, ActionType oActType) throws CfwException {
        this.logger.log(Level.INFO, "Entering ConfigClient.assignAction method");
        IActionReference[] actionref = oAggregate.getActionReferences();
        if (actionref != null) {
            this.logger.log(Level.INFO, "ConfigClient.assignAction actionref=" + actionref);
            for (int k = 0; k < actionref.length; ++k) {
                IAction action = oAggregate.getAction(actionref[k]);
                if (!action.isType(oActType)) continue;
                this.logger.log(Level.INFO, "ConfigClient.assignAction action is of type :" + oActType);
                this.m_vActionList.addElement(action);
                break;
            }
        }
        this.logger.log(Level.INFO, "Exiting ConfigClient.assignAction method");
    }

    public void stopAllExecution(boolean bBlocking) throws CfwException {
        this.logger.log(Level.INFO, "Entering ConfigClient.stopAllExecution method");
        int iNumActions = this.m_vActionList.size();
        for (int i = 0; i < iNumActions; ++i) {
            IAction action = this.m_vActionList.elementAt(i);
            action.cancel(bBlocking);
        }
        this.logger.log(Level.INFO, "Exiting ConfigClient.stopAllExecution method");
    }

    public void stopExecution(boolean bBlocking, IAggregate oAggregate, ActionType oActType) throws CfwException {
        this.logger.log(Level.INFO, "Entering ConfigClient.stopAllExecution method");
        IActionReference[] actionref = oAggregate.getActionReferences();
        if (actionref != null) {
            for (int k = 0; k < actionref.length; ++k) {
                IAction action = oAggregate.getAction(actionref[k]);
                if (!action.isType(oActType)) continue;
                action.cancel(bBlocking);
                break;
            }
        }
        this.logger.log(Level.INFO, "Exiting ConfigClient.stopAllExecution method");
    }

    public void printParameterValues(IAggregate oAggregate) throws CfwException {
        IAggregateReference[] allAggrRefs = oAggregate.getAllReferredAggregateReferences();
        if (null != allAggrRefs) {
            for (int i = 0; i < allAggrRefs.length; ++i) {
                IAggregateReference aggrRef = allAggrRefs[i];
                IAggregate aggr = this.m_oCfwSession.getAggregate(aggrRef);
                IParameterReference[] parameterRefs = aggr.getParameterReferences();
                if (null == parameterRefs) continue;
                this.logger.info("Printing Parameter values for component : " + aggr.getSelfID());
                for (int j = 0; j < parameterRefs.length; ++j) {
                    IParameter parameter = aggr.getParameter(parameterRefs[j]);
                    try {
                        this.logger.info("Parameter name  : " + parameter.getSelfID() + " value : " + parameter.getValueAsSimplestString());
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void saveSession() throws CfwException {
        if (null != this.m_oCfwSession) {
            this.m_oCfwSession.save();
        }
        this.logger.log(Level.INFO, "ConfigClient.saveSession method called");
    }

    public void endSession() throws CfwException {
        this.fireConfigSessionEnding();
        if (null != this.m_oCfwClient) {
            this.m_oCfwClient.disconnect();
        }
        this.logger.log(Level.INFO, "ConfigClient.endSession method called");
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
        try {
            this.getCfwSession().registerLogDir(logDirectory);
            this.logger.log(Level.INFO, "Configuration log directory - {0}", logDirectory);
        }
        catch (CfwException e) {
            e.printStackTrace();
        }
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public boolean isAnyConfigToolFailed() {
        return this.isAnyConfigToolFailed;
    }

    public void setAnyConfigToolFailed(boolean isAnyConfigToolFailed) {
        this.isAnyConfigToolFailed = isAnyConfigToolFailed;
    }

    public void updateTransientParameters(IAggregate configTool, Map<String, String> transientParameters, Map<String, String> defaultConfigParams) throws CfwException {
        IParameterReference[] parameterRefs;
        this.logger.log(Level.INFO, "Updating Transient Parameters for " + configTool.getSelfID());
        if (transientParameters != null) {
            this.logger.log(Level.FINEST, "TransientParams = " + transientParameters);
        }
        if (null != (parameterRefs = configTool.getParameterReferences())) {
            for (IParameterReference parameterRef : parameterRefs) {
                IParameter parameter = configTool.getParameter(parameterRef);
                String paramSelfId = parameter.getSelfID();
                this.logger.log(Level.FINEST, "Processing transient variable: " + paramSelfId);
                String transientValue = null;
                if (transientParameters != null) {
                    transientValue = transientParameters.get(paramSelfId);
                }
                if (transientValue == null && defaultConfigParams != null) {
                    transientValue = defaultConfigParams.get(paramSelfId);
                }
                if (transientValue == null || !(transientValue instanceof String)) continue;
                this.logger.log(Level.INFO, "Setting value to transient variable " + paramSelfId);
                parameter.setSimplestAsString(transientValue);
            }
        }
    }

    public void updateTransientParameters(Map<String, Map<String, String>> transientParameters, Map<String, String> defaultConfigParams) throws CfwException {
        IAggregate aggregate;
        this.logger.log(Level.INFO, "Updating Transient Parameters in the Aggregates");
        IAggregate[] aggregateList = this.getAggregateList();
        if (aggregateList != null && (aggregate = aggregateList[0]) != null) {
            String topLevelId = aggregate.getSelfID();
            Map<String, String> topLevelParams = transientParameters.get(topLevelId);
            this.updateTransientParameters(aggregate, topLevelParams, defaultConfigParams);
            IAggregateReference[] allAggrRefs = aggregate.getReferredAggregateReferences();
            if (null != allAggrRefs) {
                for (int i = 0; i < allAggrRefs.length; ++i) {
                    IAggregateReference aggrRef = allAggrRefs[i];
                    IAggregate aggr = this.getCfwSession().getAggregate(aggrRef);
                    String configToolId = aggr.getSelfID();
                    Map<String, String> params = transientParameters.get(configToolId);
                    this.updateTransientParameters(aggr, params, defaultConfigParams);
                }
            }
        }
        this.logger.log(Level.INFO, "Successfully updated Transient Parameters in the Aggregates");
    }

    public String getLocalizedDisplayName(IMicroStepStateReference invocation) throws CfwException {
        String m_sExternalName = null;
        CfwSession cfwSession = this.getCfwSession();
        IMicroStepState mstate = cfwSession.getMicroStepState(invocation);
        IActionState astate = mstate.getActionState();
        m_sExternalName = mstate.getPlugInID();
        CfwIdentifier cident = new CfwIdentifier(astate.getOriginator().getSelfID());
        IAggregate aggrgate = cfwSession.getAggregate(cfwSession.getAggregateReference(cident));
        IPlugInReference[] allPlugIns = aggrgate.getPlugInReferences();
        for (int i = 0; i < allPlugIns.length; ++i) {
            IPlugIn plugIn = this.getAggregateList()[0].getPlugIn(allPlugIns[i]);
            if (!plugIn.getSelfID().equals(mstate.getPlugInID())) continue;
            m_sExternalName = plugIn.getLocalizedDisplayName();
            break;
        }
        return m_sExternalName;
    }
}

