/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.driver.oui.config.ConfigAssistantParams;
import oracle.install.driver.oui.config.ConfigClient;
import oracle.sysman.emCfg.common.CfmInternalPlugIn;
import oracle.sysman.emCfg.common.IInternalPlugInContext;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixPlatform;

public class GenericInternalPlugIn
extends CfmInternalPlugIn {
    private static Logger logger = Logger.getLogger(GenericInternalPlugIn.class.getName());
    private int weight = 1;
    private Process process;

    public GenericInternalPlugIn(IInternalPlugInContext context) {
        super(context);
        for (Handler handler : this.plugInLogger.getHandlers()) {
            logger.addHandler(handler);
        }
    }

    public void abort() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean invoke(String actionID, int stepIndex, int selfIndex, String[] args) throws Throwable {
        if (args != null && args.length == 2) {
            File executable = new File(args[0].trim());
            String toolName = args[1];
            Integer retCode = this.invoke(executable, toolName);
            if (retCode == null) {
                return false;
            }
            return retCode == 0;
        }
        return false;
    }

    public Integer invoke(File executable, String toolName) throws Throwable {
        ConfigClient configClient = ConfigClient.getConfigClient();
        final ConfigAssistantParams configAssistantParams = configClient.getConfigAssistantParams(toolName);
        String windowsCommandLinePrefix = null;
        Object winCommand = null;
        if (configAssistantParams != null) {
            ProcessBuilder processBuilder;
            if (this.isWindows()) {
                String systemDir = "";
                try {
                    systemDir = OiipwWin32NativeCalls.getWindowsSystemDirectory();
                    windowsCommandLinePrefix = systemDir + "\\cmd";
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to get windows system directory - " + e.getMessage());
                }
                processBuilder = new ProcessBuilder(windowsCommandLinePrefix, "/c", "call", executable.getAbsolutePath());
            } else {
                processBuilder = new ProcessBuilder(new String[0]);
                processBuilder.command().add(executable.getAbsolutePath());
            }
            processBuilder.command().addAll(configAssistantParams.getArguments());
            processBuilder.directory(executable.getParentFile());
            logger.log(Level.INFO, "Executing {0}", toolName);
            StringBuffer args = new StringBuffer();
            for (String param : processBuilder.command()) {
                args.append(param);
                args.append(' ');
            }
            logger.log(Level.INFO, "Command {0}", args);
            this.process = processBuilder.start();
            ExecutorService service = Executors.newFixedThreadPool(2);
            Future<Integer> future = service.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    int retCode = 0;
                    retCode = GenericInternalPlugIn.this.handleProcess(GenericInternalPlugIn.this.process, configAssistantParams);
                    return retCode;
                }
            });
            Future<Void> stderrFuture = service.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    GenericInternalPlugIn.this.handleStderr(GenericInternalPlugIn.this.process);
                    return null;
                }
            });
            service.shutdown();
            return future.get();
        }
        return null;
    }

    protected int handleProcess(Process process, ConfigAssistantParams configAssistantParams) throws IOException, InterruptedException {
        logger.log(Level.INFO, "... GenericInternalPlugIn.handleProcess() entered.");
        Map<String, String> secretParamRegex = configAssistantParams.getSecretParamRegexMap();
        logger.log(Level.INFO, "... GenericInternalPlugIn: getting configAssistantParmas.");
        Map<String, String> secretArguments = configAssistantParams.getSecretArguments();
        logger.log(Level.INFO, "... GenericInternalPlugIn: checking secretArguments.");
        if (secretArguments.isEmpty()) {
            logger.log(Level.INFO, "No arguments to pass to stdin");
        } else {
            logger.log(Level.FINEST, "secretArguments {0}", secretArguments.keySet());
        }
        PrintWriter stdin = new PrintWriter(process.getOutputStream());
        BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = "";
        int countArgs = 0;
        logger.log(Level.INFO, "... GenericInternalPlugIn: starting read loop.");
        while ((line = stdout.readLine()) != null) {
            logger.log(Level.INFO, "Read: {0}", line);
            String secretArgValue = null;
            String secretArgName = null;
            for (Map.Entry<String, String> entry : secretParamRegex.entrySet()) {
                logger.log(Level.FINEST, "Matching regex: {0}", entry.getValue());
                Pattern p = Pattern.compile(entry.getValue(), 2);
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                secretArgName = entry.getKey();
                secretArgValue = secretArguments.get(secretArgName);
            }
            if (secretArgName != null && secretArgValue == null) {
                logger.log(Level.WARNING, "Missing secret argument for {0}", secretArgName);
                ++countArgs;
            } else if (secretArgValue != null) {
                logger.log(Level.INFO, "Processing: {0} for argument tag {1}", new String[]{line, secretArgName});
                stdin.println(secretArgValue);
                stdin.flush();
                ++countArgs;
            } else if (secretArgName == null) {
                logger.log(Level.WARNING, "Skipping line: {0}", line);
            }
            if (countArgs == secretArguments.size()) {
                logger.log(Level.INFO, "End of argument passing to stdin");
                ++countArgs;
                continue;
            }
            if (countArgs <= secretArguments.size()) continue;
            logger.log(Level.INFO, "Exceeded the number of arguments passed to stdin. CurrentCount:" + countArgs + " Total args:" + secretArguments.size());
        }
        stdin.close();
        process.waitFor();
        return process.exitValue();
    }

    protected Void handleStderr(Process process) throws IOException {
        BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String line = "";
        while ((line = stderr.readLine()) != null) {
            logger.log(Level.INFO, "Stderr Read: {0}", line);
        }
        return null;
    }

    protected void parseAggregateArgs(ConfigClient configClient, String[] args, Map<String, String> regexes) throws Throwable {
        this.parseAggregateArgs(configClient, args, regexes, 2);
    }

    protected void parseAggregateArgs(ConfigClient configClient, String[] args, Map<String, String> regexes, int ignore) throws Throwable {
        ConfigAssistantParams params = null;
        int nToolnameIndex = ignore > 0 ? ignore - 1 : ignore;
        params = configClient.getConfigAssistantParams(args[nToolnameIndex]);
        if (params == null) {
            params = new ConfigAssistantParams(args[nToolnameIndex]);
        }
        Map<String, String> secretArguments = params.getSecretArguments();
        List<String> arguments = params.getArguments();
        for (int ix = 0; ix < args.length; ++ix) {
            if (ix < ignore) continue;
            if (regexes.containsKey(args[ix])) {
                if (secretArguments.get(args[ix]) != null) {
                    logger.log(Level.INFO, String.format("GenericInternalPlugIn.parseAggregateArgs: %s argument already present.", args[ix]));
                    ++ix;
                    continue;
                }
                if (ix + 1 < args.length) {
                    secretArguments.put(args[ix], args[ix + 1]);
                    ++ix;
                    continue;
                }
                logger.severe("GenericInternalPlugIn.parseAggregateArgs: End of arguments - password expected for " + args[ix]);
                continue;
            }
            arguments.add(args[ix]);
        }
        params.setArguments(arguments);
        params.setSecretArguments(secretArguments);
        params.setSecretParamRegexMap(regexes);
        configClient.addConfigAssistantParams(params);
    }

    public boolean isWindows() {
        boolean windows = false;
        int platform = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.isPlatInGroup((int)-3, (int)platform)) {
            windows = true;
        }
        return windows;
    }
}

