/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterBatch;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilDescQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class StartClusterPreinstService
implements OiilDescQuery {
    private static final String TEMP_SERVICE_DIR = "\\clusterpreinst";
    private static final String TEMP_SERVICE_EXECUTABLE = "clusterpreinstsrv.exe";
    private static final String TEMP_SERVICE_NAME = "OracleClusterPreinstService";

    public String getDescription(Vector inputs) {
        String descStr = "";
        return descStr;
    }

    public Object performQuery(Vector inputs) throws OiilQueryException {
        String[] nodeList = (String[])this.retItem(inputs, "nodeList");
        String sourcePath = (String)this.retItem(inputs, "source");
        String source = sourcePath + File.separator + TEMP_SERVICE_EXECUTABLE;
        if (nodeList.length < 1) {
            return null;
        }
        for (int i = 0; i < nodeList.length; ++i) {
            Trace.out((String)("Node " + i + " = " + nodeList[i]));
        }
        File f = new File(source);
        if (!f.exists()) {
            String exName = "FileNotFoundException";
            String exString = OiQueryFileRes.getString("FileNotFoundException_desc");
            Object[] objs = new String[]{source};
            exString = MessageFormat.format(exString, objs);
            throw new OiilQueryException(exName, exString);
        }
        ClusterPreinstClassW32 qc = new ClusterPreinstClassW32();
        String tempdir = qc.getTempPath();
        Trace.out((String)("startDriveLetterService: Temp directory = " + tempdir));
        if (tempdir == null || tempdir.trim().equals("")) {
            tempdir = qc.getSystemPath() + File.separator + "temp";
        }
        ClusterBatch clusterBatch = null;
        try {
            ClusterBatch clusterBatchd = new ClusterBatch();
            clusterBatchd.createDirInNodes(nodeList, tempdir + TEMP_SERVICE_DIR);
            clusterBatchd.Execute();
            clusterBatch = new ClusterBatch();
        }
        catch (Exception e) {
            String exName = "DirCreationException";
            String exString = OiQueryFileRes.getString("DirCreationException_desc");
            Object[] objs = new String[]{tempdir + TEMP_SERVICE_DIR};
            exString = MessageFormat.format(exString, objs);
            throw new OiilQueryException(exName, exString);
        }
        String dest = tempdir + TEMP_SERVICE_DIR + File.separator + TEMP_SERVICE_EXECUTABLE;
        Trace.out((String)("startDriveLetterService: dest = " + dest));
        try {
            clusterBatch.copyFileToNodes(source, nodeList, dest);
            Trace.out((String)("finished copying  " + source + " to " + dest + " on all node"));
        }
        catch (Exception ce) {
            String exName = "CopyFileException";
            String exString = OiQueryFileRes.getString("CopyFileException_desc");
            Object[] objs = new String[]{source, dest};
            exString = MessageFormat.format(exString, objs);
            throw new OiilQueryException(exName, exString);
        }
        clusterBatch.Execute();
        ClusterWindows clusterWindows = null;
        try {
            clusterWindows = new ClusterWindows(4);
        }
        catch (ClusterException e) {
            String exName = "HardwareVerificationException";
            String exString = OiQueryFileRes.getString("HardwareVerificationException_desc");
            throw new OiilQueryException(exName, exString);
        }
        try {
            for (int i = 0; i < nodeList.length; ++i) {
                Trace.out((String)("before creating drive letter service on " + nodeList[i]));
                clusterWindows.createServiceOnNode(TEMP_SERVICE_NAME, dest, 2, nodeList[i]);
            }
            clusterWindows.startServiceOnNodes(TEMP_SERVICE_NAME, nodeList);
        }
        catch (ClusterException ce) {
            String exName = "HardwareVerificationException";
            String exString = OiQueryFileRes.getString("HardwareVerificationException_desc");
            throw new OiilQueryException(exName, exString);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Trace.out((Exception)e);
        }
        return new Boolean(true);
    }

    public Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }
}

