/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.util.Vector;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiil.OiilAction;
import oracle.sysman.oii.oiil.OiilActionCloneCapable;
import oracle.sysman.oii.oiil.OiilActionClusterOps;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilCommitException;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilUndoException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class SetUserNameForHome
implements OiilAction,
OiilActionCloneCapable,
OiilActionClusterOps {
    private Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public void installAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        try {
            Credentials m_cred;
            String userName = (String)this.retItem(inputs, "userName");
            String OracleHomeBin = (String)this.retItem(inputs, "OracleHomeBin");
            String oracleHomeKey = (String)this.retItem(inputs, "oracleHomeKey");
            boolean isBuildInAccount = (Boolean)this.retItem(inputs, "isBuildInAccount");
            Version m_version = new Version();
            if (!isBuildInAccount) {
                m_cred = new Credentials(userName);
            } else {
                m_cred = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                if (userName.equals(Credentials.BuiltinUser.LOCALSYSTEM.toString())) {
                    m_cred = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                }
                if (userName.equals(Credentials.BuiltinUser.LOCALSERVICE.toString())) {
                    m_cred = new Credentials(Credentials.BuiltinUser.LOCALSERVICE);
                }
                if (userName.equals(Credentials.BuiltinUser.NETWORKSERVICE.toString())) {
                    m_cred = new Credentials(Credentials.BuiltinUser.NETWORKSERVICE);
                }
            }
            WinSecurityFactory m_winSecFactory = WinSecurityFactory.getInstance((String)OracleHomeBin, null);
            User m_user = m_winSecFactory.getUser(m_cred, m_version);
            m_user.setServiceUserForHome(oracleHomeKey);
        }
        catch (WindowsSecurityException we) {
            String ExcepStr = OiActionIniRes.getString("ServiceUserForHomeException_desc");
            throw new OiilActionException("WindowsSecurityException", ExcepStr);
        }
        catch (Exception e) {
            String ExcepStr = OiActionIniRes.getString("Exception_desc");
            throw new OiilActionException(ExcepStr, e.getMessage());
        }
    }

    public void clusterInstallAction(Vector inputs, Vector inLogObjects) throws OiilActionException {
        String machineName = new String();
        try {
            machineName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        String[] remoteNodes = (String[])this.retItem(inputs, "remoteNodes");
        if (remoteNodes != null && remoteNodes.length > 0) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText((String)("***Set User Name For Home on   nodes:" + OiixFunctionOps.implodeList((String[])remoteNodes, (String)",")));
            }
            try {
                Credentials m_cred;
                String userName = (String)this.retItem(inputs, "userName");
                String OracleHomeBin = (String)this.retItem(inputs, "OracleHomeBin");
                String oracleHomeKey = (String)this.retItem(inputs, "oracleHomeKey");
                boolean isBuildInAccount = (Boolean)this.retItem(inputs, "isBuildInAccount");
                Version m_version = new Version();
                if (!isBuildInAccount) {
                    m_cred = new Credentials(userName);
                } else {
                    m_cred = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                    if (userName.equals(Credentials.BuiltinUser.LOCALSYSTEM.toString())) {
                        m_cred = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                    }
                    if (userName.equals(Credentials.BuiltinUser.LOCALSERVICE.toString())) {
                        m_cred = new Credentials(Credentials.BuiltinUser.LOCALSERVICE);
                    }
                    if (userName.equals(Credentials.BuiltinUser.NETWORKSERVICE.toString())) {
                        m_cred = new Credentials(Credentials.BuiltinUser.NETWORKSERVICE);
                    }
                }
                WinSecurityFactory m_winSecFactory = WinSecurityFactory.getInstance((String)OracleHomeBin, null);
                User m_user = m_winSecFactory.getUser(m_cred, m_version);
                m_user.setServiceUserForHome(oracleHomeKey, machineName, remoteNodes);
            }
            catch (CompositeOperationException ce) {
                String ExcepStr = OiActionIniRes.getString("ServiceUserForHomeException_desc");
                throw new OiilActionException("CompositeOperationException", ExcepStr);
            }
            catch (WindowsSecurityException we) {
                String ExcepStr = OiActionIniRes.getString("ServiceUserForHomeException_desc");
                throw new OiilActionException("WindowsSecurityException", ExcepStr);
            }
            catch (Exception e) {
                String ExcepStr = OiActionIniRes.getString("Exception_desc");
                throw new OiilActionException(ExcepStr, e.getMessage());
            }
        }
    }

    public void cloneAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        this.installAction(inputs, outLogObjects);
    }

    public String getDescription(Vector inputs) {
        return null;
    }

    public void saveAndInstallAction(Vector inputs, Vector outLogObjects, Vector outBackupObjects) throws OiilActionException {
    }

    public void deinstallAction(Vector inputs, Vector inLogObjects) throws OiilDeinstallException {
    }

    public void clusterDeinstallAction(Vector inputs, Vector inLogObjects) throws OiilDeinstallException {
    }

    public void saveAndDeinstallAction(Vector inputs, Vector inLogObjects, Vector outLogObjects, Vector outBackupObjects) throws OiilDeinstallException {
    }

    public void undoInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilUndoException {
    }

    public void undoDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilUndoException {
    }

    public void commitInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilCommitException {
    }

    public void commitDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilCommitException {
    }
}

