/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

public class BitMap {
    static final int BITSPU = 64;
    static final int USHIFT = 6;
    static final int UMASK = 63;
    static final long UNITON = -1L;
    static final int BYTESIZE = 8;
    static final int BYTECNT = 8;
    static final long[] bmapmask = new long[]{Long.MIN_VALUE, 0x4000000000000000L, 0x2000000000000000L, 0x1000000000000000L, 0x800000000000000L, 0x400000000000000L, 0x200000000000000L, 0x100000000000000L, 0x80000000000000L, 0x40000000000000L, 0x20000000000000L, 0x10000000000000L, 0x8000000000000L, 0x4000000000000L, 0x2000000000000L, 0x1000000000000L, 0x800000000000L, 0x400000000000L, 0x200000000000L, 0x100000000000L, 0x80000000000L, 0x40000000000L, 0x20000000000L, 0x10000000000L, 0x8000000000L, 0x4000000000L, 0x2000000000L, 0x1000000000L, 0x800000000L, 0x400000000L, 0x200000000L, 0x100000000L, 0x80000000L, 0x40000000L, 0x20000000L, 0x10000000L, 0x8000000L, 0x4000000L, 0x2000000L, 0x1000000L, 0x800000L, 0x400000L, 0x200000L, 0x100000L, 524288L, 262144L, 131072L, 65536L, 32768L, 16384L, 8192L, 4096L, 2048L, 1024L, 512L, 256L, 128L, 64L, 32L, 16L, 8L, 4L, 2L, 1L};
    long[] map;
    private int len;
    private int capacity;
    private static final int MSHIFT = 3;
    private static final long[] MASK = new long[]{-72057594037927936L, 0xFF000000000000L, 0xFF0000000000L, 0xFF00000000L, 0xFF000000L, 0xFF0000L, 65280L, 255L};

    public BitMap() {
        this.map = new long[1];
        this.initMap(0);
        this.len = 1;
        this.capacity = 64;
    }

    public BitMap(int n) {
        this.len = (n - 1 >> 6) + 1;
        this.map = new long[this.len];
        this.initMap(0);
        this.capacity = this.len * 64;
    }

    public BitMap(int[] nArray) {
        int n = 0;
        long l = 0L;
        int n2 = 0;
        this.len = nArray.length + 1 >> 1;
        this.map = new long[this.len];
        for (int i = 0; i < this.len; ++i) {
            l = 0L;
            for (n = 0; n < 2 && n2 < nArray.length; ++n) {
                l = l << 32 | (long)nArray[n2++];
            }
            if (n == 1) {
                l <<= 32;
            }
            this.map[i] = l;
        }
        this.capacity = this.len * 64;
    }

    public BitMap(byte[] byArray) {
        int n = 0;
        this.len = byArray.length >> 3;
        this.map = new long[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.map[i] = 0L;
            for (int j = 0; j < 8; ++j) {
                int n2 = i;
                this.map[n2] = this.map[n2] << 8;
                int n3 = i;
                this.map[n3] = this.map[n3] | (long)byArray[n++] & 0xFFL;
            }
        }
        this.capacity = this.len * 64;
    }

    public byte[] toBytes() {
        int n = 0;
        byte[] byArray = new byte[this.len * 8];
        for (int i = 0; i < this.len; ++i) {
            long l = this.map[i];
            for (int j = 0; j < 8; ++j) {
                byArray[n++] = (byte)(l >> 56);
                l <<= 8;
            }
        }
        return byArray;
    }

    public void setBit(int n) {
        int n2 = n >> 6;
        this.map[n2] = this.map[n2] | bmapmask[n & 0x3F];
    }

    public void clearBit(int n) {
        int n2 = n >> 6;
        this.map[n2] = this.map[n2] & (bmapmask[n & 0x3F] ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean testBit(int n) {
        return (this.map[n >> 6] & bmapmask[n & 0x3F]) != 0L;
    }

    public void initMap(int n) {
        if (n == 0) {
            for (int i = 0; i < this.len; ++i) {
                this.map[i] = 0L;
            }
        } else {
            for (int i = 0; i < this.len; ++i) {
                this.map[i] = -1L;
            }
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public String toString() {
        int n = this.len * 64;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.testBit(i) ? 49 : 48;
        }
        return new String(cArray);
    }

    public void andMap(BitMap bitMap) {
        int n = this.len <= bitMap.len ? this.len : bitMap.len;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.map[n2] = this.map[n2] & bitMap.map[i];
        }
    }

    public void orMap(BitMap bitMap) {
        int n = this.len <= bitMap.len ? this.len : bitMap.len;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.map[n2] = this.map[n2] | bitMap.map[i];
        }
    }

    public int nextBit(int n) {
        int n2 = n >> 6;
        int n3 = n - n2 * 64 >> 3;
        for (int i = n2; i < this.len; ++i) {
            if (this.map[i] == 0L) {
                n3 = 0;
                continue;
            }
            for (int j = n3; j < 8; ++j) {
                if ((this.map[i] & MASK[j]) == 0L) continue;
                int n4 = i * 64 + j * 8;
                int n5 = n4 + 8;
                if (n4 < n) {
                    n4 = n;
                }
                for (int k = n4; k < n5; ++k) {
                    if (!this.testBit(k)) continue;
                    return k;
                }
            }
            n3 = 0;
        }
        return -1;
    }

    public void setBitsOn(int n) {
        int n2;
        int n3 = 64;
        int n4 = 0;
        int n5 = 0;
        long l = -1L;
        long l2 = 0L;
        for (n2 = n; n2 >= n3; n2 -= n3) {
            this.map[n5++] = l;
        }
        for (int i = 0; i < 6; ++i) {
            if (n2 == 0) {
                return;
            }
            l2 = (l <<= (n3 >>= 1)) >> n4;
            if (n2 < n3) continue;
            int n6 = n5;
            this.map[n6] = this.map[n6] | l2;
            n2 -= n3;
            n4 = n3 + n4;
        }
    }

    public void growMap(int n, int n2) {
        int n3;
        if (n < this.capacity) {
            return;
        }
        int n4 = (n - 1 >> 6) + 1;
        long[] lArray = new long[n4];
        for (n3 = 0; n3 < this.len; ++n3) {
            lArray[n3] = this.map[n3];
        }
        if (n2 == 0) {
            for (n3 = this.len; n3 < n4; ++n3) {
                lArray[n3] = 0L;
            }
        } else {
            for (n3 = this.len; n3 < n4; ++n3) {
                lArray[n3] = -1L;
            }
        }
        this.len = n4;
        this.map = lArray;
        this.capacity = this.len * 64;
    }

    public Object clone() {
        BitMap bitMap = new BitMap(this.capacity);
        for (int i = 0; i < this.len; ++i) {
            bitMap.map[i] = this.map[i];
        }
        return bitMap;
    }

    public void reverse() {
        for (int i = 0; i < this.len; ++i) {
            this.map[i] = this.map[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public boolean isZero() {
        for (int i = 0; i < this.len; ++i) {
            if (this.map[i] == 0L) continue;
            return false;
        }
        return true;
    }
}

