/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.ias.cache.AggregateStatus;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.Bucket;
import oracle.ias.cache.CacheAccess;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheCleaner;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHandleQ;
import oracle.ias.cache.CacheHostInfo;
import oracle.ias.cache.CacheLogger;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.CacheObjectInfo;
import oracle.ias.cache.CacheObjectOutputStream;
import oracle.ias.cache.CapacityPolicy;
import oracle.ias.cache.Configurator;
import oracle.ias.cache.DefaultCacheLogger;
import oracle.ias.cache.DefaultPolicy;
import oracle.ias.cache.DiskCache;
import oracle.ias.cache.DiskCacheException;
import oracle.ias.cache.DiskMessage;
import oracle.ias.cache.FileLock;
import oracle.ias.cache.ListEnumeration;
import oracle.ias.cache.Mdslot;
import oracle.ias.cache.Message;
import oracle.ias.cache.Net;
import oracle.ias.cache.NetworkException;
import oracle.ias.cache.NullObj;
import oracle.ias.cache.NullObjectException;
import oracle.ias.cache.NullObjectNameException;
import oracle.ias.cache.ObjectExistsException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.ias.cache.ResponseQ;
import oracle.ias.cache.Task;
import oracle.ias.cache.TaskQ;
import oracle.ias.cache.ThreadPool;
import oracle.ias.cache.TimeQ;
import oracle.ias.cache.TimeoutException;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.GroupConfig;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.View;

public class CacheInternal {
    static final String DESTROYED = "000DESTROYED$$";
    static final NullObj NULL_OBJECT = new NullObj();
    static final String DISKROOT = "diskCache";
    static final long OBJECT_FREE = 1L;
    static final long OBJECT_LOADED = 2L;
    static final long OBJECT_LOADING = 4L;
    static final long OBJECT_NEEDLOAD = 8L;
    static final long OBJECT_VALID = 16L;
    static final long OBJECT_UPDATEALL = 32L;
    static final long OBJECT_INMEMORY = 64L;
    static final long OBJECT_GROUP = 128L;
    static final long OBJECT_ONDISK = 256L;
    static final long OBJECT_DISTRIBUTE = 512L;
    static final long OBJECT_NEEDVERIFY = 1024L;
    static final long OBJECT_REPLY = 2048L;
    static final long OBJECT_DISKONLY = 4096L;
    static final long OBJECT_DISKABLE = 8192L;
    static final long OBJECT_MEMORY = 16384L;
    static final long OBJECT_REPLACE = 32768L;
    static final long OBJECT_ORIGINAL = 65536L;
    static final long OBJECT_SYNCUP = 131072L;
    static final long OBJECT_FINDONLY = 262144L;
    static final long OBJECT_ATTRSET = 524288L;
    static final long OBJECT_SYNCDEF = 0x100000L;
    static final long OBJECT_NOWAIT = 0x200000L;
    static final long OBJECT_TTLDESTROY = 0x400000L;
    static final long OBJECT_WRITEONLY = 0x800000L;
    static final long OBJECT_LOADER = 0x1000000L;
    static final long OBJECT_STREAM = 0x2000000L;
    static final long OBJECT_REMOTELOAD = 0x4000000L;
    static final long OBJECT_NOTDEFINED = 0x8000000L;
    static final long OBJECT_REGION = 0x10000000L;
    static final long OBJECT_DISABLED = 0x20000000L;
    static final long OBJECT_ALLOWNULL = 0x40000000L;
    static final long OBJECT_MEASURESIZE = 0x80000000L;
    static final long OBJECT_LISTLOAD = 0x100000000L;
    static final long EVENT_INV_TIMEOUT = 0x200000000L;
    static final long EVENT_INV_REMOVED = 0x400000000L;
    static final long LOAD_MASK = 14L;
    static final long OBJECT_TYPES = 20608L;
    static final long OBJECT_ATTRIBUTES = 3226675712L;
    static String EXP_LOAD;
    static String EXP_VERIFY;
    static String EXP_INTERNAL;
    static String EXP_DISKCACHE;
    static String EXP_DISKLOCK;
    static String EXP_DISKMDFILE;
    static String EXP_BADID;
    static String EXP_BADHANDLE;
    static String EXP_INVALID;
    static String EXP_NEGATIVE;
    static String EXP_NEGREFCNT;
    static String EXP_GRPLOOP;
    static String EXP_NOLOAD;
    static String EXP_CONWAIT;
    static String EXP_NOTIMPEVENT;
    static String EXP_BADADDR;
    static String EXP_INVALID_SSLCONF;
    static String EXP_FULL;
    static String EXP_RFULL;
    static String EXP_NA;
    static String EXP_DISKNA;
    static String EXP_PRIV;
    static String EXP_GUSE;
    static String EXP_INVALARG;
    static String EXP_INVALGRP;
    static String EXP_INVALHDL;
    static String EXP_INVALOBJ;
    static String EXP_LDCONFL;
    static String EXP_NETOFF;
    static String EXP_NOTPOOL;
    static String EXP_POOLEMPTY;
    static String EXP_NORETROBJ;
    static String EXP_NOIMPL;
    static String EXP_NULLOBJ;
    static String EXP_NULLOBJNAM;
    static String EXP_OBJEXISTS;
    static String EXP_OBJNFOUND;
    static String EXP_OBJNOSYNC;
    static String EXP_NOREGION;
    static String EXP_NOGROUP;
    static String EXP_RESPFAIL;
    static String EXP_CANTCREATE;
    static String EXP_BASEEXCEPT;
    static String EXP_EXCEPTIONIN;
    static String EXP_ATTRSET;
    static String EXP_INVALUPDATE;
    static String EXP_NOTOWNER;
    static String EXP_SYNCDESTROYED;
    static String EXP_REDEFINELOCAL;
    static String EXP_REMCACHENFOUND;
    static final int CACHE_READY = 1;
    static final int CACHE_ONNET = 2;
    static final int CACHE_FLUSH = 4;
    static final int CACHE_NOAUTOINIT = 8;
    static final int HASHSIZE = 523;
    static final int TP_MIN = 3;
    static final int TP_MAX = 10;
    static final int TJ_TIMEOUT = 2000;
    static final int STREAMBUFDEFAULT = 10240;
    static final float WATERMARGIN = 0.03f;
    static final String GLOBAL_DISK_PATH = "global";
    static final String WORKING_PATH = "working";
    static final String INFO_FILE = "info";
    public static final String GROUP = "[Grp] ";
    static final String NET = "[Net] ";
    static final String DISK = "[Dsk] ";
    static final String MEM = "[Mem] ";
    static final String LOADER = "[Ldr] ";
    static final String CACHEMGR = "[CMg] ";
    static final String DISKMGR = "[DMg] ";
    static final String CACHEACC = "[Acc] ";
    static int nextbuck;
    static long interval;
    static int intvllen;
    static Bucket[] hashtab;
    static int loadId;
    static String rootDiskPath;
    static String diskPath;
    static String globalDiskPath;
    static String workingDir;
    static TaskQ asyncTaskQ;
    static TimeQ ttlQ;
    static ResponseQ respQ;
    static boolean distributed;
    static boolean session;
    static Thread cleanerThr;
    static Thread diskThr;
    static int objectMax;
    static long cacheMaxSize;
    static int curObjCnt;
    static long curCacheSize;
    static int regionNumber;
    static int severity;
    static Vector addrList;
    static int streamBufSize;
    static CacheAttributes cAttr;
    public static CacheLogger logger;
    public static CacheLogger default_logger;
    static Vector invalidationList;
    static RandomAccessFile pfHdl;
    static FileLock lock;
    static FileLock diskSizeFileLock;
    static byte[] diskUid;
    static boolean isDiskLeader;
    static int detectInterval;
    static int pingInterval;
    static long diskMaxSize;
    static long localDiskSize;
    static long globalDiskSize;
    static float capacityBuffer;
    static float highWater;
    static float lowWater;
    private static long seqId;
    static int cacheId;
    static int flags;
    static String cacheAddress;
    static byte[] bootlock;
    static CapacityPolicy capacityPolicy;
    static AggregateStatus aggStatus;
    static boolean updatingStats;
    static String cacheHostName;
    static int transport;
    static int cacheInstance;
    static boolean isSSLEnabled;
    static String sslConfigFilePath;
    static String localAddress;
    static boolean nlDeathDetect;
    static int overrideNLPort;
    public static final String RESOURCES = "oracle.ias.cache.messages.Translation";
    static HashMap loaderMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(CacheAttributes cacheAttributes) throws CacheException, IOException, InterruptedException, NetworkException {
        byte[] byArray = bootlock;
        synchronized (bootlock) {
            if ((flags & 1) != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            cAttr = cacheAttributes == null ? new CacheAttributes() : cacheAttributes;
            CacheInternal.initExceptionLocale();
            distributed = CacheInternal.cAttr.distribute;
            objectMax = CacheInternal.cAttr.maxObjects;
            cacheMaxSize = CacheInternal.cAttr.maxSize * 1024 * 1024;
            capacityBuffer = (float)((double)CacheInternal.cAttr.capacityBuffer * 0.01);
            intvllen = CacheInternal.cAttr.cleanInterval * 1000;
            pingInterval = CacheInternal.cAttr.pingInterval * 1000;
            detectInterval = pingInterval * 10;
            cacheHostName = CacheInternal.cAttr.cacheName;
            transport = CacheInternal.cAttr.transport;
            isSSLEnabled = CacheInternal.cAttr.isSSLEnabled;
            sslConfigFilePath = CacheInternal.cAttr.sslConfigFilePath;
            localAddress = cAttr.getLocalAddress();
            nlDeathDetect = cAttr.isNodeListenerDeathDetectable();
            overrideNLPort = cAttr.getOverrideNodeListenerPort();
            if (!CacheInternal.cAttr.autoInit) {
                flags |= 8;
            }
            if (capacityBuffer < 0.03f) {
                highWater = 1.0f;
                lowWater = 1.0f - 2.0f * capacityBuffer;
            } else {
                highWater = 1.0f - capacityBuffer + 0.03f;
                lowWater = 1.0f - capacityBuffer - 0.03f;
            }
            try {
                Class<?> clazz;
                Exception exception = null;
                try {
                    clazz = Class.forName(CacheInternal.cAttr.logger);
                    logger = (CacheLogger)clazz.newInstance();
                }
                catch (Exception exception2) {
                    exception = exception2;
                    clazz = Class.forName("oracle.ias.cache.DefaultCacheLogger");
                    logger = (CacheLogger)clazz.newInstance();
                }
                if (logger instanceof DefaultCacheLogger) {
                    default_logger = logger;
                } else {
                    clazz = Class.forName("oracle.ias.cache.DefaultCacheLogger");
                    default_logger = (CacheLogger)clazz.newInstance();
                    try {
                        default_logger.init(CacheInternal.cAttr.logFileName, CacheInternal.cAttr.logSeverity);
                        if (CacheInternal.shouldLog(7)) {
                            default_logger.log("[Mem] Logger:" + logger.getClass().getName());
                        }
                    }
                    catch (CacheException cacheException) {
                        System.err.println(cacheException);
                    }
                }
                try {
                    logger.init(CacheInternal.cAttr.logFileName, CacheInternal.cAttr.logSeverity);
                    if (CacheInternal.shouldLog(7) && exception != null) {
                        logger.log("Warning!!!");
                        logger.log("logger class: " + CacheInternal.cAttr.logger, exception);
                    }
                }
                catch (CacheException cacheException) {
                    System.err.println(exception);
                    System.err.println(cacheException);
                }
                if (CacheInternal.shouldLog(7)) {
                    logger.log("[Mem] Initializing...");
                }
                if (CacheInternal.shouldLog(10)) {
                    logger.log("[Mem] Using CacheAttributes:\n" + cAttr);
                }
                if (CacheInternal.cAttr.capacityPolicy == null) {
                    capacityPolicy = new DefaultPolicy();
                } else {
                    Class<?> clazz2 = Class.forName(CacheInternal.cAttr.capacityPolicy);
                    capacityPolicy = (CapacityPolicy)clazz2.newInstance();
                }
                aggStatus = new AggregateStatus();
                curObjCnt = 0;
                curCacheSize = 0L;
                regionNumber = 0;
                streamBufSize = cacheMaxSize > 0L && objectMax > 0 ? 2 * (int)(cacheMaxSize / (long)objectMax) : 10240;
                flags |= 1;
                interval = System.currentTimeMillis();
                asyncTaskQ = TaskQ.getInstance();
                ttlQ = new TimeQ();
                int n = 20;
                ThreadPool.interrupt();
                for (int i = 0; i < n && ThreadPool.isAlive(); ++i) {
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                CacheHandleQ.reset();
                if (CacheInternal.cAttr.diskPath != null) {
                    rootDiskPath = CacheInternal.cAttr.diskPath.replace('/', File.separatorChar);
                    CacheInternal.makeDiskPath(rootDiskPath);
                    diskMaxSize = CacheInternal.cAttr.diskSize * 1024 * 1024;
                    lock = new FileLock(rootDiskPath, !distributed);
                    if (distributed) {
                        diskSizeFileLock = new FileLock(globalDiskPath, false);
                        invalidationList = new Vector(10);
                        isDiskLeader = false;
                    }
                }
                hashtab = new Bucket[523];
                for (int i = 0; i < 523; ++i) {
                    CacheInternal.hashtab[i] = new Bucket(i);
                }
                nextbuck = 0;
                int n2 = 0;
                if (distributed) {
                    respQ = new ResponseQ();
                    addrList = cAttr.getAddrList();
                    GroupConfig groupConfig = new GroupConfig();
                    groupConfig.setListenerList(addrList);
                    groupConfig.setTag((Serializable)diskUid);
                    groupConfig.setCacheName(CacheInternal.cAttr.cacheName);
                    groupConfig.setMulticastAddress(cAttr.getMulticastAddress());
                    groupConfig.setMulticastPort(cAttr.getMulticastPort());
                    groupConfig.setMulticastInterval(cAttr.getMulticastInterval());
                    groupConfig.setMulticast(cAttr.isMulticast());
                    groupConfig.setMulticastTTL(cAttr.getMulticastTTL());
                    groupConfig.setResolutionTimeout(cAttr.getResolutionInterval());
                    groupConfig.enablePriorityOrder(cAttr.isPriorityOrderEnabled());
                    groupConfig.setLowerPortBoundry(cAttr.getLowerPortBoundry());
                    groupConfig.setUpperPortBoundry(cAttr.getUpperPortBoundry());
                    if (localAddress != null) {
                        groupConfig.setLocalAddress(localAddress);
                    } else {
                        groupConfig.setLocalAddress(Net.getOriginalListenerName(addrList));
                    }
                    groupConfig.setNLDeathDetected(nlDeathDetect);
                    if (overrideNLPort != -1) {
                        groupConfig.setOverrideNLPort(overrideNLPort);
                    }
                    if (workingDir != null) {
                        groupConfig.setWorkingDir(workingDir);
                    }
                    int n3 = 0;
                    switch (transport) {
                        case 1: {
                            n3 = 2;
                            break;
                        }
                        case 0: {
                            n3 = 1;
                        }
                    }
                    groupConfig.setMode(n3);
                    cacheId = Net.init(groupConfig, isSSLEnabled, sslConfigFilePath);
                    cacheAddress = Net.getLocalAddress();
                    flags |= 2;
                    View view = Net.getView();
                    if (view != null) {
                        n2 = view.size();
                    }
                }
                CacheHandle cacheHandle = CacheHandleQ.getHandle();
                String string = CacheAccess.getDefRegionName();
                cacheHandle.locateGroup(string, string, null);
                cacheHandle.setRegionNumber();
                CacheHandleQ.releaseHandle(cacheHandle);
                ThreadPool.init(3, Math.max(10, n2), asyncTaskQ);
                if (CacheInternal.cAttr.diskPath != null) {
                    if (distributed && CacheInternal.setDiskLeader(null, Net.getView())) {
                        CacheInternal.cleanLock();
                    }
                    CacheInternal.writeOurTimeStamp(distributed);
                    for (int i = 0; i < 523; ++i) {
                        hashtab[i].initFromDisk();
                    }
                }
                cleanerThr = new CacheCleaner();
                cleanerThr.start();
                if (logger != null && CacheInternal.shouldLog(7)) {
                    default_logger.log("[Mem] Cache is initialized.");
                }
            }
            catch (Exception exception) {
                CacheInternal.close();
                throw CacheInternal.exceptionHandler(exception);
            }
            return;
        }
    }

    static void declarativeConfig(String string) throws CacheException {
        if (string == null) {
            return;
        }
    }

    static void open(String string) throws CacheException {
        int n;
        boolean bl = false;
        if ((flags & 1) != 0) {
            return;
        }
        if (string != null && (n = string.lastIndexOf("xml")) > 0 && n == string.length() - 3) {
            bl = true;
        }
        try {
            CacheAttributes cacheAttributes = new CacheAttributes();
            Configurator configurator = null;
            try {
                if (bl) {
                    configurator = new Configurator(string);
                    cacheAttributes = configurator.getCacheAttributes();
                } else {
                    cacheAttributes.readConfig(string, false);
                }
            }
            catch (CacheException cacheException) {
                CacheInternal.exceptionLog(MEM, cacheException);
            }
            catch (IOException iOException) {
                CacheInternal.exceptionLog(MEM, iOException);
            }
            CacheInternal.init(cacheAttributes);
            if (configurator != null) {
                configurator.defineDeclarable();
            }
        }
        catch (Exception exception) {
            throw CacheInternal.exceptionHandler(exception);
        }
    }

    public static ResourceBundle initExceptionLocale() {
        ResourceBundle resourceBundle = null;
        String string = System.getProperty("user.language");
        if (string == null) {
            string = "en";
        }
        Locale locale = new Locale(string, "");
        try {
            resourceBundle = ResourceBundle.getBundle(RESOURCES, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                resourceBundle = ResourceBundle.getBundle(RESOURCES, new Locale("en", ""));
            }
            catch (MissingResourceException missingResourceException2) {
                // empty catch block
            }
        }
        EXP_LOAD = resourceBundle.getString("EXPLOAD");
        EXP_VERIFY = resourceBundle.getString("EXPVERIFY");
        EXP_INTERNAL = resourceBundle.getString("EXPINTERNAL");
        EXP_DISKCACHE = resourceBundle.getString("EXPDISKCACHE");
        EXP_DISKLOCK = resourceBundle.getString("EXPDISKLOCK");
        EXP_DISKMDFILE = resourceBundle.getString("EXPDISKMDFILE");
        EXP_BADID = resourceBundle.getString("EXPBADID");
        EXP_BADHANDLE = resourceBundle.getString("EXPBADHANDLE");
        EXP_INVALID = resourceBundle.getString("EXPINVALID");
        EXP_NEGATIVE = resourceBundle.getString("EXPNEGATIVE");
        EXP_NEGREFCNT = resourceBundle.getString("EXPNEGREFCNT");
        EXP_GRPLOOP = resourceBundle.getString("EXPGRPLOOP");
        EXP_NOLOAD = resourceBundle.getString("EXPNOLOAD");
        EXP_CONWAIT = resourceBundle.getString("EXPCONWAIT");
        EXP_NOTIMPEVENT = resourceBundle.getString("EXPNOTIMPEVENT");
        EXP_INVALID_SSLCONF = resourceBundle.getString("EXP_INVALID_SSLCONF");
        EXP_FULL = resourceBundle.getString("EXPFULL");
        EXP_RFULL = resourceBundle.getString("EXPRFULL");
        EXP_NA = resourceBundle.getString("EXPNA");
        EXP_DISKNA = resourceBundle.getString("EXPDISKNA");
        EXP_PRIV = resourceBundle.getString("EXPPRIV");
        EXP_GUSE = resourceBundle.getString("EXPGUSE");
        EXP_INVALARG = resourceBundle.getString("EXPINVALARG");
        EXP_INVALGRP = resourceBundle.getString("EXPINVALGRP");
        EXP_INVALHDL = resourceBundle.getString("EXPINVALHDL");
        EXP_INVALOBJ = resourceBundle.getString("EXPINVALOBJ");
        EXP_LDCONFL = resourceBundle.getString("EXPLDCONFL");
        EXP_NETOFF = resourceBundle.getString("EXPNETOFF");
        EXP_NOTPOOL = resourceBundle.getString("EXPNOTPOOL");
        EXP_POOLEMPTY = resourceBundle.getString("EXPPOOLEMPTY");
        EXP_NORETROBJ = resourceBundle.getString("EXPNORETROBJ");
        EXP_NOIMPL = resourceBundle.getString("EXPNOIMPL");
        EXP_NULLOBJ = resourceBundle.getString("EXPNULLOBJ");
        EXP_NULLOBJNAM = resourceBundle.getString("EXPNULLOBJNAM");
        EXP_OBJEXISTS = resourceBundle.getString("EXPOBJEXISTS");
        EXP_OBJNFOUND = resourceBundle.getString("EXPOBJNFOUND");
        EXP_OBJNOSYNC = resourceBundle.getString("EXPOBJNOSYNC");
        EXP_NOREGION = resourceBundle.getString("EXPNOREGION");
        EXP_NOGROUP = resourceBundle.getString("EXPNOGROUP");
        EXP_RESPFAIL = resourceBundle.getString("EXPRESPFAIL");
        EXP_CANTCREATE = resourceBundle.getString("EXPCANTCREATE");
        EXP_BASEEXCEPT = resourceBundle.getString("EXPBASEEXCEPT");
        EXP_EXCEPTIONIN = resourceBundle.getString("EXPEXCEPTIONIN");
        EXP_ATTRSET = resourceBundle.getString("EXPATTRSET");
        EXP_INVALUPDATE = resourceBundle.getString("EXPINVALUPDATE");
        EXP_NOTOWNER = resourceBundle.getString("EXPNOTOWNER");
        EXP_SYNCDESTROYED = resourceBundle.getString("EXPSYNCDESTROYED");
        EXP_REDEFINELOCAL = resourceBundle.getString("EXPREDEFINELOCAL");
        EXP_REMCACHENFOUND = resourceBundle.getString("EXPREMCACHENFOUND");
        return resourceBundle;
    }

    private static void makeDiskPath(String string) throws CacheException {
        File file;
        Object object;
        int n;
        File file2 = new File(string);
        File file3 = null;
        String string2 = file2.getParent();
        if (string2 != null) {
            file3 = new File(string2);
        }
        if (!file2.exists() ? file3 != null && !file3.canWrite() || !file2.mkdir() : !file2.isDirectory() || !file2.canWrite()) {
            throw new CacheException(EXP_CANTCREATE + string, new SecurityException(EXP_CANTCREATE + string));
        }
        String string3 = string + File.separator + GLOBAL_DISK_PATH;
        File file4 = new File(string3);
        if (!file4.exists()) {
            rootDiskPath = string + File.separator + DISKROOT;
            file2 = new File(rootDiskPath);
            if (!file2.exists()) {
                file2.mkdir();
            } else if (!file2.isDirectory() || !file2.canWrite()) {
                throw new CacheException(EXP_CANTCREATE + rootDiskPath, new SecurityException(EXP_CANTCREATE + rootDiskPath));
            }
        }
        if (distributed) {
            globalDiskPath = rootDiskPath + File.separator + GLOBAL_DISK_PATH;
            file4 = new File(globalDiskPath);
            if (file4.mkdir() || !new File(file4, INFO_FILE).exists()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(globalDiskPath + File.separator + INFO_FILE, "rw");
                    randomAccessFile.writeLong(0L);
                    diskUid = CacheInternal.createUid();
                    randomAccessFile.write(diskUid);
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    throw CacheInternal.exceptionHandler(iOException);
                }
            } else {
                int n2 = 10;
                for (n = 0; n < n2; ++n) {
                    try {
                        object = new RandomAccessFile(globalDiskPath + File.separator + INFO_FILE, "r");
                        globalDiskSize = ((RandomAccessFile)object).readLong();
                        diskUid = new byte[(int)((RandomAccessFile)object).length() - 8];
                        ((RandomAccessFile)object).read(diskUid);
                        ((RandomAccessFile)object).close();
                        break;
                    }
                    catch (IOException iOException) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (n == n2) {
                    throw new CacheException("[Mem] failed to read global diskcache info file");
                }
            }
        }
        Random random = new Random(System.currentTimeMillis());
        int n3 = 2000;
        for (n = 0; n < n3 && !(file = new File(diskPath = rootDiskPath + File.separator + (random.nextInt() & Integer.MAX_VALUE))).mkdir(); ++n) {
        }
        if (n == n3) {
            throw new CacheException("[Mem] can not create local diskcache");
        }
        if (CacheInternal.shouldLog(7)) {
            logger.log("[Mem] local diskPath= " + diskPath);
        }
        if (!((File)(object = new File(workingDir = diskPath + File.separator + WORKING_PATH))).exists()) {
            ((File)object).mkdir();
        }
        try {
            pfHdl = new RandomAccessFile(diskPath + File.separator + INFO_FILE, "rw");
            pfHdl.writeLong(0L);
        }
        catch (IOException iOException) {
            throw CacheInternal.exceptionHandler(iOException);
        }
        CacheInternal.writeOurTimeStamp(false);
    }

    private static byte[] createUid() throws CacheException {
        try {
            String string = new UID().toString();
            byte[] byArray = InetAddress.getLocalHost().getAddress();
            String string2 = new String(byArray) + string;
            return string2.getBytes();
        }
        catch (Exception exception) {
            throw CacheInternal.exceptionHandler(exception);
        }
    }

    static CacheAttributes getAttributes() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return cAttr;
    }

    static int getObjectCount() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return curObjCnt;
    }

    static long getCacheSize() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return curCacheSize;
    }

    static long getLocalDiskCacheSize() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return (long)((double)localDiskSize / 1048576.0 + 0.5);
    }

    static long getDistributedDiskCacheSize() throws CacheNotAvailableException {
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        return (long)((double)globalDiskSize / 1048576.0 + 0.5);
    }

    static void resetAttributes(CacheAttributes cacheAttributes) throws CacheNotAvailableException {
        boolean bl = false;
        if ((flags & 1) == 0) {
            throw new CacheNotAvailableException(EXP_NA);
        }
        if (cacheAttributes.capacityBufferSet) {
            capacityBuffer = (float)((double)cacheAttributes.capacityBuffer * 0.01);
            if (capacityBuffer < 0.03f) {
                highWater = 1.0f;
                lowWater = 1.0f - 2.0f * capacityBuffer;
            } else {
                highWater = 1.0f - capacityBuffer + 0.03f;
                lowWater = 1.0f - capacityBuffer - 0.03f;
            }
        }
        if (cacheAttributes.maxObjectsSet) {
            objectMax = cacheAttributes.maxObjects;
            CacheInternal.cAttr.maxObjects = cacheAttributes.maxObjects;
            if (curObjCnt > (int)((float)objectMax * highWater)) {
                bl = true;
            }
        }
        if (cacheAttributes.maxSizeSet) {
            cacheMaxSize = cacheAttributes.maxSize * 1024 * 1024;
            CacheInternal.cAttr.maxSize = cacheAttributes.maxSize;
            if (curCacheSize > (long)((int)((float)cacheMaxSize * highWater))) {
                bl = true;
            }
        }
        if (cacheAttributes.diskSizeSet) {
            diskMaxSize = cacheAttributes.diskSize * 1024 * 1024;
            CacheInternal.cAttr.diskSize = cacheAttributes.diskSize;
            long l = (long)((double)((float)diskMaxSize * highWater) + 0.5);
            if (localDiskSize > l || globalDiskSize > l) {
                bl = true;
            }
        }
        if (cacheAttributes.logSeveritySet) {
            CacheInternal.cAttr.logSeverity = cacheAttributes.logSeverity;
            CacheInternal.setSeverity(cacheAttributes.logSeverity);
        }
        if (cacheAttributes.cleanIntervalSet) {
            CacheInternal.cAttr.cleanInterval = cacheAttributes.cleanInterval;
            intvllen = cacheAttributes.cleanInterval * 1000;
            bl = true;
        }
        if (cacheAttributes.nameSet) {
            cacheHostName = cacheAttributes.cacheName;
        }
        if (cacheAttributes.autoInitSet) {
            flags = cacheAttributes.autoInit ? (flags &= 0xFFFFFFF7) : (flags |= 8);
        }
        if (bl) {
            ttlQ.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        byte[] byArray = bootlock;
        synchronized (bootlock) {
            try {
                if ((flags & 1) == 0) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                if (distributed && diskPath != null && invalidationList != null && invalidationList.size() != 0) {
                    CacheInternal.freeDisk();
                }
                flags &= 0xFFFFFFFE;
                ++cacheInstance;
                ttlQ.rest();
                if (ttlQ != null) {
                    ttlQ.wakeup();
                }
                if (cleanerThr != null) {
                    cleanerThr.join(2000L);
                }
                if (asyncTaskQ != null) {
                    asyncTaskQ.rest();
                    asyncTaskQ.wakeupAll();
                }
                ThreadPool.term();
                if (distributed) {
                    Net.close();
                }
                if (workingDir != null) {
                    File file = new File(workingDir);
                    CacheInternal.removeAll(file);
                }
                if (diskPath != null) {
                    CacheInternal.removeLocalCache(new File(diskPath));
                }
                if (logger != null && CacheInternal.shouldLog(7)) {
                    default_logger.log("[Mem] Cache is shutdown.");
                }
                if (logger != null) {
                    logger.flush();
                }
            }
            catch (Exception exception) {
                CacheInternal.exceptionLog(MEM, exception);
            }
            return;
        }
    }

    static Hashtable listCacheRegions() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = CacheInternal.listCacheObjects();
        while (enumeration.hasMoreElements()) {
            CacheObjectInfo cacheObjectInfo = (CacheObjectInfo)enumeration.nextElement();
            if (hashtable.containsKey(cacheObjectInfo.region)) continue;
            hashtable.put(cacheObjectInfo.region, cacheObjectInfo.region);
        }
        return hashtable;
    }

    public static void globalInvalidate(boolean bl) throws IOException, CacheException, InterruptedException {
        Object object;
        Serializable serializable;
        CacheHandle cacheHandle = CacheHandleQ.getHandle();
        if (bl && distributed) {
            serializable = new Message("invalidate", null, null, 0L, false);
            object = new Task(15, serializable);
            Net.broadcast((Task)object, cacheHandle, 1);
        }
        serializable = CacheInternal.listCacheRegions();
        object = serializable.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            cacheHandle.invalidate(string, string, true);
        }
        CacheHandleQ.releaseHandle(cacheHandle);
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = hashtab[i];
            bucket.clearBucket(false);
        }
        System.gc();
    }

    public static void globalDestroy(boolean bl) throws IOException, CacheException, InterruptedException {
        Object object;
        Serializable serializable;
        CacheHandle cacheHandle = CacheHandleQ.getHandle();
        if (bl && distributed) {
            serializable = new Message("destroy", null, null, 0L, false);
            object = new Task(15, serializable);
            Net.broadcast((Task)object, cacheHandle, 1);
        }
        serializable = CacheInternal.listCacheRegions();
        object = serializable.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            cacheHandle.destroy(string, string, true);
        }
        CacheHandleQ.releaseHandle(cacheHandle);
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = hashtab[i];
            bucket.clearBucket(true);
        }
        System.gc();
    }

    static boolean newInterval() {
        long l = System.currentTimeMillis();
        long l2 = l - interval;
        if (l2 < (long)intvllen) {
            return false;
        }
        interval = l;
        return true;
    }

    static synchronized int getNextBucket() {
        int n = nextbuck++;
        nextbuck %= 523;
        return n;
    }

    static synchronized int getRegionNumber() {
        return ++regionNumber;
    }

    static int getFlags() {
        return flags;
    }

    static int hashName(Object object) throws NullObjectNameException {
        if (object == null) {
            throw new NullObjectNameException(EXP_NULLOBJNAM);
        }
        int n = object.hashCode();
        return n & Integer.MAX_VALUE;
    }

    public static String getVersion() {
        if (cAttr == null) {
            try {
                CacheAttributes cacheAttributes = new CacheAttributes();
                return cacheAttributes.version;
            }
            catch (CacheException cacheException) {
                return cacheException.getLocalizedMessage();
            }
        }
        return CacheInternal.cAttr.version;
    }

    static long setFlags(Attributes attributes) {
        long l = 0L;
        if (attributes.flags != 0L) {
            if ((attributes.flags & 1L) != 0L) {
                l |= 0x200L;
            }
            if ((attributes.flags & 2L) != 0L) {
                l |= 0x800L;
            }
            if ((attributes.flags & 4L) != 0L) {
                l |= 0x20000L;
            } else if ((attributes.flags & 0x40L) != 0L) {
                l |= 0x100000L;
            }
            if ((attributes.flags & 8L) != 0L) {
                l |= 0x2000L;
            }
            if ((attributes.flags & 0x10L) != 0L) {
                l |= 0x400000L;
            }
            if ((attributes.flags & 0x20L) != 0L) {
                l |= 0x10000L;
            }
            if ((attributes.flags & 0x100L) != 0L) {
                l |= 0x20000000L;
            }
            if ((attributes.flags & 0x200L) != 0L) {
                l |= 0x40000000L;
            }
            if ((attributes.flags & 0x400L) != 0L) {
                l |= 0x80000000L;
            }
        }
        return l;
    }

    static boolean incrCurCnt(Mdslot mdslot) {
        int n = 5;
        while (!CacheInternal.incrCnt(mdslot)) {
            if (--n < 0) {
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    private static synchronized boolean incrCnt(Mdslot mdslot) {
        if (mdslot.wasCounted && (mdslot.state & 0x80000000L) == 0L) {
            return true;
        }
        if (curObjCnt > (int)((float)objectMax * highWater) || curCacheSize > (long)((int)((float)cacheMaxSize * highWater))) {
            ttlQ.wakeup();
        }
        if (curObjCnt >= objectMax || cacheMaxSize > 0L && curCacheSize >= cacheMaxSize) {
            return false;
        }
        ++curObjCnt;
        curCacheSize += mdslot.objStatus.size;
        mdslot.wasCounted = true;
        return true;
    }

    static synchronized void decCurCnt(Mdslot mdslot) {
        if (mdslot.wasCounted) {
            --curObjCnt;
            curCacheSize -= mdslot.objStatus.size;
            mdslot.wasCounted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanCache(boolean bl) {
        Bucket bucket;
        int n;
        int n2 = (int)((double)((float)objectMax * highWater) + 0.5);
        int n3 = (int)((double)((float)cacheMaxSize * highWater) + 0.5);
        long l = (long)((double)((float)diskMaxSize * highWater) + 0.5);
        for (n = 0; n < 523; ++n) {
            bucket = hashtab[n];
            bucket.cleanTtl();
        }
        if (curObjCnt > n2 || curCacheSize > (long)n3) {
            CacheInternal.cleanMemoryCache();
        }
        if (diskPath != null) {
            CacheInternal.cleanDiskCache();
        }
        if (bl) {
            n = -1;
            AggregateStatus aggregateStatus = aggStatus;
            synchronized (aggregateStatus) {
                if (!updatingStats) {
                    updatingStats = true;
                    n = CacheInternal.aggStatus.pass;
                    ++n;
                }
            }
            for (int i = 0; i < 523; ++i) {
                bucket = hashtab[i];
                if (n >= 0) {
                    bucket.aggStats(n);
                }
                bucket.resetmaps();
            }
            if (n >= 0) {
                CacheInternal.aggStatus.newStats.clone(aggStatus);
                CacheInternal.aggStatus.pass = n;
                CacheInternal.aggStatus.newStats.reset();
                AggregateStatus aggregateStatus2 = aggStatus;
                synchronized (aggregateStatus2) {
                    updatingStats = false;
                    aggStatus.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateStats() {
        int n;
        AggregateStatus aggregateStatus = aggStatus;
        synchronized (aggregateStatus) {
            if (updatingStats) {
                try {
                    while (updatingStats) {
                        aggStatus.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            updatingStats = true;
            n = CacheInternal.aggStatus.pass;
            ++n;
        }
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = hashtab[i];
            bucket.aggStats(n);
        }
        CacheInternal.aggStatus.newStats.clone(aggStatus);
        CacheInternal.aggStatus.pass = n;
        CacheInternal.aggStatus.newStats.reset();
        AggregateStatus aggregateStatus2 = aggStatus;
        synchronized (aggregateStatus2) {
            updatingStats = false;
            aggStatus.notifyAll();
        }
    }

    static void cleanMemoryCache() {
        long l = aggStatus.getPriority(2);
        long l2 = aggStatus.getPriority(0);
        int n = (int)((double)((float)objectMax * lowWater) + 0.5);
        int n2 = (int)((double)((float)cacheMaxSize * lowWater) + 0.5);
        if (l < l2) {
            l = Long.MAX_VALUE;
            l2 = Long.MAX_VALUE;
        }
        long l3 = (long)((double)(l - l2) / 10.0);
        for (int i = 1; i <= 10 && (curObjCnt > n || cacheMaxSize > 0L && curCacheSize > (long)n2); ++i) {
            long l4 = l2 + l3 * (long)i;
            for (int j = 0; j < 523 && (curObjCnt > n || cacheMaxSize > 0L && curCacheSize > (long)n2); ++j) {
                int n3 = curObjCnt - n;
                long l5 = cacheMaxSize == 0L ? 0L : curCacheSize - (long)n2;
                int n4 = CacheInternal.getNextBucket();
                Bucket bucket = hashtab[n4];
                bucket.clean(l4, aggStatus, n3, l5);
            }
            if (l4 >= l) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanDiskCache() {
        long l = (long)((double)((float)diskMaxSize * lowWater) + 0.5);
        long l2 = (long)((double)((float)diskMaxSize * highWater) + 0.5);
        byte[] byArray = bootlock;
        synchronized (bootlock) {
            if ((flags & 1) != 0) {
                Bucket bucket;
                int n;
                File file = new File(diskPath);
                String[] stringArray = file.list();
                if (stringArray != null) {
                    for (n = 0; n < stringArray.length && (globalDiskSize > l || localDiskSize > l); ++n) {
                        if (stringArray[n].equals(INFO_FILE) || stringArray[n].equals("_lock_") || stringArray[n].equals(WORKING_PATH)) continue;
                        bucket = hashtab[Integer.parseInt(stringArray[n])];
                        bucket.cleanLocalDisk();
                    }
                }
                if (invalidationList != null && invalidationList.size() != 0) {
                    CacheInternal.freeDisk();
                }
                if (globalDiskSize > l2 && (stringArray = (file = new File(globalDiskPath)).list()) != null) {
                    for (n = 0; n < stringArray.length && globalDiskSize > l; ++n) {
                        if (stringArray[n].equals(INFO_FILE) || stringArray[n].equals("_lock_")) continue;
                        bucket = hashtab[Integer.parseInt(stringArray[n])];
                        bucket.cleanGlobalDisk();
                    }
                }
            }
            // ** MonitorExit[var7_2] (shouldn't be in output)
            return;
        }
    }

    static void cleanIdle() {
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = hashtab[i];
            bucket.cleanIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOurTimeStamp(boolean bl) {
        long l;
        long l2;
        if (bl) {
            l2 = Net.getUid();
            l = Net.getTimeStamp();
        } else {
            l2 = -1L;
            l = System.currentTimeMillis();
        }
        RandomAccessFile randomAccessFile = pfHdl;
        synchronized (randomAccessFile) {
            try {
                pfHdl.seek(8L);
                pfHdl.writeLong(l2);
                pfHdl.writeLong(l);
            }
            catch (IOException iOException) {
                CacheInternal.exceptionLog(MEM, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deathDetect() {
        if (distributed ? !lock.getLock("deathDetect", 1) : lock.exists()) {
            return;
        }
        try {
            File file = new File(rootDiskPath);
            String[] stringArray = file.list();
            long l = System.currentTimeMillis();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2;
                if (diskPath.indexOf(stringArray[i]) != -1 || stringArray[i].equals(GLOBAL_DISK_PATH) || stringArray[i].equals("_lock_") || !(file2 = new File(file, stringArray[i])).isDirectory()) continue;
                long l2 = -1L;
                long l3 = 0L;
                long l4 = 0L;
                boolean bl = false;
                File file3 = new File(file2, INFO_FILE);
                RandomAccessFile randomAccessFile = null;
                if (file3.exists()) {
                    try {
                        randomAccessFile = new RandomAccessFile(file3, "r");
                        l4 = randomAccessFile.readLong();
                        l2 = randomAccessFile.readLong();
                        l3 = randomAccessFile.readLong();
                    }
                    catch (Exception exception) {
                        CacheInternal.exceptionLog(MEM, exception);
                        l2 = -1L;
                        l3 = file3.lastModified();
                    }
                } else {
                    l3 = file2.lastModified();
                }
                if (CacheInternal.shouldLog(15)) {
                    logger.log("[Mem] detecting dir=" + file2 + " t=" + l3 + " uid=" + l2 + " size=" + l4 + " curtime=" + l);
                }
                if (l2 != -1L) {
                    if (distributed && !Net.isAlive(l2, l3)) {
                        try {
                            while (true) {
                                int n = randomAccessFile.readInt();
                                byte[] byArray = new byte[n];
                                randomAccessFile.read(byArray);
                                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                                DiskMessage diskMessage = (DiskMessage)objectInputStream.readObject();
                                invalidationList.addElement(diskMessage);
                            }
                        }
                        catch (EOFException eOFException) {
                            if (CacheInternal.shouldLog(7)) {
                                logger.log("[Mem] detected a dead distributed cache " + file2);
                            }
                            bl = true;
                        }
                    }
                } else if (l - l3 > (long)detectInterval) {
                    if (CacheInternal.shouldLog(7)) {
                        logger.log("[Mem] detected a dead local cache " + file2);
                    }
                    bl = true;
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (!bl) continue;
                CacheInternal.removeAll(file2);
                if (!distributed) continue;
                CacheInternal.updateGlobalDiskSize(l4, false);
            }
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog(MEM, exception);
        }
        finally {
            if (distributed) {
                lock.releaseLock();
            }
        }
    }

    static void addInvalidation(Mdslot mdslot, boolean bl) {
        DiskMessage diskMessage = new DiskMessage(mdslot.name, mdslot.qualifier, mdslot.fileName, mdslot.mdRecNum, mdslot.instNum, true);
        if (bl) {
            CacheInternal.saveInvalidation(diskMessage);
        }
        invalidationList.addElement(diskMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveInvalidation(DiskMessage diskMessage) {
        RandomAccessFile randomAccessFile = pfHdl;
        synchronized (randomAccessFile) {
            try {
                pfHdl.seek(pfHdl.length());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
                CacheObjectOutputStream cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                cacheObjectOutputStream.writeObject(diskMessage);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                pfHdl.writeInt(byArray.length);
                pfHdl.write(byArray);
            }
            catch (Exception exception) {
                CacheInternal.exceptionLog(MEM, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void freeDisk() {
        String string = GLOBAL_DISK_PATH;
        synchronized (GLOBAL_DISK_PATH) {
            block21: {
                CacheHandle cacheHandle = null;
                cacheHandle = CacheHandleQ.getHandle();
                long l = 0L;
                int n = invalidationList.size();
                int n2 = 0;
                while (n2 < n) {
                    DiskMessage diskMessage = (DiskMessage)invalidationList.elementAt(n2);
                    DiskMessage diskMessage2 = new DiskMessage(diskMessage.name, diskMessage.qualifier, diskMessage.fileName, diskMessage.mdId, diskMessage.instNum, diskMessage.respond);
                    int n3 = CacheInternal.hashName(diskMessage2.name);
                    Bucket bucket = hashtab[n3 % 523];
                    if (bucket.checkObjectRef(diskMessage2)) {
                        ++n2;
                        continue;
                    }
                    Task task = new Task(14, diskMessage2);
                    Net.broadcast(task, cacheHandle, 1);
                    cacheHandle.resp.waitFor(8000);
                    if (cacheHandle.resp.retObj == null) {
                        l += bucket.freeDiskSlot(diskMessage.name, diskMessage.fileName, diskMessage.mdId, diskMessage.instNum + 1);
                        invalidationList.removeElementAt(n2);
                        --n;
                    } else {
                        ++n2;
                    }
                    cacheHandle.cancelAllResponse();
                }
                CacheInternal.updateGlobalDiskSize(l, false);
                Object var12_12 = null;
                try {
                    if (cacheHandle != null) {
                        CacheHandleQ.releaseHandle(cacheHandle);
                    }
                    break block21;
                }
                catch (Exception exception) {}
                break block21;
                {
                    catch (TimeoutException timeoutException) {
                        Object var12_13 = null;
                        try {
                            if (cacheHandle != null) {
                                CacheHandleQ.releaseHandle(cacheHandle);
                            }
                            break block21;
                        }
                        catch (Exception exception) {}
                        break block21;
                    }
                    catch (Exception exception) {
                        CacheInternal.exceptionLog(MEM, exception);
                        Object var12_14 = null;
                        try {
                            if (cacheHandle != null) {
                                CacheHandleQ.releaseHandle(cacheHandle);
                            }
                            break block21;
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    try {
                        if (cacheHandle != null) {
                            CacheHandleQ.releaseHandle(cacheHandle);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static boolean setDiskLeader(View view, View view2) {
        byte[] byArray;
        int n;
        boolean bl = false;
        Vector vector = view2.getMembers();
        Address address = null;
        int n2 = vector.size();
        for (n = 0; !(n >= n2 || (byArray = (byte[])(address = (Address)vector.elementAt(n)).getTag()) != null && CacheInternal.arrayEquals(diskUid, byArray)); ++n) {
        }
        if (n == n2 || n2 == 0) {
            logger.log("[Mem] FATAL: can't find the diskid in the view, size=" + n2);
            return false;
        }
        if (Net.getUid() == address.getUid()) {
            bl = true;
            if (CacheInternal.shouldLog(7)) {
                logger.log("[Mem] Became disk leader: uid=" + Net.getUid());
            }
        } else {
            bl = false;
        }
        if (bl) {
            if (!isDiskLeader) {
                isDiskLeader = true;
                return true;
            }
            return n2 != view.size() + 1;
        }
        isDiskLeader = false;
        return false;
    }

    static boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (n = 0; n < byArray.length && byArray[n] == byArray2[n]; ++n) {
        }
        return n == byArray.length;
    }

    static void cleanLock() {
        if (CacheInternal.shouldLog(7)) {
            logger.log("[Mem] cleaning file lock");
        }
        FileLock.cleanLock(rootDiskPath);
        FileLock.cleanLock(globalDiskPath);
        File file = new File(globalDiskPath);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(INFO_FILE) || stringArray[i].equals("_lock_")) continue;
                FileLock.cleanLock(globalDiskPath + File.separator + stringArray[i]);
            }
        }
    }

    private static void removeLocalCache(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        try {
            int n;
            pfHdl.close();
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    CacheInternal.removeAll(new File(file, stringArray[n]));
                }
            }
            stringArray = file.list();
            n = 0;
            if (invalidationList != null && (n = invalidationList.size()) > 0 || stringArray.length > 0) {
                pfHdl = new RandomAccessFile(diskPath + File.separator + INFO_FILE, "rw");
                pfHdl.writeLong(0L);
                CacheInternal.writeOurTimeStamp(distributed);
                if (invalidationList != null) {
                    for (int i = 0; i < n; ++i) {
                        CacheInternal.saveInvalidation((DiskMessage)invalidationList.elementAt(i));
                    }
                }
                pfHdl.close();
            } else if (!file.delete()) {
                logger.log("[Mem] can't delete file " + file);
            }
            if (distributed) {
                CacheInternal.updateGlobalDiskSize(localDiskSize, false);
            }
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog(MEM, exception);
        }
    }

    private static void removeAll(File file) {
        String[] stringArray;
        if (file.isDirectory() && (stringArray = file.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CacheInternal.removeAll(new File(file, stringArray[i]));
            }
        }
        if (!file.delete() && CacheInternal.shouldLog(15)) {
            logger.log("[Mem] removeAll can't delete file " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateLocalDiskSize(long l, boolean bl) throws DiskCacheException {
        if (l == 0L) {
            return;
        }
        if (bl) {
            if ((float)(localDiskSize += l) > (float)diskMaxSize * highWater) {
                if (CacheInternal.shouldLog(7)) {
                    logger.log("[Mem] local diskcache reach high water mark!!!, size=" + localDiskSize);
                }
                ttlQ.wakeup();
            }
        } else {
            localDiskSize -= l;
        }
        RandomAccessFile randomAccessFile = pfHdl;
        synchronized (randomAccessFile) {
            try {
                pfHdl.seek(0L);
                pfHdl.writeLong(localDiskSize);
            }
            catch (Exception exception) {
                throw DiskCache.diskExceptionHandler(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateGlobalDiskSize(long l, boolean bl) throws DiskCacheException {
        if (l == 0L) {
            return;
        }
        FileLock fileLock = diskSizeFileLock;
        synchronized (fileLock) {
            if (!diskSizeFileLock.getLock("updateDiskSize", 0)) {
                throw new DiskCacheException(EXP_DISKLOCK);
            }
            try {
                File file = new File(globalDiskPath + File.separator + INFO_FILE);
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                globalDiskSize = randomAccessFile.readLong();
                if (bl) {
                    if ((float)(globalDiskSize += l) > (float)diskMaxSize * highWater) {
                        if (CacheInternal.shouldLog(7)) {
                            logger.log("[Mem] global diskcache reach high water mark!, size=" + globalDiskSize);
                        }
                        ttlQ.wakeup();
                    }
                } else {
                    globalDiskSize -= l;
                }
                randomAccessFile.seek(0L);
                randomAccessFile.writeLong(globalDiskSize);
                randomAccessFile.close();
            }
            catch (Exception exception) {
                throw DiskCache.diskExceptionHandler(exception);
            }
            finally {
                diskSizeFileLock.releaseLock();
            }
        }
    }

    public static void trace(String string) {
        default_logger.log(string);
    }

    public static synchronized void dump() {
        if (!CacheInternal.isReady()) {
            return;
        }
        CacheInternal.trace("===" + cacheId + "@" + cacheAddress + ": Start dumping Cache content===");
        for (int i = 0; i < 523; ++i) {
            Bucket bucket = hashtab[i];
            if (bucket == null) continue;
            bucket.dump();
        }
        CacheInternal.trace("======End dumping Cache content======");
        default_logger.flush();
    }

    public static boolean isReady() {
        return (flags & 1) != 0;
    }

    public static boolean autoInit() {
        return (flags & 8) == 0;
    }

    public static boolean isDistributed() {
        return distributed;
    }

    static boolean isDistributedObject(Mdslot mdslot) {
        return distributed && (mdslot == null || (mdslot.state & 0x200L) != 0L);
    }

    public static Enumeration listCacheObjects() {
        return new ListEnumeration();
    }

    public static String dumpToString(String string) {
        Enumeration enumeration = null;
        StringBuffer stringBuffer = new StringBuffer().append(cacheId + "@" + cacheAddress + "\n");
        try {
            enumeration = CacheInternal.listCacheObjects(string);
            while (enumeration.hasMoreElements()) {
                CacheObjectInfo cacheObjectInfo = (CacheObjectInfo)enumeration.nextElement();
                stringBuffer.append(cacheObjectInfo.region).append("|").append(cacheObjectInfo.name).append("|");
                stringBuffer.append(cacheObjectInfo.group).append("|").append(cacheObjectInfo.type).append("|");
                stringBuffer.append(cacheObjectInfo.expire).append("|").append(cacheObjectInfo.valid).append("|");
                stringBuffer.append(cacheObjectInfo.ownerInfo).append("|");
                stringBuffer.append(cacheObjectInfo.refcount).append("|").append(cacheObjectInfo.accesses).append("\n");
            }
        }
        catch (Exception exception) {
            CacheInternal.log(null, exception);
        }
        return stringBuffer.toString();
    }

    public static String getConfig() {
        StringBuffer stringBuffer = new StringBuffer().append(cacheId + "@" + cacheAddress + "\n");
        try {
            stringBuffer.append(CacheInternal.cAttr.distribute);
            stringBuffer.append("|");
            stringBuffer.append(CacheInternal.cAttr.version);
            stringBuffer.append("|");
            stringBuffer.append(CacheInternal.cAttr.maxObjects);
            stringBuffer.append("|");
            stringBuffer.append(CacheInternal.cAttr.maxSize);
            stringBuffer.append("|");
            stringBuffer.append(CacheInternal.cAttr.diskSize);
            stringBuffer.append("|");
            stringBuffer.append(CacheInternal.cAttr.diskPath);
            stringBuffer.append("|");
            stringBuffer.append(CacheInternal.cAttr.cleanInterval);
            stringBuffer.append("|");
            stringBuffer.append(CacheInternal.cAttr.logFileName);
            stringBuffer.append("|");
            stringBuffer.append(CacheInternal.cAttr.logger);
            stringBuffer.append("|");
            stringBuffer.append(CacheInternal.cAttr.logSeverity).append("|");
            stringBuffer.append("|");
            stringBuffer.append(cAttr.getAddrListString()).append("\n");
        }
        catch (Exception exception) {
            CacheInternal.log("getConfig() error", exception);
            return new String("cannot get configuration, see log for more info");
        }
        return stringBuffer.toString();
    }

    public static Enumeration listCacheObjects(String string) {
        return new ListEnumeration(string);
    }

    public static void log(String string) {
        if (logger != null) {
            logger.log(string);
        }
    }

    public static void log(String string, Throwable throwable) {
        if (logger != null) {
            logger.log(string, throwable);
        }
    }

    public static boolean shouldLog(int n) {
        boolean bl = false;
        if (logger != null) {
            bl = logger.shouldLog(n);
        }
        return bl;
    }

    static void exceptionLog(String string, Exception exception) {
        Exception exception2 = null;
        if (logger != null && logger.shouldLog(3)) {
            if (exception instanceof CacheException) {
                if ((exception instanceof ObjectNotFoundException || exception instanceof ObjectExistsException || exception instanceof NullObjectException) && !logger.shouldLog(15)) {
                    return;
                }
                if (((CacheException)exception).logged()) {
                    return;
                }
                ((CacheException)exception).setLogged();
                exception2 = ((CacheException)exception).getBaseException();
            }
            if (exception2 == null) {
                logger.log(string, exception);
            } else {
                logger.log(string, exception2);
            }
            logger.flush();
        }
    }

    static CacheException exceptionHandler(Exception exception) {
        CacheInternal.exceptionLog(MEM, exception);
        if (exception instanceof CacheException) {
            return (CacheException)exception;
        }
        CacheException cacheException = new CacheException(null, exception);
        cacheException.setLogged();
        return cacheException;
    }

    static CacheException exceptionHandler(String string, Exception exception) {
        CacheInternal.exceptionLog(MEM, exception);
        if (exception instanceof CacheException) {
            ((CacheException)exception).setInfoMsg(string);
            return (CacheException)exception;
        }
        CacheException cacheException = new CacheException(string, exception);
        cacheException.setLogged();
        return cacheException;
    }

    public static void setSeverity(int n) {
        logger.setSeverity(n);
        CacheInternal.cAttr.logSeverity = n;
    }

    public static synchronized long getSeqId() {
        return ++seqId;
    }

    static CacheAddress getLocalAddressObject() throws CacheException {
        Address address = Net.getLocalAddressObject();
        CacheAddress cacheAddress = new CacheAddress(address);
        return cacheAddress;
    }

    static void setUserClassLoader(String string, ClassLoader classLoader) {
        loaderMap.put(string, classLoader);
    }

    static ClassLoader getUserClassLoader(String string) {
        return (ClassLoader)loaderMap.get(string);
    }

    static void removeUserClassLoader(String string) {
        loaderMap.remove(string);
    }

    static CacheHostInfo[] getActiveHostInfo() throws CacheException {
        Vector vector;
        try {
            if (!distributed) {
                return new CacheHostInfo[0];
            }
            vector = Net.chan.getView().getMembers();
        }
        catch (GroupException groupException) {
            throw CacheInternal.exceptionHandler(groupException);
        }
        CacheHostInfo[] cacheHostInfoArray = new CacheHostInfo[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            cacheHostInfoArray[i] = new CacheHostInfo((Address)vector.get(i));
        }
        return cacheHostInfoArray;
    }

    static boolean isDiskCacheConfigured() {
        return rootDiskPath != null;
    }

    static {
        workingDir = null;
        cacheId = -1;
        flags = 0;
        cacheAddress = null;
        bootlock = new byte[0];
        updatingStats = false;
        cacheHostName = null;
        transport = 0;
        cacheInstance = 0;
        isSSLEnabled = false;
        sslConfigFilePath = null;
        localAddress = null;
        nlDeathDetect = false;
        overrideNLPort = -1;
        loaderMap = new HashMap();
        flags = 0;
    }
}

