/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheLogger;
import oracle.ias.cache.LogRecord;

public class DefaultCacheLogger
extends CacheLogger {
    private static final int STRING_TYPE = 0;
    private static final int EXCPT_TYPE = 1;
    private static final int BGFLUSH_DELPAY = 5000;
    private static final String TAB = " ";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd E hh:mm:ss.SSS a z";
    private final int DEFAULT_SIZE = 1000;
    private FileOutputStream fd = null;
    private LogRecord[] buffer = null;
    private String defaultLogFile = "javacache.log";
    private int nextInsert;
    private int startFlush;
    private int recordCount;
    private int recordPerFlush;
    private boolean showTimeStamp = true;
    private boolean showThreadId = false;
    private Date timeOfDate;
    private SimpleDateFormat dateFormat;
    private NumberFormat numFormat;

    public DefaultCacheLogger(int n) throws CacheException {
        this.setSeverity(n);
        this.logFileName = null;
        this.init(1000);
    }

    public DefaultCacheLogger(int n, String string) throws CacheException {
        this.setSeverity(n);
        this.logFileName = string;
        this.init(1000);
    }

    public DefaultCacheLogger() throws CacheException {
    }

    public void init(String string, int n) throws CacheException {
        this.severity = n;
        this.logFileName = string;
        this.init(1000);
    }

    private synchronized void init(int n) throws CacheException {
        if (this.buffer != null) {
            return;
        }
        this.buffer = new LogRecord[n];
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = new LogRecord();
            this.buffer[i].time = null;
        }
        this.nextInsert = 0;
        this.startFlush = 0;
        this.recordCount = n;
        this.recordPerFlush = n;
        this.timeOfDate = new Date();
        this.dateFormat = new SimpleDateFormat(DATE_TIME_FORMAT);
        this.numFormat = NumberFormat.getNumberInstance();
        this.numFormat.setGroupingUsed(false);
        this.numFormat.setMinimumIntegerDigits(3);
        this.numFormat.setMaximumFractionDigits(0);
        try {
            if (this.logFileName != null) {
                this.fd = new FileOutputStream(this.logFileName, true);
            } else {
                this.logFileName = this.defaultLogFile;
                this.fd = new FileOutputStream(this.defaultLogFile, true);
            }
        }
        catch (IOException iOException) {
            throw new CacheException(iOException.toString());
        }
        catch (Exception exception) {
            this.fd = null;
        }
    }

    public void finalize() {
        try {
            this.fd.close();
        }
        catch (Exception exception) {
            this.fd = null;
        }
    }

    synchronized void flushBuffer() {
        if (this.buffer == null) {
            return;
        }
        this.flushRecords(this.startFlush, false);
        this.startFlush = this.nextInsert;
    }

    void dumpBuffer() {
        if (this.buffer == null) {
            return;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(System.out, 4096);
        PrintWriter printWriter = new PrintWriter(bufferedOutputStream, false);
        LogRecord logRecord = this.buffer[this.nextInsert];
        if (logRecord.time != null) {
            this.writeRecords(this.nextInsert, this.recordCount, printWriter);
        }
        this.writeRecords(0, this.nextInsert, printWriter);
        try {
            printWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void flushRecords(int n, boolean bl) {
        if (this.fd == null) {
            return;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.fd, 4096);
        PrintWriter printWriter = new PrintWriter(bufferedOutputStream, false);
        int n2 = bl ? this.recordPerFlush : this.nextInsert;
        this.writeRecords(n, n2, printWriter);
        try {
            printWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void insert(int n, String string, Throwable throwable) {
        if (this.buffer == null) {
            return;
        }
        LogRecord logRecord = this.buffer[this.nextInsert];
        logRecord.recordType = n;
        logRecord.message = string;
        logRecord.ex = throwable;
        logRecord.threadId = Thread.currentThread().toString();
        if (this.showTimeStamp && this.timeOfDate != null) {
            this.timeOfDate.setTime(System.currentTimeMillis());
            logRecord.time = this.dateFormat.format(this.timeOfDate);
        }
        this.nextInsert = (this.nextInsert + 1) % this.recordCount;
        if (this.nextInsert % this.recordPerFlush == 0) {
            this.flushRecords(this.startFlush, true);
            this.startFlush = this.nextInsert;
        }
    }

    private synchronized void writeRecords(int n, int n2, PrintWriter printWriter) {
        LogRecord logRecord = this.buffer[this.nextInsert];
        block4: for (int i = n; i < n2; ++i) {
            logRecord = this.buffer[i];
            switch (logRecord.recordType) {
                case 0: {
                    this.dumpString(logRecord, printWriter);
                    continue block4;
                }
                case 1: {
                    this.dumpException(logRecord, printWriter);
                }
            }
        }
    }

    private void dumpString(LogRecord logRecord, PrintWriter printWriter) {
        if (this.showTimeStamp) {
            printWriter.print("[" + logRecord.time + "]");
            printWriter.print(TAB);
        }
        if (this.showThreadId) {
            printWriter.print("[" + logRecord.threadId + "]");
            printWriter.print(TAB);
        }
        printWriter.print(this.numFormat.format(CacheInternal.cacheId));
        printWriter.print(TAB);
        printWriter.println(logRecord.message);
    }

    private void dumpException(LogRecord logRecord, PrintWriter printWriter) {
        if (this.showTimeStamp) {
            printWriter.print("[" + logRecord.time + "]");
            printWriter.print(TAB);
        }
        if (this.showThreadId) {
            printWriter.print("[" + logRecord.threadId + "]");
            printWriter.print(TAB);
        }
        printWriter.print(this.numFormat.format(CacheInternal.cacheId));
        printWriter.print(TAB);
        if (logRecord.message != null) {
            printWriter.println(logRecord.message);
        }
        logRecord.ex.printStackTrace(printWriter);
    }

    public void log(String string) {
        if (this.severity == -1) {
            return;
        }
        this.insert(0, string, null);
    }

    public void log(String string, Throwable throwable) {
        if (this.severity == -1) {
            return;
        }
        this.insert(1, string, throwable);
    }

    public void setShowTimeStamp(boolean bl) {
        this.showTimeStamp = bl;
    }

    public void setShowThreadId(boolean bl) {
        this.showThreadId = bl;
    }

    public void flush() {
        if (this.severity == -1) {
            return;
        }
        this.flushBuffer();
    }

    public void setSeverity(int n) {
        if (n >= 15) {
            this.setShowThreadId(true);
            this.setShowTimeStamp(true);
        }
        super.setSeverity(n);
    }
}

