/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import oracle.ias.cache.Bucket;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheObjectInputStream;
import oracle.ias.cache.CacheObjectOutputStream;
import oracle.ias.cache.DiskCacheException;
import oracle.ias.cache.DiskCacheIdx;
import oracle.ias.cache.FileLock;
import oracle.ias.cache.Mdslot;

class DiskCache {
    private static final String METADATA = "1";
    private static final String DATA = "2";
    private static final String IDX = "3";
    private static final String OVERFLOW = "4";
    private static final char MD_DISKONLY = 'D';
    private static final char MD_MEMORY = 'M';
    private static final char MD_STREAM = 'S';
    private static final char MD_INVALID = 'I';
    private static final char MD_FREE = 'F';
    private static final char MD_LOADING = 'A';
    private static final char MD_USEOV = 'O';
    private static final char MD_LOCALNAME = 'N';
    private static final char SP = '\u007f';
    private static final int BASE = 6;
    private static final int MASK = 63;
    private static final int RECORDSIZE = 256;
    private static final int REC_PER_BUF = 8;
    private static final int LOCK_RETRY = 1000;
    String qualifier;
    Object name;
    long timeToLive;
    long ttlInterval;
    int idleTime;
    long version;
    long flags;
    String fileName;
    String path;
    int mdRecNum;
    int instNum;
    long fileSize;
    long oSize;
    long storType;
    private FileLock lock;
    private String mdFile;
    private RandomAccessFile mdFileHdl;
    private String ovFile;
    private RandomAccessFile ovFileHdl;
    private DiskCacheIdx idx;
    private String bucketPath;
    private File objectDir;
    private byte[] buffer;
    private byte[] bigBuf;
    private byte[] smallBuf;
    private byte[] ovBuf;
    private int bufPtr;
    private long seekPtr;
    private int recCount;
    private int currRec;
    private int ovPtr;
    private char status;
    private int buckNum;
    private Bucket bucket;
    private boolean isLocal;
    static final long[] l2bMask = new long[]{63L, 4032L, 258048L, 0xFC0000L, 0x3F000000L, 0xFC0000000L, 0x3F000000000L, 0xFC0000000000L, 0x3F000000000000L, 0xFC0000000000000L, -1152921504606846976L};

    DiskCache(String string, int n) {
        this(string, n, false);
    }

    DiskCache(String string, int n, boolean bl) {
        if (!string.equals(CacheInternal.globalDiskPath)) {
            this.isLocal = true;
        }
        this.buckNum = n;
        if (!bl) {
            this.bucket = CacheInternal.hashtab[n];
        }
        this.bucketPath = string + File.separator + n;
        this.path = this.bucketPath + File.separator + DATA;
        this.mdFile = this.bucketPath + File.separator + METADATA;
        this.objectDir = new File(this.path);
        this.lock = new FileLock(this.bucketPath, this.isLocal);
    }

    long checkDisk(Mdslot mdslot) throws DiskCacheException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        long l = 8L;
        if (!this.objectDir.exists()) {
            this.objectDir.mkdirs();
        }
        if (!this.lock.getLock("checkDisk", 1000)) {
            throw new DiskCacheException(CacheInternal.EXP_DISKLOCK);
        }
        try {
            if (this.idx == null) {
                this.idx = new DiskCacheIdx(this.bucketPath, IDX, this.buckNum);
            }
            this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
            if ((mdslot.state & 0x100L) != 0L && this.getRecord(mdslot.mdRecNum)) {
                l = this.status == 'A' ? 4L : 2L;
                if (CacheInternal.shouldLog(7)) {
                    CacheInternal.logger.log("[Dsk] checkDisk: slot on disk, ret=" + l);
                }
                long l2 = l;
                return l2;
            }
            if (this.idx.updateNeeded()) {
                n = 0;
                while ((n = this.idx.findNextUpdate(n)) >= 0) {
                    if (this.getRecord(n)) {
                        if (!bl && this.qualifier.equals(mdslot.qualifier) && this.name.equals(mdslot.name)) {
                            l = this.status == 'A' ? 4L : 2L;
                            bl = true;
                            mdslot.fileName = new String(this.fileName);
                            mdslot.path = this.path;
                            mdslot.timeToLive = this.timeToLive;
                            mdslot.ttlInterval = this.ttlInterval;
                            mdslot.idleTime = this.idleTime;
                            mdslot.version = this.version;
                            mdslot.instNum = this.instNum;
                            mdslot.mdRecNum = this.mdRecNum;
                            mdslot.state = 0L;
                            mdslot.objStatus.size = this.oSize;
                            mdslot.objStatus.fileSize = this.fileSize;
                            if (this.flags != 0L) {
                                mdslot.state |= this.flags | 0x80000L;
                            }
                            mdslot.state |= 0x110L | this.storType;
                            if ((mdslot.state & 0x1000L) != 0L) {
                                mdslot.object = this.path + File.separator + this.fileName;
                                mdslot.state |= 2L;
                            }
                        } else if (this.status != 'A') {
                            this.bucket.updateDisk();
                        }
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.generateName(mdslot.extension);
                n = this.idx.findFree(0);
                while (this.readStatus(n) != 'F') {
                    n = this.idx.findFree(n + 1);
                }
                if (!this.isLocal) {
                    this.bucket.growDiskMaps(this.idx.length());
                }
                this.instNum = this.idx.incrInst(this.instNum);
                mdslot.mdRecNum = n;
                mdslot.instNum = this.instNum;
                mdslot.fileName = new String(this.fileName);
                mdslot.path = this.path;
                this.writeMetadata(n, 'A', mdslot);
                this.idx.writeHeader(n, this.instNum);
                l = 8L;
            }
        }
        catch (Exception exception) {
            throw DiskCache.diskExceptionHandler(exception);
        }
        finally {
            this.mdClose();
            this.lock.releaseLock();
        }
        return l;
    }

    void updateSlot(Mdslot mdslot) throws DiskCacheException {
        if (!this.objectDir.exists()) {
            this.objectDir.mkdirs();
        }
        if (!this.lock.getLock("updateSlot", 1000)) {
            throw new DiskCacheException(CacheInternal.EXP_DISKLOCK);
        }
        try {
            if (this.idx == null) {
                this.idx = new DiskCacheIdx(this.bucketPath, IDX, this.buckNum);
            }
            this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
            mdslot.instNum = this.instNum = this.idx.incrInst(this.instNum);
            mdslot.objStatus.fileSize = new File(mdslot.path, mdslot.fileName).length();
            if ((mdslot.state & 0x10L) == 0L) {
                this.writeMetadata(mdslot.mdRecNum, 'I', mdslot);
            } else if ((mdslot.state & 0x1000L) != 0L) {
                this.writeMetadata(mdslot.mdRecNum, 'D', mdslot);
            } else if ((mdslot.state & 0x2000000L) != 0L) {
                this.writeMetadata(mdslot.mdRecNum, 'S', mdslot);
            } else {
                this.writeMetadata(mdslot.mdRecNum, 'M', mdslot);
            }
            this.idx.writeHeader(mdslot.mdRecNum, this.instNum);
        }
        catch (Exception exception) {
            throw DiskCache.diskExceptionHandler(exception);
        }
        finally {
            this.mdClose();
            this.lock.releaseLock();
        }
    }

    void invalidate(Mdslot mdslot) throws DiskCacheException {
        if (!this.objectDir.exists()) {
            this.objectDir.mkdirs();
        }
        if (!this.lock.getLock("invalidate", 1000)) {
            throw new DiskCacheException(CacheInternal.EXP_DISKLOCK);
        }
        try {
            if (this.idx == null) {
                this.idx = new DiskCacheIdx(this.bucketPath, IDX, this.buckNum);
            }
            this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
            this.checkForUpdates(false);
            this.readStatus(mdslot.mdRecNum);
            if (this.status != 'A' && mdslot.instNum == this.instNum) {
                mdslot.instNum = this.instNum = this.idx.incrInst(this.instNum);
                byte[] byArray = new byte[18];
                int n = this.charToByte(byArray, 0, 'I');
                n = this.charToByte(byArray, n, 'N');
                n = DiskCache.longToByte(byArray, n, this.instNum, 3);
                n = this.longToByte(byArray, n, 0L);
                this.mdFileHdl.seek(mdslot.mdRecNum * 256);
                this.mdFileHdl.write(byArray);
                this.idx.writeHeader(mdslot.mdRecNum, this.instNum);
            }
        }
        catch (Exception exception) {
            throw DiskCache.diskExceptionHandler(exception);
        }
        finally {
            this.mdClose();
            this.lock.releaseLock();
        }
    }

    long freeSlot(Object object, String string, int n, int n2) throws DiskCacheException {
        long l = 0L;
        if (!this.objectDir.exists()) {
            this.objectDir.mkdirs();
        }
        if (!this.lock.getLock("freeSlot", 1000)) {
            throw new DiskCacheException(CacheInternal.EXP_DISKLOCK);
        }
        try {
            if (this.idx == null) {
                this.idx = new DiskCacheIdx(this.bucketPath, IDX, this.buckNum);
            }
            this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
            this.checkForUpdates(false);
            this.readStatus(n);
            if (this.status == 'I' && n2 == this.instNum) {
                this.instNum = this.idx.incrInst(this.instNum);
                byte[] byArray = new byte[18];
                int n3 = this.charToByte(byArray, 0, 'F');
                n3 = this.charToByte(byArray, n3, 'N');
                n3 = DiskCache.longToByte(byArray, n3, this.instNum, 3);
                n3 = this.longToByte(byArray, n3, 0L);
                this.mdFileHdl.seek(n * 256);
                this.mdFileHdl.write(byArray);
                this.instNum = 0;
                this.idx.writeHeader(n, this.instNum);
                File file = new File(this.path + File.separator + string);
                l = file.length();
                if (!file.delete()) {
                    CacheInternal.logger.log("[Dsk] freeSlot failed to delete " + file);
                }
            } else if (CacheInternal.shouldLog(7)) {
                CacheInternal.logger.log("[Dsk] freeSlot: invalid state, status=" + this.status + " inst=" + n2 + " instNum=" + this.instNum);
            }
            long l2 = l;
            return l2;
        }
        catch (Exception exception) {
            throw DiskCache.diskExceptionHandler(exception);
        }
        finally {
            this.mdClose();
            this.lock.releaseLock();
        }
    }

    void checkForUpdates() throws DiskCacheException {
        this.checkForUpdates(true);
    }

    void checkForUpdates(boolean bl) throws DiskCacheException {
        if (bl) {
            if (!this.objectDir.exists()) {
                this.objectDir.mkdirs();
            }
            if (!this.lock.getLock("checkForUpdates", 1000)) {
                throw new DiskCacheException(CacheInternal.EXP_DISKLOCK);
            }
        }
        int n = 0;
        try {
            if (bl) {
                if (this.idx == null) {
                    this.idx = new DiskCacheIdx(this.bucketPath, IDX, this.buckNum);
                }
                this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
            }
            if (this.idx != null && this.idx.updateNeeded()) {
                while ((n = this.idx.findNextUpdate(n)) >= 0) {
                    if (this.getRecord(n) && this.status != 'A') {
                        this.bucket.updateDisk();
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            throw DiskCache.diskExceptionHandler(exception);
        }
        finally {
            if (bl) {
                this.mdClose();
                this.lock.releaseLock();
            }
        }
    }

    void loadFromDisk() throws DiskCacheException {
        if (!this.objectDir.exists() || this.objectDir.list().length == 0) {
            return;
        }
        int n = 0;
        try {
            if (this.idx == null) {
                this.idx = new DiskCacheIdx(this.bucketPath, IDX, this.buckNum);
            }
            if (this.idx != null && this.idx.updateNeeded()) {
                this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
                while ((n = this.idx.findNextUpdate(n)) >= 0) {
                    if (this.getRecord(n) && this.status != 'A') {
                        this.bucket.updateDisk();
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            throw DiskCache.diskExceptionHandler(exception);
        }
        finally {
            this.mdClose();
        }
    }

    private boolean getRecord(int n) throws DiskCacheException {
        try {
            this.getRec(n);
            return this.readRecord();
        }
        catch (Exception exception) {
            throw DiskCache.diskExceptionHandler(exception);
        }
    }

    private boolean readRecord() throws IOException {
        this.status = this.getNextChar();
        char c = this.getNextChar();
        this.instNum = (int)this.getNextNum();
        this.version = this.getNextNum();
        switch (this.status) {
            case 'F': 
            case 'I': {
                return false;
            }
            case 'D': {
                this.storType = 4096L;
                break;
            }
            case 'M': {
                this.storType = 16384L;
                break;
            }
            case 'A': {
                this.storType = 0x4000000L;
                break;
            }
            case 'S': {
                this.storType = 0x2000000L;
            }
        }
        int n = (int)this.getNextNum();
        int n2 = (int)this.getNextNum();
        int n3 = (int)this.getNextNum();
        this.timeToLive = this.getNextNum();
        this.ttlInterval = this.getNextNum();
        this.idleTime = (int)this.getNextNum();
        this.flags = this.getNextNum();
        this.oSize = this.getNextNum();
        this.mdRecNum = (int)this.getNextNum();
        this.fileName = this.getNextString(n3);
        this.fileSize = new File(this.path, this.fileName).length();
        if (c == 'O') {
            int n4 = n + n2;
            long l = this.getNextNum();
            this.ovBuf = new byte[n4];
            this.ovPtr = 0;
            if (this.ovFileHdl == null) {
                if (this.ovFile == null) {
                    this.ovFile = this.bucketPath + File.separator + OVERFLOW;
                }
                this.ovFileHdl = new RandomAccessFile(this.ovFile, "rw");
            }
            this.ovFileHdl.seek(l);
            this.ovFileHdl.read(this.ovBuf, 0, n4);
            this.qualifier = this.getNextOString(n);
            this.name = this.getNextOObject(n2, this.qualifier);
        } else {
            this.qualifier = this.getNextString(n);
            this.name = this.getNextObject(n2, this.qualifier);
        }
        return true;
    }

    private String getNextOString(int n) {
        String string = new String(this.ovBuf, this.ovPtr, n);
        this.ovPtr += n;
        return string;
    }

    private String getNextString(int n) {
        String string = new String(this.buffer, this.bufPtr, n);
        this.bufPtr += n;
        return string;
    }

    private Object getNextOObject(int n, String string) throws IOException {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.ovBuf, this.ovPtr, n);
            CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream(byteArrayInputStream, string);
            object = cacheObjectInputStream.readObject();
            this.ovPtr += n;
        }
        catch (ClassNotFoundException classNotFoundException) {
            CacheInternal.exceptionLog("[Dsk] ", classNotFoundException);
        }
        return object;
    }

    private Object getNextObject(int n, String string) throws IOException {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buffer, this.bufPtr, n);
            CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream(byteArrayInputStream, string);
            object = cacheObjectInputStream.readObject();
            this.bufPtr += n;
        }
        catch (ClassNotFoundException classNotFoundException) {
            CacheInternal.exceptionLog("[Dsk] ", classNotFoundException);
        }
        return object;
    }

    private char getNextChar() {
        char c = (char)this.buffer[this.bufPtr];
        ++this.bufPtr;
        return c;
    }

    private long getNextNum() {
        long l;
        long l2 = this.buffer[this.bufPtr++];
        while ((l = (long)this.buffer[this.bufPtr++]) != 127L) {
            l2 = (l2 << 6) + l;
        }
        return l2;
    }

    private void mdClose() {
        try {
            if (this.mdFileHdl != null) {
                this.mdFileHdl.close();
                this.mdFileHdl = null;
                this.bufPtr = 0;
            }
            if (this.ovFileHdl != null) {
                this.ovFileHdl.close();
                this.ovFileHdl = null;
                this.ovPtr = 0;
            }
            this.idx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean getNextRec() throws IOException {
        if (this.bigBuf == null) {
            this.bigBuf = new byte[2048];
        }
        this.buffer = this.bigBuf;
        if (++this.currRec < this.recCount) {
            this.bufPtr = this.currRec * 256;
            return true;
        }
        if (this.seekPtr >= this.mdFileHdl.length()) {
            this.bigBuf = null;
            return false;
        }
        this.mdFileHdl.seek(this.seekPtr);
        int n = this.mdFileHdl.read(this.bigBuf, 0, 2048);
        this.recCount = n / 256;
        this.seekPtr += (long)n;
        this.bufPtr = 0;
        this.currRec = 0;
        return true;
    }

    private void getRec(int n) throws IOException {
        if (this.smallBuf == null) {
            this.smallBuf = new byte[256];
        }
        this.buffer = this.smallBuf;
        this.mdFileHdl.seek(n * 256);
        int n2 = this.mdFileHdl.read(this.buffer, 0, 256);
        if (n2 == -1) {
            this.initRec(this.buffer);
        }
        this.bufPtr = 0;
    }

    private void initRec(byte[] byArray) {
        int n = 0;
        n = this.charToByte(byArray, n, 'F');
        n = this.charToByte(byArray, n, 'N');
        n = DiskCache.longToByte(byArray, n, 0L, 3);
        n = this.longToByte(byArray, n, 0L);
    }

    private void writeMetadata(int n, char c, Mdslot mdslot) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[256];
        byte[] byArray2 = mdslot.qualifier.getBytes();
        int n3 = byArray2.length;
        byte[] byArray3 = mdslot.fileName.getBytes();
        int n4 = byArray3.length;
        byte[] byArray4 = this.objectToByte(mdslot.name);
        int n5 = byArray4.length;
        long l = n * 256;
        int n6 = n2 = this.charToByte(byArray, n2, c);
        n2 = this.charToByte(byArray, n2, 'N');
        n2 = DiskCache.longToByte(byArray, n2, mdslot.instNum, 3);
        n2 = this.longToByte(byArray, n2, mdslot.version);
        n2 = this.longToByte(byArray, n2, n3);
        n2 = this.longToByte(byArray, n2, n5);
        n2 = this.longToByte(byArray, n2, n4);
        n2 = this.longToByte(byArray, n2, mdslot.timeToLive);
        n2 = this.longToByte(byArray, n2, mdslot.ttlInterval);
        n2 = this.longToByte(byArray, n2, mdslot.idleTime);
        n2 = this.longToByte(byArray, n2, mdslot.state & 0xC2532A00L);
        n2 = this.longToByte(byArray, n2, mdslot.objStatus.size);
        n2 = this.longToByte(byArray, n2, n);
        n2 = this.byteToByte(byArray, n2, byArray3);
        this.mdFileHdl.seek(l);
        int n7 = n3 + n5;
        if (n7 > 256 - n2) {
            this.charToByte(byArray, n6, 'O');
            if (c == 'A' || mdslot.overFlow == -1L) {
                byte[] byArray5 = new byte[n7];
                n6 = 0;
                n6 = this.byteToByte(byArray5, n6, byArray2);
                n6 = this.byteToByte(byArray5, n6, byArray4);
                if (this.ovFile == null) {
                    this.ovFile = this.bucketPath + File.separator + OVERFLOW;
                }
                this.ovFileHdl = new RandomAccessFile(this.ovFile, "rw");
                mdslot.overFlow = this.ovFileHdl.length();
                this.ovFileHdl.seek(mdslot.overFlow);
                this.ovFileHdl.write(byArray5);
            }
            n2 = this.longToByte(byArray, n2, mdslot.overFlow);
        } else {
            n2 = this.byteToByte(byArray, n2, byArray2);
            n2 = this.byteToByte(byArray, n2, byArray4);
            mdslot.overFlow = -1L;
        }
        this.mdFileHdl.write(byArray);
    }

    private void generateName(String string) {
        String string2;
        File file;
        Random random = new Random(System.currentTimeMillis());
        do {
            file = null;
            int n = random.nextInt() & Integer.MAX_VALUE;
            string2 = String.valueOf(n);
            if (string == null) continue;
            string2 = string2 + string;
        } while ((file = new File(this.objectDir, string2)).exists());
        try {
            FileWriter fileWriter = new FileWriter(file.getAbsolutePath());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.fileName = string2;
    }

    static int longToByte(byte[] byArray, int n, long l, int n2) {
        int n3 = n + n2;
        int n4 = n3 - 1;
        for (int i = n2; i > 0; --i) {
            if (l > 0L) {
                byArray[n4] = (byte)(l & 0x3FL);
                l >>= 6;
            } else {
                byArray[n4] = 0;
            }
            --n4;
        }
        byArray[n3++] = 127;
        return n3;
    }

    private int longToByte(byte[] byArray, int n, long l) {
        int n2 = l2bMask.length;
        while (n2 > 0 && (l & l2bMask[--n2]) == 0L) {
        }
        n += n2 + 1;
        n2 = n + 1;
        byArray[n--] = 127;
        do {
            byArray[n--] = (byte)(l & 0x3FL);
        } while ((l >>= 6) > 0L);
        return n2;
    }

    private byte[] objectToByte(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
        CacheObjectOutputStream cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
        cacheObjectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    private int charToByte(byte[] byArray, int n, char c) {
        byArray[n++] = (byte)c;
        return n;
    }

    private int byteToByte(byte[] byArray, int n, byte[] byArray2) {
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return n + byArray2.length;
    }

    private char readStatus(int n) throws IOException {
        this.getRec(n);
        this.status = this.getNextChar();
        this.getNextChar();
        this.instNum = (int)this.getNextNum();
        return this.status;
    }

    boolean isValid() {
        return this.status != 'I' && this.status != 'F';
    }

    boolean isLoading() {
        return this.status == 'A';
    }

    static DiskCacheException diskExceptionHandler(Exception exception) {
        CacheInternal.exceptionLog("[Dsk] ", exception);
        if (exception instanceof DiskCacheException) {
            return (DiskCacheException)exception;
        }
        DiskCacheException diskCacheException = new DiskCacheException(exception.toString(), exception);
        diskCacheException.setLogged();
        return diskCacheException;
    }

    void dump(int n) {
        String string;
        if (this.idx != null) {
            CacheInternal.trace("<<< Bucket " + n + " Disk Index >>>");
            this.idx.dumpIndex();
        }
        if (!(string = this.dump()).equals("")) {
            CacheInternal.trace("<<< Bucket " + n + " Disk metadata >>>" + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String dump() {
        StringBuffer stringBuffer;
        block7: {
            stringBuffer = new StringBuffer();
            if (this.objectDir.exists()) break block7;
            String string = "";
            Object var4_4 = null;
            this.mdClose();
            this.currRec = 0;
            this.recCount = 0;
            this.seekPtr = 0L;
            return string;
        }
        try {
            try {
                if (this.idx == null) {
                    this.idx = new DiskCacheIdx(this.bucketPath, IDX, this.buckNum);
                }
                this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
                while (this.getNextRec()) {
                    if (!this.readRecord()) continue;
                    stringBuffer.append(this.toString());
                }
                Object var4_5 = null;
                this.mdClose();
                this.currRec = 0;
                this.recCount = 0;
                this.seekPtr = 0L;
            }
            catch (Exception exception) {
                Object var4_6 = null;
                this.mdClose();
                this.currRec = 0;
                this.recCount = 0;
                this.seekPtr = 0L;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.mdClose();
            this.currRec = 0;
            this.recCount = 0;
            this.seekPtr = 0L;
            throw throwable;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "\n Qualifier=" + this.qualifier + " Name=" + this.name + " FileName=" + this.fileName + " Path=" + this.path + " Record Number=" + this.mdRecNum + " Instance Number=" + this.instNum + " TimeToLive=" + this.timeToLive + " FileSize=" + this.fileSize + " Size=" + this.oSize + " Status=" + this.status + " Storage Type=" + this.storType;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[1]);
        DiskCache diskCache = new DiskCache(stringArray[0], n, true);
        System.err.println("dumping diskcache: " + diskCache.dump());
        if (diskCache.idx != null) {
            diskCache.idx.printIndex();
        }
    }
}

